//----------------------------------------------------------
// DC[^֐
//----------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include "motor.h"

unsigned char cycle=0;
char motor_enable=0;

typedef struct {
	char pow;	// PWM rate(0-MOTPOWERMAX)
	char dir;
	int time;
} ST_MOT;   // \

ST_MOT motor[MOTOR_MAX];

#if HARDTYPE==HARD_EDUMK2
	#define MOTOR_PORT   PORTF  // |[g
	#define MOTOR_DDR    DDRF   // o͐ݒ

#else
	#define MOTOR_PORT   PORTC  // |[g
	#define MOTOR_DDR    DDRC   // o͐ݒ
#endif
	#define MOTOR_BIT    0   // 

#ifndef F_CPU
#define   F_CPU   8000000    //CPUNbNg[Hz]
#endif


//-------------------------------------------------------

//void motor_init(void)
//{
//	motor_set_pow(MOTOR_A,0,0);
//	motor_set_pow(MOTOR_B,0,0);
//}

//-------------------------------------------------------
#if 1
void motor_ctrl(void)
{
	if(motor_enable==0)return;

	ST_MOT *pmot = &motor[0];

    MOTOR_DDR  |= 0b1111;    // o͂ɐݒ

	//------PWM A
    MOTOR_PORT &= ~(0b11);   // [^Xgbv
	if(pmot->time > 0){
		if(pmot->pow > cycle){
	    	MOTOR_PORT |= pmot->dir;   // [^
		}
		pmot->time--;
	}
	pmot++;
	//------PWM B
    MOTOR_PORT &= ~(0b11 << 2);   // [^Xgbv
	if(pmot->time > 0){
		if(pmot->pow > cycle){
		    MOTOR_PORT |= (pmot->dir << 2);   // [^
		}
		pmot->time--;
	}

	cycle++;
	if(cycle >= MOTPOWCYCLE){
		cycle=0;
	}
}
#else
void motor_ctrl(void)
{
	if(motor_enable==0)return;

	char num;
	ST_MOT *pmot = &motor[0];

	for(num=0; num<MOTOR_MAX; num++){

		//------PWM
		if(pmot->pow > cycle){
			motor_set(num,pmot->dir);
		}else{
			motor_set(num,MOTOR_STOP);
		}
		if(pmot->time > 0){
			pmot->time--;
			if(pmot->time == 0){
				pmot->dir = MOTOR_STOP;
			}
		}
		pmot++;
	}
	cycle++;
	if(cycle >= MOTPOWCYCLE){
		cycle=0;
	}
}
#endif
// num:[^ԍ(0-1)
// pow :p[(+10`-10) vXƐ]A}CiXƋt]
// time:ԁB1/100bP
//-------------------------------------------------------
void motor_set_pow(char num,char pow,int time)
{
	char dir;
	ST_MOT *pmot;

	pmot = &motor[(int)num];

	if(pow == 0){
		dir=MOTOR_STOP;	//stop
	}else if(pow > 0){
		dir=MOTOR_FOW;	//]
	}else{
		dir=MOTOR_BACK;	//t]
		pow = -pow;
	}
	if(pow > MOTPOWMAX) pow = MOTPOWMAX;
//	cli();
	pmot->dir = dir;
	pmot->pow = pow;
	pmot->time = time;
//	sei();

//	motor_enable |= (1<<num);
	motor_enable = 1;
}

//----------------------------------------------------------
// DC[^
//  dirF[hݒ0`3 motor.hQ
void motor_set(char num,char dir)
{

	num = (num*2)+MOTOR_BIT;

    MOTOR_PORT &= ~(0x3 << num);   // [^UXgbv
    MOTOR_DDR  |= (0x3 << num);    // o͂ɐݒ
    MOTOR_PORT |= (dir << num); 	// [hݒ
}

