// NicoBASIC

// main for EDU2(ATmega64)
// by takuya matsubara
// http://nicotak.com


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>
#include "vram.h"
#include "textx.h"
#include "sw.h"
#include "str.h"
#include "keyboard.h"
#include "nicobasic.h"

#if USE_AKILED
	#include "akiled.h"
#endif
#if USE_BEEP
	#include "beep.h"
#endif
#if USE_VIDEO
	#include "video.h"
#endif
#if USE_PWM
	#include "motor.h"
#endif

#include "sio.h"
#include "i2c.h"

#include "stime.h"	//(FAT file system by ChaN)
#include "tff.h"	//(FAT file system by ChaN)
#include "diskio.h"	//(FAT file system by ChaN)

// ChaNFAT file systemgĂ܂B
// gpĂt@C
// integer.h / stime.S / stime.h / mmc.c / tff.c / tff.h / diskio.h
// IWĩR[h͂
// http://elm-chan.org/
// http://elm-chan.org/fsw/ff/00index_j.html



//FUSE bit
//          -FX11111111 -FH11011001 -FL11100100
/*
  ATmega103 compatible mode: DISABLED
  JTAG : DISABLED
  Clock : Calibrated Internal RC Oscillator 8MHz
*/

void edit(void);
unsigned char getkey(void);
char fileselect (void);
char mmc_start(	void);
void filesave (char *fname);

extern char bascode[];
extern char dispwidth;
extern char dispheight;
extern char text_x;


//	^C}[0
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif

#define T0INTRCYCLE  600    //^C}荞ݎ[Hz]
#define T0PRESCALE   256    // ^C}0vXP[l
#define T0PRESCALER    6    // ^C}0vXP[ݒ
	// 1=div1 / 2=div8 / 3=div32 / 4=div64 / 5=128 / 6=256 /7=div1K
#define T0STA (0x100-((F_CPU/T0PRESCALE)/T0INTRCYCLE))

//-----------------------^C}荞

BYTE intflg;
char taskcnt=0;

SIGNAL(SIG_OVERFLOW1)
{	//	15750Hz
	sei();
#if USE_BEEP
	wave_driver();
#endif
	if(video_driver()){	//1/60sec

		intflg++;		//`I
		taskcnt = 4;
	}
	if(taskcnt!=0){
		taskcnt--;
		if(taskcnt==0){
			disk_timerproc();	/* Drive timer procedure of low level disk I/O module */
		}else if(taskcnt==1){
#if USE_BEEP
			beep_ctrl();
#endif
		}else if(taskcnt==2){
#if USE_LCD
			lcd_disp2();
#endif
		}else if(taskcnt==3){
#if USE_PWM
			motor_ctrl();	//motor control
#endif
		}
	}
}

//SIGNAL(SIG_OVERFLOW0)
//{
//}

//---------------------
//void timer_init(void)
//{
//	//---------------^C}荞
//	TCCR0= T0PRESCALER;   // ^C}0 vXP[ݒ
//	TCNT0 = T0STA;        // ^C}0 lݒ
//	TIFR |= (1 << TOV0);  // ^C}0 OVFtONA
//	TIMSK |= (1 << TOIE0); // ^C}0 OVF荞݋
//}

//-----------------------
DWORD get_fattime ()
{
	struct tm *tmr;
	time_t t=0;

	tmr = gmtime(&t);
	return	  ((DWORD)(tmr->tm_year - 80) << 25)
			| ((DWORD)(tmr->tm_mon + 1) << 21)
			| ((DWORD)tmr->tm_mday << 16)
			| (WORD)(tmr->tm_hour << 11)
			| (WORD)(tmr->tm_min << 5)
			| (WORD)(tmr->tm_sec >> 1);
/*
	return	((2006UL-1980) << 25)	// Year = 2006
			| (2UL << 21)			// Month = Feb
			| (9UL << 16)			// Day = 9
			| (22U << 11)			// Hour = 22
			| (30U << 5)			// Min = 30
			| (0U >> 1)				// Sec = 0
			;
*/
}

//-----------------------
unsigned char getkey(void)
{
#define BRINKCYCLE 60	// cursor brink time
#define NOKEYCNT 5
	char nokey=NOKEYCNT;
	char cursorflag=0;
	unsigned char key;
	BYTE intflg2=0;
	int i=0;

	text_setcolor(2);	//xor
	while(1){
		while(intflg2 == intflg){
			sleep_mode();		//
		}
		intflg2 = intflg;

		i --;
		if(i < 0){
			i=BRINKCYCLE;
			text_putch2(0x7f);	//J[\_
			sio_txvram();
			cursorflag ^= 1;
		}
		if(sio_rxflag()){
			key=sio_rx();	// SIO1oCgM
			break;
		}
		key = kb_getbuff();	// input keyboard
		if(key != 0)break;	// no data

		key=sw_get();
		if(key==0){
			if(nokey)
				nokey--;

			continue;
		}
		if(nokey)	// input disable
			continue;

		nokey=NOKEYCNT;

		if(key==SW_UP){
			key=KEYBOARD_UP;
			break;
		}else if(key==SW_DOWN){
			key=KEYBOARD_DOWN;
			break;
		}else if(key==SW_RIGHT){
			key=KEYBOARD_RIGHT;
			break;
		}else if(key==SW_LEFT){
			key=KEYBOARD_LEFT;
			break;
		}else if(key==SW_A){
			key=2;
			break;
		}else if(key==SW_B){
			key=3;
			break;
		}
	}
	if(cursorflag)
		text_putch2(0x7f);	//J[\

	return(key);
}


//---------------menu
PROGMEM char pgm_menu[]=
	"EDIT\0"	/*0*/
	"RUN\0"		/*1*/
	"LIST\0"	/*2*/
	"LOAD\0"	/*3*/
	"SIOopen\0"	/*4*/
	"ABOUT\0"	/*5*/
	"EXIT\0"
;

#define MENUID_EDIT    0
#define MENUID_RUN     1
#define MENUID_LIST    2
#define MENUID_LOAD    3
#define MENUID_SIOOPEN 4
#define MENUID_ABOUT   5
#define MENUID_EXIT    6
//-----------------------
void menu(void)
{
	char cnt=0;
	unsigned char key;
	char strtemp[10];

	while(1){
		while(text_x){
			text_putch(8);	// BS
		}
		prm_strcpy(strtemp, pgm_menu, cnt);
		text_setcolor(1);
		bas_print(strtemp);
		key = getkey();
		if((key==2)||(key==KEYBOARD_ENTER)){	//A
			text_putch(13);	//s
			if(cnt==MENUID_RUN){
				bas_run();
			}else if(cnt==MENUID_LIST){
				bas_list();
			}else if(cnt==MENUID_LOAD){
				if(fileselect())
					bas_run();
			}else if(cnt==MENUID_EDIT){
				edit();
			}else if(cnt==MENUID_SIOOPEN){
				sio_init(9600);
			}else if(cnt==MENUID_ABOUT){
				bas_print("Programed by Takuya Matsubara.");
				bas_print2("included [FAT file System]by ChaN.");
			}
			break;
		}else if(key==3){	//B
			break;
		}else if((key==KEYBOARD_UP)||(key==KEYBOARD_LEFT)){	//
			cnt--;
			if(cnt < 0)cnt=MENUID_EXIT;
		}else if((key==KEYBOARD_DOWN)||(key==KEYBOARD_RIGHT)){	//
			cnt++;
			if(cnt > MENUID_EXIT)cnt=0;
		}
	}
}

//----------------------------------------------------------------
int null_search(char *p ,int adr ,char a1)
{
	unsigned char ch;
	int charcnt=0;

	while(1){
		adr += a1;
		if(adr < 0){
			charcnt++;
			break;//ԏɓB
		}
		ch = *(p+adr);
		if(ch==BASCODE_EOF){
			break;
		}
		charcnt++;
		if(ch=='\0'){
			break;
		}
	}
	return(charcnt);
}


//-------------------------------------------------------
// edit mode
void edit(void)
{
	#define EDITSIZE 2000

	char buff[EDITSIZE];
	unsigned char key;
	unsigned char ch;
	int i;
	char x=0,y=0;
	char tmpx,tmpy;
	int bascodecnt=0;
	int adr1;
	int bascode_sta=0;
	char textw = (dispwidth/(FONTW+1));	//1s̕ 
	char texth = (dispheight/(FONTH+1));	//1ʂ̍s

	bas_readall(buff);
//	text_setcolor(1);

	//L[{[h		
	while(1)
	{
		bas_cls();
		if(bascodecnt < 0)bascodecnt=0;

		tmpx=0;
		tmpy=0;
		i=bascode_sta;
		while(1){
			ch=buff[i];
			if(i == bascodecnt){
				x = tmpx;
				y = tmpy;
			}
			if(ch==BASCODE_EOF)break;//eof
			if(ch >= ' '){
				text_putch(ch);
				tmpx++;
			}else{	//NULL
				tmpx += textw;
				if(tmpy < (texth-1))
					text_putch(13);	//ŏIsłȂȂs
			}
			if(tmpx >= textw) {
				tmpx=0;
				tmpy++;
				if(tmpy >= texth) {
					break;						
				}
			}
			i++;
		}
		ch= buff[bascodecnt];
		text_locate(x*(FONTW+1),y*8);
		key=getkey();
		if((key==2)||(key==3)){	//
			break;
		}else if(key==KEYBOARD_ENTER){	//Enter key
			mem_ins(buff, bascodecnt, 0, EDITSIZE-1);
			bascodecnt++;
		}else if(key==KEYBOARD_BS){	//
			if(bascodecnt > 0){
				bascodecnt--;
				mem_del(buff, bascodecnt, EDITSIZE-1);
			}
		}else if(key==KEYBOARD_UP){	//
			if(bascodecnt <= 0)continue;
			if(ch=='\0'){
				bascodecnt--;
			}else{
				bascodecnt -= null_search(buff,bascodecnt,-1);
				if(bascodecnt <= 0)continue;
				bascodecnt -= null_search(buff,bascodecnt,-1);
				bascodecnt++;//NULLɃJ[\킳Ă̂ŉE
			}
			y--;
			if(y<0){
				adr1 = null_search(buff,bascode_sta,-1);
				bascode_sta -= adr1;
				adr1 = null_search(buff,bascode_sta,-1);
				bascode_sta -= adr1;
				bascode_sta++;	//NULLɃJ[\킳Ă̂ŉE
			}
		}else if(key==KEYBOARD_DOWN){	//
			if(ch == BASCODE_EOF)continue;
			if(ch == '\0')
				adr1 = 1;
			else
				adr1 = null_search(buff,bascodecnt,1)+1;

			bascodecnt += adr1;
			y += ((adr1 / textw)+1);
			if(y > 3){
				adr1 = null_search(buff,bascode_sta,1)+1;
				bascode_sta += adr1;
			}
		}else if(key==KEYBOARD_RIGHT){	//
			if(ch == BASCODE_EOF)continue;
			if(ch == '\0')continue;	//NullEɂ̓J[\ړs
			bascodecnt++;
		}else if(key==KEYBOARD_LEFT){	//
			if(x > 0){
				bascodecnt--;
			}
		}else{
			if(ch == BASCODE_EOF)
				mem_ins(buff, bascodecnt, '\0', EDITSIZE-1);

//			key=str_ucase(key);
			mem_ins(buff, bascodecnt, key, EDITSIZE-1);
			bascodecnt++;
			sio_tx(key);	//echo back
		}
	}

	bas_cls();
	bas_writeall(buff);
	bas_printd(code_size());
	bas_print2("Bytes Used");

	return;
}



//-------------------------------------------------------
int main(void)
{
	unsigned char key;
	int i;
	char bascodecnt=0;
	char bascode_sta=0;

#if USE_AKILED
	led_init();
#endif

#if USE_VIDEO
	video_init();	// initialize H-sync intr.
#endif
//	timer_init();
	bas_init();
	bas_print2("NicoBASIC v20081024");	//---programming day

#if MEMORYTYPE==MEMTYPE_FLASH
	bas_print2("FLASHmode");
	bas_run();	//s
#endif
#if MEMORYTYPE==MEMTYPE_RAM
	bas_print2("RAMmode");
	bas_commandline("new");	
//	bas_commandline("100 input \"a=\";A");
	bas_commandline("100 PRINT \"X =\"; X; \",Y=\"; Y; \"desu");
//	bas_commandline("1 A=&H8000>>1");	
//	bas_commandline("1 A=&H8000>>1");	
//	bas_commandline("20 print a");	
//	bas_commandline("10 fread buf,14");	
//	bas_commandline("4 fclose");	
//	bas_commandline("1 gosub 5");	
//	bas_commandline("2 end");	
//	bas_commandline("5 cls");	
//	bas_commandline("6 return");	
//	bas_commandline("A=0");	
//	bas_commandline("*main");	
//	bas_commandline("A=A+1");	
//	bas_commandline("if a<3 then goto *main");	
//	bas_commandline("3 goto 9");	
//	bas_commandline("4 else");	
//	bas_commandline("6 endif");	
//	bas_commandline("7 goto 2");	
//	bas_commandline("9 end");	
//	bas_commandline("5 locate 0,0");	
	bas_commandline("run");	
//	edit();
#endif
#if MEMORYTYPE==MEMTYPE_EEPROM
#endif


	while(1)
	{
		bascodecnt=0;
		bascode_sta=0;

		//L[{[h		
		while(1)
		{
			char textw = dispwidth /(FONTW+1);

			if(bascodecnt < 0) bascodecnt=0;
			if(bascodecnt > BASCODEMAX-1) bascodecnt=BASCODEMAX-1;
			if((bascodecnt < bascode_sta)&&(bascode_sta > 0))
				bascode_sta--;

			if((bascodecnt >= (bascode_sta+textw))&&(bascode_sta < (BASCODEMAX-8)))
				bascode_sta++;

			i=0;
			for(i=0; i<textw; i++){
				key=bas_cmdget(bascode_sta + i);
				text_locate(i*(FONTW+1),-1);
				text_setcolor(0);
				text_putch2(0x7F);
				text_setcolor(1);
				if(key=='\0')break;
				text_locate(i*(FONTW+1),-1);
				text_putch2(key);
			}

			text_locate((bascodecnt-bascode_sta)*(FONTW+1),-1);
			key=getkey();
//			sio_tx(key);	//echo back
			if(key==2){	// A sw
				menu();
			}else if(key==KEYBOARD_ENTER){	//Enter key
				text_putch(13);	//cr
				if(bas_command()==0){//R}hsAYȂ̏ꍇ
					bas_decode();	//vOs
					text_putch(13);	//cr
				}
				bas_cmdins(0,'\0');	//NULL
				break;
			}else if(key==KEYBOARD_BS){	//
				if(bascodecnt > 0){
					bascodecnt--;
					bas_cmddel(bascodecnt);
				}
//			}else if(key==KEYBOARD_UP){	//
//				bas_readbakline();
//				break;
//			}else if(key==KEYBOARD_DOWN){	//
//				bas_readline();
//				break;
			}else if(key==KEYBOARD_RIGHT){	//
				if(bas_cmdget(bascodecnt)!='\0'){
					bascodecnt++;
				}	//NullEɂ̓J[\ړs
			}else if(key==KEYBOARD_LEFT){	//
				bascodecnt--;
			}else if(key < 0x20){
				//
			}else{
				bas_cmdins(bascodecnt,key);
				bascodecnt++;
			}
		}
	}
	return 0;
}



//------------------------------------
void filesave (char *fname)
{
	FATFS fatfs;	//(FAT file system by ChaN)
	BYTE buff[512];		/* Working buffer */
	UINT wcnt, cnt;
	BYTE res;
	FIL file;
	char ch;
	int i;
	char eof=0;

	f_mount(0, &fatfs);	//mount diskdrive
	// t@C쐬
	res = f_open(&file, fname, FA_CREATE_ALWAYS | FA_WRITE);
    if (res) {
		bas_errset(ERR_CARD);
	}else{
		//ŏ1sڂǂ
		bas_readline0();

		while(1)
		{
			wcnt=0;
			i=0;
			while(wcnt < sizeof(buff)){
				ch = bas_cmdget(i++);
				if(ch ==0){	//NULL
					ch = 13;	//sɒ
					eof = bas_readline();
					i=0;
				}
				buff[wcnt++] = ch;
				if(eof)break;	//EOF
			}
			res = f_write(&file, buff, wcnt, &cnt);
			if (res || (cnt < wcnt)) break;  //error
			if(eof)break;	//EOF
		}
	    f_close(&file);
	}

	f_mount(0, 0);	//unmount diskdrive
}

//----------------------------------
void fileload (char *fname)
{
	FATFS fatfs;	//(FAT file system by ChaN)
	FIL file;
	BYTE buff[512];			/* Working buffer / 1sector */
	int i;
	unsigned int adr=0;
	unsigned char ch;
	UINT cnt;
	BYTE res;

	f_mount(0, &fatfs);	//mount
	// \[XEt@CJ
	res = f_open(&file, fname, FA_OPEN_EXISTING | FA_READ);
	if (res) {
		//error
	}else{
		while(1){
			res = f_read(&file, buff, sizeof(buff), &cnt);
			if (res || (cnt == 0)) break;   // error or eof

			for(i=0; i<cnt; i++){
				ch = buff[i];
				if(ch==13){
					text_putch(13);
					ch = '\0'; //CR null
				}else if(ch < 0x20){
					continue;
				}else{
					text_putch(ch);
				}
				code_writebyte(adr++,ch);
			}
		}
		f_close(&file);
		code_writebyte(adr,BASCODE_EOF);	//eof
	}
	f_mount(0, 0);	//unmount
}
//------------------------------------------------------------
//
char fileselect (void)
{
	FATFS fatfs;	//(FAT file system by ChaN)
	unsigned char key;
	int i;
	int fn,fnmax;
	FILINFO finfo;
	DIR dir;
	BYTE res;
	char filetemp[12+1]="";	// 8+3+1+1

	f_mount(0, &fatfs);	//mount
	fn = 0;
	while(1){
		bas_cls();

		res = f_opendir(&dir, "/");	//Dir
		if (res) {
			bas_errset(ERR_CARD);
			break;
		}

		for(fnmax=0 ;;) {
			res = f_readdir(&dir, &finfo);
			if ((res != FR_OK) || !finfo.fname[0]) break;
			if(finfo.fattrib & AM_DIR) continue;

			i=str_len((char *)finfo.fname);
			if(i < 4)continue;
			i -= 4;
			if(str_cmp(finfo.fname+i,".txt")) continue;
			if(fnmax==fn){
				str_cpy(filetemp,(char *)finfo.fname);
			}
			fnmax++;
		}
		bas_print2(filetemp);
		bas_printd(fn+1);
		bas_print("/");
		bas_printd(fnmax);

		key = getkey();
		bas_cls();
		if ((key == 2)||(key==KEYBOARD_ENTER)){
			break;
		}else if (key == 3){	//cancel
			filetemp[0] = '\0';//null
			break;
		}else if((key == KEYBOARD_LEFT)||(key == KEYBOARD_UP)){
			fn--;
			if (fn < 0)
				fn = fnmax-1;
		}else if((key == KEYBOARD_RIGHT)||(key == KEYBOARD_DOWN)) {
			fn++;
			if (fn >= fnmax)	fn = 0;
		}
	}
	f_mount(0, 0);	//unmount

	if(filetemp[0] == '\0')
		return(0);	//not open

	fileload(filetemp);
	return(1);
}

