// NicoBASIC by Takuya Matsubara / NICO Corp. 2008
// http://www.nicotak.com/
//
// LCD function
//
// ppEĔzz͎Rɂł܂B
// Ĕzzꍇɂ͂킩₷`ŖLĂB
//---------------------------------------------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include "lcd.h"
#include "akiled.h"



//*********************************
//	^C}[Q
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif


char dispmode=DISPMODE_SG12232;

//^C}gLCDɃNbN
#define INTRCYCLE  5000	//x2[Hz]
#define T2PRESCALE  8	// ^C}2vXP[l
#define T2PRESCALER 2	// ^C}2vXP[ݒ
#define T2OCR ((F_CPU/T2PRESCALE)/INTRCYCLE)

#define LCD_BUSDDR  DDRA
#define LCD_BUSPORT PORTA

#define LCD_DDR     DDRD
#define LCD_PORT    PORTD
#define LCD_A0  (1<<2)
#define LCD_RS LCD_A0
#define LCD_CS1 (1<<3)
#define LCD_E2 LCD_CS1
#define LCD_CS2 (1<<4)

#define LCDE_DDR     DDRG
#define LCDE_PORT    PORTG
#define LCDE_BIT   (1<<0)

#define XMEM_DISABLE 0

#define VRAMMAX 488	//61bytes * 4page * 2
unsigned char vram[VRAMMAX];//488


char dispwidth=122;
char dispheight=32;

//SG12232
//20:K   19:A
//18:RES 17:db7
//16:db6 15:db5
//14:db4 13:db3
//12:db2 11:db1
//10:db0 9:r/w
//8:e    7:clk
//6:cs2  5:cs1
//4:A0   3:vo
//2:vcc  1:gnd


void vram_clear(void)
{
	unsigned char *p = &vram[0];
	int i;

	for(i=0; i<VRAMMAX; i++){
		*p++ = 0;
	}
}
//-------------------
char vram_point(char x,char y)
{
	int addr;
	unsigned char mask;

	if(x<0)return(0);
	if(y<0)return(0);
	if(x>=dispwidth)return(0);
	if(y>=dispheight)return(0);

	addr = ((y>>3)*122)+x;   //  ((y/8)*122)+x
	mask = 1 << (y & 0b111);//  mask=1<<(y % 8)

	if(vram[addr] & mask)
		return(1);
	else
		return(0);
}
//-----------------
void vram_pset(char x,char y,char c)
{
	int addr;
	unsigned char mask;

	if(x<0)return;
	if(y<0)return;
	if(x>=dispwidth)return;
	if(y>=dispheight)return;

	addr = ((y>>3)*122)+x;    //  addr=((y/8)*122)+x
	mask = 1 << (y & 0b111);  //  mask=1<<(y % 8)

	if(c==0)
		vram[addr] &= ~mask;
	else if(c==1)
		vram[addr] |= mask;
	else
		vram[addr] ^= mask;
}
//-----------------
void vram_scroll(char xd,char yd)
{
	unsigned char temp1,temp2,temp3,temp4;
	char yd2;
	int i,j;

	if(xd == 0){
	}else if(xd > 0){
		while(xd--){
			for(j=0; j<(4*122); j+=122){
				for(i=j; i<(j+121); i++){
					vram[i] = vram[i+1];
				}
				vram[j+121] =0;
			}
		}
	}else{
		xd = -xd;
		while(xd--){
			for(j=0; j<(4*122); j+=122){
				for(i=(j+121); i>j; i--){
					vram[i] = vram[i-1];
				}
				vram[j+0] =0;
			}
		}
	}

	if(yd > 0){
		yd2 = (8-yd);
		for(i=0; i<122; i++){
			temp1 = vram[i+(122*0)];
			temp2 = vram[i+(122*1)];
			temp3 = vram[i+(122*2)];
			temp4 = vram[i+(122*3)];
			vram[i+(122*0)] = (temp1 >> yd)|(temp2 << yd2);
			vram[i+(122*1)] = (temp2 >> yd)|(temp3 << yd2);
			vram[i+(122*2)] = (temp3 >> yd)|(temp4 << yd2);
			vram[i+(122*3)] = (temp4 >> yd);
		}
	}else{
	//
	}
}

//-----------------
void lcd_delay(void)
{
#define DELAYCNT 0
	char i;
	for(i=0; i<DELAYCNT ;i++);
}

void lcd_wait( char m )
{
	int i;
    while( m-- > 0 ) {
		for(i=0;i<40;i++);
    }
}





//-----------------
void lcd_setbyte(unsigned char dat)
{
#if XMEM_DISABLE
	LCD_BUSPORT = dat;
	if(dispmode==DISPMODE_SG12232){
		lcd_delay();
		LCDE_PORT &= ~LCDE_BIT;
		lcd_delay();
		LCDE_PORT |= LCDE_BIT;
	}else{
		LCD_PORT |= LCD_E2;
		lcd_wait(1);
		LCD_PORT &= ~LCD_E2;
	}
	
#else
	unsigned char *offset=(unsigned char *)0x7FFF;
	//dummy address

	if(dispmode==DISPMODE_SG12232){
		lcd_delay();
		*offset = dat;
	}else{
		PORTC |= 0xff;//A8-A15
		DDRC |= 0xff;
		MCUCR &= ~( 1 << SRE );
		LCD_BUSPORT = dat;
		LCD_PORT |= LCD_E2;
		lcd_wait(1);
		LCD_PORT &= ~LCD_E2;
		MCUCR |= ( 1 << SRE );
	}
	lcd_delay();

#endif
}
//-----------------
void lcd_cs(char chipnum)
{
	LCD_PORT |= (LCD_CS1|LCD_CS2);
	lcd_delay();
	if(chipnum==1)	LCD_PORT &= ~LCD_CS1;
	if(chipnum==2)	LCD_PORT &= ~LCD_CS2;
	lcd_delay();//
}

//-----------------
void lcd_setcmd(unsigned char cmd)
{

	LCD_PORT &= ~LCD_A0; //mode = command
	lcd_cs(1);
	lcd_setbyte( cmd ); //
	lcd_cs(2);
	lcd_setbyte( cmd ); //
	LCD_PORT |= LCD_A0; //mode = data
	lcd_cs(0);	// CS disable
} 
//-----------------
void lcd_init(void)
{
#if XMEM_DISABLE
	PORTG |= 0b011; //~WR ~RD ALE disable
	DDRG |= 0b111;  //~WR ~RD ALE output 
	PORTC |= 0xff;//A8-A15
	DDRC |= 0xff;

	LCD_BUSDDR |= 0xff;//D0-D7
#else
	MCUCR |= ( 1 << SRE )|(0 << SRW10);
//SRE:External SRAM/XMEM Enable
//SRW10: Wait State Select Bit

    XMCRA = ( 0 << SRW01 )| ( 0 <<SRW00 ) | ( 0 << SRW11 );
//SRL2, SRL1, SRL0: Wait State Sector Limit
//000b= Lower sector=N/A ,Upper sector=0x1100 - 0xFFFF
//SRW01, SRW00: Wait State Select Bits for Lower Sector
//00b= No wait states

//    XMCRB = ( 0 << XMM2 )| ( 0 <<XMM1 ) |( 0 << XMM0 );

//ATmega103 non-compatible mode.
//32KB external memory 0x1100 to 0x90FF.

#endif
	LCD_PORT |= (LCD_A0 | LCD_CS1 | LCD_CS2);
	LCD_DDR |=  (LCD_A0 | LCD_CS1 | LCD_CS2);

	//---------------OC2pXo
	DDRB |= (1<<7);	//OC2
    TCCR2= (1<<COM20)| T2PRESCALER;       // TCCR2 vXP[ݒ /gO
	OCR2 = T2OCR;

	if(dispmode==DISPMODE_SG12232){
		vram_clear();
		lcd_setcmd(0xE2);	//reset
		lcd_setcmd(0xAF);	//S on
	}else{
		LCD_PORT &= ~LCD_E2;
	    LCD_PORT &= ~LCD_RS;   // RS = L 
	    lcd_wait(150);
	    lcd_setbyte( 0x30 ); //Function Set Mode 
	    lcd_wait(40);
	    lcd_setbyte( 0x30 );
	    lcd_wait(10);
	    lcd_setbyte( 0x30 );
//	    lcd_setbyte( 0x38 ); //Function Set Mode=8bit
	    lcd_setbyte( 0x38 ); // Mode=8bit / Line=2 / Font=5x7dot
	    lcd_setbyte( 0x0F ); // Display=ON / Cursor=ON / Blink=ON 
	    lcd_setbyte( 0x06 ); // Cursor=Increment / Display_shift=OFF 
	    lcd_setbyte( 0x01 ); // Display Clear
	    lcd_wait(20);
	    LCD_PORT |= LCD_RS;    // RS = H 
	}
}

void lcd_setchar(char tx ,char ty,char ch)
{
	if(dispmode==DISPMODE_SG12232)return;
	if(tx>=16)return;
	if(ty>=2)return;

    LCD_PORT &= ~LCD_RS;    // RS = L
	lcd_setbyte(0x80 | tx | (0x40 * ty)); // Address = 0 
    LCD_PORT |= LCD_RS;    // RS = H

	lcd_setbyte(ch);
}



//      chip1       chip2
//page0 [  0]-----  [ 61]-----
//page1 [122]-----  [183]-----
//page2 [244]-----  [305]-----
//page3 [366]-----  [427]-----



void lcd_setvram(char icnum)
{
	char pagenum;
	unsigned char *p;
	char colnum;
//	int addr;

	lcd_cs(icnum);
	if(icnum==1){
		p = &vram[0];
//		addr=0;
	}else{
		p = &vram[61];
//		addr=61;
	}
	for(pagenum = 0; pagenum<4 ; pagenum++){

		LCD_PORT &= ~LCD_A0; //mode = command
		lcd_setbyte(0xb8 + pagenum); //y[Wݒ
		lcd_setbyte(0); 			//݃J=0

		LCD_PORT |= LCD_A0; //mode = data
		for(colnum = 0; colnum<61 ; colnum++){
//			lcd_setbyte( vram[addr++] );
			lcd_setbyte( *p++ );
		}
//		addr+=61;
		p += 61;
	}
}



//          -FX11111111 -fh10011001 -FL11100100
// (default)-FX11111101 -fh10011001 -FL11100001


/*
External Crystal/Ceramic Resonator 1111 - 1010
External Low-frequency Crystal 1001
External RC Oscillator 1000 - 0101
Calibrated Internal RC Oscillator
0100 8MHz
0011 4MHz
0010 2MHz 
0001 1MHz(default)
External Clock 0000
*/

void lcd_disp(void)
{
	if(dispmode==DISPMODE_SG12232){
		led_enable(0);//LED disable
		lcd_setvram(1);
		lcd_setvram(2);
		lcd_cs(0);	// LCD CS disable
		led_enable(1);//LED enable
	}
}

/*
void vram_boxf(char x1 ,char y1 ,char x2 ,char y2 ,char color)
{
	char x;
	char y;

	if(x1 > x2){
		x = x1;
		x1 = x2;
		x2 = x;
	}
	if(y1 > y2){
		y = y1;
		y1 = y2;
		y2 = y;
	}
	for(y=y1 ;y<y2 ;y++){
		for(x=x1 ;x<x2 ;x++){
			vram_pset(x, y ,color); //hbg`
		}
	}
}
*/

//--------------------------------------------------------------------------------
//C`
//x1FX1W
//y1FY1W
//x2FX2W
//y2FY2W
//colorFJ[R[hB0=A1=
void vram_line(char x1 ,char y1 ,char x2 ,char y2 ,char color)
{
	char xd;	// X2-X1W̋
	char yd;	// Y2-Y1W̋
	char xs=1;  // X1pixelړ
	char ys=1;  // Y1pixelړ
	int e;

	xd = x2 - x1;	 // X2-X1W̋
	if(xd < 0){
		xd = -xd;	 // X2-X1W̐Βl
		xs = -1;	  // X1pixelړ
	}
	yd = y2 - y1;	 // Y2-Y1W̋
	if(yd < 0){
		yd = -yd;	 // Y2-Y1W̐Βl
		ys = -1;	  // Y1pixelړ
	}
	vram_pset(x1, y1 ,color); //hbg`
	e = 0;
	if( yd < xd ) {
		while( x1 != x2) {
			x1 += xs;
			e += (2 * yd);
			if(e >= xd) {
				y1 += ys;
				e -= (2 * xd);
			}
			vram_pset(x1, y1 ,color); //hbg`
		}
	}else{
		while( y1 != y2) {
			y1 += ys;
			e += (2 * xd);
			if(e >= yd) {
				x1 += xs;
				e -= (2 * yd);
			}
			vram_pset (x1, y1 ,color); //hbg`
		}
	}
}

//
void vram_circle(char Xcenter, char Ycenter, char Radius)
{
    int tswitch;
    char X, Y;
    char dYX;

    dYX = Ycenter - Xcenter;
    X = 0;
    Y = Radius;
    tswitch = 3 - 2 * Radius;
    while (X <= Y) {
        vram_pset(Xcenter + X, Ycenter + Y,1);     
        vram_pset(Xcenter + X, Ycenter - Y,1);
        vram_pset(Xcenter - X, Ycenter + Y,1);     
        vram_pset(Xcenter - X, Ycenter - Y,1);
        vram_pset(Ycenter + Y - dYX, Ycenter + X,1); 
        vram_pset(Ycenter + Y - dYX, Ycenter - X,1);
        vram_pset(Ycenter - Y - dYX, Ycenter + X,1); 
        vram_pset(Ycenter - Y - dYX, Ycenter - X,1);

        if (tswitch < 0) {
            tswitch += (4 * X + 6);
        }
        else {
            tswitch += (4 * (X - Y) + 10);
            Y--;
        }
        X++;
    }
}

