//-----------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include "akiled.h"

//*********************************

char linecnt;

#define LED_DDR     DDRD
#define LED_PORT    PORTD
#define LED_LATCH (1<<5)

#define LEDIN_DDR     DDRA
#define LEDIN_PORT    PORTA
#define LED_IN1   (1<<0)
#define LED_IN2   (1<<1)
#define LED_IN3   (1<<2)

#define LED_CLK   (1<<0)
#define LEDCLK_DDR     DDRG
#define LEDCLK_PORT    PORTG

extern unsigned char vram[488];//488


//char led_flag=1;

//void led_enable(char enableflag)
//{
//	led_flag = enableflag;
//}



//-----------------
void led_init(void)
{
	int i;
//	unsigned char *offset=(unsigned char *)0x7FFF; //dummy address

//	MCUCR |= ( 1 << SRE )|(0 << SRW10);//External SRAM/XMEM Enable
//  XMCRA = ( 0 << SRW01 )| ( 0 <<SRW00 ) | ( 0 << SRW11 );

	linecnt=0;

	LED_PORT |= LED_LATCH ;
	LED_DDR |= LED_LATCH;

	LEDCLK_PORT &= ~LED_CLK;
	LEDCLK_DDR |= LED_CLK;

	LEDIN_PORT &= ~(LED_IN1 | LED_IN2 | LED_IN3);
	LEDIN_DDR |= (LED_IN1 | LED_IN2 | LED_IN3);

	for(i=0;i<16;i++)
	{
		LEDCLK_PORT |= LED_CLK;
		LEDCLK_PORT &= ~LED_CLK;
	
//		*offset=0;
	}
	LED_PORT &= ~LED_LATCH ;
	LED_PORT |= LED_LATCH ;
}


//      chip1       chip2
//page1 [  0]-----  [ 61]-----
//page2 [122]-----  [183]-----
//page3 [244]-----  [305]-----
//page4 [366]-----  [427]-----

	unsigned char *offset=(unsigned char *)0x7FFF; //sram address
	unsigned char *p = &vram[15];
	char ledcol=0;

//1C_
void led_disp(void)
{
	char i=4;
	unsigned char mask;
	unsigned char leddata;

	mask = 1 << (linecnt & 7);

		//ʃrbg瑗M
	while(i--)
	{
		leddata = (ledcol==linecnt);

		if(mask & *p){
			leddata |= (1<<1);
		}
		if(mask & *(p+16)){
			leddata |= (1<<2);
		}
		*offset = leddata;
		p--;
		ledcol++;
	}
	if(ledcol >= 16){
		ledcol=0;

		LED_PORT &= ~LED_LATCH ;	/*latch on*/
//		linecnt++;
//		if(linecnt >= 16)
//			linecnt=0;
		linecnt = (linecnt +1) & 15;
		LED_PORT |= LED_LATCH ;	/*latch off*/

		if(linecnt < 8)
			p = &vram[15];
		else
			p = &vram[15+122];

	}
}




