// Developed by mgjtg[ig Part284 136
/*-----------------------------------------------------------------------------
NHKtCGI̊kifutH[}bgɕϊtB^
-----------------------------------------------------------------------------*/

#include "stdafx.h"
#include "NHK_HENKAN.h"

namespace {

// L[[h^Cv
enum KeywordType {
	KT_OnAir,
	KT_Title,
	KT_Stage,
	KT_Start,
	KT_End,
	KT_Player1,
	KT_Player2,
	KT_Notify,
	KT_p,
	KT_END,

	KT_Result,
	KT_Tactics,
	KT_h1,
	KT_h2,
	KT_NSP100,

	KT_Unknown,
};

// L[[h
struct KeywordInfo
{
	// L[[h (es̐擪̕)
	LPCTSTR keyword;
	// L[[h^Cv
	KeywordType type;
};

// ׂẴL[[h
static const KeywordInfo keyword[]={
	// ̍s͎̏g
	{ _T("OnAir="),   KT_OnAir },
	{ _T("Title="),   KT_Title },
	{ _T("Stage="),   KT_Stage },
	{ _T("Start="),   KT_Start },
	{ _T("End="),     KT_End },
	{ _T("Player1="), KT_Player1 },
	{ _T("Player2="), KT_Player2 },
	{ _T("Notify="),  KT_Notify },
	{ _T("p="),       KT_p },
	{ _T("END"),      KT_END },

	// ̍s͎̏gȂ
	{ _T("Result="),  KT_Result },
	{ _T("Tactics="), KT_Tactics },
	{ _T("h1="),      KT_h1 },
	{ _T("h2="),      KT_h2 },
	{ _T("NSP100"),   KT_NSP100 },
};

// ΉL[[h擾
const KeywordInfo& GetKeywordInfo(LPCTSTR p)
{
	for(int i=0; i<sizeof(keyword)/sizeof(keyword[0]); i++){
		if(!_tcsncmp(keyword[i].keyword, p, _tcslen(keyword[i].keyword))){
			return keyword[i];
		}
	}
	static const KeywordInfo unkown = { _T(""), KT_Unknown };
	return unkown;
}

// ̒`
// cgił̋̒`     // {programł̋̒` = F0x00/:0x10{ʂ̋ԍt
// 00, 'emp',        // 00, 'emp', 
// 01, 'ou0',        // 01, 'ou0', 
// 02, 'gy0',        // 02, 'gy0', 
// 03, 'hi0',        // 03, 'hi0', 
// 04, 'ry0',        // 04, 'ry0', 
// 05, 'ka0', p       // 05, 'ka0', p
// 06, 'um0', n       // 06, 'um0', n
// 07, 'ki0',        // 07, 'ki0', 
// 08, 'gi0',        // 08, 'gi0', 
// 09, 'gn0',      // 09, 'gn0', 
// 0a, 'ke0', j       // 0a, 'ke0', j
// 0b, 'kn0', j     // 0b, 'kn0', j
// 0c, 'ky0',        // 0c, 'ky0', 
// 0d, 'kyn0',     // 0d, 'kyn0',
// 0e, 'fu0',        // 0e, 'fu0', 
// 0f, 'to0',        // 0f, 'to0', 
// 10, 'ou1',        // 11, 'ou1', 
// 11, 'gy1',        // 12, 'gy1', 
// 12, 'hi1',        // 13, 'hi1', 
// 13, 'ry1',        // 14, 'ry1', 
// 14, 'ka1', p       // 15, 'ka1', p
// 15, 'um1', n       // 16, 'um1', n
// 16, 'ki1',        // 17, 'ki1', 
// 17, 'gi1',        // 18, 'gi1', 
// 18, 'gn1',      // 19, 'gn1', 
// 19, 'ke1', j       // 1a, 'ke1', j
// 1a, 'kn1', j     // 1b, 'kn1', j
// 1b, 'ky1',        // 1c, 'ky1', 
// 1c, 'kyn1',     // 1d, 'kyn1',
// 1d, 'fu1',        // 1e, 'fu1', 
// 1e, 'to1'         // 1f, 'to1'  

static LPCTSTR koma_name[]={
	_T(""),       // 00
	_T(""),     // 01
	_T(""),     // 02
	_T(""),     // 03
	_T(""),     // 04
	_T("p"),     // 05
	_T("n"),     // 06
	_T(""),     // 07
	_T(""),     // 08
	_T(""),   // 09
	_T("j"),     // 0a
	_T("j"),   // 0b
	_T(""),     // 0c
	_T(""),   // 0d
	_T(""),     // 0e
	_T("")      // 0f
};

// Ղ̈ʒu
static LPCTSTR board_place[][2]={
	{ NULL, NULL },
	{ _T("P"), _T("") },
	{ _T("Q"), _T("") },
	{ _T("R"), _T("O") },
	{ _T("S"), _T("l") },
	{ _T("T"), _T("") },
	{ _T("U"), _T("Z") },
	{ _T("V"), _T("") },
	{ _T("W"), _T("") },
	{ _T("X"), _T("") },
};

// 2byte̕ŕ\Ăintɒu}N
// ͂ЂƂ炷Ƃ4LSB㋤ʂ̋\悤ɂB
inline int DBYTE2KOMA(TCHAR x, TCHAR y)
{
	return (x-_T('0'))*16 + (y>_T('9')?y-_T('a')+10:y-_T('0')) + (x-_T('0'));
}

/**
 * tH[}bgʂ𕶎ɒǉ.
 */
void AddPrintfToStr(tstring& str, LPCTSTR format, ...)
{
	va_list args;
	va_start(args, format);

	TCHAR buf[1024];
	_vstprintf_s(buf, format, args);
	str += buf;

	va_start(args, format);
}

/**
 * 𕶎ɒǉ.
 */
inline void AddStr(tstring& str, LPCTSTR s)
{
	str += s;
}

}	// anonymous namespace

bool ConvertKifData(LPCTSTR src, size_t size, KifData& kifData)
{
	// ߂Ă
	tstring info_kaishi;   // Jn
	tstring info_shuuryou; // I
	tstring info_hyoudai1; // \(#1)
	tstring info_hyoudai2; // \(#2)
	tstring info_sente;    // 
	tstring info_gote;     // 
	tstring info_housou;   // *
	tstring info_notify;   // *m点

	// w̐̃JE^i̎w/̎wj
	int tesuu=1;

	// Ֆʂ̉ߊ֘A (ŏ 0 OȂ̂ŁA0 )
	int banmen[2][9][9]={ //݁AyшO̔Ֆʂ9x9\
		{
			{0x1c,0x1a,0x18,0x17,0x11,0x17,0x18,0x1a,0x1c},
			{0x00,0x15,0x00,0x00,0x00,0x00,0x00,0x13,0x00},
			{0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e},
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e},
			{0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x05,0x00},
			{0x0c,0x0a,0x08,0x07,0x02,0x07,0x08,0x0a,0x0c},
		},
	};

	// f[^ǂݍ݊֘A
	TCHAR linenuffer[300];  //
	int  charcnt=0;

	// Óű̈ʒuv (Ƃ "`" ɂ邽)
	int cur_dan_bak = -1, cur_suji_bak = -1;

	// ݉͒̃̕CfbNX
	size_t index = 0;
	while(index < size){
		// ͂镶擾
		TCHAR c = src[index++];

		// s܂Ńobt@ɂƂ肱
		if(c!=_T('\n')){
			linenuffer[charcnt++]=c;
			continue;
		}

		// Ō̃Z~Rꕶ
		if (charcnt > 0 && linenuffer[charcnt-1] == _T(';')) {
			linenuffer[charcnt-1]=_T('\0');
		}
		charcnt=0;

		// ݍs̃^Cv
		KeywordInfo keywordInfo = GetKeywordInfo(linenuffer);
		if (keywordInfo.type == KT_Unknown) {
			// unknown keyword
			return false;
		}

		// eAs^CvƂ̏

		LPCTSTR datastring=&linenuffer[_tcslen(keywordInfo.keyword)];
		switch(keywordInfo.type){
			// ̎荞
			case  KT_OnAir:   info_housou   = datastring; break; // "OnAir=",
			case  KT_Title:   info_hyoudai1 = datastring; break; // "Title=",
			case  KT_Stage:   info_hyoudai2 = datastring; break; // "Stage=",
			case  KT_Start:   info_kaishi   = datastring; break; // "Start=",
			case  KT_End:     info_shuuryou = datastring; break; // "End=",
			case  KT_Player1: info_sente    = datastring; break; // "Player1=",
			case  KT_Player2: info_gote     = datastring; break; // "Player2=",
			case  KT_Notify:  info_notify   = datastring; break; // "Notify=",

			// ȉ̃L[[hŎn܂s͎gȂ
			case KT_END:      // "END"
			case KT_Result:   // "Result=",
			case KT_Tactics:  // "Tactics=",
			case KT_h1:       // "h1=",
			case KT_h2:       // "h2=",
			case KT_NSP100:   // "NSP100",
				break;

			// ȉAՖʏ̍s̏
			// O̔ՖʂƔr邱ƂŎwo
			case KT_p: { // "p=",

				//̑OɊo
				if(tesuu==1){
					AddPrintfToStr(kifData.kif, _T("F%s\r\n")       , info_hyoudai1.c_str());
					AddPrintfToStr(kifData.kif, _T("JnF%s\r\n")   , info_kaishi.c_str());
					AddPrintfToStr(kifData.kif, _T("IF%s\r\n")   , info_shuuryou.c_str());
					AddPrintfToStr(kifData.kif, _T("\F%s\r\n")       , info_hyoudai2.c_str());
					AddPrintfToStr(kifData.kif, _T("F%s\r\n")       , info_sente.c_str());
					AddPrintfToStr(kifData.kif, _T("F%s\r\n")       , info_gote.c_str());
					AddStr        (kifData.kif, _T("萔----w-----------\r\n"));
					AddPrintfToStr(kifData.kif, _T("*fF%s\r\n")    , info_housou.c_str());
					AddPrintfToStr(kifData.kif, _T("*ڍׁF%s%s\r\n"), info_hyoudai1.c_str(), info_hyoudai2.c_str());
					AddPrintfToStr(kifData.kif, _T("*u%svvsu%sv\r\n"), info_sente.c_str()   , info_gote.c_str());
					if (!info_notify.empty()) {
						AddPrintfToStr(kifData.kif, _T("* %s\r\n"),        info_notify.c_str());
					}
					kifData.onAir = info_housou;
					kifData.title = info_hyoudai1;
					kifData.stage = info_hyoudai2;
					kifData.player1 = info_sente;
					kifData.player2 = info_gote;
					kifData.notify  = info_notify;
				}

				//O/ǖʂ2̔Ֆʂ29x9z̔zシ邱ƂōsB
				//̓Iɂ́AwJE^1LSB2݂ɐ؂ւB
				int cur=tesuu&0x01;
				int old=cur^0x01;

				//iẃjՖʂ9x9zւ̎荞
				for(int dan=0; dan<9; dan++){
					for(int suji=0; suji<9; suji++){
						int koma = DBYTE2KOMA(datastring[0], datastring[1]);
						if(koma>31){
							return false;
						}
						datastring+=2;
						banmen[cur][dan][suji]=koma;
					}
				}

				int cur_dan, cur_suji, cur_koma; //̋̈ʒuƎ
				int old_dan, old_suji, old_koma; //Ő̈ʒuƎ
				//OiwÓjՖʂƂ̔r
				old_koma = -1;  // łꍇ(-1)̂܂܂ƂȂ邱Ƃ_
				for(int dan=0; dan<9; dan++){
					for(int suji=0; suji<9; suji++){
						// OƍŕςĂ
						if(banmen[cur][dan][suji]!=banmen[old][dan][suji]){
							// ݋Ȃ (֓)
							if(banmen[cur][dan][suji]==0){
								old_dan =dan;
								old_suji=suji;
								old_koma=banmen[old][dan][suji];
							}
							// ݋ (֓)
							else{
								cur_dan =dan;
								cur_suji=suji;
								cur_koma=banmen[cur][dan][suji];
							}
						}
					}
				}

				bool uchi_flag = false;    // ułvŖꍇ́iuv̉\܂߁jŐɂȂ
				//łꍇ̏
				if (old_koma == -1) {
					old_koma = cur_koma;  //OIȏꍇׂ̈ɒ`(-1)Ă
					uchi_flag = true;        //̑Azɢłł邱ƂtO𗧂ĂĂ
				}

				// kif for win ŃMMǂݍ߂ł낤KIF̎w̏o
				tstring line;
				// 萔
				AddPrintfToStr(line, _T("%4d "), tesuu);
				// ꏊ
				// OƓ
				if (cur_suji_bak == cur_suji && cur_dan_bak == cur_dan) {
					AddStr(line, _T("@"));
				}
				else {
					AddStr(line, board_place[cur_suji+1][0]);
					AddStr(line, board_place[cur_dan+1] [1]);
				}
				// 
				AddStr(line, koma_name[old_koma%16]);
				// 
				if(old_koma!=cur_koma) { //OƋ̔ԍςĂ΁AuvƔfĂ
					AddStr(line, _T(""));
				}
				// ł or Öʒu
				if (uchi_flag) {
					AddStr(line, _T(""));
				}else{
					AddPrintfToStr(line, _T("(%1d%1d)"), old_suji+1, old_dan+1);
				}
				// ݂̍sԊJnʒu܂ł̕
#if 0
				int size = 18 - line.size();
#else
				// HACK: Multi-byte ŐKv
				// TODO: ɗ܂łɐ͂
				int size = 18 - strlen(CT2A(line.c_str()));
#endif
				ASSERT(size > 0);
				if (size > 0) {
					AddStr(line, tstring(size, _T(' ')).c_str());
				}
				AddStr(line, _T("( 0:00/00:00:00)\r\n"));

				AddStr(kifData.kif, line.c_str());

				// ̈ʒuۑĂ
				cur_dan_bak  = cur_dan;
				cur_suji_bak = cur_suji;

//				// Ô߁AusvȂǂ̗L蓾Ȃꍇ`FbNĂ
//				if(old_koma!=cur_koma){
//					switch(old_koma%16){
//						case 0x03:  // 'hi0',  // uvɂȂ肦
//						case 0x05:  // 'ka0', p
//						case 0x08:  // 'gi0', 
//						case 0x0a:  // 'ke0', j
//						case 0x0c:  // 'ky0', 
//						case 0x0e:  // 'fu0', 
//							break;
//						case 0x01:  // 'ou0',  // uvɂȂ肦Ȃ
//						case 0x02:  // 'gy0', 
//						case 0x04:  // 'ry0', 
//						case 0x06:  // 'um0', n
//						case 0x07:  // 'ki0', 
//						case 0x09:  // 'gn0', 
//						case 0x0b:  // 'kn0', j
//						case 0x0d:  // 'kyn0',
//						case 0x0f:  // 'to0', 
//							printf("---err---\n");
//							exit(1);
//					}
//					switch(new_koma%16){
//						case 0x04:  // 'ry0',   // Ȃǂ
//						case 0x06:  // 'um0', n
//						case 0x09:  // 'gn0', 
//						case 0x0b:  // 'kn0', j
//						case 0x0d:  // 'kyn0',
//						case 0x0f:  // 'to0', 
//							if(old_koma==0){
//								printf("---err2---\n");
//								exit(1);
//							}
//					}
//					if((old_koma+1)!=cur_koma){  // u⁨jvȂǂȂǂ
//						printf("---err3---\n");
//						printf("%02x\n", old_koma);
//						exit(1);
//					}
//				}

				// 萔CN
				tesuu++;

			} // case type=7
		} // switch
	} // while(getchar()!= EOF)

	AddPrintfToStr(kifData.kif, _T("%4d          ( 0:00/00:00:00)\r\n"), tesuu);
	kifData.moves = tesuu - 1;
	AddPrintfToStr(kifData.kif, _T("܂%d%s̏\r\n"), kifData.moves, kifData.moves % 2 == 1 ? _T("") : _T(""));

	return true;
}
