/*--------------*/
/* conffile.cpp */
/*--------------*/
#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include "conffile.h"
#include "myutil.h"
#include "calc/calc.h"

CCALC calc;
void conffile::readfile(char filename[])
{
    FILE *fp;
    char sbuf[1024];
    char *str;
    char index[32] = "\0", confbody[1024] = "\0";
    bool flg_dq;
    char *p;
    int i;
    fp = fopen(filename, "r");
    if (fp == NULL)
      {
          printf("can't open %s\n", filename);
          exit(1);
      }
    while (fgets(sbuf, 1024, fp) != NULL)
      {
          sprintf(index, "\0");
          sprintf(confbody, "\0");
          del_linefeed(sbuf);   //改行コードをナル文字に変換
          if ((p = strrchr(sbuf, '#')) != NULL)
              *p = '\0';        //コメントを削除
          str = cutspace(sbuf);
          if (*str != '\0')
            {
                //*** まず、最初のスペースまでをインデックスとしてとる ***//
                str = cutspace(sbuf);
                for (i = 0; ifspace(*(str + i)) == false; i++)
                  {
                      addchar2eol(index, *(str + i));
                  }
                //*** スペースが"〜"外で来た時までを設定本文としてとる ***//
                flg_dq = false;
                str = cutspace(str + i);
                for (i = 0; ifspace(*(str + i)) == false || flg_dq == false;
                     i++)
                  {
                      if (*(str + i) == '\0')
                          break;
                      if (*(str + i) == '\"')
                        {
                            flg_dq = switchflg(flg_dq);
                      } else
                        {
                            if(ifspace(*(str+i))==false||flg_dq==true)
                            addchar2eol(confbody, *(str + i));
                        }
                  }
                if (strcmp(index, "dxf_nonallaxis") == 0)
                  {
                      vdxffilepath_nonallaxis =
                          (char *) malloc(sizeof(char) *
                                          (strlen(confbody) + 2));
                      sprintf(vdxffilepath_nonallaxis, confbody);
                } else if (strcmp(index, "dxf_allaxis") == 0)
                  {
                      vdxffilepath_allaxis =
                          (char *) malloc(sizeof(char) *
                                          (strlen(confbody) + 2));
                      sprintf(vdxffilepath_allaxis, confbody);
                } else if (strcmp(index, "cycle") == 0)
                  {
                      vcycle = calc.flont(confbody);
                } else if (strcmp(index, "angle_x") == 0)
                  {
                      vangle_x = calc.flont(confbody);
                } else if (strcmp(index, "angle_y") == 0)
                  {
                      vangle_y = calc.flont(confbody);
                } else if (strcmp(index, "angle_z") == 0)
                  {
                      vangle_z = calc.flont(confbody);
                } else if (strcmp(index, "positiond_x") == 0)
                  {
                      if (strcmp(confbody, "automatic") == 0)
                          vpositiond_x = NULL;
                      else
                          vpositiond_x = calc.flont(confbody);
                } else if (strcmp(index, "positiond_y") == 0)
                  {
                      if (strcmp(confbody, "automatic") == 0)
                          vpositiond_y = NULL;
                      else
                          vpositiond_y = calc.flont(confbody);
                } else if (strcmp(index, "positiond_z") == 0)
                  {
                      if (strcmp(confbody, "automatic") == 0)
                          vpositiond_z = NULL;
                      else
                          vpositiond_z = calc.flont(confbody);
                } else if (strcmp(index, "deltap") == 0)
                  {
                      vdeltap = calc.flont(confbody);
                } else if (strcmp(index, "scale") == 0)
                  {
                      vscale = calc.flont(confbody);
                } else if (strcmp(index, "aviout") == 0)
                  {
                      if (strcmp(confbody, "on") == 0)
                          vavioutput = true;
                      else if (strcmp(confbody, "off") == 0)
                          vavioutput = false;
                      else
                        {
                            printf("`%s %s` is NOT FOUND.\n", index, confbody);
                            exit(1);
                        }
                } else if (strcmp(index, "avi_start") == 0)
                  {
                      vavioutputtime_start = calc.flont(confbody);
                } else if (strcmp(index, "avi_end") == 0)
                  {
                      vavioutputtime_end = calc.flont(confbody);
                } 
            }
      }
    fclose(fp);
}


bool conffile::ifspace(char c)
{
    char table[] = "\t ";
    if (strrchr(table, c) != NULL)
        return true;
    return false;
}

char *conffile::cutspace(char *s)
{
    while (ifspace(*s) == true)
        s++;
    return s;
}

void conffile::addchar2eol(char str[], char c)
{
    int size = strlen(str) + 2;
    char *s = (char *) malloc(size * sizeof(char));
    sprintf(s, "%s%c", str, c);
    sprintf(str, s);
    free(s);
}

char *conffile::dxffilepath(char *mode)
{
    if (strcmp(mode, "nonallaxis") == 0)
        return vdxffilepath_nonallaxis;
    if (strcmp(mode, "allaxis") == 0)
        return vdxffilepath_allaxis;
}

double conffile::cycle()
{
    return vcycle;
}

double conffile::angle(char mode[])
{
    switch (mode[0])
      {
      case 'x':
          return vangle_x;
          break;
      case 'y':
          return vangle_y;
          break;
      case 'z':
          return vangle_z;
          break;
      }
}

double conffile::positiond(char mode[])
{
    switch (mode[0])
      {
      case 'x':
          return vpositiond_x;
      case 'y':
          return vpositiond_y;
      case 'z':
          return vpositiond_z;
      }
}

double conffile::deltap()
{
    return vdeltap;
}

double conffile::scale()
{
    return vscale;
}

bool conffile::avioutput()
{
    return vavioutput;
}

double conffile::avioutputtime(char *mode)
{
    if (strcmp(mode, "start") == 0)
      {
          return vavioutputtime_start;
    } else if (strcmp(mode, "end") == 0)
      {
          return vavioutputtime_end;
      }
}

conffile::~conffile()
{
    free(vdxffilepath_nonallaxis);
    free(vdxffilepath_allaxis);
}

conffile::conffile()
{
//    char* vdxffilepath_nonallaxis;
//    char* vdxffilepath_allaxis;
    vdxffilepath_nonallaxis = NULL;
    vdxffilepath_allaxis = NULL;

//    double vcycle;
    vcycle = (double) NULL;
//    double vangle_x,vangle_y,vangle_z;
    vangle_x = vangle_y = vangle_z = 0.0;
//    double vpositiond_x,vpositiond_y,vpositiond_z;
    vpositiond_x = vpositiond_y = vpositiond_z = (double) NULL;
//    int vdeltap;
    vdeltap = 1;
//    int vscale;
    vscale = 1;
//    bool vavioutput;
    vavioutput = false;
//    double vavioutputtime_end,vavioutputtime_start;
    vavioutputtime_end = vavioutputtime_start = (double) NULL;
}
