/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QUuid;
import com.trolltech.qt.xml.QXmlStreamReader;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class ImportEnex {
    public int lastError;
    private String errorMessage;
    private String fileName;
    DatabaseConnection conn;
    QXmlStreamReader reader;
    private Note note;
    public int highUpdateSequenceNumber;
    public long lastSequenceDate;
    private final ApplicationLogger logger = new ApplicationLogger("import.log");
    private String notebookGuid;
    public final boolean importTags = false;
    public final boolean importNotebooks = false;
    private String newGuid;
    List<Tag> tags;
    public boolean createNewTags;

    public ImportEnex(DatabaseConnection c, boolean full) {
        this.conn = c;
        this.tags = this.conn.getTagTable().getAll();
        this.createNewTags = true;
    }

    public void importData(String f) {
        this.fileName = f;
        this.errorMessage = "";
        this.lastError = 0;
        this.errorMessage = "";
        QFile xmlFile = new QFile(this.fileName);
        if (!xmlFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            this.lastError = 16;
            this.errorMessage = "Cannot open file.";
        }
        this.reader = new QXmlStreamReader((QIODevice)xmlFile);
        while (!this.reader.atEnd()) {
            this.reader.readNext();
            if (this.reader.hasError()) {
                this.errorMessage = this.reader.errorString();
                this.logger.log(this.logger.LOW, "************************* ERROR READING FILE " + this.reader.errorString());
                this.lastError = 16;
                return;
            }
            if (!this.reader.name().equalsIgnoreCase("note") || !this.reader.isStartElement()) continue;
            this.processNoteNode();
            this.note.setUpdateSequenceNum(0);
            if (this.notebookGuid != null) {
                this.note.setNotebookGuid(this.notebookGuid);
            }
            int i = 0;
            while (i < this.note.getResourcesSize()) {
                ((Resource)this.note.getResources().get(i)).setUpdateSequenceNum(0);
                ++i;
            }
            this.note.setActive(true);
            if (this.note.getUpdated() == 0L) {
                this.note.setUpdated(this.note.getCreated());
            }
            this.conn.getNoteTable().addNote(this.note, true);
        }
        xmlFile.close();
    }

    private void processNoteNode() {
        this.note = new Note();
        this.newGuid = QUuid.createUuid().toString().replace("{", "").replace("}", "");
        this.note.setGuid(this.newGuid);
        this.note.setResources(new ArrayList());
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.name().equalsIgnoreCase("title")) {
                this.note.setTitle(this.textValue());
            }
            if (this.reader.name().equalsIgnoreCase("Created")) {
                this.note.setCreated(this.datetimeValue());
            }
            if (this.reader.name().equalsIgnoreCase("updated")) {
                this.note.setCreated(this.datetimeValue());
            }
            if (this.reader.name().equalsIgnoreCase("Content")) {
                this.note.setContent(this.textValue());
            }
            if (this.reader.name().equalsIgnoreCase("tag") && this.createNewTags) {
                String tag = this.textValue();
                Tag noteTag = null;
                boolean found = false;
                int i = 0;
                while (i < this.tags.size()) {
                    if (this.tags.get(i).getName().equalsIgnoreCase(tag)) {
                        found = true;
                        noteTag = this.tags.get(i);
                        i = this.tags.size();
                    }
                    ++i;
                }
                if (!found) {
                    noteTag = new Tag();
                    noteTag.setName(tag);
                    String tagGuid = QUuid.createUuid().toString().replace("{", "").replace("}", "");
                    noteTag.setGuid(tagGuid);
                    noteTag.setName(tag);
                    this.tags.add(noteTag);
                    this.conn.getTagTable().addTag(noteTag, true);
                }
                this.note.addToTagNames(noteTag.getName());
                this.note.addToTagGuids(noteTag.getGuid());
            }
            if (this.reader.name().equalsIgnoreCase("note-attributes")) {
                this.note.setAttributes(this.processNoteAttributes());
            }
            if (this.reader.name().equalsIgnoreCase("resource")) {
                this.note.getResources().add(this.processResource());
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("note") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
    }

    private Resource processResource() {
        Resource resource = new Resource();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement() && this.reader.name().equalsIgnoreCase("resource")) {
                String newResGuid = QUuid.createUuid().toString().replace("{", "").replace("}", "");
                resource.setGuid(newResGuid);
                resource.setNoteGuid(this.newGuid);
            }
            if (this.reader.name().equalsIgnoreCase("mime")) {
                resource.setMime(this.textValue());
            }
            if (this.reader.name().equalsIgnoreCase("height")) {
                resource.setHeight(this.shortValue());
            }
            if (this.reader.name().equalsIgnoreCase("width")) {
                resource.setWidth(this.shortValue());
            }
            if (this.reader.name().equalsIgnoreCase("data")) {
                resource.setData(this.processData("data"));
            }
            if (this.reader.name().equalsIgnoreCase("resource-attributes")) {
                resource.setAttributes(this.processResourceAttributes());
            }
            if (this.reader.name().equalsIgnoreCase("recognition")) {
                resource.setRecognition(this.processRecognition());
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("resource") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        if (resource.getAttributes() == null) {
            resource.setAttributes(new ResourceAttributes());
        }
        this.conn.getNoteTable().noteResourceTable.updateNoteResource(resource, true);
        return resource;
    }

    private Data processData(String nodeName) {
        Data data = new Data();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                try {
                    byte[] b = this.textValue().getBytes();
                    if (b.length > 0) {
                        QByteArray hexData = new QByteArray(b);
                        String hexString = hexData.toString();
                        data.setBody(DatatypeConverter.parseBase64Binary((String)hexString));
                        try {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            md.update(data.getBody());
                            data.setBodyHash(md.digest());
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.reader.name().equalsIgnoreCase(nodeName) && this.reader.isEndElement()) {
                atEnd = true;
                continue;
            }
            this.reader.readNext();
        }
        return data;
    }

    private NoteAttributes processNoteAttributes() {
        NoteAttributes attributes = new NoteAttributes();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("source-url")) {
                    attributes.setSourceURL(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("source")) {
                    attributes.setSource(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("longitude")) {
                    attributes.setLongitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("latitude")) {
                    attributes.setLatitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("altitude")) {
                    attributes.setAltitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("author")) {
                    attributes.setAuthor(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("subject-date")) {
                    attributes.setSubjectDate(this.datetimeValue());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("note-attributes") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return attributes;
    }

    private Data processRecognition() {
        Data reco = new Data();
        reco.setBody(this.textValue().getBytes());
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(reco.getBody());
            reco.setBodyHash(md.digest());
            reco.setSize(reco.getBody().length);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return reco;
    }

    private ResourceAttributes processResourceAttributes() {
        ResourceAttributes attributes = new ResourceAttributes();
        boolean atEnd = false;
        while (!atEnd) {
            if (this.reader.isStartElement()) {
                if (this.reader.name().equalsIgnoreCase("camera-model")) {
                    attributes.setCameraModel(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("file-name")) {
                    attributes.setFileName(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("reco-type")) {
                    attributes.setRecoType(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("camera-make")) {
                    attributes.setCameraMake(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("source-url")) {
                    attributes.setSourceURL(this.textValue());
                }
                if (this.reader.name().equalsIgnoreCase("Altitude")) {
                    attributes.setAltitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Longitude")) {
                    attributes.setLongitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Latitude")) {
                    attributes.setLatitude(this.doubleValue());
                }
                if (this.reader.name().equalsIgnoreCase("Timestamp")) {
                    attributes.setTimestamp(this.longValue());
                }
                if (this.reader.name().equalsIgnoreCase("Attachment")) {
                    attributes.setAttachment(this.booleanValue());
                }
                if (this.reader.name().equalsIgnoreCase("ClientWillIndex")) {
                    attributes.setClientWillIndex(this.booleanValue());
                }
            }
            this.reader.readNext();
            if (!this.reader.name().equalsIgnoreCase("resource-attributes") || !this.reader.isEndElement()) continue;
            atEnd = true;
        }
        return attributes;
    }

    private String textValue() {
        return this.reader.readElementText();
    }

    private long longValue() {
        return new Long(this.textValue());
    }

    private long datetimeValue() {
        String time = this.textValue();
        String year = time.substring(0, 4);
        String month = time.substring(4, 6);
        String day = time.substring(6, 8);
        String hour = time.substring(9, 11);
        String minute = time.substring(11, 13);
        String second = time.substring(13, 15);
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date d = dfm.parse(String.valueOf(year) + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second);
            return d.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private boolean booleanValue() {
        String value = this.textValue();
        return value.equalsIgnoreCase("true");
    }

    private short shortValue() {
        return new Short(this.textValue());
    }

    public void setNotebookGuid(String g) {
        this.notebookGuid = g;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private double doubleValue() {
        return new Double(this.textValue());
    }
}

