/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Publishing;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.xml.QXmlStreamWriter;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.NoteMetadata;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExportData {
    private List<Notebook> notebooks;
    private final HashMap<String, String> localNotebooks;
    private final HashMap<String, String> dirtyNotebooks;
    private final ApplicationLogger logger;
    private List<SavedSearch> searches;
    private List<LinkedNotebook> linkedNotebooks;
    private List<SharedNotebook> sharedNotebooks;
    private final HashMap<String, String> dirtySearches;
    private List<Tag> tags;
    private final HashMap<String, String> dirtyTags;
    private final HashMap<String, String> exportableNotebooks;
    private final HashMap<String, String> exportableTags;
    private List<Note> notes;
    private final HashMap<String, String> dirtyNotes;
    private final HashMap<String, String> dirtyLinkedNotebooks;
    private final HashMap<Long, String> dirtySharedNotebooks;
    private HashMap<String, NoteMetadata> noteMeta;
    private final boolean fullBackup;
    private final DatabaseConnection conn;
    private QXmlStreamWriter writer;
    private String errorMessage;
    public int lastError;

    public ExportData(DatabaseConnection conn2, boolean full) {
        this.conn = conn2;
        this.logger = new ApplicationLogger("export.log");
        this.notebooks = new ArrayList<Notebook>();
        this.tags = new ArrayList<Tag>();
        this.notes = new ArrayList<Note>();
        this.sharedNotebooks = new ArrayList<SharedNotebook>();
        this.linkedNotebooks = new ArrayList<LinkedNotebook>();
        this.dirtyNotebooks = new HashMap();
        this.localNotebooks = new HashMap();
        this.dirtyLinkedNotebooks = new HashMap();
        this.dirtySharedNotebooks = new HashMap();
        this.dirtyTags = new HashMap();
        this.fullBackup = full;
        this.dirtyNotes = new HashMap();
        this.dirtySearches = new HashMap();
        this.searches = new ArrayList<SavedSearch>();
        this.exportableNotebooks = new HashMap();
        this.exportableTags = new HashMap();
    }

    public ExportData(DatabaseConnection conn2, boolean full, List<String> guids) {
        this.conn = conn2;
        this.logger = new ApplicationLogger("export.log");
        this.notebooks = new ArrayList<Notebook>();
        this.tags = new ArrayList<Tag>();
        this.notes = new ArrayList<Note>();
        int i = 0;
        while (i < guids.size()) {
            this.notes.add(this.conn.getNoteTable().getNote(guids.get(i), true, true, true, true, true));
            ++i;
        }
        this.dirtyNotebooks = new HashMap();
        this.localNotebooks = new HashMap();
        this.dirtyTags = new HashMap();
        this.fullBackup = full;
        this.dirtyNotes = new HashMap();
        this.dirtyLinkedNotebooks = new HashMap();
        this.dirtySharedNotebooks = new HashMap();
        this.dirtySearches = new HashMap();
        this.searches = new ArrayList<SavedSearch>();
        this.exportableNotebooks = new HashMap();
        this.exportableTags = new HashMap();
    }

    public void exportData(String filename) {
        this.notebooks = this.conn.getNotebookTable().getAll();
        this.tags = this.conn.getTagTable().getAll();
        List<Notebook> books = this.conn.getNotebookTable().getAllLocal();
        int i = 0;
        while (i < books.size()) {
            this.localNotebooks.put(books.get(i).getGuid(), "");
            ++i;
        }
        books = this.conn.getNotebookTable().getDirty();
        i = 0;
        while (i < books.size()) {
            this.dirtyNotebooks.put(books.get(i).getGuid(), "");
            ++i;
        }
        List<Tag> d = this.conn.getTagTable().getDirty();
        int i2 = 0;
        while (i2 < d.size()) {
            this.dirtyTags.put(d.get(i2).getGuid(), "");
            ++i2;
        }
        if (this.fullBackup) {
            this.notes = this.conn.getNoteTable().getAllNotes();
        }
        List<Note> dn = this.conn.getNoteTable().getDirty();
        int i3 = 0;
        while (i3 < dn.size()) {
            this.dirtyNotes.put(dn.get(i3).getGuid(), "");
            ++i3;
        }
        this.noteMeta = this.conn.getNoteTable().getNotesMetaInformation();
        this.searches = this.conn.getSavedSearchTable().getAll();
        List<SavedSearch> ds = this.conn.getSavedSearchTable().getDirty();
        int i4 = 0;
        while (i4 < ds.size()) {
            this.dirtySearches.put(ds.get(i4).getGuid(), "");
            ++i4;
        }
        this.linkedNotebooks = this.conn.getLinkedNotebookTable().getAll();
        List<String> dln = this.conn.getLinkedNotebookTable().getDirtyGuids();
        int i5 = 0;
        while (i5 < dln.size()) {
            this.dirtyLinkedNotebooks.put(dln.get(i5), "");
            ++i5;
        }
        this.sharedNotebooks = this.conn.getSharedNotebookTable().getAll();
        List<Long> dsn = this.conn.getSharedNotebookTable().getDirtyIds();
        int i6 = 0;
        while (i6 < dsn.size()) {
            this.dirtySharedNotebooks.put(dsn.get(i6), "");
            ++i6;
        }
        this.lastError = 0;
        this.errorMessage = "";
        QFile xmlFile = new QFile(filename);
        if (!xmlFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly, QIODevice.OpenModeFlag.Truncate})) {
            this.lastError = 16;
            this.errorMessage = "Cannot open file.";
        }
        this.writer = new QXmlStreamWriter((QIODevice)xmlFile);
        this.writer.setAutoFormatting(true);
        this.writer.setCodec("UTF-8");
        this.writer.writeStartDocument();
        this.writer.writeDTD("<!DOCTYPE NeverNote-Export>");
        this.writer.writeStartElement("nevernote-export");
        this.writer.writeAttribute("version", "0.95");
        if (this.fullBackup) {
            this.writer.writeAttribute("exportType", "backup");
        } else {
            this.writer.writeAttribute("exportType", "export");
        }
        this.writer.writeAttribute("application", "NeverNote");
        this.writer.writeAttribute("applicationVersion", Global.version);
        if (this.fullBackup) {
            this.writer.writeStartElement("Synchronization");
            long sequenceDate = this.conn.getSyncTable().getLastSequenceDate();
            int number = this.conn.getSyncTable().getUpdateSequenceNumber();
            this.createTextNode("UpdateSequenceNumber", new Long(number).toString());
            this.createTextNode("LastSequenceDate", new Long(sequenceDate).toString());
            this.writer.writeEndElement();
        }
        int i7 = 0;
        while (i7 < this.notes.size()) {
            String guid = this.notes.get(i7).getGuid();
            this.logger.log(this.logger.EXTREME, "Getting note " + guid + " : " + this.notes.get(i7).getTitle());
            Note note = this.conn.getNoteTable().getNote(guid, true, true, true, true, true);
            this.logger.log(this.logger.EXTREME, "Writing note XML");
            this.writeNote(note);
            ++i7;
        }
        this.writeNotebooks();
        this.writeTags();
        this.writeSavedSearches();
        this.writeLinkedNotebooks();
        this.writeSharedNotebooks();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.dispose();
        xmlFile.close();
        xmlFile.dispose();
    }

    private void writeSavedSearches() {
        if (!this.fullBackup) {
            return;
        }
        int i = 0;
        while (i < this.searches.size()) {
            this.writer.writeStartElement("SavedSearch");
            this.createTextNode("Guid", this.searches.get(i).getGuid());
            this.createTextNode("Name", this.searches.get(i).getName());
            this.createTextNode("Query", this.searches.get(i).getQuery());
            this.createTextNode("Format", new Integer(this.searches.get(i).getFormat().getValue()).toString());
            if (this.dirtySearches.containsKey(this.searches.get(i).getGuid())) {
                this.createTextNode("Dirty", "true");
            } else {
                this.createTextNode("Dirty", "false");
            }
            this.writer.writeEndElement();
            ++i;
        }
    }

    private void writeLinkedNotebooks() {
        if (!this.fullBackup) {
            return;
        }
        int i = 0;
        while (i < this.linkedNotebooks.size()) {
            this.writer.writeStartElement("LinkedNotebook");
            this.createTextNode("Guid", this.linkedNotebooks.get(i).getGuid());
            this.createTextNode("ShardID", this.linkedNotebooks.get(i).getShardId());
            this.createTextNode("ShareKey", this.linkedNotebooks.get(i).getShareKey());
            this.createTextNode("ShareName", this.linkedNotebooks.get(i).getShareName());
            this.createTextNode("Uri", this.linkedNotebooks.get(i).getUri());
            this.createTextNode("Username", this.linkedNotebooks.get(i).getUsername());
            this.createTextNode("UpdateSequenceNumber", new Long(this.linkedNotebooks.get(i).getUpdateSequenceNum()).toString());
            if (this.dirtyLinkedNotebooks.containsKey(this.linkedNotebooks.get(i).getGuid())) {
                this.createTextNode("Dirty", "true");
            } else {
                this.createTextNode("Dirty", "false");
            }
            this.writer.writeEndElement();
            ++i;
        }
    }

    private void writeSharedNotebooks() {
        if (!this.fullBackup) {
            return;
        }
        int i = 0;
        while (i < this.linkedNotebooks.size()) {
            this.writer.writeStartElement("SharedNotebook");
            this.createTextNode("Id", new Long(this.sharedNotebooks.get(i).getId()).toString());
            this.createTextNode("Userid", new Integer(this.sharedNotebooks.get(i).getUserId()).toString());
            this.createTextNode("Email", this.sharedNotebooks.get(i).getEmail());
            this.createTextNode("NotebookGuid", this.sharedNotebooks.get(i).getNotebookGuid());
            this.createTextNode("ShareKey", this.sharedNotebooks.get(i).getShareKey());
            this.createTextNode("Username", this.sharedNotebooks.get(i).getUsername());
            this.createTextNode("ServiceCreated", new Long(this.sharedNotebooks.get(i).getServiceCreated()).toString());
            if (this.dirtySharedNotebooks.containsKey(this.sharedNotebooks.get(i).getId())) {
                this.createTextNode("Dirty", "true");
            } else {
                this.createTextNode("Dirty", "false");
            }
            this.writer.writeEndElement();
            ++i;
        }
    }

    private void writeNote(Note note) {
        NoteAttributes noteAttributes;
        this.writer.writeStartElement("Note");
        this.createTextNode("Guid", note.getGuid());
        this.createTextNode("UpdateSequenceNumber", new Long(note.getUpdateSequenceNum()).toString());
        this.createTextNode("Title", note.getTitle());
        this.createTextNode("Created", new Long(note.getCreated()).toString());
        this.createTextNode("Updated", new Long(note.getUpdated()).toString());
        this.createTextNode("Deleted", new Long(note.getDeleted()).toString());
        this.createTextNode("Active", new Boolean(note.isActive()).toString());
        this.createTextNode("NotebookGuid", note.getNotebookGuid());
        if (this.dirtyNotes.containsKey(note.getGuid())) {
            this.createTextNode("Dirty", "true");
        } else {
            this.createTextNode("Dirty", "false");
        }
        if (this.noteMeta.containsKey(note.getGuid())) {
            Integer color = new Integer(this.noteMeta.get(note.getGuid()).getColor());
            this.createTextNode("TitleColor", color.toString());
        }
        this.exportableNotebooks.put(note.getNotebookGuid(), "");
        if (note.getTagGuidsSize() > 0) {
            this.writer.writeStartElement("NoteTags");
            int i = 0;
            while (i < note.getTagGuidsSize()) {
                this.createTextNode("Guid", (String)note.getTagGuids().get(i));
                this.exportableTags.put((String)note.getTagGuids().get(i), "");
                ++i;
            }
            this.writer.writeEndElement();
        }
        if ((noteAttributes = note.getAttributes()) != null) {
            this.writer.writeStartElement("NoteAttributes");
            this.createTextNode("Author", noteAttributes.getAuthor());
            this.createTextNode("Source", noteAttributes.getSource());
            this.createTextNode("SourceApplication", noteAttributes.getSourceApplication());
            this.createTextNode("SourceURL", noteAttributes.getSourceURL());
            this.createTextNode("Altitude", new Double(noteAttributes.getAltitude()).toString());
            this.createTextNode("Longitude", new Double(noteAttributes.getLongitude()).toString());
            this.createTextNode("Latitude", new Double(noteAttributes.getLatitude()).toString());
            this.createTextNode("SubjectDate", new Long(noteAttributes.getSubjectDate()).toString());
            this.writer.writeEndElement();
        }
        this.writeResources(note.getResources());
        this.logger.log(this.logger.EXTREME, "Writing content");
        this.writer.writeStartElement("Content");
        this.writer.writeCDATA(this.conn.getNoteTable().getNoteContentNoUTFConversion(note.getGuid()));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeResources(List<Resource> resourceTable) {
        if (resourceTable.size() == 0) {
            return;
        }
        int i = 0;
        while (i < resourceTable.size()) {
            Resource resource = resourceTable.get(i);
            this.writer.writeStartElement("NoteResource");
            this.createTextNode("Guid", resource.getGuid());
            this.createTextNode("NoteGuid", resource.getNoteGuid());
            this.createTextNode("UpdateSequenceNumber", new Integer(resource.getUpdateSequenceNum()).toString());
            this.createTextNode("Mime", resource.getMime());
            this.createTextNode("Duration", new Integer(resource.getDuration()).toString());
            this.createTextNode("Height", new Integer(resource.getHeight()).toString());
            this.createTextNode("Width", new Integer(resource.getWidth()).toString());
            this.logger.log(this.logger.EXTREME, "Checking for data node");
            if (resource.getData() != null) {
                this.writeDataNode("Data", resource.getData());
            }
            this.logger.log(this.logger.EXTREME, "Checking for alternate data node");
            if (resource.getAlternateData() != null) {
                this.writeDataNode("AlternateData", resource.getAlternateData());
            }
            this.logger.log(this.logger.EXTREME, "Checking for recognition");
            if (resource.getRecognition() != null) {
                this.writeRecognitionNode("Recognition", resource.getRecognition());
            }
            if (resource.isActive()) {
                this.createTextNode("Active", "true");
            } else {
                this.createTextNode("Active", "false");
            }
            this.logger.log(this.logger.EXTREME, "Checking resource attributes");
            if (resource.getAttributes() != null) {
                this.writer.writeStartElement("NoteResourceAttribute");
                this.createTextNode("CameraMake", resource.getAttributes().getCameraMake());
                this.createTextNode("CameraModel", resource.getAttributes().getCameraModel());
                this.createTextNode("FileName", resource.getAttributes().getFileName());
                this.createTextNode("RecoType", resource.getAttributes().getRecoType());
                this.createTextNode("SourceURL", resource.getAttributes().getSourceURL());
                this.createTextNode("Altitude", new Double(resource.getAttributes().getAltitude()).toString());
                this.createTextNode("Longitude", new Double(resource.getAttributes().getLongitude()).toString());
                this.createTextNode("Latitude", new Double(resource.getAttributes().getLatitude()).toString());
                this.createTextNode("Timestamp", new Long(resource.getAttributes().getTimestamp()).toString());
                if (resource.getAttributes().isAttachment()) {
                    this.createTextNode("Attachment", "true");
                } else {
                    this.createTextNode("Attachment", "false");
                }
                if (resource.getAttributes().isClientWillIndex()) {
                    this.createTextNode("ClientWillIndex", "true");
                } else {
                    this.createTextNode("ClientWillIndex", "false");
                }
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Ending resource node");
    }

    private void writeDataNode(String name, Data data) {
        this.writer.writeStartElement(name);
        this.createTextNode("Size", new Integer(data.getSize()).toString());
        if (data.getBody() != null && data.getBody().length > 0) {
            this.createBinaryNode("Body", new QByteArray(data.getBody()).toHex().toString());
        } else {
            this.createBinaryNode("Body", "");
        }
        if (data.getBodyHash() != null && data.getBodyHash().length > 0) {
            this.createTextNode("BodyHash", new QByteArray(data.getBodyHash()).toHex().toString());
        } else {
            this.createTextNode("BodyHash", "");
        }
        this.writer.writeEndElement();
    }

    private void writeRecognitionNode(String name, Data data) {
        this.writer.writeStartElement(name);
        this.createTextNode("Size", new Integer(data.getSize()).toString());
        if (data.getBody() != null && data.getBody().length > 0) {
            this.writer.writeStartElement("Body");
            this.writer.writeCDATA(new QByteArray(data.getBody()).toString());
            this.writer.writeEndElement();
        } else {
            this.createBinaryNode("Body", "");
        }
        if (data.getBodyHash() != null && data.getBodyHash().length > 0) {
            this.createTextNode("BodyHash", new QByteArray(data.getBodyHash()).toHex().toString());
        } else {
            this.createTextNode("BodyHash", "");
        }
        this.writer.writeEndElement();
    }

    private void writeNotebooks() {
        int i = 0;
        while (i < this.notebooks.size()) {
            if (this.exportableNotebooks.containsKey(this.notebooks.get(i).getGuid()) || this.fullBackup) {
                QByteArray b;
                this.writer.writeStartElement("Notebook");
                this.createTextNode("Guid", this.notebooks.get(i).getGuid());
                this.createTextNode("Name", this.notebooks.get(i).getName());
                this.createTextNode("UpdateSequenceNumber", new Long(this.notebooks.get(i).getUpdateSequenceNum()).toString());
                if (this.notebooks.get(i).isDefaultNotebook()) {
                    this.createTextNode("DefaultNotebook", "true");
                } else {
                    this.createTextNode("DefaultNotebook", "false");
                }
                this.createTextNode("ServiceCreated", new Long(this.notebooks.get(i).getServiceCreated()).toString());
                this.createTextNode("ServiceUpdated", new Long(this.notebooks.get(i).getServiceUpdated()).toString());
                if (this.localNotebooks.containsKey(this.notebooks.get(i).getGuid())) {
                    this.createTextNode("Local", "true");
                } else {
                    this.createTextNode("Local", "false");
                }
                if (this.dirtyNotebooks.containsKey(this.notebooks.get(i).getGuid())) {
                    this.createTextNode("Dirty", "true");
                } else {
                    this.createTextNode("Dirty", "false");
                }
                if (this.conn.getNotebookTable().isReadOnly(this.notebooks.get(i).getGuid())) {
                    this.createTextNode("ReadOnly", "true");
                } else {
                    this.createTextNode("ReadOnly", "false");
                }
                if (this.notebooks.get(i).getPublishing() != null) {
                    Publishing p = this.notebooks.get(i).getPublishing();
                    this.createTextNode("PublishingPublicDescription", p.getPublicDescription());
                    this.createTextNode("PublishingUri", p.getUri());
                    this.createTextNode("PublishingOrder", new Integer(p.getOrder().getValue()).toString());
                    if (p.isAscending()) {
                        this.createTextNode("PublishingAscending", "true");
                    } else {
                        this.createTextNode("PublishingAscending", "false");
                    }
                }
                if ((b = this.conn.getNotebookTable().getIconAsByteArray(this.notebooks.get(i).getGuid())) != null) {
                    this.createBinaryNode("Icon", b.toHex().toString());
                }
                if (this.notebooks.get(i).getStack() != null && !this.notebooks.get(i).getStack().trim().equals("")) {
                    this.createTextNode("Stack", this.notebooks.get(i).getStack());
                }
                this.writer.writeEndElement();
            }
            ++i;
        }
    }

    private void writeTags() {
        int i = 0;
        while (i < this.tags.size()) {
            if (this.exportableTags.containsKey(this.tags.get(i).getGuid()) || this.fullBackup) {
                this.writer.writeStartElement("Tag");
                this.createTextNode("Guid", this.tags.get(i).getGuid());
                this.createTextNode("Name", this.tags.get(i).getName());
                this.createTextNode("ParentGuid", this.tags.get(i).getParentGuid());
                this.createTextNode("UpdateSequenceNumber", new Long(this.tags.get(i).getUpdateSequenceNum()).toString());
                if (this.dirtyTags.containsKey(this.tags.get(i).getGuid())) {
                    this.createTextNode("Dirty", "true");
                } else {
                    this.createTextNode("Dirty", "false");
                }
                this.writer.writeEndElement();
            }
            ++i;
        }
    }

    private void createTextNode(String nodeName, String value) {
        if (value == null) {
            value = "";
        }
        this.writer.writeTextElement(nodeName, value);
    }

    private void createBinaryNode(String nodeName, String value) {
        if (value == null) {
            value = "";
        }
        this.logger.log(this.logger.EXTREME, "Writing binary node");
        this.writer.writeStartElement(nodeName);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

