/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.SharedNotebook;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class SharedNotebookTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;

    public SharedNotebookTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table SharedNotebook...");
        if (!query.exec("Create table SharedNotebook (id long primary key, userid Integer, notebookGuid VarChar, email VarChar, notebookModifiable boolean, requireLogin boolean, serviceCreated timestamp, shareKey VarChar,  username VarChar, icon blob, isDirty boolean)")) {
            this.logger.log(this.logger.HIGH, "Table SharedNotebook creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table SharedNotebook");
    }

    public void addNotebook(SharedNotebook tempNotebook, boolean isDirty) {
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into SharedNotebook (id, userid, notebookGuid, email,  notebookModifiable, requireLogin, serviceCreated, shareKey, username, isDirty)  Values(:id, :userid, :notebookGuid, :email, :notebookModifiable, :requireLogin, :serviceCreated, :shareKey, :username, :isDirty)");
        query.bindValue(":id", tempNotebook.getId());
        query.bindValue(":userid", tempNotebook.getUserId());
        query.bindValue(":notebookGuid", tempNotebook.getNotebookGuid());
        query.bindValue(":email", tempNotebook.getEmail());
        query.bindValue(":notebookModifiable", tempNotebook.isNotebookModifiable());
        query.bindValue(":requireLogin", tempNotebook.isRequireLogin());
        StringBuilder serviceCreated = new StringBuilder(simple.format(tempNotebook.getServiceCreated()));
        query.bindValue(":serviceCreated", serviceCreated.toString());
        query.bindValue(":shareKey", tempNotebook.getShareKey());
        query.bindValue(":username", tempNotebook.getUsername());
        if (isDirty) {
            query.bindValue(":isDirty", true);
        } else {
            query.bindValue(":isDirty", false);
        }
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SharedNotebook Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public boolean exists(long id) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.EXTREME, "Checking if shared notebook " + id + " exists");
        boolean check = query.prepare("Select id from sharednotebook where id=:id");
        query.bindValue(":id", id);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SharedNotebook Table exists check failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
        if (query.next()) {
            return true;
        }
        this.logger.log(this.logger.EXTREME, "Shared notebook " + id + " does not exist");
        return false;
    }

    public void expungeNotebook(long id, boolean needsSync) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from SharedNotebook where id=:id");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SharedNotebook SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":id", id);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SharedNotebook delete failed.");
        }
        if (needsSync) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(new Long(id).toString(), "SharedNotebook");
        }
    }

    public void expungeNotebookByGuid(String id, boolean needsSync) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from SharedNotebook where guid=:id");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SharedNotebook SQL delete by notebook guid prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError().toString());
        }
        query.bindValue(":id", id);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SharedNotebook delete by notebook guid failed.");
        }
        if (needsSync) {
            DeletedTable deletedTable = new DeletedTable(this.logger, this.db);
            deletedTable.addDeletedItem(new Long(id).toString(), "SharedNotebook");
        }
    }

    public void updateNotebook(SharedNotebook tempNotebook, boolean isDirty) {
        this.logger.log(this.logger.EXTREME, "*Updating Shared Notebook*");
        this.logger.log(this.logger.EXTREME, "ID: " + tempNotebook.getId());
        this.logger.log(this.logger.EXTREME, "Userid: " + tempNotebook.getUserId());
        this.logger.log(this.logger.EXTREME, "Email: " + tempNotebook.getEmail());
        this.logger.log(this.logger.EXTREME, "Notebook Guid: " + tempNotebook.getNotebookGuid());
        this.logger.log(this.logger.EXTREME, "Share Key: " + tempNotebook.getShareKey());
        this.logger.log(this.logger.EXTREME, "Username: " + tempNotebook.getUsername());
        if (!this.exists(tempNotebook.getId())) {
            this.addNotebook(tempNotebook, isDirty);
            return;
        }
        List<SharedNotebook> list = this.getAll();
        this.logger.log(this.logger.EXTREME, "Dumping shared notebooks");
        int i = 0;
        while (i < list.size()) {
            this.logger.log(this.logger.EXTREME, "**************");
            this.logger.log(this.logger.EXTREME, "ID: " + list.get(i).getId());
            this.logger.log(this.logger.EXTREME, "Userid: " + list.get(i).getUserId());
            this.logger.log(this.logger.EXTREME, "Email: " + list.get(i).getEmail());
            this.logger.log(this.logger.EXTREME, "Notebook Guid: " + list.get(i).getNotebookGuid());
            this.logger.log(this.logger.EXTREME, "Share Key: " + list.get(i).getShareKey());
            this.logger.log(this.logger.EXTREME, "Username: " + list.get(i).getUsername());
            ++i;
        }
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        StringBuilder serviceCreated = new StringBuilder(simple.format(tempNotebook.getServiceCreated()));
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update SharedNotebook set userid=:userid, notebookGuid=:notebook, email=:email, notebookModifiable=:mod, requireLogin=:rlogin, serviceCreated=:serviceCreated, shareKey=:shareKey, username=:username, isDirty=:isdirty where id=:id");
        query.bindValue(":id", tempNotebook.getId());
        query.bindValue(":userid", tempNotebook.getUserId());
        query.bindValue(":notebook", tempNotebook.getNotebookGuid());
        query.bindValue(":email", tempNotebook.getEmail());
        query.bindValue(":mod", tempNotebook.isNotebookModifiable());
        query.bindValue(":rlogin", tempNotebook.isRequireLogin());
        query.bindValue(":serviceCreated", serviceCreated.toString());
        query.bindValue(":shareKey", tempNotebook.getShareKey());
        query.bindValue(":username", tempNotebook.getUsername());
        query.bindValue(":isDirty", isDirty);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "SharedNotebook Table update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError().toString());
        }
    }

    public List<SharedNotebook> getAll() {
        ArrayList<SharedNotebook> index = new ArrayList<SharedNotebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select id, userid, notebookGuid, email, notebookModifiable, requireLogin, serviceCreated, shareKey, username from SharedNotebook");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Notebook SQL retrieve has failed.");
        }
        while (query.next()) {
            SharedNotebook tempNotebook = new SharedNotebook();
            tempNotebook.setId(query.valueLong(0));
            tempNotebook.setUserId(query.valueInteger(1));
            tempNotebook.setNotebookGuid(query.valueString(2));
            tempNotebook.setEmail(query.valueString(3));
            tempNotebook.setNotebookModifiable(query.valueBoolean(4, false));
            tempNotebook.setRequireLogin(query.valueBoolean(5, true));
            SimpleDateFormat indfm = null;
            try {
                indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(6)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setShareKey(query.valueString(7));
            tempNotebook.setUsername(query.valueString(8));
            index.add(tempNotebook);
        }
        return index;
    }

    public List<SharedNotebook> getForNotebook(String guid) {
        ArrayList<SharedNotebook> index = new ArrayList<SharedNotebook>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select id, userid, notebookGuid, email, notebookModifiable, requireLogin, serviceCreated, shareKey, username from SharedNotebook where notebookGuid=:notebookGuid ");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SharedNotebook getForNotebook SQL prepare has failed.");
        }
        query.bindValue(":notebookGuid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SharedNotebook getForNotebook SQL exec has failed.");
        }
        while (query.next()) {
            SharedNotebook tempNotebook = new SharedNotebook();
            tempNotebook.setId(query.valueLong(0));
            tempNotebook.setUserId(query.valueInteger(1));
            tempNotebook.setNotebookGuid(query.valueString(2));
            tempNotebook.setEmail(query.valueString(3));
            tempNotebook.setNotebookModifiable(query.valueBoolean(4, false));
            tempNotebook.setRequireLogin(query.valueBoolean(5, true));
            SimpleDateFormat indfm = null;
            try {
                indfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tempNotebook.setServiceCreated(indfm.parse(query.valueString(6)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            tempNotebook.setShareKey(query.valueString(7));
            tempNotebook.setUsername(query.valueString(8));
            index.add(tempNotebook);
        }
        return index;
    }

    public List<Long> getDirtyIds() {
        ArrayList<Long> index = new ArrayList<Long>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select id from SharedNotebook where isDirty = true");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "SharedNotebook SQL retrieve has failed in getdirtyIds.");
        }
        while (query.next()) {
            index.add(query.valueLong(0));
        }
        return index;
    }
}

