/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QDragEnterEvent;
import com.trolltech.qt.gui.QHeaderView;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QTreeWidget;
import com.trolltech.qt.gui.QTreeWidgetItem;
import com.trolltech.qt.gui.QWidget;
import java.util.ArrayList;

public class TrashTreeWidget
extends QTreeWidget {
    private QAction emptyAction;
    private QTreeWidgetItem trashItem;
    private Integer trashCount = 0;
    private final String iconPath;
    private final QIcon trashIcon;
    private final QIcon trashFullIcon;

    public void setEmptyAction(QAction a) {
        this.emptyAction = a;
    }

    public TrashTreeWidget() {
        this.setProperty("hideTree", true);
        this.iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        this.trashIcon = new QIcon(String.valueOf(this.iconPath) + "trash.png");
        this.trashFullIcon = new QIcon(String.valueOf(this.iconPath) + "trash-full.png");
        this.header().hide();
        this.setMinimumHeight(30);
    }

    public void updateCounts(Integer cnt) {
        QBrush gray = new QBrush();
        gray.setColor(QColor.gray);
        QBrush black = new QBrush();
        black.setColor(QColor.black);
        this.trashCount = cnt;
        this.trashItem.setText(1, this.trashCount.toString());
        this.header().resizeSection(1, 0);
        if (this.trashCount > 0) {
            this.trashItem.setForeground(0, black);
            this.trashItem.setForeground(1, black);
            this.trashItem.setIcon(0, this.trashFullIcon);
        } else {
            this.trashItem.setIcon(0, this.trashIcon);
            this.trashItem.setForeground(0, gray);
            this.trashItem.setForeground(1, gray);
        }
    }

    public void load() {
        this.trashItem = new QTreeWidgetItem();
        this.trashItem.setIcon(0, this.trashIcon);
        this.trashItem.setText(0, this.tr("Trash"));
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        this.trashItem.setTextAlignment(1, ra.value());
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("");
        headers.add("");
        this.setHeaderLabels(headers);
        this.setColumnCount(2);
        this.header().setResizeMode(0, QHeaderView.ResizeMode.ResizeToContents);
        this.header().setResizeMode(1, QHeaderView.ResizeMode.Stretch);
        this.header().setMovable(false);
        this.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.addTopLevelItem(this.trashItem);
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        QMenu menu = new QMenu((QWidget)this);
        menu.addAction(this.emptyAction);
        menu.exec(event.globalPos());
    }

    public void dragEnterEvent(QDragEnterEvent event) {
        event.mimeData().setData("application/x-nevernote-trash", new QByteArray(this.currentItem().text(1)));
        event.accept();
    }

    public QTreeWidgetItem getTrashItem() {
        return this.trashItem;
    }
}

