/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QCompleter;
import com.trolltech.qt.gui.QStringListModel;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.gui.TagLineEdit;
import java.util.ArrayList;
import java.util.List;

public class TagLineCompleter
extends QCompleter {
    private List<Tag> tags;
    private List<String> currentTags;
    private QStringListModel model;
    private final TagLineEdit editor;
    private String currentText;

    public TagLineCompleter(TagLineEdit e) {
        this.editor = e;
        this.setWidget((QWidget)this.editor);
        this.currentTags = new ArrayList<String>();
        this.setTagList(new ArrayList<Tag>());
        this.setCaseSensitivity(Qt.CaseSensitivity.CaseInsensitive);
    }

    public List<String> getTagList() {
        return this.currentTags;
    }

    public void update(List<String> t, String prefix) {
        this.currentTags = t;
        this.buildModelList();
        this.setCompletionPrefix(prefix);
        if (!prefix.trim().equals("")) {
            this.complete();
        }
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    private List<String> buildModelList() {
        this.model = (QStringListModel)this.model();
        if (this.model == null) {
            this.model = new QStringListModel();
            this.setModel((QAbstractItemModel)this.model);
        }
        int i = 0;
        while (i < this.model.rowCount()) {
            this.model.removeRow(i);
            ++i;
        }
        ArrayList<String> newTagList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.tags.size()) {
            boolean found = false;
            int j = 0;
            while (j < this.currentTags.size() && !found) {
                if (this.currentTags.get(j).trim().equalsIgnoreCase(this.tags.get(i2).getName())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                newTagList.add(this.tags.get(i2).getName());
            }
            ++i2;
        }
        this.model.setStringList(newTagList);
        return newTagList;
    }

    public void setTagList(List<Tag> t) {
        this.tags = t;
        this.resetList();
        this.buildModelList();
    }

    public void resetList() {
        this.currentTags.clear();
    }

    public String currentText() {
        return this.currentText;
    }

    public void reset() {
        this.currentText = "";
    }
}

