/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QHeaderView;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import java.util.List;

public class TableViewHeader
extends QHeaderView {
    public QMenu contextMenu;
    public QAction createdDateAction;
    public QAction changedDateAction;
    public QAction subjectDateAction;
    public QAction tagsAction;
    public QAction titleAction;
    public QAction notebookAction;
    public QAction synchronizedAction;
    public QAction authorAction;
    public QAction urlAction;
    public QAction thumbnailAction;
    public QAction guidAction;
    public QAction pinnedAction;

    public TableViewHeader(Qt.Orientation orientation, QWidget parent) {
        super(orientation, parent);
        this.setSortIndicatorShown(true);
        this.setClickable(true);
        this.contextMenu = new QMenu();
        this.titleAction = new QAction((QObject)this);
        this.titleAction.setText(this.tr("Title"));
        this.titleAction.setCheckable(true);
        this.contextMenu.addAction(this.titleAction);
        this.createdDateAction = new QAction((QObject)this);
        this.createdDateAction.setText(this.tr("Date Created"));
        this.createdDateAction.setCheckable(true);
        this.contextMenu.addAction(this.createdDateAction);
        this.changedDateAction = new QAction((QObject)this);
        this.changedDateAction.setText(this.tr("Date Changed"));
        this.changedDateAction.setCheckable(true);
        this.contextMenu.addAction(this.changedDateAction);
        this.subjectDateAction = new QAction((QObject)this);
        this.subjectDateAction.setText(this.tr("Subject Date"));
        this.subjectDateAction.setCheckable(true);
        this.contextMenu.addAction(this.subjectDateAction);
        this.tagsAction = new QAction((QObject)this);
        this.tagsAction.setText(this.tr("Tags"));
        this.tagsAction.setCheckable(true);
        this.contextMenu.addAction(this.tagsAction);
        this.notebookAction = new QAction((QObject)this);
        this.notebookAction.setText(this.tr("Notebook"));
        this.notebookAction.setCheckable(true);
        this.contextMenu.addAction(this.notebookAction);
        this.synchronizedAction = new QAction((QObject)this);
        this.synchronizedAction.setText(this.tr("Sync"));
        this.synchronizedAction.setCheckable(true);
        this.contextMenu.addAction(this.synchronizedAction);
        this.authorAction = new QAction((QObject)this);
        this.authorAction.setText(this.tr("Author"));
        this.authorAction.setCheckable(true);
        this.contextMenu.addAction(this.authorAction);
        this.urlAction = new QAction((QObject)this);
        this.urlAction.setText(this.tr("Source URL"));
        this.urlAction.setCheckable(true);
        this.contextMenu.addAction(this.urlAction);
        this.thumbnailAction = new QAction((QObject)this);
        this.thumbnailAction.setText(this.tr("Thumbnail"));
        this.thumbnailAction.setCheckable(true);
        this.contextMenu.addAction(this.thumbnailAction);
        this.pinnedAction = new QAction((QObject)this);
        this.pinnedAction.setText(this.tr("Pinned"));
        this.pinnedAction.setCheckable(true);
        this.contextMenu.addAction(this.pinnedAction);
        this.guidAction = new QAction((QObject)this);
        this.guidAction.setText(this.tr("Guid"));
        this.guidAction.setCheckable(true);
        this.setMouseTracking(true);
        this.sectionEntered.connect((Object)this, "sectionClicked(Integer)");
        this.checkActions();
    }

    private void checkActions() {
        this.titleAction.setChecked(Global.isColumnVisible("title"));
        this.createdDateAction.setChecked(Global.isColumnVisible("dateCreated"));
        this.changedDateAction.setChecked(Global.isColumnVisible("dateChanged"));
        this.subjectDateAction.setChecked(Global.isColumnVisible("dateSubject"));
        this.tagsAction.setChecked(Global.isColumnVisible("tags"));
        this.notebookAction.setChecked(Global.isColumnVisible("notebook"));
        this.synchronizedAction.setChecked(Global.isColumnVisible("synchronized"));
        this.authorAction.setChecked(Global.isColumnVisible("author"));
        this.urlAction.setChecked(Global.isColumnVisible("sourceUrl"));
        this.thumbnailAction.setChecked(Global.isColumnVisible("thumbnail"));
        this.pinnedAction.setChecked(Global.isColumnVisible("pinned"));
        this.guidAction.setChecked(Global.isColumnVisible("guid"));
    }

    public void sectionClicked(Integer position) {
        if (position == Global.noteTableThumbnailPosition) {
            this.setClickable(false);
        } else {
            this.setClickable(true);
        }
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        this.checkActions();
        List actions = this.contextMenu.actions();
        int count = 0;
        int i = 0;
        while (i < actions.size()) {
            ((QAction)actions.get(i)).setEnabled(true);
            if (((QAction)actions.get(i)).isChecked()) {
                ++count;
            }
            ++i;
        }
        if (count <= 1) {
            i = 0;
            while (i < actions.size()) {
                if (((QAction)actions.get(i)).isChecked()) {
                    ((QAction)actions.get(i)).setEnabled(false);
                }
                ++i;
            }
        }
        this.contextMenu.exec(event.globalPos());
    }
}

