/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QSize;
import com.trolltech.qt.gui.QTabBar;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.gui.TabBrowserBar;

public class TabBrowserWidget
extends QTabWidget {
    private final TabBrowserBar bar;
    private final NeverNote parent;
    private QSize closeButtonSize;

    public TabBrowserWidget(NeverNote parent) {
        super((QWidget)parent);
        this.parent = parent;
        this.bar = new TabBrowserBar();
        this.setTabBar(this.bar);
        this.bar.tabMoved.connect((Object)parent, "tabIndexChanged(int, int)");
    }

    public int addNewTab(QWidget widget, String title) {
        int index = this.addTab(widget, new String());
        this.bar.addNewTab(index, title);
        this.setTabToolTip(index, title);
        int tabCnt = this.count();
        if (tabCnt == 1) {
            this.hideTabCloseButton(0);
        } else if (tabCnt >= 2 && this.closeButtonSize != null && !this.bar.tabButton(0, QTabBar.ButtonPosition.RightSide).size().equals((Object)this.closeButtonSize)) {
            this.showTabCloseButton(0);
        }
        return index;
    }

    public void setTabTitle(int index, String title) {
        this.bar.setTabTitle(index, title);
        this.setTabToolTip(index, title);
    }

    public void hideTabCloseButton(int index) {
        if (this.closeButtonSize == null) {
            this.closeButtonSize = this.bar.tabButton(index, QTabBar.ButtonPosition.RightSide).size();
        }
        this.bar.tabButton(index, QTabBar.ButtonPosition.RightSide).resize(0, 0);
    }

    public void showTabCloseButton(int index) {
        if (this.closeButtonSize != null) {
            this.bar.tabButton(index, QTabBar.ButtonPosition.RightSide).resize(this.closeButtonSize);
        } else {
            this.bar.tabButton(index, QTabBar.ButtonPosition.RightSide).resize(16, 16);
        }
    }
}

