/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.SavedSearch;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QTreeWidget;
import com.trolltech.qt.gui.QTreeWidgetItem;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.gui.NTreeWidgetItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SavedSearchTreeWidget
extends QTreeWidget {
    private QAction editAction;
    private QAction deleteAction;
    private QAction addAction;
    private QAction iconAction;
    private HashMap<String, QIcon> icons;

    public SavedSearchTreeWidget() {
        this.setProperty("hideTree", true);
        this.header().setStyleSheet("QHeaderView::section {border: 0.0em;}");
        this.setAcceptDrops(false);
        this.setDragEnabled(false);
        this.setHeaderLabel(this.tr("Saved Searches"));
        this.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
    }

    public void setEditAction(QAction e) {
        this.editAction = e;
    }

    public void setDeleteAction(QAction d) {
        this.deleteAction = d;
    }

    public void setAddAction(QAction a) {
        this.addAction = a;
    }

    public void setIconAction(QAction a) {
        this.iconAction = a;
    }

    public void setIcons(HashMap<String, QIcon> i) {
        this.icons = i;
    }

    public void load(List<SavedSearch> tempList) {
        ArrayList<NTreeWidgetItem> index = new ArrayList<NTreeWidgetItem>();
        this.clear();
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon icon = new QIcon(String.valueOf(iconPath) + "search.png");
        int i = 0;
        while (i < tempList.size()) {
            SavedSearch search = tempList.get(i);
            NTreeWidgetItem child = new NTreeWidgetItem();
            child.setText(0, search.getName());
            if (this.icons != null && !this.icons.containsKey(search.getGuid())) {
                child.setIcon(0, icon);
            } else {
                child.setIcon(0, this.icons.get(search.getGuid()));
            }
            child.setText(1, search.getGuid());
            index.add(child);
            this.addTopLevelItem(child);
            ++i;
        }
        this.sortItems(0, Qt.SortOrder.AscendingOrder);
    }

    public boolean selectGuid(String guid) {
        QTreeWidgetItem root = this.invisibleRootItem();
        int i = 0;
        while (i < root.childCount()) {
            QTreeWidgetItem child = root.child(i);
            if (child.text(1).equals(guid)) {
                child.setSelected(true);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        QMenu menu = new QMenu((QWidget)this);
        menu.addAction(this.addAction);
        menu.addAction(this.editAction);
        menu.addAction(this.deleteAction);
        menu.addSeparator();
        menu.addAction(this.iconAction);
        menu.exec(event.globalPos());
    }

    public void selectSavedSearch(QTreeWidgetItem item) {
        QTreeWidgetItem root = this.invisibleRootItem();
        int i = 0;
        while (i < root.childCount()) {
            QTreeWidgetItem child = root.child(i);
            if (child.text(1).equals(item.text(1))) {
                child.setSelected(true);
                return;
            }
            ++i;
        }
    }
}

