/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.Tag;
import com.evernote.edam.type.User;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QCoreApplication;
import com.trolltech.qt.core.QDataStream;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileSystemWatcher;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QMimeData;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTextCodec;
import com.trolltech.qt.core.QTimer;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCalendarWidget;
import com.trolltech.qt.gui.QClipboard;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDateEdit;
import com.trolltech.qt.gui.QDesktopServices;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QFont;
import com.trolltech.qt.gui.QFontDatabase;
import com.trolltech.qt.gui.QFormLayout;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QKeyEvent;
import com.trolltech.qt.gui.QKeySequence;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QMatrix;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QShortcut;
import com.trolltech.qt.gui.QSplitter;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QTimeEdit;
import com.trolltech.qt.gui.QToolButton;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.network.QNetworkAccessManager;
import com.trolltech.qt.network.QNetworkReply;
import com.trolltech.qt.network.QNetworkRequest;
import com.trolltech.qt.webkit.QWebPage;
import com.trolltech.qt.webkit.QWebSettings;
import com.trolltech.qt.webkit.QWebView;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.clipboard.ClipBoardObserver;
import cx.fbn.nevernote.dialog.EnCryptDialog;
import cx.fbn.nevernote.dialog.EnDecryptDialog;
import cx.fbn.nevernote.dialog.GeoDialog;
import cx.fbn.nevernote.dialog.InsertLatexImage;
import cx.fbn.nevernote.dialog.InsertLinkDialog;
import cx.fbn.nevernote.dialog.NoteQuickLinkDialog;
import cx.fbn.nevernote.dialog.SpellCheck;
import cx.fbn.nevernote.dialog.TableDialog;
import cx.fbn.nevernote.dialog.TagAssign;
import cx.fbn.nevernote.evernote.EnCrypt;
import cx.fbn.nevernote.filters.FilterEditorTags;
import cx.fbn.nevernote.gui.ColorMenu;
import cx.fbn.nevernote.gui.ContentView;
import cx.fbn.nevernote.gui.EditorButtonBar;
import cx.fbn.nevernote.gui.Highlighter;
import cx.fbn.nevernote.gui.PDFPreview;
import cx.fbn.nevernote.gui.TagLineEdit;
import cx.fbn.nevernote.signals.NoteResourceSignal;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.FileUtils;
import cx.fbn.nevernote.utilities.Pair;
import cx.fbn.nevernote.xml.HtmlTagModifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URI;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class BrowserWindow
extends QWidget {
    public final QLineEdit titleLabel;
    private final QLineEdit urlText;
    private final QLabel authorLabel;
    private final QLineEdit authorText;
    private final QComboBox geoBox;
    public final TagLineEdit tagEdit;
    public final QLabel tagLabel;
    private final QPushButton urlLabel;
    private final QLabel alteredLabel;
    private final QDateEdit alteredDate;
    private final QTimeEdit alteredTime;
    private final QDateEdit createdDate;
    private final QTimeEdit createdTime;
    private final QLabel subjectLabel;
    private final QDateEdit subjectDate;
    private final QTimeEdit subjectTime;
    public final QComboBox notebookBox;
    private final QLabel notebookLabel;
    private final QLabel createdLabel;
    public final QComboBox fontSize;
    public final QAction fontSizeAction;
    private boolean extendedOn;
    public boolean buttonsVisible;
    private final String iconPath;
    public final ContentView browser;
    private final QTextEdit sourceEdit;
    private String sourceEditHeader;
    Highlighter syntaxHighlighter;
    private List<Tag> allTags;
    private List<String> currentTags;
    public NoteSignal noteSignal;
    public QSignalEmitter.Signal2<String, String> evernoteLinkClicked;
    private List<Notebook> notebookList;
    private Note currentNote;
    private String saveNoteTitle;
    private String saveTagList;
    private boolean insideList;
    private final DatabaseConnection conn;
    private final QCalendarWidget createdCalendarWidget;
    private final QCalendarWidget alteredCalendarWidget;
    private final QCalendarWidget subjectCalendarWidget;
    public final QPushButton undoButton;
    public final QAction undoAction;
    public final QPushButton redoButton;
    public final QAction redoAction;
    public final QPushButton cutButton;
    public final QAction cutAction;
    public final QPushButton copyButton;
    public final QAction copyAction;
    public final QPushButton pasteButton;
    public final QAction pasteAction;
    public final QPushButton boldButton;
    public final QAction boldAction;
    public final QPushButton underlineButton;
    public final QAction underlineAction;
    public final QPushButton italicButton;
    public final QAction italicAction;
    public final QSignalEmitter.Signal0 focusLost;
    public final NoteResourceSignal resourceSignal;
    public QPushButton rightAlignButton;
    public final QAction rightAlignAction;
    public QPushButton leftAlignButton;
    public final QAction leftAlignAction;
    public QPushButton centerAlignButton;
    public final QAction centerAlignAction;
    public final QPushButton strikethroughButton;
    public final QAction strikethroughAction;
    public final QPushButton hlineButton;
    public final QAction hlineAction;
    public final QPushButton indentButton;
    public final QAction indentAction;
    public final QPushButton outdentButton;
    public final QAction outdentAction;
    public final QPushButton bulletListButton;
    public final QAction bulletListAction;
    public final QPushButton numberListButton;
    public final QAction numberListAction;
    public final QPushButton spellCheckButton;
    public final QAction spellCheckAction;
    public final QPushButton todoButton;
    public final QAction todoAction;
    public final QShortcut focusTitleShortcut;
    public final QShortcut focusTagShortcut;
    public final QShortcut focusNoteShortcut;
    public final QShortcut focusUrlShortcut;
    public final QShortcut focusAuthorShortcut;
    public EditorButtonBar buttonLayout;
    public final QComboBox fontList;
    public final QAction fontListAction;
    public final QToolButton fontColor;
    public final QAction fontColorAction;
    private final ColorMenu fontColorMenu;
    public final QToolButton fontHilight;
    public final QAction fontHilightAction;
    private final ColorMenu fontHilightColorMenu;
    public final QFileSystemWatcher fileWatcher;
    public int cursorPosition;
    private boolean forceTextPaste;
    private String selectedFile;
    private String currentHyperlink;
    public boolean keepPDFNavigationHidden;
    private final ApplicationLogger logger = new ApplicationLogger("browser.log");
    SpellDictionary dictionary;
    SpellDictionary userDictionary;
    SpellChecker spellChecker;
    SuggestionListener spellListener;
    private final HashMap<String, Integer> previewPageList;
    boolean insertHyperlink;
    boolean insideTable;
    boolean insideEncryption;
    public QSignalEmitter.Signal1<BrowserWindow> blockApplication;
    public QSignalEmitter.Signal0 unblockApplication;
    public boolean awaitingHttpResponse;
    public long unblockTime;
    private final QTimer setSourceTimer;
    String latexGuid;
    private final ClipBoardObserver cbObserver;

    public BrowserWindow(DatabaseConnection c, ClipBoardObserver cbObserver) {
        this.logger.log(this.logger.HIGH, "Setting up browser");
        this.iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        this.forceTextPaste = false;
        this.insertHyperlink = true;
        this.insideTable = false;
        this.insideEncryption = false;
        this.fileWatcher = new QFileSystemWatcher();
        this.noteSignal = new NoteSignal();
        this.titleLabel = new QLineEdit();
        this.evernoteLinkClicked = new QSignalEmitter.Signal2((QSignalEmitter)this);
        this.titleLabel.setMaxLength(255);
        this.urlText = new QLineEdit();
        this.authorText = new QLineEdit();
        this.geoBox = new QComboBox();
        this.urlLabel = new QPushButton();
        this.urlLabel.clicked.connect((Object)this, "sourceUrlClicked()");
        this.authorLabel = new QLabel();
        this.conn = c;
        this.cbObserver = cbObserver;
        this.focusLost = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.tagEdit = new TagLineEdit(this.allTags);
        this.tagLabel = new QLabel(this.tr("Tags:"));
        this.tagEdit.focusLost.connect((Object)this, "modifyTagsTyping()");
        this.createdCalendarWidget = new QCalendarWidget();
        this.createdDate = new QDateEdit();
        this.createdDate.setDisplayFormat(Global.getDateFormat());
        this.createdDate.setCalendarPopup(true);
        this.createdDate.setCalendarWidget(this.createdCalendarWidget);
        this.createdTime = new QTimeEdit();
        this.createdDate.dateChanged.connect((Object)this, "createdChanged()");
        this.createdTime.timeChanged.connect((Object)this, "createdChanged()");
        this.alteredCalendarWidget = new QCalendarWidget();
        this.alteredDate = new QDateEdit();
        this.alteredDate.setDisplayFormat(Global.getDateFormat());
        this.alteredDate.setCalendarPopup(true);
        this.alteredDate.setCalendarWidget(this.alteredCalendarWidget);
        this.alteredTime = new QTimeEdit();
        this.alteredLabel = new QLabel(this.tr("Altered:"));
        this.alteredDate.dateChanged.connect((Object)this, "alteredChanged()");
        this.alteredTime.timeChanged.connect((Object)this, "alteredChanged()");
        this.subjectCalendarWidget = new QCalendarWidget();
        this.subjectDate = new QDateEdit();
        this.subjectDate.setDisplayFormat(Global.getDateFormat());
        this.subjectDate.setCalendarPopup(true);
        this.subjectDate.setCalendarWidget(this.subjectCalendarWidget);
        this.subjectTime = new QTimeEdit();
        this.subjectLabel = new QLabel(this.tr("Subject Date:"));
        this.subjectDate.dateChanged.connect((Object)this, "subjectDateTimeChanged()");
        this.subjectTime.timeChanged.connect((Object)this, "subjectDateTimeChanged()");
        this.authorText.textChanged.connect((Object)this, "authorChanged()");
        this.urlText.textChanged.connect((Object)this, "sourceUrlChanged()");
        this.notebookBox = new QComboBox();
        this.notebookLabel = new QLabel(this.tr("Notebook"));
        this.createdLabel = new QLabel(this.tr("Created:"));
        this.urlLabel.setVisible(false);
        this.urlText.setVisible(false);
        this.authorLabel.setVisible(false);
        this.geoBox.setVisible(false);
        this.geoBox.addItem(new QIcon(String.valueOf(this.iconPath) + "globe.png"), "");
        this.geoBox.addItem(new String(this.tr("Set")));
        this.geoBox.addItem(new String(this.tr("Clear")));
        this.geoBox.addItem(new String(this.tr("View On Map")));
        this.geoBox.activated.connect((Object)this, "geoBoxChanged()");
        this.authorText.setVisible(false);
        this.createdDate.setVisible(false);
        this.alteredLabel.setVisible(false);
        this.notebookLabel.setVisible(false);
        this.createdLabel.setVisible(false);
        this.createdTime.setVisible(false);
        this.alteredDate.setVisible(false);
        this.alteredTime.setVisible(false);
        this.subjectLabel.setVisible(false);
        this.subjectDate.setVisible(false);
        this.subjectTime.setVisible(false);
        this.extendedOn = false;
        this.buttonsVisible = true;
        this.setAcceptDrops(true);
        this.browser = new ContentView(this);
        this.browser.page().setLinkDelegationPolicy(QWebPage.LinkDelegationPolicy.DelegateAllLinks);
        this.browser.linkClicked.connect((Object)this, "linkClicked(QUrl)");
        this.currentHyperlink = "";
        this.sourceEdit = new QTextEdit((QWidget)this);
        this.sourceEdit.setVisible(false);
        this.sourceEdit.setTabChangesFocus(true);
        this.sourceEdit.setLineWrapMode(QTextEdit.LineWrapMode.NoWrap);
        QFont font = new QFont();
        font.setFamily("Courier");
        font.setFixedPitch(true);
        font.setPointSize(10);
        this.sourceEdit.setFont(font);
        this.syntaxHighlighter = new Highlighter(this.sourceEdit.document());
        this.sourceEdit.textChanged.connect((Object)this, "sourceEdited()");
        QVBoxLayout v = new QVBoxLayout();
        QFormLayout notebookLayout = new QFormLayout();
        QGridLayout dateLayout = new QGridLayout();
        this.titleLabel.setReadOnly(false);
        this.titleLabel.editingFinished.connect((Object)this, "titleEdited()");
        this.browser.page().contentsChanged.connect((Object)this, "contentChanged()");
        this.browser.page().selectionChanged.connect((Object)this, "selectionChanged()");
        this.browser.page().mainFrame().javaScriptWindowObjectCleared.connect((Object)this, "exposeToJavascript()");
        this.notebookBox.activated.connect((Object)this, "notebookChanged()");
        this.resourceSignal = new NoteResourceSignal();
        QHBoxLayout tagLayout = new QHBoxLayout();
        v.addWidget((QWidget)this.titleLabel, 0, new Qt.AlignmentFlag[0]);
        notebookLayout.addRow((QWidget)this.notebookLabel, (QWidget)this.notebookBox);
        tagLayout.addLayout((QLayout)notebookLayout, 0);
        tagLayout.stretch(4);
        tagLayout.addWidget((QWidget)this.tagLabel, 0, new Qt.AlignmentFlag[0]);
        tagLayout.addWidget((QWidget)this.tagEdit, 1, new Qt.AlignmentFlag[0]);
        v.addLayout((QLayout)tagLayout);
        QHBoxLayout urlLayout = new QHBoxLayout();
        urlLayout.addWidget((QWidget)this.urlLabel, 0, new Qt.AlignmentFlag[0]);
        urlLayout.addWidget((QWidget)this.urlText, 0, new Qt.AlignmentFlag[0]);
        v.addLayout((QLayout)urlLayout);
        QHBoxLayout authorLayout = new QHBoxLayout();
        authorLayout.addWidget((QWidget)this.authorLabel, 0, new Qt.AlignmentFlag[0]);
        authorLayout.addWidget((QWidget)this.authorText, 0, new Qt.AlignmentFlag[0]);
        authorLayout.addWidget((QWidget)this.geoBox);
        v.addLayout((QLayout)authorLayout);
        dateLayout.addWidget((QWidget)this.createdLabel, 0, 0);
        dateLayout.addWidget((QWidget)this.createdDate, 0, 1);
        dateLayout.addWidget((QWidget)this.createdTime, 0, 2);
        dateLayout.setColumnStretch(9, 100);
        dateLayout.addWidget((QWidget)this.alteredLabel, 0, 3);
        dateLayout.addWidget((QWidget)this.alteredDate, 0, 4);
        dateLayout.addWidget((QWidget)this.alteredTime, 0, 5);
        dateLayout.addWidget((QWidget)this.subjectLabel, 0, 6);
        dateLayout.addWidget((QWidget)this.subjectDate, 0, 7);
        dateLayout.addWidget((QWidget)this.subjectTime, 0, 8);
        v.addLayout((QLayout)dateLayout, 0);
        this.undoButton = this.newEditorButton("undo", this.tr("Undo Change"));
        this.redoButton = this.newEditorButton("redo", this.tr("Redo Change"));
        this.cutButton = this.newEditorButton("cut", this.tr("Cut"));
        this.copyButton = this.newEditorButton("copy", this.tr("Copy"));
        this.pasteButton = this.newEditorButton("paste", this.tr("Paste"));
        this.boldButton = this.newEditorButton("bold", this.tr("Bold"));
        this.underlineButton = this.newEditorButton("underline", this.tr("Underline"));
        this.italicButton = this.newEditorButton("italic", this.tr("Italic"));
        this.rightAlignButton = this.newEditorButton("justifyRight", this.tr("Right Align"));
        this.leftAlignButton = this.newEditorButton("justifyLeft", this.tr("Left Align"));
        this.centerAlignButton = this.newEditorButton("justifyCenter", this.tr("Center Align"));
        this.strikethroughButton = this.newEditorButton("strikethrough", this.tr("Strikethrough"));
        this.hlineButton = this.newEditorButton("hline", this.tr("Insert Horizontal Line"));
        this.indentButton = this.newEditorButton("indent", this.tr("Shift Right"));
        this.outdentButton = this.newEditorButton("outdent", this.tr("Shift Left"));
        this.bulletListButton = this.newEditorButton("bulletList", this.tr("Bullet List"));
        this.numberListButton = this.newEditorButton("numberList", this.tr("Number List"));
        this.spellCheckButton = this.newEditorButton("spellCheck", this.tr("Spell Check"));
        this.todoButton = this.newEditorButton("todo", this.tr("To-do"));
        this.buttonLayout = new EditorButtonBar();
        v.addWidget((QWidget)this.buttonLayout);
        this.undoAction = this.buttonLayout.addWidget((QWidget)this.undoButton);
        this.buttonLayout.toggleUndoVisible.triggered.connect((Object)this, "toggleUndoVisible(Boolean)");
        this.redoAction = this.buttonLayout.addWidget((QWidget)this.redoButton);
        this.buttonLayout.toggleRedoVisible.triggered.connect((Object)this, "toggleRedoVisible(Boolean)");
        this.buttonLayout.addWidget((QWidget)this.newSeparator());
        this.cutAction = this.buttonLayout.addWidget((QWidget)this.cutButton);
        this.buttonLayout.toggleCutVisible.triggered.connect((Object)this, "toggleCutVisible(Boolean)");
        this.copyAction = this.buttonLayout.addWidget((QWidget)this.copyButton);
        this.buttonLayout.toggleCopyVisible.triggered.connect((Object)this, "toggleCopyVisible(Boolean)");
        this.pasteAction = this.buttonLayout.addWidget((QWidget)this.pasteButton);
        this.buttonLayout.togglePasteVisible.triggered.connect((Object)this, "togglePasteVisible(Boolean)");
        this.buttonLayout.addWidget((QWidget)this.newSeparator());
        this.boldAction = this.buttonLayout.addWidget((QWidget)this.boldButton);
        this.buttonLayout.toggleBoldVisible.triggered.connect((Object)this, "toggleBoldVisible(Boolean)");
        this.italicAction = this.buttonLayout.addWidget((QWidget)this.italicButton);
        this.buttonLayout.toggleItalicVisible.triggered.connect((Object)this, "toggleItalicVisible(Boolean)");
        this.underlineAction = this.buttonLayout.addWidget((QWidget)this.underlineButton);
        this.buttonLayout.toggleUnderlineVisible.triggered.connect((Object)this, "toggleUnderlineVisible(Boolean)");
        this.strikethroughAction = this.buttonLayout.addWidget((QWidget)this.strikethroughButton);
        this.buttonLayout.toggleStrikethroughVisible.triggered.connect((Object)this, "toggleStrikethroughVisible(Boolean)");
        this.buttonLayout.addWidget((QWidget)this.newSeparator());
        this.leftAlignAction = this.buttonLayout.addWidget((QWidget)this.leftAlignButton);
        this.buttonLayout.toggleLeftAlignVisible.triggered.connect((Object)this, "toggleLeftAlignVisible(Boolean)");
        this.centerAlignAction = this.buttonLayout.addWidget((QWidget)this.centerAlignButton);
        this.buttonLayout.toggleCenterAlignVisible.triggered.connect((Object)this, "toggleCenterAlignVisible(Boolean)");
        this.rightAlignAction = this.buttonLayout.addWidget((QWidget)this.rightAlignButton);
        this.buttonLayout.toggleRightAlignVisible.triggered.connect((Object)this, "toggleRightAlignVisible(Boolean)");
        this.buttonLayout.addWidget((QWidget)this.newSeparator());
        this.hlineAction = this.buttonLayout.addWidget((QWidget)this.hlineButton);
        this.buttonLayout.toggleHLineVisible.triggered.connect((Object)this, "toggleHLineVisible(Boolean)");
        this.indentAction = this.buttonLayout.addWidget((QWidget)this.indentButton);
        this.buttonLayout.toggleIndentVisible.triggered.connect((Object)this, "toggleIndentVisible(Boolean)");
        this.outdentAction = this.buttonLayout.addWidget((QWidget)this.outdentButton);
        this.buttonLayout.toggleOutdentVisible.triggered.connect((Object)this, "toggleOutdentVisible(Boolean)");
        this.bulletListAction = this.buttonLayout.addWidget((QWidget)this.bulletListButton);
        this.buttonLayout.toggleBulletListVisible.triggered.connect((Object)this, "toggleBulletListVisible(Boolean)");
        this.numberListAction = this.buttonLayout.addWidget((QWidget)this.numberListButton);
        this.buttonLayout.toggleNumberListVisible.triggered.connect((Object)this, "toggleNumberListVisible(Boolean)");
        this.buttonLayout.addWidget((QWidget)this.newSeparator());
        this.fontList = new QComboBox();
        this.fontSize = new QComboBox();
        this.fontList.setMaximumWidth(130);
        this.fontSize.setMaximumWidth(45);
        this.fontList.setToolTip("Font");
        this.fontSize.setToolTip("Font Size");
        this.fontList.activated.connect((Object)this, "fontChanged(String)");
        this.fontSize.activated.connect((Object)this, "fontSizeChanged(String)");
        this.fontListAction = this.buttonLayout.addWidget((QWidget)this.fontList);
        this.buttonLayout.toggleFontVisible.triggered.connect((Object)this, "toggleFontListVisible(Boolean)");
        this.fontSizeAction = this.buttonLayout.addWidget((QWidget)this.fontSize);
        this.buttonLayout.toggleFontSizeVisible.triggered.connect((Object)this, "toggleFontSizeVisible(Boolean)");
        QFontDatabase fonts = new QFontDatabase();
        List fontFamilies = fonts.families();
        int i = 0;
        while (i < fontFamilies.size()) {
            this.fontList.addItem((String)fontFamilies.get(i));
            if (i == 0) {
                this.loadFontSize((String)fontFamilies.get(i));
            }
            ++i;
        }
        this.fontColor = this.newToolButton("fontColor", this.tr("Font Color"));
        this.fontColorMenu = new ColorMenu(this);
        this.fontColor.setMenu(this.fontColorMenu.getMenu());
        this.fontColor.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup);
        this.fontColor.setAutoRaise(false);
        this.fontColorMenu.getMenu().triggered.connect((Object)this, "fontColorClicked()");
        this.fontColorAction = this.buttonLayout.addWidget((QWidget)this.fontColor);
        this.buttonLayout.toggleFontColorVisible.triggered.connect((Object)this, "toggleFontColorVisible(Boolean)");
        this.fontHilight = this.newToolButton("fontHilight", this.tr("Font Hilight Color"));
        this.fontHilight.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup);
        this.fontHilight.setAutoRaise(false);
        this.fontHilightColorMenu = new ColorMenu(this);
        this.fontHilightColorMenu.setDefault(QColor.yellow);
        this.fontHilight.setMenu(this.fontHilightColorMenu.getMenu());
        this.fontHilightColorMenu.getMenu().triggered.connect((Object)this, "fontHilightClicked()");
        this.fontHilightAction = this.buttonLayout.addWidget((QWidget)this.fontHilight);
        this.fontHilightColorMenu.setDefault(QColor.yellow);
        this.buttonLayout.toggleFontHilight.triggered.connect((Object)this, "toggleFontHilightVisible(Boolean)");
        this.spellCheckAction = this.buttonLayout.addWidget((QWidget)this.spellCheckButton);
        this.buttonLayout.toggleNumberListVisible.triggered.connect((Object)this, "spellCheckClicked()");
        this.buttonLayout.toggleSpellCheck.triggered.connect((Object)this, "toggleSpellCheckVisible(Boolean)");
        this.todoAction = this.buttonLayout.addWidget((QWidget)this.todoButton);
        this.buttonLayout.toggleNumberListVisible.triggered.connect((Object)this, "todoClicked()");
        this.buttonLayout.toggleTodo.triggered.connect((Object)this, "toggleTodoVisible(Boolean)");
        QSplitter editSplitter = new QSplitter((QWidget)this);
        editSplitter.addWidget((QWidget)this.browser);
        editSplitter.setOrientation(Qt.Orientation.Vertical);
        editSplitter.addWidget((QWidget)this.sourceEdit);
        v.addWidget((QWidget)editSplitter);
        this.setLayout((QLayout)v);
        this.browser.downloadAttachmentRequested.connect((Object)this, "downloadAttachment(QNetworkRequest)");
        this.browser.downloadImageRequested.connect((Object)this, "downloadImage(QNetworkRequest)");
        BrowserWindow.setTabOrder((QWidget)this.notebookBox, (QWidget)this.tagEdit);
        BrowserWindow.setTabOrder((QWidget)this.tagEdit, (QWidget)this.browser);
        this.focusNoteShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.focusNoteShortcut, "Focus_Note");
        this.focusNoteShortcut.activated.connect((Object)this, "focusNote()");
        this.focusTitleShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.focusTitleShortcut, "Focus_Title");
        this.focusTitleShortcut.activated.connect((Object)this, "focusTitle()");
        this.focusTagShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.focusTagShortcut, "Focus_Tag");
        this.focusTagShortcut.activated.connect((Object)this, "focusTag()");
        this.focusAuthorShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.focusAuthorShortcut, "Focus_Author");
        this.focusAuthorShortcut.activated.connect((Object)this, "focusAuthor()");
        this.focusUrlShortcut = new QShortcut((QWidget)this);
        this.setupShortcut(this.focusUrlShortcut, "Focus_Url");
        this.focusUrlShortcut.activated.connect((Object)this, "focusUrl()");
        this.browser.page().mainFrame().setTextSizeMultiplier(Global.getTextSizeMultiplier());
        this.browser.page().mainFrame().setZoomFactor(Global.getZoomFactor());
        this.previewPageList = new HashMap();
        this.browser.page().microFocusChanged.connect((Object)this, "microFocusChanged()");
        QPalette pal = new QPalette();
        pal.setColor(QPalette.ColorRole.Text, QColor.black);
        this.titleLabel.setPalette(pal);
        this.authorText.setPalette(pal);
        this.authorLabel.setPalette(pal);
        this.urlLabel.setPalette(pal);
        this.urlText.setPalette(pal);
        this.createdDate.setPalette(pal);
        this.createdTime.setPalette(pal);
        this.alteredDate.setPalette(pal);
        this.alteredTime.setPalette(pal);
        this.subjectDate.setPalette(pal);
        this.subjectTime.setPalette(pal);
        this.tagEdit.setPalette(pal);
        this.notebookBox.setPalette(pal);
        this.blockApplication = new QSignalEmitter.Signal1((QSignalEmitter)this);
        this.unblockApplication = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.setSourceTimer = new QTimer();
        this.setSourceTimer.timeout.connect((Object)this, "setSource()");
        this.logger.log(this.logger.HIGH, "Browser setup complete");
    }

    private void setupShortcut(QShortcut action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setKey(new QKeySequence(Global.shortcutKeys.getShortcut(text)));
    }

    public QWebView getBrowser() {
        return this.browser;
    }

    public void loadingData(boolean val) {
        this.logger.log(this.logger.EXTREME, "Entering BrowserWindow.loadingData() " + val);
        this.notebookBox.blockSignals(val);
        this.browser.page().blockSignals(val);
        this.browser.page().mainFrame().blockSignals(val);
        this.titleLabel.blockSignals(val);
        this.alteredDate.blockSignals(val);
        this.alteredTime.blockSignals(val);
        this.createdTime.blockSignals(val);
        this.createdDate.blockSignals(val);
        this.subjectDate.blockSignals(val);
        this.subjectTime.blockSignals(val);
        this.urlText.blockSignals(val);
        this.authorText.blockSignals(val);
        if (!val) {
            this.exposeToJavascript();
        }
        this.logger.log(this.logger.EXTREME, "Exiting BrowserWindow.loadingData() " + val);
    }

    public void setReadOnly(boolean v) {
        this.setEnabled(true);
        this.titleLabel.setEnabled(!v);
        this.notebookBox.setEnabled(!v);
        this.tagEdit.setEnabled(!v);
        this.authorLabel.setEnabled(!v);
        this.geoBox.setEnabled(!v);
        this.urlText.setEnabled(!v);
        this.createdDate.setEnabled(!v);
        this.subjectDate.setEnabled(!v);
        this.alteredDate.setEnabled(!v);
        this.authorText.setEnabled(!v);
        this.createdTime.setEnabled(!v);
        this.alteredTime.setEnabled(!v);
        this.subjectTime.setEnabled(!v);
        this.getBrowser().setEnabled(true);
        this.getBrowser().page().setContentEditable(!v);
    }

    private void exposeToJavascript() {
        this.browser.page().mainFrame().addToJavaScriptWindowObject("jambi", (QObject)this);
    }

    public boolean event(QEvent e) {
        if (e.type().equals((Object)QEvent.Type.FocusOut)) {
            this.logger.log(this.logger.EXTREME, "Focus lost");
            this.focusLost.emit();
        }
        return super.event(e);
    }

    public void clear() {
        this.logger.log(this.logger.EXTREME, "Entering BrowserWindow.clear()");
        this.setNote(null);
        this.setContent(new QByteArray());
        this.tagEdit.setText("");
        this.tagEdit.tagCompleter.reset();
        this.urlLabel.setText(this.tr("Source URL:"));
        this.titleLabel.setText("");
        this.logger.log(this.logger.EXTREME, "Exiting BrowserWindow.clear()");
    }

    public void setContent(QByteArray data) {
        this.sourceEdit.blockSignals(true);
        this.browser.setContent(data);
        this.setSource();
    }

    public void setNote(Note n) {
        this.currentNote = n;
        if (n == null) {
            n = new Note();
        }
        this.saveNoteTitle = n.getTitle();
    }

    public Note getNote() {
        return this.currentNote;
    }

    private QPushButton newEditorButton(String name, String toolTip) {
        QPushButton button = new QPushButton();
        QIcon icon = new QIcon(String.valueOf(this.iconPath) + name + ".png");
        button.setIcon(icon);
        button.setIconSize(new QSize(16, 16));
        button.setToolTip(toolTip);
        button.clicked.connect((Object)this, String.valueOf(name) + "Clicked()");
        return button;
    }

    private QToolButton newToolButton(String name, String toolTip) {
        QToolButton button = new QToolButton();
        QIcon icon = new QIcon(String.valueOf(this.iconPath) + name + ".png");
        button.setIcon(icon);
        button.setIconSize(new QSize(16, 16));
        button.setToolTip(toolTip);
        button.clicked.connect((Object)this, String.valueOf(name) + "Clicked()");
        return button;
    }

    private QLabel newSeparator() {
        return new QLabel("   ");
    }

    public void setTitle(String t) {
        this.titleLabel.setText(t);
        this.saveNoteTitle = t;
        this.checkNoteTitle();
    }

    public String getTitle() {
        return this.titleLabel.text();
    }

    public void setTag(String t) {
        this.saveTagList = t;
        this.tagEdit.setText(t);
        this.tagEdit.tagCompleter.reset();
    }

    public void setUrl(String t) {
        this.urlLabel.setText(this.tr("Source URL:\t"));
        this.urlText.setText(t);
    }

    public void sourceUrlClicked() {
        if (this.urlText.text().trim().equals("")) {
            return;
        }
        String url = this.urlText.text();
        if (!url.toLowerCase().startsWith(this.tr("http://"))) {
            url = String.valueOf(this.tr("http://")) + url;
        }
        if (!QDesktopServices.openUrl((QUrl)new QUrl(url))) {
            this.logger.log(this.logger.LOW, "Error opening file :" + url);
        }
    }

    public void setAuthor(String t) {
        this.authorLabel.setText(this.tr("Author:\t"));
        this.authorText.setText(t);
    }

    public void setCreation(long date) {
        QDateTime dt = new QDateTime();
        dt.setTime_t((int)(date / 1000L));
        this.createdDate.setDateTime(dt);
        this.createdTime.setDateTime(dt);
        this.createdDate.setDisplayFormat(Global.getDateFormat());
        this.createdTime.setDisplayFormat(Global.getTimeFormat());
    }

    public void setAltered(long date) {
        QDateTime dt = new QDateTime();
        dt.setTime_t((int)(date / 1000L));
        this.alteredDate.setDateTime(dt);
        this.alteredTime.setDateTime(dt);
        this.alteredDate.setDisplayFormat(Global.getDateFormat());
        this.alteredTime.setDisplayFormat(Global.getTimeFormat());
    }

    public void setSubjectDate(long date) {
        QDateTime dt = new QDateTime();
        dt.setTime_t((int)(date / 1000L));
        this.subjectDate.setDateTime(dt);
        this.subjectTime.setDateTime(dt);
        this.subjectDate.setDisplayFormat(Global.getDateFormat());
        this.subjectTime.setDisplayFormat(Global.getTimeFormat());
    }

    public void toggleInformation() {
        this.extendedOn = !this.extendedOn;
        this.urlLabel.setVisible(this.extendedOn);
        this.urlText.setVisible(this.extendedOn);
        this.authorText.setVisible(this.extendedOn);
        this.geoBox.setVisible(this.extendedOn);
        this.authorLabel.setVisible(this.extendedOn);
        this.createdDate.setVisible(this.extendedOn);
        this.createdTime.setVisible(this.extendedOn);
        this.createdLabel.setVisible(this.extendedOn);
        this.alteredLabel.setVisible(this.extendedOn);
        this.alteredDate.setVisible(this.extendedOn);
        this.alteredTime.setVisible(this.extendedOn);
        this.notebookLabel.setVisible(this.extendedOn);
        this.subjectLabel.setVisible(this.extendedOn);
        this.subjectDate.setVisible(this.extendedOn);
        this.subjectTime.setVisible(this.extendedOn);
    }

    public void hideButtons() {
        this.undoButton.parentWidget().setVisible(false);
        this.buttonsVisible = false;
    }

    public boolean isExtended() {
        return this.extendedOn;
    }

    private void openFile() {
        this.logger.log(this.logger.EXTREME, "Starting openFile()");
        File fileHandle = new File(this.selectedFile);
        URI fileURL = fileHandle.toURI();
        String localURL = fileURL.toString();
        QUrl url = new QUrl(localURL);
        QFile file = new QFile(this.selectedFile);
        this.logger.log(this.logger.EXTREME, "Adding to fileWatcher:" + file.fileName());
        this.fileWatcher.addPath(file.fileName());
        if (!QDesktopServices.openUrl((QUrl)url)) {
            this.logger.log(this.logger.LOW, "Error opening file :" + url);
        }
    }

    private void linkClicked(QUrl url) {
        this.logger.log(this.logger.EXTREME, "URL Clicked: " + url.toString());
        if (url.toString().startsWith("latex:")) {
            int position = url.toString().lastIndexOf(".");
            String guid = url.toString().substring(0, position);
            position = guid.lastIndexOf("/");
            guid = guid.substring(position + 1);
            this.editLatex(guid);
            return;
        }
        if (url.toString().startsWith("evernote:/view/")) {
            StringTokenizer tokens = new StringTokenizer(url.toString().replace("evernote:/view/", ""), "/");
            tokens.nextToken();
            tokens.nextToken();
            String sid = tokens.nextToken();
            String lid = tokens.nextToken();
            this.evernoteLinkClicked.emit((Object)sid, (Object)lid);
            return;
        }
        if (url.toString().startsWith("nnres://")) {
            String resGuid;
            this.logger.log(this.logger.EXTREME, "URL is NN resource");
            if (url.toString().endsWith("/vnd.evernote.ink")) {
                this.logger.log(this.logger.EXTREME, "Unable to open ink note");
                QMessageBox.information((QWidget)this, (String)this.tr("Unable Open"), (String)this.tr("This is an ink note.\nInk notes are not supported since Evernote has not\n published any specifications on them\nand I'm too lazy to figure them out by myself."));
                return;
            }
            String fullName = url.toString().substring(8);
            int index = fullName.indexOf(".");
            String guid = "";
            String type = "";
            if (index > -1) {
                type = fullName.substring(index + 1);
                guid = fullName.substring(0, index);
            }
            if ((index = guid.indexOf(Global.attachmentNameDelimeter)) > -1) {
                guid = guid.substring(0, index);
            }
            List resList = this.currentNote.getResources();
            Resource res = null;
            int i = 0;
            while (i < resList.size()) {
                if (((Resource)resList.get(i)).getGuid().equals(guid)) {
                    res = (Resource)resList.get(i);
                    i = resList.size();
                }
                ++i;
            }
            if (res == null && (resGuid = Global.resourceMap.get(guid)) != null) {
                res = this.conn.getNoteTable().noteResourceTable.getNoteResource(resGuid, true);
            }
            if (res != null) {
                String fileName = res.getAttributes() != null && res.getAttributes().getFileName() != null && !res.getAttributes().getFileName().trim().equals("") ? String.valueOf(res.getGuid()) + Global.attachmentNameDelimeter + res.getAttributes().getFileName() : String.valueOf(res.getGuid()) + "." + type;
                QFile file = new QFile(Global.getFileManager().getResDirPath(fileName));
                QIODevice.OpenMode mode = new QIODevice.OpenMode(new QIODevice.OpenModeFlag[0]);
                mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                boolean openResult = file.open(mode);
                this.logger.log(this.logger.EXTREME, "File opened:" + openResult);
                QDataStream out = new QDataStream((QIODevice)file);
                Resource resBinary = this.conn.getNoteTable().noteResourceTable.getNoteResource(res.getGuid(), true);
                QByteArray binData = new QByteArray(resBinary.getData().getBody());
                resBinary = null;
                this.logger.log(this.logger.EXTREME, "Writing resource");
                out.writeBytes(binData.toByteArray());
                file.close();
                String whichOS = System.getProperty("os.name");
                if (whichOS.contains("Windows")) {
                    url.setUrl("file:///" + file.fileName());
                } else {
                    url.setUrl("file://" + file.fileName());
                }
                this.logger.log(this.logger.EXTREME, "Adding file watcher " + file.fileName());
                this.fileWatcher.addPath(file.fileName());
                if (!QDesktopServices.openUrl((QUrl)url)) {
                    this.logger.log(this.logger.EXTREME, "We can't handle this.  Where do we put it?");
                    QFileDialog dialog = new QFileDialog();
                    dialog.show();
                    if (dialog.exec() != 0) {
                        List fileNames = dialog.selectedFiles();
                        if (fileNames.size() == 0) {
                            return;
                        }
                        String sf = (String)fileNames.get(0);
                        QFile saveFile = new QFile(sf);
                        mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                        saveFile.open(mode);
                        QDataStream saveOut = new QDataStream((QIODevice)saveFile);
                        saveOut.writeBytes(binData.toByteArray());
                        saveFile.close();
                        return;
                    }
                }
            }
            return;
        }
        this.logger.log(this.logger.EXTREME, "Launching URL");
        QDesktopServices.openUrl((QUrl)url);
    }

    private void undoClicked() {
        this.browser.page().triggerAction(QWebPage.WebAction.Undo);
        this.browser.setFocus();
    }

    private void redoClicked() {
        this.browser.page().triggerAction(QWebPage.WebAction.Redo);
        this.browser.setFocus();
    }

    private void boldClicked() {
        this.browser.page().triggerAction(QWebPage.WebAction.ToggleBold);
        this.microFocusChanged();
        this.browser.setFocus();
    }

    private void italicClicked() {
        this.browser.page().triggerAction(QWebPage.WebAction.ToggleItalic);
        this.microFocusChanged();
        this.browser.setFocus();
    }

    private void underlineClicked() {
        this.browser.page().triggerAction(QWebPage.WebAction.ToggleUnderline);
        this.microFocusChanged();
        this.browser.setFocus();
    }

    private void strikethroughClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('strikeThrough', false, '');");
        this.browser.setFocus();
    }

    private void cutClicked() {
        this.cbObserver.setCopySourceGuid(this.currentNote.getGuid(), this.browser.page().selectedText());
        this.browser.page().triggerAction(QWebPage.WebAction.Cut);
        this.browser.setFocus();
    }

    private void copyClicked() {
        this.cbObserver.setCopySourceGuid(this.currentNote.getGuid(), this.browser.page().selectedText());
        this.browser.page().triggerAction(QWebPage.WebAction.Copy);
        this.browser.setFocus();
    }

    public void pasteClicked() {
        QClipboard clipboard;
        QMimeData mime;
        this.logger.log(this.logger.EXTREME, "Paste Clicked");
        if (this.forceTextPaste) {
            this.pasteWithoutFormattingClicked();
            return;
        }
        String srcGuid = this.cbObserver.getSourceGuid();
        String dstGuid = this.currentNote.getGuid();
        if (srcGuid != null && dstGuid != null && !srcGuid.equals(dstGuid)) {
            this.conn.getHistoryTable().addHistory("copy & paste", srcGuid, dstGuid);
        }
        if ((mime = (clipboard = QApplication.clipboard()).mimeData()).hasImage()) {
            this.logger.log(this.logger.EXTREME, "Image paste found");
            this.browser.setFocus();
            this.insertImage(mime);
            this.browser.setFocus();
            return;
        }
        if (mime.hasUrls()) {
            this.logger.log(this.logger.EXTREME, "URL paste found");
            if (mime.text().startsWith("evernote:")) {
                this.handleNoteLink(mime);
            } else {
                this.handleUrls(mime);
                this.browser.setFocus();
            }
            return;
        }
        String text = mime.html();
        if (text.contains("en-tag") && mime.hasHtml()) {
            this.logger.log(this.logger.EXTREME, "Intra-note paste found");
            text = this.fixInternotePaste(text);
            mime.setHtml(text);
            clipboard.setMimeData(mime);
        }
        this.logger.log(this.logger.EXTREME, "Final paste choice encountered");
        this.browser.page().triggerAction(QWebPage.WebAction.Paste);
        this.browser.setFocus();
    }

    private void pasteWithoutFormattingClicked() {
        this.logger.log(this.logger.EXTREME, "Paste without format clipped");
        QClipboard clipboard = QApplication.clipboard();
        QMimeData mime = clipboard.mimeData();
        if (!mime.hasText()) {
            return;
        }
        String srcGuid = this.cbObserver.getSourceGuid();
        String dstGuid = this.currentNote.getGuid();
        if (srcGuid != null && dstGuid != null && !srcGuid.equals(dstGuid)) {
            this.conn.getHistoryTable().addHistory("copy & paste", srcGuid, dstGuid);
        }
        String text = mime.text();
        clipboard.clear();
        clipboard.setText(text, QClipboard.Mode.Clipboard);
        this.browser.page().triggerAction(QWebPage.WebAction.Paste);
        if (this.insideEncryption) {
            String js = new String("function fixEncryption() {    var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode;   while(workingNode != null && workingNode.nodeName.toLowerCase() != 'table') {            workingNode = workingNode.parentNode;   }    workingNode.innerHTML = window.jambi.fixEncryptionPaste(workingNode.innerHTML);} fixEncryption();");
            this.browser.page().mainFrame().evaluateJavaScript(js);
        }
    }

    public String fixEncryptionPaste(String data) {
        data = data.replace("<tbody>", "");
        data = data.replace("</tbody>", "");
        data = data.replace("<tr>", "");
        data = data.replace("</tr>", "");
        data = data.replace("<td>", "");
        data = data.replace("</td>", "<br>");
        data = data.replace("<br><br>", "<br>");
        return "<tbody><tr><td>" + data + "</td></tr></tbody>";
    }

    private void insertDateTime() {
        String fmt = String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat();
        String dateTimeFormat = new String(fmt);
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        Calendar cal = Calendar.getInstance();
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('insertHtml', false, '" + simple.format(cal.getTime()) + "');");
        this.browser.setFocus();
    }

    private void justifyLeftClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('JustifyLeft', false, '');");
        this.browser.setFocus();
    }

    private void justifyCenterClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('JustifyCenter', false, '');");
        this.browser.setFocus();
    }

    private void justifyRightClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('JustifyRight', false, '');");
        this.browser.setFocus();
    }

    private void hlineClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('insertHorizontalRule', false, '');");
        this.browser.setFocus();
    }

    private void outdentClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('outdent', false, '');");
        this.browser.setFocus();
    }

    private void bulletListClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('InsertUnorderedList', false, '');");
        this.browser.setFocus();
    }

    private void numberListClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('InsertOrderedList', false, '');");
        this.browser.setFocus();
    }

    private void indentClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('indent', false, '');");
        this.browser.setFocus();
    }

    private void fontChanged(String font) {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('fontName',false,'" + font + "');");
        this.browser.setFocus();
    }

    private void fontSizeChanged(String font) {
        String text = this.browser.selectedText();
        if (text.trim().equalsIgnoreCase("")) {
            return;
        }
        String selectedText = this.browser.selectedText();
        String url = "<span style=\"font-size:" + font + "pt; \">" + selectedText + "</a>";
        String script = "document.execCommand('insertHtml', false, '" + url + "');";
        this.browser.page().mainFrame().evaluateJavaScript(script);
        this.browser.setFocus();
    }

    private void loadFontSize(String name) {
        QFontDatabase db = new QFontDatabase();
        this.fontSize.clear();
        List points = db.pointSizes(name);
        int i = 0;
        while (i < points.size()) {
            this.fontSize.addItem(((Integer)points.get(i)).toString());
            ++i;
        }
    }

    private void fontColorClicked() {
        QColor color = this.fontColorMenu.getColor();
        if (color.isValid()) {
            this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('foreColor',false,'" + color.name() + "');");
        }
        this.browser.setFocus();
    }

    private void fontHilightClicked() {
        QColor color = this.fontHilightColorMenu.getColor();
        if (color.isValid()) {
            this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('backColor',false,'" + color.name() + "');");
        }
        this.browser.setFocus();
    }

    private void superscriptClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('superscript');");
        this.browser.setFocus();
    }

    private void subscriptClicked() {
        this.browser.page().mainFrame().evaluateJavaScript("document.execCommand('subscript');");
        this.browser.setFocus();
    }

    private void todoClicked() {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String script_start = new String("document.execCommand('insertHtml', false, '");
        String script_end = new String("');");
        String todo = new String("<input TYPE=\"CHECKBOX\" value=\"false\" onMouseOver=\"style.cursor=\\'hand\\'\" onClick=\"value=checked; window.jambi.contentChanged(); \" />");
        this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + todo + script_end);
        this.browser.setFocus();
    }

    private void encryptText() {
        String text = this.browser.selectedText();
        if (text.trim().equalsIgnoreCase("")) {
            return;
        }
        text = new String(text.replaceAll("\n", "<br/>"));
        EnCryptDialog dialog = new EnCryptDialog();
        dialog.exec();
        if (!dialog.okPressed()) {
            return;
        }
        EnCrypt crypt = new EnCrypt();
        String encrypted = crypt.encrypt(text, dialog.getPassword().trim(), 64);
        String decrypted = crypt.decrypt(encrypted, dialog.getPassword().trim(), 64);
        if (encrypted.trim().equals("")) {
            QMessageBox.information((QWidget)this, (String)this.tr("Error"), (String)this.tr("Error Encrypting String"));
            return;
        }
        StringBuffer buffer = new StringBuffer(encrypted.length() + 100);
        buffer.append("<img en-tag=\"en-crypt\" cipher=\"RC2\" hint=\"" + dialog.getHint().replace("'", "\\'") + "\" length=\"64\" ");
        buffer.append("contentEditable=\"false\" alt=\"");
        buffer.append(encrypted);
        buffer.append("\" src=\"").append(FileUtils.toForwardSlashedPath(String.valueOf(Global.getFileManager().getImageDirPath("encrypt.png")) + "\""));
        Global.cryptCounter = Global.cryptCounter + 1;
        buffer.append(" id=\"crypt" + Global.cryptCounter.toString() + "\"");
        buffer.append(" onMouseOver=\"style.cursor=\\'hand\\'\"");
        buffer.append(" onClick=\"window.jambi.decryptText(\\'crypt" + Global.cryptCounter.toString() + "\\', \\'" + encrypted + "\\', \\'" + dialog.getHint().replace("'", "\\&amp;apos;") + "\\');\"");
        buffer.append("style=\"display:block\" />");
        String script_start = new String("document.execCommand('insertHtml', false, '");
        String script_end = new String("');");
        this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + buffer.toString() + script_end);
    }

    public void insertQuickLink() {
        this.logger.log(this.logger.EXTREME, "Inserting link");
        String text = this.browser.selectedText();
        if (text.trim().equalsIgnoreCase("")) {
            return;
        }
        NoteQuickLinkDialog dialog = new NoteQuickLinkDialog(this.logger, this.conn, text, this.cbObserver);
        if (dialog.getResults().size() == 0) {
            QMessageBox.critical(null, (String)this.tr("No Matches Found"), (String)this.tr("No matching notes found."));
            return;
        }
        if (dialog.getResults().size() > 1) {
            dialog.exec();
            if (!dialog.okPressed) {
                this.logger.log(this.logger.EXTREME, "Insert link canceled");
                return;
            }
        }
        User user = Global.getUserInformation();
        String dUrl = String.valueOf(new String("evernote:///view/")) + new String(String.valueOf(user.getId()) + "/" + user.getShardId() + "/" + dialog.getSelectedNote() + "/" + dialog.getSelectedNote() + "/ " + "style=\"color:#69aa35\"");
        String url = "<a title=\"" + dUrl + "\" href=" + dUrl + " >" + text + "</a>";
        String script = "document.execCommand('insertHtml', false, '" + url + "');";
        this.browser.page().mainFrame().evaluateJavaScript(script);
        this.contentChanged();
    }

    public void insertLink() {
        this.logger.log(this.logger.EXTREME, "Inserting link");
        String text = this.browser.selectedText();
        if (text.trim().equalsIgnoreCase("")) {
            return;
        }
        InsertLinkDialog dialog = new InsertLinkDialog(this.insertHyperlink);
        if (this.currentHyperlink != null && this.currentHyperlink != "") {
            dialog.setUrl(this.currentHyperlink);
        }
        dialog.exec();
        if (!dialog.okPressed()) {
            this.logger.log(this.logger.EXTREME, "Insert link canceled");
            return;
        }
        if (this.insertHyperlink) {
            String selectedText = this.browser.selectedText();
            if (dialog.getUrl().trim().equals("")) {
                return;
            }
            this.logger.log(this.logger.EXTREME, "Inserting link on text " + selectedText);
            this.logger.log(this.logger.EXTREME, "URL Link " + dialog.getUrl().trim());
            String dUrl = StringUtils.replace((String)dialog.getUrl().trim(), (String)"'", (String)"\\'");
            String url = "<a href=\"" + dUrl + "\" title=" + dUrl + " >" + selectedText + "</a>";
            String script = "document.execCommand('insertHtml', false, '" + url + "');";
            this.browser.page().mainFrame().evaluateJavaScript(script);
            return;
        }
        String js = new String("function getCursorPos() {var cursorPos;if (window.getSelection) {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   while(workingNode != null) {       if (workingNode.nodeName.toLowerCase()=='a') workingNode.setAttribute('href','" + dialog.getUrl() + "');" + "      workingNode = workingNode.parentNode;" + "   }" + "}" + "} getCursorPos();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        if (!dialog.getUrl().trim().equals("")) {
            this.contentChanged();
            return;
        }
        js = new String("function getCursorPos() {var cursorPos;if (window.getSelection) {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   while(workingNode != null) {       if (workingNode.nodeName.toLowerCase()=='a') {          workingNode.removeAttribute('href');         workingNode.removeAttribute('title');         var text = document.createTextNode(workingNode.innerText);         workingNode.parentNode.insertBefore(text, workingNode);         workingNode.parentNode.removeChild(workingNode);      }      workingNode = workingNode.parentNode;   }}} getCursorPos();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    public void insertLatex() {
        this.editLatex(null);
    }

    public void editLatex(String guid) {
        this.logger.log(this.logger.EXTREME, "Inserting latex");
        String text = this.browser.selectedText();
        if (text.trim().equalsIgnoreCase("\n") || text.trim().equalsIgnoreCase("")) {
            InsertLatexImage dialog = new InsertLatexImage();
            if (guid != null) {
                String formula = this.conn.getNoteTable().noteResourceTable.getNoteSourceUrl(guid).replace("http://latex.codecogs.com/gif.latex?", "");
                dialog.setFormula(formula);
            }
            dialog.exec();
            if (!dialog.okPressed()) {
                this.logger.log(this.logger.EXTREME, "Edit LaTex canceled");
                return;
            }
            text = dialog.getFormula().trim();
        }
        this.blockApplication.emit((Object)this);
        this.logger.log(this.logger.EXTREME, "Inserting LaTeX formula:" + text);
        this.latexGuid = guid;
        text = StringUtils.replace((String)text, (String)"'", (String)"\\'");
        String url = "http://latex.codecogs.com/gif.latex?" + text;
        this.logger.log(this.logger.EXTREME, "Sending request to codecogs --> " + url);
        QNetworkAccessManager manager = new QNetworkAccessManager((QObject)this);
        manager.finished.connect((Object)this, "insertLatexImageReady(QNetworkReply)");
        this.unblockTime = new GregorianCalendar().getTimeInMillis() + 5000L;
        this.awaitingHttpResponse = true;
        manager.get(new QNetworkRequest(new QUrl(url)));
    }

    public void insertLatexImageReady(QNetworkReply reply) {
        QImage pix;
        QFile tfile;
        String path;
        this.logger.log(this.logger.EXTREME, "Response received from CodeCogs");
        if (reply.error() != QNetworkReply.NetworkError.NoError) {
            return;
        }
        this.unblockTime = -1L;
        if (!this.awaitingHttpResponse) {
            return;
        }
        this.awaitingHttpResponse = false;
        QUrl replyUrl = reply.url();
        QByteArray image = reply.readAll();
        reply.close();
        this.logger.log(this.logger.EXTREME, "New image size: " + image.size());
        Resource newRes = null;
        if (this.latexGuid == null) {
            this.logger.log(this.logger.EXTREME, "Creating temporary gif");
            path = Global.getFileManager().getResDirPath("latex-temp.gif");
            tfile = new QFile(path);
            tfile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}));
            this.logger.log(this.logger.EXTREME, "File Open: " + tfile.errorString());
            tfile.write(image);
            this.logger.log(this.logger.EXTREME, "Bytes writtes: " + tfile.size());
            tfile.close();
            this.logger.log(this.logger.EXTREME, "Creating resource");
            int sequence = 0;
            if (this.currentNote.getResources() != null || this.currentNote.getResources().size() > 0) {
                sequence = this.currentNote.getResources().size();
            }
            newRes = this.createResource(path, sequence, "image/gif", false);
            pix = new QImage();
            pix.loadFromData(image);
            newRes.setHeight(new Integer(pix.height()).shortValue());
            newRes.setWidth(new Integer(pix.width()).shortValue());
            this.logger.log(this.logger.EXTREME, "Renaming temporary file to " + newRes.getGuid() + ".gif");
            path = Global.getFileManager().getResDirPath(String.valueOf(newRes.getGuid()) + ".gif");
            tfile.rename(path);
        } else {
            newRes = this.conn.getNoteTable().noteResourceTable.getNoteResource(this.latexGuid, false);
            path = Global.getFileManager().getResDirPath(String.valueOf(newRes.getGuid()) + ".gif");
            tfile = new QFile(path);
            tfile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}));
            tfile.write(image);
            tfile.close();
            newRes.getData().setBody(image.toByteArray());
            this.logger.log(this.logger.EXTREME, "Generating MD5");
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(image.toByteArray());
                byte[] hash = md.digest();
                newRes.getData().setBodyHash(hash);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            pix = new QImage();
            pix.loadFromData(image);
            newRes.setHeight(new Integer(pix.height()).shortValue());
            newRes.setWidth(new Integer(pix.width()).shortValue());
            this.conn.getNoteTable().noteResourceTable.updateNoteResource(newRes, true);
        }
        this.logger.log(this.logger.EXTREME, "Setting source: " + replyUrl.toString());
        newRes.getAttributes().setSourceURL(replyUrl.toString());
        this.conn.getNoteTable().noteResourceTable.updateNoteSourceUrl(newRes.getGuid(), replyUrl.toString(), true);
        int i = 0;
        while (i < this.currentNote.getResourcesSize()) {
            if (((Resource)this.currentNote.getResources().get(i)).getGuid().equals(newRes.getGuid())) {
                this.currentNote.getResources().remove(i);
                i = this.currentNote.getResourcesSize();
            }
            ++i;
        }
        this.currentNote.getResources().add(newRes);
        if (this.latexGuid == null) {
            StringBuffer buffer = new StringBuffer(100);
            String formula = replyUrl.toString().toLowerCase().replace("http://latex.codecogs.com/gif.latex?", "");
            buffer.append("<a href=\"latex://" + path.replace("\\", "/") + "\" title=\"" + formula + "\"" + "><img src=\"");
            buffer.append(path.replace("\\", "/"));
            buffer.append("\" en-tag=\"en-latex\" type=\"image/gif\" hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\"" + " guid=\"" + newRes.getGuid() + "\"" + " /></a>");
            String script_start = new String("document.execCommand('insertHTML', false, '");
            String script_end = new String("');");
            this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + buffer + script_end);
        } else {
            HtmlTagModifier modifier = new HtmlTagModifier(this.getContent());
            modifier.modifyLatexTagHash(newRes);
            String newContent = modifier.getHtml();
            this.setContent(new QByteArray(newContent));
        }
        this.logger.log(this.logger.EXTREME, "New HTML set\n" + this.browser.page().currentFrame().toHtml());
        QWebSettings.setMaximumPagesInCache((int)0);
        QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
        this.browser.page().mainFrame().setHtml(this.browser.page().mainFrame().toHtml());
        this.browser.reload();
        this.contentChanged();
        this.unblockTime = -1L;
        this.unblockApplication.emit();
    }

    public void insertTable() {
        TableDialog dialog = new TableDialog();
        dialog.exec();
        if (!dialog.okPressed()) {
            return;
        }
        int cols = dialog.getCols();
        int rows = dialog.getRows();
        int width = dialog.getWidth();
        boolean percent = dialog.isPercent();
        String newHTML = "<table border=\"1\" width=\"" + new Integer(width).toString();
        if (percent) {
            newHTML = String.valueOf(newHTML) + "%";
        }
        newHTML = String.valueOf(newHTML) + "\"><tbody>";
        int i = 0;
        while (i < rows) {
            newHTML = String.valueOf(newHTML) + "<tr>";
            int j = 0;
            while (j < cols) {
                newHTML = String.valueOf(newHTML) + "<td>&nbsp;</td>";
                ++j;
            }
            newHTML = String.valueOf(newHTML) + "</tr>";
            ++i;
        }
        newHTML = String.valueOf(newHTML) + "</tbody></table>";
        String script = "document.execCommand('insertHtml', false, '" + newHTML + "');";
        this.browser.page().mainFrame().evaluateJavaScript(script);
    }

    private void selectionChanged() {
        this.browser.encryptAction.setEnabled(true);
        this.browser.insertLinkAction.setEnabled(true);
        this.browser.insertQuickLinkAction.setEnabled(true);
        String scriptStart = "var selection_text = (window.getSelection()).toString();var range = (window.getSelection()).getRangeAt(0);var parent_html = range.commonAncestorContainer.innerHTML;if (parent_html == undefined) {window.jambi.saveSelectedText(selection_text); return;}var first_text = range.startContainer.nodeValue.substr(range.startOffset);var last_text = (range.endContainer.nodeValue).substring(0,range.endOffset);var start = parent_html.indexOf(first_text);var end = parent_html.indexOf(last_text,start+1)+last_text.length;var value = parent_html.substring(start,end);window.jambi.saveSelectedText(value);";
        this.browser.page().mainFrame().evaluateJavaScript(scriptStart);
    }

    public void saveSelectedText(String text) {
        boolean enabled = true;
        if (text.trim().length() == 0) {
            enabled = false;
        }
        if (text.indexOf("en-tag=\"en-crypt\"") >= 0) {
            enabled = false;
        }
        if (text.indexOf("<img en-tag=\"en-media\"") >= 0) {
            enabled = false;
        }
        if (text.indexOf("<a en-tag=\"en-media\"") >= 0) {
            enabled = false;
        }
        if (text.indexOf("<input ") >= 0) {
            enabled = false;
        }
        this.browser.encryptAction.setEnabled(enabled);
        this.browser.insertLinkAction.setEnabled(enabled);
        this.browser.insertQuickLinkAction.setEnabled(enabled);
    }

    public void decryptText(String id, String text, String hint) {
        EnCrypt crypt = new EnCrypt();
        String plainText = null;
        GregorianCalendar currentTime = new GregorianCalendar();
        Long l = new Long(currentTime.getTimeInMillis());
        String slot = new String(Long.toString(l));
        int i = 0;
        while (i < Global.passwordRemember.size()) {
            plainText = crypt.decrypt(text, Global.passwordRemember.get(i).getFirst(), 64);
            if (plainText != null) {
                slot = new String(Long.toString(l));
                Global.passwordSafe.put(slot, Global.passwordRemember.get(i));
                this.removeEncryption(id, plainText, false, slot);
                return;
            }
            ++i;
        }
        EnDecryptDialog dialog = new EnDecryptDialog();
        dialog.setHint(hint);
        while (plainText == null || !dialog.okPressed()) {
            dialog.exec();
            if (!dialog.okPressed()) {
                return;
            }
            plainText = crypt.decrypt(text, dialog.getPassword().trim(), 64);
            if (plainText != null) continue;
            QMessageBox.warning((QWidget)this, (String)this.tr("Incorrect Password"), (String)this.tr("The password entered is not correct"));
        }
        Pair<String, String> passwordPair = new Pair<String, String>();
        passwordPair.setFirst(dialog.getPassword());
        passwordPair.setSecond(dialog.getHint());
        Global.passwordSafe.put(slot, passwordPair);
        this.removeEncryption(id, plainText, dialog.permanentlyDecrypt(), slot);
        if (dialog.rememberPassword()) {
            Pair<String, String> pair = new Pair<String, String>();
            pair.setFirst(dialog.getPassword());
            pair.setSecond(dialog.getHint());
            Global.passwordRemember.add(pair);
        }
    }

    public TagLineEdit getTagLine() {
        return this.tagEdit;
    }

    private void modifyTags() {
        TagAssign tagWindow = new TagAssign(this.allTags, this.currentTags, !this.conn.getNotebookTable().isLinked(this.currentNote.getNotebookGuid()));
        tagWindow.exec();
        if (tagWindow.okClicked()) {
            this.currentTags.clear();
            StringBuffer tagDisplay = new StringBuffer();
            List newTags = tagWindow.getTagList().selectedItems();
            int i = 0;
            while (i < newTags.size()) {
                this.currentTags.add(((QListWidgetItem)newTags.get(i)).text());
                tagDisplay.append(((QListWidgetItem)newTags.get(i)).text());
                if (i < newTags.size() - 1) {
                    tagDisplay.append(String.valueOf(Global.tagDelimeter) + " ");
                }
                ++i;
            }
            this.tagEdit.setText(tagDisplay.toString());
            this.noteSignal.tagsChanged.emit((Object)this.currentNote.getGuid(), this.currentTags);
        }
    }

    private void modifyTagsTyping() {
        String[] newTagArray;
        String completionText = "";
        if (this.tagEdit.currentCompleterSelection != null && !this.tagEdit.currentCompleterSelection.equals("")) {
            completionText = this.tagEdit.currentCompleterSelection;
            this.tagEdit.currentCompleterSelection = "";
        }
        if (this.tagEdit.text().equalsIgnoreCase(this.saveTagList)) {
            return;
        }
        if (this.saveTagList == null) {
            return;
        }
        String[] oldTagArray = this.saveTagList.split(Global.tagDelimeter);
        if (!completionText.equals("")) {
            String before = this.tagEdit.text().substring(0, this.tagEdit.cursorPosition());
            int lastDelimiter = before.lastIndexOf(Global.tagDelimeter);
            before = lastDelimiter > 0 ? before.substring(0, before.lastIndexOf(Global.tagDelimeter)) : "";
            String after = this.tagEdit.text().substring(this.tagEdit.cursorPosition());
            newTagArray = (String.valueOf(before) + Global.tagDelimeter + completionText + Global.tagDelimeter + after).split(Global.tagDelimeter);
        } else {
            newTagArray = this.tagEdit.text().split(Global.tagDelimeter);
        }
        int i = 0;
        while (i < newTagArray.length) {
            newTagArray[i] = newTagArray[i].trim().replaceAll("^\\s+", "");
            ++i;
        }
        i = 0;
        while (i < newTagArray.length) {
            boolean foundOnce = false;
            int j = 0;
            while (j < newTagArray.length) {
                if (newTagArray[j].equalsIgnoreCase(newTagArray[i])) {
                    if (!foundOnce) {
                        foundOnce = true;
                    } else {
                        newTagArray[j] = "";
                    }
                }
                ++j;
            }
            ++i;
        }
        ArrayList<String> newTagList = new ArrayList<String>();
        ArrayList<String> oldTagList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < oldTagArray.length) {
            if (!oldTagArray[i2].trim().equals("")) {
                oldTagList.add(oldTagArray[i2]);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < newTagArray.length) {
            if (!newTagArray[i2].trim().equals("")) {
                newTagList.add(newTagArray[i2]);
            }
            ++i2;
        }
        if (this.conn.getNotebookTable().isLinked(this.currentNote.getNotebookGuid())) {
            i2 = newTagList.size() - 1;
            while (i2 >= 0) {
                boolean found = false;
                int j = 0;
                while (j < this.allTags.size()) {
                    if (this.allTags.get(j).getName().equalsIgnoreCase((String)newTagList.get(i2))) {
                        found = true;
                        j = this.allTags.size();
                    }
                    ++j;
                }
                if (!found) {
                    newTagList.remove(i2);
                }
                --i2;
            }
        }
        Collections.sort(newTagList);
        String newDisplay = "";
        int i3 = 0;
        while (i3 < newTagList.size()) {
            newDisplay = String.valueOf(newDisplay) + (String)newTagList.get(i3);
            if (i3 < newTagList.size() - 1) {
                newDisplay = String.valueOf(newDisplay) + Global.tagDelimeter + " ";
            }
            ++i3;
        }
        this.tagEdit.blockSignals(true);
        this.tagEdit.setText(newDisplay);
        this.tagEdit.blockSignals(false);
        i3 = newTagList.size() - 1;
        while (i3 >= 0) {
            String nTag = (String)newTagList.get(i3);
            int j = oldTagList.size() - 1;
            while (j >= 0) {
                String oTag = (String)oldTagList.get(j);
                if (oTag.equalsIgnoreCase(nTag)) {
                    oldTagList.remove(j);
                    newTagList.remove(i3);
                    j = -1;
                }
                --j;
            }
            --i3;
        }
        if (oldTagList.size() != 0 || newTagList.size() != 0) {
            this.currentTags.clear();
            newTagArray = this.tagEdit.text().split(Global.tagDelimeter);
            i3 = 0;
            while (i3 < newTagArray.length) {
                if (!newTagArray[i3].trim().equals("")) {
                    this.currentTags.add(newTagArray[i3].trim());
                }
                ++i3;
            }
            this.noteSignal.tagsChanged.emit((Object)this.currentNote.getGuid(), this.currentTags);
        }
    }

    public void tabPressed() {
        if (this.insideEncryption) {
            return;
        }
        if (!this.insideList && !this.insideTable) {
            String script_start = new String("document.execCommand('insertHtml', false, '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');");
            this.browser.page().mainFrame().evaluateJavaScript(script_start);
            return;
        }
        if (this.insideList) {
            this.indentClicked();
        }
        if (this.insideTable) {
            String js = new String("function getCursorPosition() {    var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode;   var rowCount = 0;   var colCount = 0;   while(workingNode != null && workingNode.nodeName.toLowerCase() != 'table') {       if (workingNode.nodeName.toLowerCase()=='tr') {         rowCount = rowCount+1;      }      if (workingNode.nodeName.toLowerCase() == 'td') {         colCount = colCount+1;      }      if (workingNode.previousSibling != null)          workingNode = workingNode.previousSibling;      else            workingNode = workingNode.parentNode;   }   var nodes = workingNode.getElementsByTagName('tr');   var tableRows = nodes.length;   nodes = nodes[0].getElementsByTagName('td');   var tableColumns = nodes.length;   window.jambi.setTableCursorPositionTab(rowCount, colCount, tableRows, tableColumns);} getCursorPosition();");
            this.browser.page().mainFrame().evaluateJavaScript(js);
        }
    }

    public void setTableCursorPositionTab(int currentRow, int currentCol, int tableRows, int tableColumns) {
        if (tableRows == currentRow && currentCol == tableColumns) {
            this.insertTableRow();
        }
        Qt.KeyboardModifiers modifiers = new Qt.KeyboardModifiers(new Qt.KeyboardModifier[]{Qt.KeyboardModifier.NoModifier});
        QKeyEvent right = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_Right.value(), modifiers);
        QKeyEvent end = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_End.value(), modifiers);
        QKeyEvent end2 = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_End.value(), modifiers);
        this.getBrowser().focusWidget();
        QCoreApplication.postEvent((QObject)this.getBrowser(), (QEvent)end);
        QCoreApplication.postEvent((QObject)this.getBrowser(), (QEvent)right);
        QCoreApplication.postEvent((QObject)this.getBrowser(), (QEvent)end2);
    }

    public void backtabPressed() {
        if (this.insideEncryption) {
            return;
        }
        if (this.insideList) {
            this.outdentClicked();
        }
        if (this.insideTable) {
            String js = new String("function getCursorPosition() {    var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode;   var rowCount = 0;   var colCount = 0;   while(workingNode != null && workingNode.nodeName.toLowerCase() != 'table') {       if (workingNode.nodeName.toLowerCase()=='tr') {         rowCount = rowCount+1;      }      if (workingNode.nodeName.toLowerCase() == 'td') {         colCount = colCount+1;      }      if (workingNode.previousSibling != null)          workingNode = workingNode.previousSibling;      else            workingNode = workingNode.parentNode;   }   var nodes = workingNode.getElementsByTagName('tr');   var tableRows = nodes.length;   nodes = nodes[0].getElementsByTagName('td');   var tableColumns = nodes.length;   window.jambi.setTableCursorPositionBackTab(rowCount, colCount, tableRows, tableColumns);} getCursorPosition();");
            this.browser.page().mainFrame().evaluateJavaScript(js);
        }
    }

    public void setTableCursorPositionBackTab(int currentRow, int currentCol, int tableRows, int tableColumns) {
        if (currentRow == 1 && currentCol == 1) {
            return;
        }
        Qt.KeyboardModifiers modifiers = new Qt.KeyboardModifiers(new Qt.KeyboardModifier[]{Qt.KeyboardModifier.NoModifier});
        QKeyEvent left = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_Left.value(), modifiers);
        QKeyEvent home = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_Home.value(), modifiers);
        this.getBrowser().focusWidget();
        QCoreApplication.postEvent((QObject)this.getBrowser(), (QEvent)home);
        QCoreApplication.postEvent((QObject)this.getBrowser(), (QEvent)left);
    }

    public void setInsideList() {
        this.insideList = true;
    }

    private void titleEdited() {
        if (this.currentNote == null) {
            return;
        }
        if (this.currentNote.getTitle().trim().equals(this.titleLabel.text().trim())) {
            return;
        }
        String text = this.titleLabel.text().trim();
        if (text.equals("")) {
            text = this.tr("Untitled Note");
        }
        this.noteSignal.titleChanged.emit((Object)this.currentNote.getGuid(), (Object)text);
        this.currentNote.setTitle(text);
        this.saveNoteTitle = text;
        this.checkNoteTitle();
    }

    public void setAllTags(List<Tag> l) {
        this.allTags = l;
        this.tagEdit.setTagList(l);
    }

    public void setCurrentTags(List<String> s) {
        this.currentTags = s;
    }

    public void setNotebookList(List<Notebook> n) {
        this.notebookList = n;
        this.loadNotebookList();
    }

    private void loadNotebookList() {
        if (this.notebookBox.count() != 0) {
            this.notebookBox.clear();
        }
        if (this.notebookList == null) {
            return;
        }
        int i = 0;
        while (i < this.notebookList.size()) {
            this.notebookBox.addItem(this.notebookList.get(i).getName());
            if (this.currentNote != null && this.currentNote.getNotebookGuid().equals(this.notebookList.get(i).getGuid())) {
                this.notebookBox.setCurrentIndex(i);
            }
            ++i;
        }
    }

    public void setNotebook(String notebook) {
        this.currentNote.setNotebookGuid(notebook);
        this.loadNotebookList();
    }

    public String getContent() {
        return this.browser.page().currentFrame().toHtml();
    }

    public void contentChanged() {
        String content = this.getContent();
        if (this.sourceEdit.isVisible()) {
            this.setSourceTimer.stop();
            this.setSourceTimer.setInterval(500);
            this.setSourceTimer.setSingleShot(true);
            this.setSourceTimer.start();
        }
        this.checkNoteTitle();
        this.noteSignal.noteChanged.emit((Object)this.currentNote.getGuid(), (Object)content);
    }

    private void notebookChanged() {
        boolean changed = false;
        String n = this.notebookBox.currentText();
        int i = 0;
        while (i < this.notebookList.size()) {
            if (n.equals(this.notebookList.get(i).getName())) {
                if (!this.notebookList.get(i).getGuid().equals(this.currentNote.getNotebookGuid())) {
                    String guid = this.conn.getNotebookTable().findNotebookByName(n);
                    if (this.conn.getNotebookTable().isLinked(guid)) {
                        this.tagEdit.setText("");
                        this.noteSignal.tagsChanged.emit((Object)this.currentNote.getGuid(), new ArrayList());
                        FilterEditorTags t = new FilterEditorTags(this.conn, this.logger);
                        this.setAllTags(t.getValidTags(this.currentNote));
                    }
                    this.currentNote.setNotebookGuid(this.notebookList.get(i).getGuid());
                    changed = true;
                }
                i = this.notebookList.size();
            }
            ++i;
        }
        if (changed) {
            this.noteSignal.notebookChanged.emit((Object)this.currentNote.getGuid(), (Object)this.currentNote.getNotebookGuid());
        }
    }

    private void checkNoteTitle() {
        int newLine;
        String text = this.browser.page().currentFrame().toPlainText();
        if (this.saveNoteTitle == null) {
            this.saveNoteTitle = new String();
        }
        text = text.trim();
        if (!this.saveNoteTitle.trim().equals("") && !this.saveNoteTitle.trim().equals("Untitled Note")) {
            text = this.saveNoteTitle.trim();
        }
        if ((newLine = text.indexOf("\n")) > 0) {
            text = text.substring(0, newLine);
        }
        if (this.saveNoteTitle.trim().equals("") || this.saveNoteTitle.trim().equals("Untitled Note")) {
            if (text.trim().equals("")) {
                text = this.tr("Untitled Note");
            }
            this.titleLabel.setText(text);
        } else if (text.length() > 255) {
            this.titleLabel.setText(text.substring(0, 255));
        } else {
            this.titleLabel.blockSignals(true);
            if (text.trim().equals("")) {
                this.titleLabel.setText(this.tr("Untitled Note"));
            } else {
                this.titleLabel.setText(text);
            }
            this.titleLabel.blockSignals(false);
        }
        if (this.currentNote != null && this.titleLabel != null && !this.currentNote.getTitle().equals(text)) {
            this.noteSignal.titleChanged.emit((Object)this.currentNote.getGuid(), (Object)text);
        }
    }

    public String getContentsToEmail() {
        return this.browser.page().currentFrame().toPlainText().trim();
    }

    private void insertImage(QMimeData mime) {
        this.logger.log(this.logger.EXTREME, "Entering insertImage");
        QImage img = (QImage)mime.imageData();
        String script_start = new String("document.execCommand('insertHTML', false, '");
        String script_end = new String("');");
        long now = new Date().getTime();
        String path = Global.getFileManager().getResDirPath(String.valueOf(new Long(now).toString()) + ".jpg");
        long i = new Date().getTime();
        while (now == i) {
            i = new Date().getTime();
        }
        QFile tfile = new QFile(path);
        tfile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}));
        if (!img.save((QIODevice)tfile)) {
            tfile.close();
            return;
        }
        tfile.close();
        Resource newRes = this.createResource(QUrl.fromLocalFile((String)path).toString(), 0, "image/jpeg", false);
        if (newRes == null) {
            return;
        }
        this.currentNote.getResources().add(newRes);
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("<img src=\"");
        buffer.append(tfile.fileName());
        buffer.append("\" en-tag=en-media type=\"image/jpeg\" hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\"" + " guid=\"" + newRes.getGuid() + "\"" + " onContextMenu=\"window.jambi.imageContextMenu(&amp." + tfile.fileName() + "&amp.);\"" + " />");
        this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + buffer + script_end);
    }

    private void handleNoteLink(QMimeData mime) {
        int i = 0;
        while (i < mime.urls().size()) {
            StringTokenizer tokens = new StringTokenizer(((QUrl)mime.urls().get(i)).toString().replace("evernote:///view/", ""), "/");
            tokens.nextToken();
            tokens.nextToken();
            String sid = tokens.nextToken();
            String lid = tokens.nextToken();
            if (!sid.equals(this.currentNote.getGuid()) && !lid.equals(this.currentNote.getGuid())) {
                Note note = this.conn.getNoteTable().getNote(sid, false, false, false, false, false);
                if (note == null) {
                    note = this.conn.getNoteTable().getNote(lid, false, false, false, false, false);
                }
                if (note == null) {
                    return;
                }
                StringBuffer url = new StringBuffer(100);
                String script_start = new String("document.execCommand('insertHtml', false, '");
                String script_end = new String("');");
                url.append("<a href=\"" + ((QUrl)mime.urls().get(i)).toString() + "\" style=\"color:#69aa35\">");
                url.append(note.getTitle());
                url.append("</a>");
                if (mime.urls().size() > 1) {
                    url.append("&nbsp;");
                }
                this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + url + script_end);
            }
            ++i;
        }
    }

    public void handleUrls(QMimeData mime) {
        this.logger.log(this.logger.EXTREME, "Starting handleUrls");
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        List urlList = mime.urls();
        String url = new String();
        String script_start = new String("document.execCommand('createLink', false, '");
        String script_end = new String("');");
        int i = 0;
        while (i < urlList.size()) {
            url = ((QUrl)urlList.get(i)).toString();
            String mimeType = fileNameMap.getContentTypeFor(url);
            if (mimeType == null) {
                mimeType = "application/" + url.substring(url.lastIndexOf(".") + 1);
            }
            if (url.substring(0, 5).equalsIgnoreCase("file:") && mimeType.substring(0, 5).equalsIgnoreCase("image")) {
                this.handleLocalImageURLPaste(mime, mimeType);
                return;
            }
            boolean smallEnough = this.checkFileAttachmentSize(url);
            if (smallEnough && url.substring(0, 5).equalsIgnoreCase("file:") && !mimeType.substring(0, 5).equalsIgnoreCase("image")) {
                this.handleLocalAttachment(mime, mimeType);
                return;
            }
            this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + url + script_end);
            ++i;
        }
    }

    private void handleLocalImageURLPaste(QMimeData mime, String mimeType) {
        List urlList = mime.urls();
        String url = new String();
        String script_start_image = new String("document.execCommand('insertHtml', false, '");
        String script_end = new String("');");
        int i = 0;
        while (i < urlList.size()) {
            url = ((QUrl)urlList.get(i)).toString();
            Resource newRes = this.createResource(url, i, mimeType, false);
            if (newRes == null) {
                return;
            }
            this.currentNote.getResources().add(newRes);
            StringBuffer buffer = new StringBuffer(100);
            String fileName = Global.getFileManager().getResDirPath(newRes.getGuid());
            QFile tfile = new QFile(fileName);
            tfile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly}));
            tfile.write(newRes.getData().getBody());
            tfile.close();
            buffer.append(script_start_image);
            buffer.append("<img src=\"" + FileUtils.toForwardSlashedPath(fileName));
            buffer.append("\" en-tag=\"en-media\" type=\"" + mimeType + "\"" + " hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\"" + " guid=\"" + newRes.getGuid() + "\"" + " onContextMenu=\"window.jambi.imageContextMenu(&apos;" + tfile.fileName() + "&apos;);\"" + " />");
            buffer.append(script_end);
            this.browser.page().mainFrame().evaluateJavaScript(buffer.toString());
            ++i;
        }
    }

    private void handleLocalAttachment(QMimeData mime, String mimeType) {
        this.logger.log(this.logger.EXTREME, "Attaching local file");
        List urlList = mime.urls();
        String script_start = new String("document.execCommand('insertHtml', false, '");
        String script_end = new String("');");
        String[] type = mimeType.split("/");
        String icon = this.findIcon(type[1]);
        if (icon.equals("attachment.png")) {
            icon = this.findIcon(type[0]);
        }
        StringBuffer buffer = new StringBuffer(100);
        int i = 0;
        while (i < urlList.size()) {
            String url = ((QUrl)urlList.get(i)).toString();
            if (icon.equals("attachment.png")) {
                icon = this.findIcon(url.substring(url.lastIndexOf(".") + 1));
            }
            String imageURL = FileUtils.toFileURLString(Global.getFileManager().getImageDirFile(icon));
            this.logger.log(this.logger.EXTREME, "Creating resource ");
            Resource newRes = this.createResource(url, i, mimeType, true);
            if (newRes == null) {
                return;
            }
            this.logger.log(this.logger.EXTREME, "New resource size: " + newRes.getData().getSize());
            this.currentNote.getResources().add(newRes);
            String fileName = String.valueOf(newRes.getGuid()) + Global.attachmentNameDelimeter + newRes.getAttributes().getFileName();
            if (icon.equalsIgnoreCase("pdf.png") && Global.pdfPreview()) {
                this.logger.log(this.logger.EXTREME, "Setting up PDF preview");
                fileName = newRes.getAttributes() != null && newRes.getAttributes().getFileName() != null && !newRes.getAttributes().getFileName().trim().equals("") ? String.valueOf(newRes.getGuid()) + Global.attachmentNameDelimeter + newRes.getAttributes().getFileName() : String.valueOf(newRes.getGuid()) + ".pdf";
                QFile file = new QFile(Global.getFileManager().getResDirPath(fileName));
                QIODevice.OpenMode mode = new QIODevice.OpenMode(new QIODevice.OpenModeFlag[0]);
                mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                file.open(mode);
                QDataStream out = new QDataStream((QIODevice)file);
                QByteArray binData = new QByteArray(newRes.getData().getBody());
                out.writeBytes(binData.toByteArray());
                file.close();
                PDFPreview pdfPreview = new PDFPreview();
                if (pdfPreview.setupPreview(Global.getFileManager().getResDirPath(fileName), "pdf", 0)) {
                    imageURL = String.valueOf(file.fileName()) + ".png";
                }
            }
            this.logger.log(this.logger.EXTREME, "Generating link tags");
            buffer.delete(0, buffer.length());
            buffer.append("<a en-tag=\"en-media\" guid=\"" + newRes.getGuid() + "\" ");
            buffer.append(" onContextMenu=\"window.jambi.imageContextMenu(&apos;").append(Global.getFileManager().getResDirPath(fileName)).append("&apos;);\" ");
            buffer.append("type=\"" + mimeType + "\" href=\"nnres://" + fileName + "\" hash=\"" + Global.byteArrayToHexString(newRes.getData().getBodyHash()) + "\" >");
            buffer.append("<img src=\"" + imageURL + "\" title=\"" + newRes.getAttributes().getFileName());
            buffer.append("\"></img>");
            buffer.append("</a>");
            this.browser.page().mainFrame().evaluateJavaScript(String.valueOf(script_start) + buffer.toString() + script_end);
            ++i;
        }
    }

    private Resource createResource(String url, int sequence, String mime, boolean attachment) {
        this.logger.log(this.logger.EXTREME, "Inside create resource");
        this.logger.log(this.logger.EXTREME, "File URL:" + url);
        String whichOS = System.getProperty("os.name");
        url = whichOS.contains("Windows") ? url.replace("file:///", "") : url.replace("file://", "");
        String urlTest = new QUrl(url).toLocalFile();
        this.logger.log(this.logger.EXTREME, "File URL toLocalFile():" + urlTest);
        urlTest = url;
        if (!urlTest.equals("")) {
            url = urlTest;
        }
        this.logger.log(this.logger.EXTREME, "Reading from file to create resource:" + url);
        QFile resourceFile = new QFile(url);
        resourceFile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}));
        this.logger.log(this.logger.EXTREME, "Error opening file " + url.toString() + ": " + resourceFile.errorString());
        byte[] fileData = resourceFile.readAll().toByteArray();
        resourceFile.close();
        this.logger.log(this.logger.EXTREME, "File Length: " + fileData.length);
        if (fileData.length == 0) {
            return null;
        }
        try {
            this.logger.log(this.logger.EXTREME, "Generating MD5");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(fileData);
            byte[] hash = md.digest();
            Resource r = new Resource();
            GregorianCalendar time = new GregorianCalendar();
            long prevTime = time.getTimeInMillis();
            while (prevTime == time.getTimeInMillis()) {
                time = new GregorianCalendar();
            }
            r.setGuid(String.valueOf(time.getTimeInMillis()) + new Integer(sequence).toString());
            r.setNoteGuid(this.currentNote.getGuid());
            r.setMime(mime);
            r.setActive(true);
            r.setUpdateSequenceNum(0);
            r.setWidth((short)0);
            r.setHeight((short)0);
            r.setDuration((short)0);
            Data d = new Data();
            d.setBody(fileData);
            d.setBodyIsSet(true);
            d.setBodyHash(hash);
            d.setBodyHashIsSet(true);
            r.setData(d);
            d.setSize(fileData.length);
            int fileNamePos = url.lastIndexOf(File.separator);
            if (fileNamePos == -1) {
                fileNamePos = url.lastIndexOf("/");
            }
            String fileName = url.substring(fileNamePos + 1);
            ResourceAttributes a = new ResourceAttributes();
            a.setAltitude(0.0);
            a.setAltitudeIsSet(false);
            a.setLongitude(0.0);
            a.setLongitudeIsSet(false);
            a.setLatitude(0.0);
            a.setLatitudeIsSet(false);
            a.setCameraMake("");
            a.setCameraMakeIsSet(false);
            a.setCameraModel("");
            a.setCameraModelIsSet(false);
            a.setAttachment(attachment);
            a.setAttachmentIsSet(true);
            a.setClientWillIndex(false);
            a.setClientWillIndexIsSet(true);
            a.setRecoType("");
            a.setRecoTypeIsSet(false);
            a.setSourceURL(url);
            a.setSourceURLIsSet(true);
            a.setTimestamp(0L);
            a.setTimestampIsSet(false);
            a.setFileName(fileName);
            a.setFileNameIsSet(true);
            r.setAttributes(a);
            this.conn.getNoteTable().noteResourceTable.saveNoteResource(r, true);
            this.logger.log(this.logger.EXTREME, "Resource created");
            return r;
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private String findIcon(String appl) {
        appl = appl.toLowerCase();
        File f = Global.getFileManager().getImageDirFile(String.valueOf(appl) + ".png");
        if (f.exists()) {
            return String.valueOf(appl) + ".png";
        }
        return "attachment.png";
    }

    private boolean checkFileAttachmentSize(String url) {
        String fileName = url.substring(8);
        QFile resourceFile = new QFile(fileName);
        resourceFile.open(new QIODevice.OpenMode(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly}));
        long size = resourceFile.size();
        resourceFile.close();
        size = size / 1024L / 1024L;
        if (size < 50L && Global.isPremium()) {
            return true;
        }
        if (size < 25L) {
            return true;
        }
        String error = this.tr("A file attachment may not exceed 25MB.");
        QMessageBox.information((QWidget)this, (String)this.tr("Attachment Size"), (String)error);
        return false;
    }

    private void createdChanged() {
        QDateTime dt = new QDateTime();
        dt.setDate(this.createdDate.date());
        dt.setTime(this.createdTime.time());
        this.noteSignal.createdDateChanged.emit((Object)this.currentNote.getGuid(), (Object)dt);
    }

    private void alteredChanged() {
        QDateTime dt = new QDateTime();
        dt.setDate(this.alteredDate.date());
        dt.setTime(this.alteredTime.time());
        this.noteSignal.alteredDateChanged.emit((Object)this.currentNote.getGuid(), (Object)dt);
    }

    private void subjectDateTimeChanged() {
        QDateTime dt = new QDateTime();
        dt.setDate(this.subjectDate.date());
        dt.setTime(this.subjectTime.time());
        this.noteSignal.subjectDateChanged.emit((Object)this.currentNote.getGuid(), (Object)dt);
    }

    private void sourceUrlChanged() {
        this.noteSignal.sourceUrlChanged.emit((Object)this.currentNote.getGuid(), (Object)this.urlText.text());
    }

    private void authorChanged() {
        this.noteSignal.authorChanged.emit((Object)this.currentNote.getGuid(), (Object)this.authorText.text());
    }

    private void geoBoxChanged() {
        int index = this.geoBox.currentIndex();
        this.geoBox.setCurrentIndex(0);
        if (index == 1) {
            GeoDialog box = new GeoDialog();
            box.setLongitude(this.currentNote.getAttributes().getLongitude());
            box.setLatitude(this.currentNote.getAttributes().getLatitude());
            box.setAltitude(this.currentNote.getAttributes().getAltitude());
            box.exec();
            if (!box.okPressed()) {
                return;
            }
            double alt = box.getAltitude();
            double lat = box.getLatitude();
            double lon = box.getLongitude();
            if (alt != this.currentNote.getAttributes().getAltitude() || lon != this.currentNote.getAttributes().getLongitude() || lat != this.currentNote.getAttributes().getLatitude()) {
                this.noteSignal.geoChanged.emit((Object)this.currentNote.getGuid(), (Object)lon, (Object)lat, (Object)alt);
                this.currentNote.getAttributes().setAltitude(alt);
                this.currentNote.getAttributes().setLongitude(lon);
                this.currentNote.getAttributes().setLatitude(lat);
            }
        }
        if (index == 2) {
            this.noteSignal.geoChanged.emit((Object)this.currentNote.getGuid(), (Object)0.0, (Object)0.0, (Object)0.0);
            this.currentNote.getAttributes().setAltitude(0.0);
            this.currentNote.getAttributes().setLongitude(0.0);
            this.currentNote.getAttributes().setLatitude(0.0);
        }
        if (index == 3 || index == 0) {
            QDesktopServices.openUrl((QUrl)new QUrl("http://maps.google.com/maps?z=6&q=" + this.currentNote.getAttributes().getLatitude() + "," + this.currentNote.getAttributes().getLongitude()));
        }
    }

    public void downloadAttachment(QNetworkRequest request) {
        String guid;
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.AnyFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Save File"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptSave);
        fd.setDirectory(System.getProperty("user.home"));
        String name = request.url().toString();
        int pos = name.lastIndexOf(Global.attachmentNameDelimeter);
        if (pos > -1) {
            guid = name.substring(0, pos).replace("nnres://", "");
            name = name.substring(pos + Global.attachmentNameDelimeter.length());
            fd.selectFile(name);
            pos = name.lastIndexOf(46);
            if (pos > -1) {
                String mimeType = "(*." + name.substring(pos + 1) + ");; All Files (*)";
                fd.setFilter(this.tr(mimeType));
            }
        } else {
            guid = name;
        }
        guid = guid.replace("nnres://", "").replace(FileUtils.toForwardSlashedPath(Global.getFileManager().getResDirPath()), "");
        pos = (guid = guid.replace("file://", "").replace("/", "").replace(FileUtils.toForwardSlashedPath(Global.getFileManager().getResDirPath()), "")).lastIndexOf(46);
        if (pos > 0) {
            guid = guid.substring(0, pos);
        }
        if (fd.exec() != 0 && fd.selectedFiles().size() > 0) {
            name = name.replace('\\', '/');
            Resource resBinary = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
            QFile saveFile = new QFile((String)fd.selectedFiles().get(0));
            QIODevice.OpenMode mode = new QIODevice.OpenMode(new QIODevice.OpenModeFlag[0]);
            mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
            saveFile.open(mode);
            QDataStream saveOut = new QDataStream((QIODevice)saveFile);
            QByteArray binData = new QByteArray(resBinary.getData().getBody());
            saveOut.writeBytes(binData.toByteArray());
            saveFile.close();
        }
    }

    public void downloadImage(QNetworkRequest request) {
        QFileDialog fd = new QFileDialog((QWidget)this);
        fd.setFileMode(QFileDialog.FileMode.AnyFile);
        fd.setConfirmOverwrite(true);
        fd.setWindowTitle(this.tr("Save File"));
        fd.setAcceptMode(QFileDialog.AcceptMode.AcceptSave);
        fd.setDirectory(System.getProperty("user.home"));
        String name = request.url().toString();
        name = name.replace("nnres://", "");
        String dPath = FileUtils.toForwardSlashedPath(Global.getFileManager().getResDirPath());
        name = name.replace(dPath, "");
        int pos = name.lastIndexOf(46);
        String guid = name;
        if (pos > -1) {
            String mimeType = "(*." + name.substring(pos + 1) + ");; All Files (*)";
            fd.setFilter(this.tr(mimeType));
            guid = guid.substring(0, pos);
        }
        if ((pos = name.lastIndexOf(Global.attachmentNameDelimeter)) > -1) {
            guid = name.substring(0, pos);
            fd.selectFile(name.substring(pos + Global.attachmentNameDelimeter.length()));
        }
        if (fd.exec() != 0 && fd.selectedFiles().size() > 0) {
            Resource resBinary = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
            String fileName = (String)fd.selectedFiles().get(0);
            QFile saveFile = new QFile(fileName);
            QIODevice.OpenMode mode = new QIODevice.OpenMode(new QIODevice.OpenModeFlag[0]);
            mode.set((QtEnumerator[])new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
            saveFile.open(mode);
            QDataStream saveOut = new QDataStream((QIODevice)saveFile);
            QByteArray binData = new QByteArray(resBinary.getData().getBody());
            saveOut.writeBytes(binData.toByteArray());
            saveFile.close();
        }
    }

    private void removeEncryption(String id, String plainText, boolean permanent, String slot) {
        String html;
        if (!permanent) {
            plainText = " <table class=\"en-crypt-temp\" slot=\"" + slot + "\"" + "border=1 width=100%><tbody><tr><td>" + plainText + "</td></tr></tbody></table>";
        }
        String text = html = this.browser.page().mainFrame().toHtml();
        int imagePos = html.indexOf("<img");
        while (imagePos > 0) {
            int endPos = text.indexOf(">", imagePos);
            String tag = text.substring(imagePos - 1, endPos);
            if (tag.indexOf("id=\"" + id + "\"") > -1) {
                text = String.valueOf(text.substring(0, imagePos)) + plainText + text.substring(endPos + 1);
                QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
                QByteArray unicode = codec.fromUnicode(text);
                this.setContent(unicode);
                if (permanent) {
                    this.contentChanged();
                }
            }
            imagePos = text.indexOf("<img", imagePos + 1);
        }
    }

    private void focusTitle() {
        this.titleLabel.setFocus();
    }

    private void focusTag() {
        this.tagEdit.setFocus();
    }

    private void focusNote() {
        this.browser.setFocus();
    }

    private void focusAuthor() {
        this.authorLabel.setFocus();
    }

    private void focusUrl() {
        this.urlLabel.setFocus();
    }

    public void setBackgroundColor(String color) {
        String js = "function changeBackground(color) {document.body.style.background = color;}changeBackground('" + color + "');";
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    private void microFocusChanged() {
        this.boldButton.setDown(false);
        this.italicButton.setDown(false);
        this.underlineButton.setDown(false);
        this.browser.openAction.setEnabled(false);
        this.browser.downloadAttachment.setEnabled(false);
        this.browser.downloadImage.setEnabled(false);
        this.browser.rotateImageLeft.setEnabled(false);
        this.browser.rotateImageRight.setEnabled(false);
        this.browser.insertTableAction.setEnabled(true);
        this.browser.deleteTableColumnAction.setEnabled(false);
        this.browser.insertTableRowAction.setEnabled(false);
        this.browser.insertTableColumnAction.setEnabled(false);
        this.browser.deleteTableRowAction.setEnabled(false);
        this.browser.insertLinkAction.setText(this.tr("Insert Hyperlink"));
        this.insertHyperlink = true;
        this.browser.insertQuickLinkAction.setEnabled(true);
        this.currentHyperlink = "";
        this.insideList = false;
        this.insideTable = false;
        this.insideEncryption = false;
        this.forceTextPaste = false;
        String js = new String("function getCursorPos() {var cursorPos;if (window.getSelection) {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   while(workingNode != null) {       if (workingNode.nodeName=='TABLE') { if (workingNode.getAttribute('class').toLowerCase() == 'en-crypt-temp') window.jambi.insideEncryption(); }      if (workingNode.nodeName=='B') window.jambi.boldActive();      if (workingNode.nodeName=='I') window.jambi.italicActive();      if (workingNode.nodeName=='U') window.jambi.underlineActive();      if (workingNode.nodeName=='UL') window.jambi.setInsideList();      if (workingNode.nodeName=='OL') window.jambi.setInsideList();      if (workingNode.nodeName=='LI') window.jambi.setInsideList();      if (workingNode.nodeName=='TBODY') window.jambi.setInsideTable();      if (workingNode.nodeName=='A') {for(var x = 0; x < workingNode.attributes.length; x++ ) {if (workingNode.attributes[x].nodeName.toLowerCase() == 'href') window.jambi.setInsideLink(workingNode.attributes[x].nodeValue);}}      if (workingNode.nodeName=='SPAN') {         if (workingNode.getAttribute('style') == 'text-decoration: underline;') window.jambi.underlineActive();      }      workingNode = workingNode.parentNode;   }}} getCursorPos();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
    }

    public void printNode(String n) {
        System.out.println("Node Vaule: " + n);
    }

    public void insideEncryption() {
        this.insideEncryption = true;
        this.forceTextPaste();
    }

    public void insertTableRow() {
        String js = new String("function insertTableRow() {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   var cellCount = 0;   while(workingNode != null) {       if (workingNode.nodeName.toLowerCase()=='tr') {           row = document.createElement('TR');           var nodes = workingNode.getElementsByTagName('td');           for (j=0; j<nodes.length; j=j+1) {              cell = document.createElement('TD');              cell.innerHTML='&nbsp;';              row.appendChild(cell);           }           workingNode.parentNode.insertBefore(row,workingNode.nextSibling);           return;      }      workingNode = workingNode.parentNode;   }} insertTableRow();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    public void insertTableColumn() {
        String js = new String("function insertTableColumn() {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   var current = 0;   while (workingNode.nodeName.toLowerCase() != 'table' && workingNode != null) {       if (workingNode.nodeName.toLowerCase() == 'td') {          var td = workingNode;          while (td.previousSibling != null) {              current = current+1; td = td.previousSibling;          }       }       workingNode = workingNode.parentNode;    }   if (workingNode == null) return;   for (var i=0; i<workingNode.rows.length; i++) {       var cell = workingNode.rows[i].insertCell(current+1);       cell.innerHTML = '&nbsp';    }} insertTableColumn();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    public void deleteTableRow() {
        String js = new String("function deleteTableRow() {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   var cellCount = 0;   while(workingNode != null) {       if (workingNode.nodeName.toLowerCase()=='tr') {           workingNode.parentNode.removeChild(workingNode);           return;      }      workingNode = workingNode.parentNode;   }} deleteTableRow();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    public void deleteTableColumn() {
        String js = new String("function deleteTableColumn() {   var selObj = window.getSelection();   var selRange = selObj.getRangeAt(0);   var workingNode = window.getSelection().anchorNode.parentNode;   var current = 0;   while (workingNode.nodeName.toLowerCase() != 'table' && workingNode != null) {       if (workingNode.nodeName.toLowerCase() == 'td') {          var td = workingNode;          while (td.previousSibling != null) {              current = current+1; td = td.previousSibling;          }       }       workingNode = workingNode.parentNode;    }   if (workingNode == null) return;   for (var i=0; i<workingNode.rows.length; i++) {       workingNode.rows[i].deleteCell(current);    }} deleteTableColumn();");
        this.browser.page().mainFrame().evaluateJavaScript(js);
        this.contentChanged();
    }

    public void setInsideTable() {
        this.browser.insertTableRowAction.setEnabled(true);
        this.browser.insertTableColumnAction.setEnabled(true);
        this.browser.deleteTableRowAction.setEnabled(true);
        this.browser.deleteTableColumnAction.setEnabled(true);
        this.browser.insertTableAction.setEnabled(false);
        this.browser.encryptAction.setEnabled(false);
        this.insideTable = true;
    }

    public void setInsideLink(String link) {
        this.browser.insertLinkAction.setText(this.tr("Edit Hyperlink"));
        this.currentHyperlink = link;
        this.insertHyperlink = false;
    }

    public void italicActive() {
        this.italicButton.setDown(true);
    }

    public void boldActive() {
        this.boldButton.setDown(true);
    }

    public void underlineActive() {
        this.underlineButton.setDown(true);
    }

    public void forceTextPaste() {
        this.forceTextPaste = true;
    }

    public void imageContextMenu(String f) {
        this.browser.downloadImage.setEnabled(true);
        this.browser.rotateImageRight.setEnabled(true);
        this.browser.rotateImageLeft.setEnabled(true);
        this.browser.openAction.setEnabled(true);
        this.selectedFile = f;
    }

    public void rotateImageRight() {
        QWebSettings.setMaximumPagesInCache((int)0);
        QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
        QImage image = new QImage(this.selectedFile);
        QMatrix matrix = new QMatrix();
        matrix.rotate(90.0);
        image = image.transformed(matrix);
        image.save(this.selectedFile);
        QWebSettings.setMaximumPagesInCache((int)0);
        QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
        this.browser.setHtml(this.browser.page().mainFrame().toHtml());
        this.browser.reload();
        this.contentChanged();
        this.resourceSignal.contentChanged.emit((Object)this.selectedFile);
    }

    public void rotateImageLeft() {
        QImage image = new QImage(this.selectedFile);
        QMatrix matrix = new QMatrix();
        matrix.rotate(-90.0);
        image = image.transformed(matrix);
        image.save(this.selectedFile);
        this.browser.setHtml(this.browser.page().mainFrame().toHtml());
        this.browser.reload();
        this.contentChanged();
        this.resourceSignal.contentChanged.emit((Object)this.selectedFile);
    }

    public void resourceContextMenu(String f) {
        this.browser.downloadAttachment.setEnabled(true);
        this.browser.openAction.setEnabled(true);
        this.selectedFile = f;
    }

    public void latexContextMenu(String f) {
        this.browser.downloadImage.setEnabled(true);
        this.browser.rotateImageRight.setEnabled(true);
        this.browser.rotateImageLeft.setEnabled(true);
        this.browser.openAction.setEnabled(true);
        this.selectedFile = f;
    }

    private String fixInternotePaste(String text) {
        this.logger.log(this.logger.EXTREME, "Fixing internote paste");
        String returnValue = this.fixInternotePasteSearch(text, "<img", "src=\"");
        return this.fixInternotePasteSearch(returnValue, "<a", "href=\"nnres://");
    }

    private String fixInternotePasteSearch(String text, String type, String locTag) {
        int startPos = text.indexOf(type);
        while (startPos >= 0) {
            int endPos = text.indexOf(">", startPos + 1);
            String segment = text.substring(startPos, endPos);
            if (segment.indexOf("en-tag") > -1) {
                String source;
                String newSegment = segment;
                int guidStartPos = segment.indexOf("guid=\"");
                int guidEndPos = segment.indexOf("\"", guidStartPos + 7);
                String guid = segment.substring(guidStartPos + 6, guidEndPos);
                int mimeStartPos = segment.indexOf("type");
                int mimeEndPos = segment.indexOf("\"", mimeStartPos + 7);
                String mime = segment.substring(mimeStartPos + 6, mimeEndPos);
                int srcStartPos = segment.indexOf("src");
                int srcEndPos = segment.indexOf("\"", srcStartPos + 6);
                String src = segment.substring(srcStartPos + 5, srcEndPos);
                GregorianCalendar currentTime = new GregorianCalendar();
                Long l = new Long(currentTime.getTimeInMillis());
                long prevTime = l;
                while (l == prevTime) {
                    currentTime = new GregorianCalendar();
                    l = new Long(currentTime.getTimeInMillis());
                }
                Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, true);
                if (r == null && (r = this.createResource(src, 1, mime, false)) == null) {
                    return "";
                }
                String randint = new String(Long.toString(l));
                String extension = null;
                if (r.getMime() != null && (extension = r.getMime().toLowerCase()).indexOf("/") > -1) {
                    extension = extension.substring(extension.indexOf("/") + 1);
                }
                String newFile = randint;
                if (r.getAttributes().getFileName() != null && r.getAttributes().getFileName() != "" && !locTag.startsWith("src")) {
                    newFile = String.valueOf(newFile) + Global.attachmentNameDelimeter + r.getAttributes().getFileName();
                }
                r.setNoteGuid(this.currentNote.getGuid());
                r.setGuid(randint);
                this.conn.getNoteTable().noteResourceTable.saveNoteResource(r, true);
                QFile f = new QFile(Global.getFileManager().getResDirPath(newFile));
                QByteArray bin = new QByteArray(r.getData().getBody());
                f.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly});
                f.write(bin);
                f.close();
                newSegment = newSegment.replace("guid=\"" + guid, "guid=\"" + randint);
                this.currentNote.getResources().add(r);
                int startSrcPos = newSegment.indexOf(locTag);
                int endSrcPos = newSegment.indexOf("\"", startSrcPos + locTag.length() + 1);
                if (locTag.startsWith("src")) {
                    source = newSegment.substring(startSrcPos + locTag.length(), endSrcPos);
                    newSegment = newSegment.replace(source, FileUtils.toForwardSlashedPath(Global.getFileManager().getResDirPath(newFile)));
                } else {
                    source = newSegment.substring(startSrcPos + locTag.length(), endSrcPos);
                    newSegment = newSegment.replace(source, newFile);
                }
                text = String.valueOf(text.substring(0, startPos)) + newSegment + text.substring(endPos);
            }
            startPos = text.indexOf(type, startPos + 1);
        }
        return text;
    }

    public void nextPage(String file) {
        this.logger.log(this.logger.EXTREME, "Starting nextPage()");
        Integer pageNumber = this.previewPageList.containsKey(file) ? Integer.valueOf(this.previewPageList.get(file) + 1) : Integer.valueOf(2);
        this.previewPageList.remove(file);
        this.previewPageList.put(file, pageNumber);
        PDFPreview pdfPreview = new PDFPreview();
        boolean goodPreview = pdfPreview.setupPreview(file, "pdf", pageNumber);
        if (goodPreview) {
            QWebSettings.setMaximumPagesInCache((int)0);
            QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
            this.browser.setHtml(this.browser.page().mainFrame().toHtml());
            this.browser.reload();
        }
    }

    public void previousPage(String file) {
        this.logger.log(this.logger.EXTREME, "Starting previousPage()");
        Integer pageNumber = this.previewPageList.containsKey(file) ? Integer.valueOf(this.previewPageList.get(file) - 1) : Integer.valueOf(1);
        this.previewPageList.remove(file);
        this.previewPageList.put(file, pageNumber);
        PDFPreview pdfPreview = new PDFPreview();
        boolean goodPreview = pdfPreview.setupPreview(file, "pdf", pageNumber);
        if (goodPreview) {
            QWebSettings.setMaximumPagesInCache((int)0);
            QWebSettings.setObjectCacheCapacities((int)0, (int)0, (int)0);
            this.browser.setHtml(this.browser.page().mainFrame().toHtml());
            this.browser.reload();
        }
    }

    private void toggleUndoVisible(Boolean toggle) {
        this.undoAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("undo", toggle);
    }

    private void toggleRedoVisible(Boolean toggle) {
        this.redoAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("redo", toggle);
    }

    private void toggleCutVisible(Boolean toggle) {
        this.cutAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("cut", toggle);
    }

    private void toggleCopyVisible(Boolean toggle) {
        this.copyAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("copy", toggle);
    }

    private void togglePasteVisible(Boolean toggle) {
        this.pasteAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("paste", toggle);
    }

    private void toggleBoldVisible(Boolean toggle) {
        this.boldAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("bold", toggle);
    }

    private void toggleItalicVisible(Boolean toggle) {
        this.italicAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("italic", toggle);
    }

    private void toggleUnderlineVisible(Boolean toggle) {
        this.underlineAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("underline", toggle);
    }

    private void toggleStrikethroughVisible(Boolean toggle) {
        this.strikethroughAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("strikethrough", toggle);
    }

    private void toggleLeftAlignVisible(Boolean toggle) {
        this.leftAlignAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("alignLeft", toggle);
    }

    private void toggleRightAlignVisible(Boolean toggle) {
        this.rightAlignAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("alignRight", toggle);
    }

    private void toggleCenterAlignVisible(Boolean toggle) {
        this.centerAlignAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("alignCenter", toggle);
    }

    private void toggleHLineVisible(Boolean toggle) {
        this.hlineAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("hline", toggle);
    }

    private void toggleIndentVisible(Boolean toggle) {
        this.indentAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("indent", toggle);
    }

    private void toggleTodoVisible(Boolean toggle) {
        this.todoAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("todo", toggle);
    }

    private void toggleOutdentVisible(Boolean toggle) {
        this.outdentAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("outdent", toggle);
    }

    private void toggleBulletListVisible(Boolean toggle) {
        this.bulletListAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("bulletList", toggle);
    }

    private void toggleNumberListVisible(Boolean toggle) {
        this.numberListAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("numberList", toggle);
    }

    private void toggleFontListVisible(Boolean toggle) {
        this.fontListAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("font", toggle);
    }

    private void toggleFontColorVisible(Boolean toggle) {
        this.fontColorAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("fontColor", toggle);
    }

    private void toggleFontSizeVisible(Boolean toggle) {
        this.fontSizeAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("fontSize", toggle);
    }

    private void toggleFontHilightVisible(Boolean toggle) {
        this.fontHilightAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("fontHilight", toggle);
    }

    private void toggleSpellCheckVisible(Boolean toggle) {
        this.spellCheckAction.setVisible(toggle.booleanValue());
        Global.saveEditorButtonsVisible("spellCheck", toggle);
    }

    private void setupDictionary() {
        File wordList = new File(String.valueOf(Global.getFileManager().getSpellDirPath()) + Locale.getDefault() + ".dic");
        try {
            this.dictionary = new SpellDictionaryHashMap(wordList);
            this.spellChecker = new SpellChecker(this.dictionary);
            File userWordList = new File(String.valueOf(Global.getFileManager().getSpellDirPathUser()) + "user.dic");
            try {
                this.userDictionary = new SpellDictionaryHashMap(userWordList);
            }
            catch (FileNotFoundException e) {
                userWordList.createNewFile();
                this.userDictionary = new SpellDictionaryHashMap(userWordList);
            }
            catch (IOException e) {
                userWordList.createNewFile();
                this.userDictionary = new SpellDictionaryHashMap(userWordList);
            }
            this.spellListener = new SuggestionListener(this, this.spellChecker);
            this.spellChecker.addSpellCheckListener((SpellCheckListener)this.spellListener);
            this.spellChecker.setUserDictionary(this.userDictionary);
        }
        catch (FileNotFoundException e) {
            QMessageBox.critical((QWidget)this, (String)this.tr("Spell Check Error"), (String)(String.valueOf(this.tr("Dictionary ")) + Global.getFileManager().getSpellDirPath() + Locale.getDefault() + this.tr(".dic was not found.")));
        }
        catch (IOException e) {
            QMessageBox.critical((QWidget)this, (String)this.tr("Spell Check Error"), (String)(String.valueOf(this.tr("Dictionary ")) + Global.getFileManager().getSpellDirPath() + Locale.getDefault() + this.tr(".dic is invalid.")));
        }
    }

    private void spellCheckClicked() {
        if (this.spellChecker == null) {
            this.setupDictionary();
        }
        this.spellChecker.getConfiguration().setBoolean("SPELL_IGNOREDIGITWORDS", Global.getSpellSetting("SPELL_IGNOREDIGITWORDS"));
        this.spellChecker.getConfiguration().setBoolean("SPELL_IGNOREINTERNETADDRESS", Global.getSpellSetting("SPELL_IGNOREINTERNETADDRESS"));
        this.spellChecker.getConfiguration().setBoolean("SPELL_IGNOREMIXEDCASE", Global.getSpellSetting("SPELL_IGNOREMIXEDCASE"));
        this.spellChecker.getConfiguration().setBoolean("SPELL_IGNOREUPPERCASE", Global.getSpellSetting("SPELL_IGNOREUPPERCASE"));
        this.spellChecker.getConfiguration().setBoolean("SPELL_IGNORESENTENCECAPTILIZATION", Global.getSpellSetting("SPELL_IGNORESENTENCECAPTILIZATION"));
        this.spellListener.abortSpellCheck = false;
        this.spellListener.errorsFound = false;
        String content = this.getBrowser().page().mainFrame().toPlainText();
        StringWordTokenizer tokenizer = new StringWordTokenizer(content);
        if (!tokenizer.hasMoreWords()) {
            return;
        }
        this.getBrowser().page().action(QWebPage.WebAction.MoveToStartOfDocument);
        this.getBrowser().setFocus();
        Qt.KeyboardModifiers ctrl = new Qt.KeyboardModifiers(Qt.KeyboardModifier.ControlModifier.value());
        QKeyEvent home = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_Home.value(), ctrl);
        this.browser.keyPressEvent(home);
        this.getBrowser().setFocus();
        tokenizer = new StringWordTokenizer(content);
        while (tokenizer.hasMoreWords()) {
            String word = tokenizer.nextWord();
            boolean found = this.getBrowser().page().findText(word);
            if (!found || this.spellListener.abortSpellCheck) continue;
            this.spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(word));
            this.getBrowser().setFocus();
        }
        home = new QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_End.value(), ctrl);
        this.browser.keyPressEvent(home);
        if (!this.spellListener.errorsFound) {
            QMessageBox.information((QWidget)this, (String)this.tr("Spell Check Complete"), (String)this.tr("No Errors Found"));
        }
    }

    private void sourceEdited() {
        QTextCodec codec = QTextCodec.codecForLocale();
        codec = QTextCodec.codecForName((String)"UTF-8");
        String content = codec.fromUnicode(this.sourceEdit.toHtml()).toString();
        content = StringEscapeUtils.unescapeHtml4((String)this.removeTags(content));
        QByteArray data = new QByteArray(String.valueOf(this.sourceEditHeader) + content + "</body></html>");
        this.getBrowser().setContent(data);
        this.checkNoteTitle();
        if (this.currentNote != null && this.sourceEdit != null) {
            this.noteSignal.noteChanged.emit((Object)this.currentNote.getGuid(), (Object)this.sourceEdit.toPlainText());
        }
    }

    private void setSource() {
        String text = this.getContent();
        this.sourceEdit.blockSignals(true);
        int body = text.indexOf("<body");
        if (body > 0 && (body = text.indexOf(">", body)) > 0) {
            this.sourceEditHeader = text.substring(0, body + 1);
            text = text.substring(body + 1);
        }
        text = text.replace("</body></html>", "");
        this.sourceEdit.setPlainText(text);
        this.sourceEdit.setReadOnly(!this.getBrowser().page().isContentEditable());
        this.sourceEdit.blockSignals(false);
    }

    public void showSource(boolean value) {
        this.setSource();
        this.sourceEdit.setVisible(value);
    }

    private String removeTags(String text) {
        StringBuffer buffer = new StringBuffer(text);
        boolean inTag = false;
        int bodyPosition = text.indexOf("<body");
        int i = buffer.length() - 1;
        while (i >= 0) {
            if (buffer.charAt(i) == '>') {
                inTag = true;
            }
            if (buffer.charAt(i) == '<') {
                inTag = false;
            }
            if (inTag || buffer.charAt(i) == '<' || i < bodyPosition) {
                buffer.deleteCharAt(i);
            }
            --i;
        }
        return buffer.toString();
    }

    public static class SuggestionListener
    implements SpellCheckListener {
        public boolean abortSpellCheck = false;
        public boolean errorsFound = false;
        private final SpellCheck spellCheckDialog;
        private final BrowserWindow parent;

        public SuggestionListener(BrowserWindow parent, SpellChecker checker) {
            this.parent = parent;
            this.spellCheckDialog = new SpellCheck(checker);
        }

        public void spellingError(SpellCheckEvent event) {
            this.errorsFound = true;
            this.spellCheckDialog.setWord(event.getInvalidWord());
            List suggestions = event.getSuggestions();
            this.spellCheckDialog.clearSuggestions();
            if (!suggestions.isEmpty()) {
                int i = 0;
                while (i < suggestions.size()) {
                    this.spellCheckDialog.addSuggestion(((Word)suggestions.get(i)).getWord());
                    ++i;
                }
                this.spellCheckDialog.setSelectedSuggestion(0);
            }
            this.spellCheckDialog.exec();
            if (this.spellCheckDialog.cancelPressed()) {
                this.abortSpellCheck = true;
                event.cancel();
                return;
            }
            if (this.spellCheckDialog.replacePressed()) {
                QClipboard clipboard = QApplication.clipboard();
                clipboard.setText(this.spellCheckDialog.getReplacementWord());
                this.parent.pasteClicked();
            }
            event.cancel();
        }
    }
}

