/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.filters;

import com.trolltech.qt.core.QCoreApplication;
import cx.fbn.nevernote.filters.ContainsAttributeFilter;
import cx.fbn.nevernote.filters.ContainsAttributeFilterAttachment;
import cx.fbn.nevernote.filters.ContainsAttributeFilterContent;
import cx.fbn.nevernote.filters.ContainsAttributeFilterMime;
import cx.fbn.nevernote.filters.ContainsAttributeFilterTodo;

public class ContainsAttributeFilterFactory {
    private ContainsAttributeFilterFactory() {
    }

    public static ContainsAttributeFilter create(Contains fType) {
        switch (fType) {
            case Images: {
                return new ContainsAttributeFilterMime(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Images"), "image/");
            }
            case Audio: {
                return new ContainsAttributeFilterMime(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Audio"), "audio/");
            }
            case Ink: {
                return new ContainsAttributeFilterMime(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Ink"), "application/vnd.evernote.ink");
            }
            case EncryptedText: {
                return new ContainsAttributeFilterContent(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Encrypted Text"), "<en-crypt");
            }
            case Todo: {
                return new ContainsAttributeFilterContent(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"ToDo Items"), "<en-todo");
            }
            case UnfinishedTodo: {
                return new ContainsAttributeFilterTodo(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Unfinished to-do items"), false);
            }
            case FinishedTodo: {
                return new ContainsAttributeFilterTodo(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Finished to-do items"), true);
            }
            case Attachment: {
                return new ContainsAttributeFilterAttachment(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"Attachment"));
            }
            case PDF: {
                return new ContainsAttributeFilterMime(QCoreApplication.translate((String)"cx.fbn.nevernote.filters.ContainsAttributeFilter", (String)"PDF"), "application/pdf");
            }
        }
        throw new IllegalArgumentException("The filter type " + (Object)((Object)fType) + " is not recognized.");
    }

    public static enum Contains {
        Images,
        Audio,
        Ink,
        EncryptedText,
        Todo,
        UnfinishedTodo,
        FinishedTodo,
        Attachment,
        PDF;

    }
}

