/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.clipboard.ClipBoardObserver;
import cx.fbn.nevernote.gui.BrowserWindow;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.xml.NoteFormatter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class OnlineNoteHistory
extends QDialog {
    public final QPushButton restoreAsNew;
    public final QPushButton restore;
    private final DatabaseConnection conn;
    public final QComboBox historyCombo;
    private final BrowserWindow browser;
    private final ApplicationLogger logger;
    List<QTemporaryFile> tempFiles;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
    private final ClipBoardObserver cbObserver;

    public OnlineNoteHistory(ApplicationLogger l, DatabaseConnection c, ClipBoardObserver cbObserver) {
        this.setWindowTitle(this.tr("Online Note History"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "notebook-green.png"));
        QVBoxLayout main = new QVBoxLayout();
        this.setLayout((QLayout)main);
        this.historyCombo = new QComboBox((QWidget)this);
        QHBoxLayout comboLayout = new QHBoxLayout();
        comboLayout.addWidget((QWidget)new QLabel(this.tr("History Date:")));
        comboLayout.addWidget((QWidget)this.historyCombo);
        comboLayout.addStretch(100);
        main.addLayout((QLayout)comboLayout);
        this.conn = c;
        this.cbObserver = cbObserver;
        this.browser = new BrowserWindow(this.conn, this.cbObserver);
        main.addWidget((QWidget)this.browser);
        this.browser.titleLabel.setVisible(false);
        this.browser.notebookBox.setVisible(false);
        this.browser.hideButtons();
        this.browser.tagEdit.setVisible(false);
        this.browser.tagLabel.setVisible(false);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(100);
        this.restore = new QPushButton(this.tr("Restore Note"));
        this.restore.clicked.connect((Object)this, "restorePushed()");
        this.restoreAsNew = new QPushButton(this.tr("Restore As New Note"));
        this.restoreAsNew.clicked.connect((Object)this, "restoreAsNewPushed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelPressed()");
        buttonLayout.addWidget((QWidget)this.restore);
        buttonLayout.addWidget((QWidget)this.restoreAsNew);
        buttonLayout.addWidget((QWidget)cancel);
        main.addLayout((QLayout)buttonLayout);
        this.browser.getBrowser().setContextMenuPolicy(Qt.ContextMenuPolicy.NoContextMenu);
        this.tempFiles = new ArrayList<QTemporaryFile>();
        this.logger = l;
    }

    private void restoreAsNewPushed() {
        this.close();
    }

    private void restorePushed() {
        this.close();
    }

    private void cancelPressed() {
        this.close();
    }

    public void setCurrent(boolean isDirty) {
        if (isDirty) {
            this.historyCombo.addItem(new String(this.tr("Current (Non Synchronized)")));
        } else {
            this.historyCombo.addItem(new String(this.tr("Current (Synchronized)")));
        }
    }

    public void load(List<NoteVersionId> versions) {
        String fmt = String.valueOf(Global.getDateFormat()) + " " + Global.getTimeFormat();
        String dateTimeFormat = new String(fmt);
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        int i = 0;
        while (i < versions.size()) {
            StringBuilder versionDate = new StringBuilder(simple.format(versions.get(i).getSaved()));
            this.historyCombo.addItem(versionDate.toString());
            ++i;
        }
    }

    public void setContent(Note currentNote) {
        NoteFormatter formatter = new NoteFormatter(this.logger, this.conn, this.tempFiles);
        formatter.setNote(currentNote, false);
        formatter.setHighlight(null);
        formatter.setNoteHistory(true);
        StringBuffer js = new StringBuffer();
        js.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        js.append("<style type=\"text/css\">en-crypt-temp { border-style:solid; border-color:blue; padding:1mm 1mm 1mm 1mm; }</style>");
        js.append("</head>");
        js.append(formatter.rebuildNoteHTML());
        js.append("</HTML>");
        this.browser.setNote(currentNote);
        this.browser.getBrowser().page().mainFrame().setHtml(js.toString());
    }
}

