/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;

public class InsertLinkDialog
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit url;
    private final QPushButton ok;
    private String urlText;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
    private final boolean insertHyperlink;

    public InsertLinkDialog(boolean insert) {
        this.setWindowTitle(this.tr("Insert Link"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "link.png"));
        QGridLayout grid = new QGridLayout();
        QGridLayout input = new QGridLayout();
        QGridLayout button = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.insertHyperlink = insert;
        this.url = new QLineEdit("");
        input.addWidget((QWidget)new QLabel(this.tr("Url")), 1, 1);
        input.addWidget((QWidget)this.url, 1, 2);
        input.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)input, 1, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "accept()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "reject()");
        button.addWidget((QWidget)this.ok, 1, 1);
        button.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)button, 3, 1);
        this.url.textChanged.connect((Object)this, "validateInput()");
        this.setAttribute(Qt.WidgetAttribute.WA_DeleteOnClose);
    }

    public String getUrl() {
        if (this.urlText.indexOf("://") > 0) {
            return this.urlText;
        }
        return "http://" + this.urlText;
    }

    public void setUrl(String u) {
        this.url.setText(u);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void validateInput() {
        this.ok.setEnabled(true);
        if (this.url.text().trim().equals("") && this.insertHyperlink) {
            this.ok.setEnabled(false);
        }
    }

    public void accept() {
        if (this.ok.isEnabled()) {
            this.okPressed = true;
            this.urlText = this.url.text();
            super.accept();
        }
    }

    public void reject() {
        this.okPressed = false;
        super.reject();
    }
}

