/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.ExcludedTable;
import cx.fbn.nevernote.sql.HistoryTable;
import cx.fbn.nevernote.sql.InkImagesTable;
import cx.fbn.nevernote.sql.InvalidXMLTable;
import cx.fbn.nevernote.sql.LinkedNotebookTable;
import cx.fbn.nevernote.sql.NoteTable;
import cx.fbn.nevernote.sql.NotebookTable;
import cx.fbn.nevernote.sql.SavedSearchTable;
import cx.fbn.nevernote.sql.SharedNotebookTable;
import cx.fbn.nevernote.sql.StaredTable;
import cx.fbn.nevernote.sql.SyncTable;
import cx.fbn.nevernote.sql.SystemIconTable;
import cx.fbn.nevernote.sql.TagTable;
import cx.fbn.nevernote.sql.WatchFolderTable;
import cx.fbn.nevernote.sql.WordsTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseConnection {
    private WordsTable wordsTable;
    private TagTable tagTable;
    private NotebookTable notebookTable;
    private NoteTable noteTable;
    private DeletedTable deletedTable;
    private SavedSearchTable searchTable;
    private WatchFolderTable watchFolderTable;
    private InvalidXMLTable invalidXMLTable;
    private LinkedNotebookTable linkedNotebookTable;
    private SharedNotebookTable sharedNotebookTable;
    private InkImagesTable inkImagesTable;
    private SyncTable syncTable;
    private SystemIconTable systemIconTable;
    private HistoryTable historyTable;
    private ExcludedTable excludedTable;
    private StaredTable staredTable;
    private final ApplicationLogger logger;
    private Connection conn;
    private Connection indexConn;
    private Connection resourceConn;
    private Connection behaviorConn;
    int throttle;
    int id;

    public DatabaseConnection(ApplicationLogger l, String url, String iurl, String rurl, String burl, String userid, String password, String cypherPassword, int throttle) {
        this.logger = l;
        this.throttle = throttle;
        this.dbSetup(url, iurl, rurl, burl, userid, password, cypherPassword);
    }

    private void setupTables() {
        this.tagTable = new TagTable(this.logger, this);
        this.notebookTable = new NotebookTable(this.logger, this);
        this.noteTable = new NoteTable(this.logger, this);
        this.deletedTable = new DeletedTable(this.logger, this);
        this.searchTable = new SavedSearchTable(this.logger, this);
        this.watchFolderTable = new WatchFolderTable(this.logger, this);
        this.invalidXMLTable = new InvalidXMLTable(this.logger, this);
        this.wordsTable = new WordsTable(this.logger, this);
        this.syncTable = new SyncTable(this.logger, this);
        this.linkedNotebookTable = new LinkedNotebookTable(this.logger, this);
        this.sharedNotebookTable = new SharedNotebookTable(this.logger, this);
        this.systemIconTable = new SystemIconTable(this.logger, this);
        this.inkImagesTable = new InkImagesTable(this.logger, this);
        this.historyTable = new HistoryTable(this.logger, this);
        this.excludedTable = new ExcludedTable(this.logger, this);
        this.staredTable = new StaredTable(this.logger, this);
    }

    public void compactDatabase() {
    }

    public void dbSetup(String url, String indexUrl, String resourceUrl, String behaviorUrl, String userid, String userPassword, String cypherPassword) {
        this.logger.log(this.logger.HIGH, "Entering DatabaseConnection.dbSetup " + this.id);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            System.exit(16);
        }
        this.setupTables();
        File f = Global.getFileManager().getDbDirFile(String.valueOf(Global.databaseName) + ".h2.db");
        boolean dbExists = f.exists();
        f = Global.getFileManager().getDbDirFile(String.valueOf(Global.indexDatabaseName) + ".h2.db");
        boolean indexDbExists = f.exists();
        f = Global.getFileManager().getDbDirFile(String.valueOf(Global.resourceDatabaseName) + ".h2.db");
        boolean resourceDbExists = f.exists();
        f = Global.getFileManager().getDbDirFile(String.valueOf(Global.behaviorDatabaseName) + ".h2.db");
        boolean behaviorDbExists = f.exists();
        this.logger.log(this.logger.HIGH, "Entering RDatabaseConnection.dbSetup");
        String passwordString = null;
        try {
            passwordString = cypherPassword == null || cypherPassword.trim().equals("") ? userPassword : String.valueOf(cypherPassword) + " " + userPassword;
            this.conn = this.throttle == 0 ? DriverManager.getConnection(String.valueOf(url) + ";CACHE_SIZE=" + Global.databaseCache, userid, passwordString) : DriverManager.getConnection(String.valueOf(url) + ";THROTTLE=" + new Integer(this.throttle).toString() + ";CACHE_SIZE=" + Global.databaseCache, userid, passwordString);
            this.indexConn = DriverManager.getConnection(indexUrl, userid, passwordString);
            this.resourceConn = DriverManager.getConnection(resourceUrl, userid, passwordString);
            this.behaviorConn = DriverManager.getConnection(behaviorUrl, userid, passwordString);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        if (!dbExists) {
            this.createTables();
            Global.setAutomaticLogin(false);
        }
        if (!resourceDbExists) {
            this.createResourceTables();
            if (this.dbTableExists("NoteResources")) {
                NSqlQuery query = new NSqlQuery(this.resourceConn);
                String linkcmd = "create linked table oldnoteresources ('org.h2.Driver', '" + url + "', '" + userid + "', '" + passwordString + "', 'NoteResources')";
                query.exec(linkcmd);
                query.exec("insert into noteresources (select * from oldnoteresources)");
                query.exec("Drop table oldnoteresources;");
                query.exec("Update noteresources set indexneeded='true'");
            }
        }
        if (!indexDbExists) {
            this.createIndexTables();
            this.executeSql("Update note set indexneeded='true'");
        }
        if (!behaviorDbExists) {
            this.createHistoryTables();
            this.createExcludedTables();
            this.createStaredTables();
        }
        this.logger.log(this.logger.HIGH, "Leaving DatabaseConnection.dbSetup" + this.id);
    }

    public void dbShutdown() {
        this.logger.log(this.logger.HIGH, "Entering RDatabaseConnection.dbShutdown");
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.logger.log(this.logger.HIGH, "Leaving RDatabaseConnection.dbShutdown");
    }

    public void upgradeDb(String version) {
        if (version.equals("0.85")) {
            this.executeSql("alter table note add column titleColor integer");
            this.executeSql("alter table note add column thumbnail blob");
            this.executeSql("alter table note add column thumbnailneeded boolean");
            this.executeSql("Update note set thumbnailneeded = true;");
            this.executeSql("create index NOTE_NOTEBOOK_INDEX on note (notebookguid, guid);");
            this.executeSql("create index NOTETAGS_TAG_INDEX on notetags (tagguid, noteguid);");
            version = "0.86";
            Global.setDatabaseVersion(version);
        }
        if (version.equals("0.86")) {
            this.executeSql("alter table notebook add column publishingUri VarChar");
            this.executeSql("alter table notebook add column publishingOrder Integer");
            this.executeSql("alter table notebook add column publishingAscending Boolean");
            this.executeSql("alter table notebook add column publishingPublicDescription varchar");
            this.executeSql("alter table notebook add column stack varchar");
            this.executeSql("alter table notebook add column icon blob");
            this.executeSql("alter table notebook add column readOnly boolean");
            this.executeSql("alter table notebook add column linked boolean");
            this.executeSql("alter table tag add column realname varchar");
            this.executeSql("alter table tag add column linked boolean");
            this.executeSql("alter table tag add column icon blob");
            this.executeSql("alter table tag add column notebookguid varchar");
            this.executeSql("alter table SavedSearch add column icon blob");
            this.executeSql("create index NOTE_THUMBNAIL_INDEX on note (thumbnailneeded, guid);");
            this.executeSql("create index NOTE_EXPUNGED_INDEX on note (isExpunged, guid);");
            this.executeSql("create index NOTE_DUEDATE_INDEX on note (attributeSubjectDate, guid);");
            this.executeSql("create index TAG_NOTEBOOK_INDEX on tag (notebookGuid);");
            this.executeSql("update note set thumbnailneeded=true, thumbnail=null;");
            this.executeSql("update notebook set publishingUri='', publishingAscending=false, stack='', readonly=false, publishingOrder=1, publishingPublicDescription='', linked=false");
            this.executeSql("update tag set linked=false, realname='', notebookguid=''");
            this.sharedNotebookTable.createTable();
            this.linkedNotebookTable.createTable();
            this.systemIconTable.createTable();
            this.inkImagesTable.createTable();
            version = "0.95";
            this.executeSql("Insert into Sync (key, value) values ('FullNotebookSync', 'true')");
            this.executeSql("Insert into Sync (key, value) values ('FullLinkedNotebookSync', 'true')");
            this.executeSql("Insert into Sync (key, value) values ('FullSharedNotebookSync', 'true')");
            this.executeSql("Insert into Sync (key, value) values ('FullInkNoteImageSync', 'true')");
            Global.setDatabaseVersion(version);
        }
        if (version.equals("0.95")) {
            if (this.dbTableExists("words")) {
                this.executeSql("Drop table words;");
            }
            if (this.dbTableExists("NoteResources")) {
                this.executeSql("Drop table NoteResources;");
            }
        }
        if (!this.dbTableColumnExists("NOTE", "ORIGINAL_GUID")) {
            this.executeSql("alter table note add column ORIGINAL_GUID VarChar");
            this.executeSql("create index NOTE_ORIGINAL_GUID_INDEX on note (original_guid, guid);");
        }
        if (!this.dbTableColumnExists("NOTEBOOK", "NARROW_SORT_ORDER")) {
            this.executeSql("alter table notebook add column NARROW_SORT_ORDER integer");
            this.executeSql("update notebook set NARROW_SORT_ORDER = -1");
            this.executeSql("alter table notebook add column WIDE_SORT_ORDER integer");
            this.executeSql("update notebook set WIDE_SORT_ORDER = -1");
            this.executeSql("alter table notebook add column WIDE_SORT_COLUMN integer");
            this.executeSql("update notebook set WIDE_SORT_COLUMN = -1");
            this.executeSql("alter table notebook add column NARROW_SORT_COLUMN integer");
            this.executeSql("update notebook set NARROW_SORT_COLUMN = -1");
        }
        if (!this.dbTableColumnExists("NOTE", "PINNED")) {
            this.executeSql("alter table note add column pinned integer");
            this.executeSql("update note set pinned = 0");
        }
        if (!this.dbTableColumnExists("NOTE", "ATTRIBUTECONTENTCLASS")) {
            this.executeSql("alter table note add column attributeContentClass VarChar");
            this.executeSql("update note set attributeContentClass = ''");
        }
        if (!this.dbTableColumnExists("NOTE", "CONTENTTEXT")) {
            this.executeSql("alter table note add column contentText VarChar");
            this.executeSql("update note set contentText = ''");
            NSqlQuery query = new NSqlQuery(this.conn);
            query.exec("Select guid, content from Note where contentText = ''");
            while (query.next()) {
                String guid = query.valueString(0);
                String content = query.valueString(1);
                String contentText = Global.extractPlainText(content);
                NSqlQuery query2 = new NSqlQuery(this.conn);
                query2.prepare("update note set contentText=:contentText where guid=:guid");
                query2.bindValue(":contentText", contentText);
                query2.bindValue(":guid", guid);
                query2.exec();
            }
            query.exec("CREATE ALIAS IF NOT EXISTS FTL_INIT FOR \"org.h2.fulltext.FullTextLuceneEx.init\"");
            query.exec("CALL FTL_INIT()");
            Global.rebuildFullTextNoteTarget(this);
        }
        NSqlQuery rQuery = new NSqlQuery(this.resourceConn);
        rQuery.exec("select TABLE_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='NOTERESOURCES' and COLUMN_NAME='RESOURCETEXT'");
        if (!rQuery.next()) {
            rQuery.exec("alter table noteResources add column resourceText VarChar");
            rQuery.exec("update noteResources set resourceText = ''");
            rQuery.exec("CREATE ALIAS IF NOT EXISTS FTL_INIT FOR \"org.h2.fulltext.FullTextLuceneEx.init\"");
            rQuery.exec("CALL FTL_INIT()");
            Global.rebuildFullTextResourceTarget(this);
        }
    }

    public void executeSql(String sql) {
        NSqlQuery query = new NSqlQuery(this.conn);
        query.exec(sql);
    }

    public void checkDatabaseVersion() {
        if (!Global.getDatabaseVersion().equals("0.86")) {
            this.upgradeDb(Global.getDatabaseVersion());
        }
        if (!Global.getDatabaseVersion().equals("0.95")) {
            this.upgradeDb(Global.getDatabaseVersion());
        }
        if (!Global.getDatabaseVersion().equals("0.97")) {
            this.upgradeDb(Global.getDatabaseVersion());
        }
    }

    public void backupDatabase(int highSequence, long date) {
    }

    public void createTables() {
        Global.setDatabaseVersion("0.85");
        Global.setAutomaticLogin(false);
        Global.saveCurrentNoteGuid("");
        Global.saveUploadAmount(0L);
        this.getTagTable().createTable();
        this.notebookTable.createTable(true);
        this.noteTable.createTable();
        this.deletedTable.createTable();
        this.searchTable.createTable();
        this.watchFolderTable.createTable();
        this.invalidXMLTable.createTable();
        this.syncTable.createTable();
    }

    public void createIndexTables() {
        this.wordsTable.createTable();
    }

    public void createResourceTables() {
        this.noteTable.noteResourceTable.createTable();
    }

    public void createHistoryTables() {
        this.historyTable.createTable();
    }

    public void createExcludedTables() {
        this.excludedTable.createTable();
    }

    public void createStaredTables() {
        this.staredTable.createTable();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Connection getIndexConnection() {
        return this.indexConn;
    }

    public Connection getResourceConnection() {
        return this.resourceConn;
    }

    public Connection getBehaviorConnection() {
        return this.behaviorConn;
    }

    public DeletedTable getDeletedTable() {
        return this.deletedTable;
    }

    public TagTable getTagTable() {
        return this.tagTable;
    }

    public NoteTable getNoteTable() {
        return this.noteTable;
    }

    public NotebookTable getNotebookTable() {
        return this.notebookTable;
    }

    public SavedSearchTable getSavedSearchTable() {
        return this.searchTable;
    }

    public WatchFolderTable getWatchFolderTable() {
        return this.watchFolderTable;
    }

    public WordsTable getWordsTable() {
        return this.wordsTable;
    }

    public InvalidXMLTable getInvalidXMLTable() {
        return this.invalidXMLTable;
    }

    public SyncTable getSyncTable() {
        return this.syncTable;
    }

    public LinkedNotebookTable getLinkedNotebookTable() {
        return this.linkedNotebookTable;
    }

    public SharedNotebookTable getSharedNotebookTable() {
        return this.sharedNotebookTable;
    }

    public SystemIconTable getSystemIconTable() {
        return this.systemIconTable;
    }

    public InkImagesTable getInkImagesTable() {
        return this.inkImagesTable;
    }

    public HistoryTable getHistoryTable() {
        return this.historyTable;
    }

    public ExcludedTable getExcludedTable() {
        return this.excludedTable;
    }

    public StaredTable getStaredTable() {
        return this.staredTable;
    }

    public void beginTransaction() {
        this.commitTransaction();
        NSqlQuery query = new NSqlQuery(this.getConnection());
        if (!query.exec("Begin Transaction")) {
            this.logger.log(this.logger.EXTREME, "Begin transaction has failed: " + query.lastError());
        }
    }

    public void commitTransaction() {
        NSqlQuery query = new NSqlQuery(this.getConnection());
        if (!query.exec("Commit")) {
            this.logger.log(this.logger.EXTREME, "Transaction commit has failed: " + query.lastError());
        }
    }

    public boolean dbTableExists(String name) {
        NSqlQuery query = new NSqlQuery(this.getConnection());
        query.prepare("select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME=:name");
        query.bindValue(":name", name.toUpperCase());
        query.exec();
        return query.next();
    }

    public boolean dbTableColumnExists(String tableName, String columnName) {
        NSqlQuery query = new NSqlQuery(this.getConnection());
        query.prepare("select TABLE_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME=:name and COLUMN_NAME=:column");
        query.bindValue(":name", tableName.toUpperCase());
        query.bindValue(":column", columnName);
        query.exec();
        return query.next();
    }
}

