/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.gui.NotebookTreeWidget;
import cx.fbn.nevernote.gui.controls.QuotaProgressBar;

public class SearchPanel
extends QWidget {
    private final QLabel zoomLabel;
    private final QSpinBox zoomSpinner;
    private final NotebookTreeWidget notebook;
    private final QComboBox search;
    private final QuotaProgressBar bar;

    public SearchPanel(QComboBox search, QuotaProgressBar bar, NotebookTreeWidget notebook, QSpinBox zoom) {
        QVBoxLayout mainLayout = new QVBoxLayout();
        QVBoxLayout subLayout = new QVBoxLayout();
        this.zoomSpinner = zoom;
        this.bar = bar;
        this.search = search;
        this.notebook = notebook;
        this.setLayout((QLayout)mainLayout);
        subLayout.addWidget((QWidget)search);
        subLayout.addWidget((QWidget)bar);
        QHBoxLayout zoomLayout = new QHBoxLayout();
        this.zoomLabel = new QLabel(this.tr("Zoom:"));
        zoomLayout.addWidget((QWidget)this.zoomLabel);
        zoomLayout.addWidget((QWidget)zoom);
        zoomLayout.setStretch(1, 100);
        subLayout.addLayout((QLayout)zoomLayout);
        mainLayout.addLayout((QLayout)subLayout);
        mainLayout.addWidget((QWidget)notebook);
        mainLayout.setContentsMargins(0, 0, 0, 0);
    }

    public void hideZoom() {
        this.zoomLabel.hide();
        this.zoomSpinner.hide();
    }

    public void showZoom() {
        this.zoomLabel.show();
        this.zoomSpinner.show();
    }

    public void toggleNotebook() {
        this.show();
        if (this.notebook.isVisible()) {
            this.notebook.hide();
        } else {
            this.notebook.show();
        }
        this.checkVisibility();
    }

    public void toggleSearchField() {
        this.show();
        if (this.search.isVisible()) {
            this.search.hide();
        } else {
            this.search.show();
        }
        this.checkVisibility();
    }

    private void checkVisibility() {
        if (this.notebook.isHidden() && this.bar.isHidden() && this.search.isHidden() && this.zoomSpinner.isHidden()) {
            this.hide();
        }
    }

    public void toggleQuotaBar() {
        this.show();
        if (this.bar.isVisible()) {
            this.bar.hide();
        } else {
            this.bar.show();
        }
        this.checkVisibility();
    }

    public void toggleZoom() {
        this.show();
        if (this.zoomSpinner.isVisible()) {
            this.zoomSpinner.hide();
            this.zoomLabel.hide();
        } else {
            this.zoomSpinner.show();
            this.zoomLabel.show();
        }
        this.checkVisibility();
    }
}

