/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.trolltech.qt.QThread;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.NeverNote;
import cx.fbn.nevernote.gui.RensoNoteListItem;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.threads.ENRelatedNotesRunner;
import cx.fbn.nevernote.threads.SyncRunner;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class RensoNoteList
extends QListWidget {
    private final DatabaseConnection conn;
    private final ApplicationLogger logger;
    private final HashMap<QListWidgetItem, String> rensoNoteListItems;
    private final List<RensoNoteListItem> rensoNoteListTrueItems;
    private String rensoNotePressedItemGuid;
    private final QAction openNewTabAction;
    private final QAction starAction;
    private final QAction unstarAction;
    private final QAction excludeNoteAction;
    private final NeverNote parent;
    private final QMenu menu;
    private HashMap<String, Integer> mergedHistory;
    private final SyncRunner syncRunner;
    private final ENRelatedNotesRunner enRelatedNotesRunner;
    private final QThread enRelatedNotesThread;
    private final HashMap<String, List<String>> enRelatedNotesCache;
    private String guid;
    private int allPointSum;

    public RensoNoteList(DatabaseConnection c, NeverNote p, SyncRunner syncRunner, ApplicationLogger logger) {
        this.logger = logger;
        this.logger.log(this.logger.HIGH, "Setting up rensoNoteList");
        this.allPointSum = 0;
        this.conn = c;
        this.parent = p;
        this.syncRunner = syncRunner;
        this.guid = new String();
        this.mergedHistory = new HashMap();
        this.enRelatedNotesCache = new HashMap();
        this.enRelatedNotesRunner = new ENRelatedNotesRunner(this.syncRunner, this.logger);
        this.enRelatedNotesRunner.enRelatedNotesSignal.getENRelatedNotesFinished.connect((Object)this, "enRelatedNotesComplete()");
        this.enRelatedNotesThread = new QThread((Runnable)this.enRelatedNotesRunner, "ENRelatedNotes Thread");
        this.getEnRelatedNotesThread().start();
        this.rensoNoteListItems = new HashMap();
        this.rensoNoteListTrueItems = new ArrayList<RensoNoteListItem>();
        this.itemPressed.connect((Object)this, "rensoNoteItemPressed(QListWidgetItem)");
        this.menu = new QMenu((QWidget)this);
        this.openNewTabAction = new QAction(this.tr("Open in New Tab"), (QObject)this);
        this.openNewTabAction.setToolTip(this.tr("Open this note in new tab"));
        this.openNewTabAction.triggered.connect((Object)this.parent, "openNewTabFromRNL()");
        this.starAction = new QAction(this.tr("Add Star"), (QObject)this);
        this.starAction.setToolTip(this.tr("Add Star to this item"));
        this.starAction.triggered.connect((Object)this.parent, "starNote()");
        this.unstarAction = new QAction(this.tr("Remove Star"), (QObject)this);
        this.unstarAction.setToolTip(this.tr("Remove Star from this item"));
        this.unstarAction.triggered.connect((Object)this.parent, "unstarNote()");
        this.excludeNoteAction = new QAction(this.tr("Exclude"), (QObject)this);
        this.excludeNoteAction.setToolTip(this.tr("Exclude this note from RensoNoteList"));
        this.excludeNoteAction.triggered.connect((Object)this.parent, "excludeNote()");
        this.menu.addAction(this.openNewTabAction);
        this.menu.addAction(this.excludeNoteAction);
        this.menu.aboutToHide.connect((Object)this, "contextMenuHidden()");
        this.logger.log(this.logger.HIGH, "rensoNoteList setup complete");
    }

    public void refreshRensoNoteList() {
        this.refreshRensoNoteList(this.guid);
    }

    public void refreshRensoNoteList(String guid) {
        this.logger.log(this.logger.HIGH, "Entering RensoNoteList.refreshRensoNoteList guid = " + guid);
        this.clear();
        this.rensoNoteListItems.clear();
        this.rensoNoteListTrueItems.clear();
        this.mergedHistory = new HashMap();
        if (!this.isEnabled()) {
            return;
        }
        if (guid == null || guid.equals("")) {
            return;
        }
        this.guid = guid;
        boolean isCached = this.enRelatedNotesCache.containsKey(guid);
        if (!isCached) {
            this.enRelatedNotesRunner.addGuid(guid);
        } else {
            List<String> relatedNoteGuids = this.enRelatedNotesCache.get(guid);
            this.addENRelatedNotes(relatedNoteGuids);
        }
        this.calculateHistory(guid);
        this.repaintRensoNoteList(false);
        this.logger.log(this.logger.HIGH, "Leaving RensoNoteList.refreshRensoNoteList");
    }

    private void calculateHistory(String guid) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.calculateHistory guid = " + guid);
        HashMap<String, Integer> browseHistory = this.conn.getHistoryTable().getBehaviorHistory("browse", guid);
        this.addWeight(browseHistory, Global.getBrowseWeight());
        this.mergedHistory = this.mergeHistory(browseHistory, this.mergedHistory);
        HashMap<String, Integer> copyAndPasteHistory = this.conn.getHistoryTable().getBehaviorHistory("copy & paste", guid);
        this.addWeight(copyAndPasteHistory, Global.getCopyPasteWeight());
        this.mergedHistory = this.mergeHistory(copyAndPasteHistory, this.mergedHistory);
        HashMap<String, Integer> addNewNoteHistory = this.conn.getHistoryTable().getBehaviorHistory("addNewNote", guid);
        this.addWeight(addNewNoteHistory, Global.getAddNewNoteWeight());
        this.mergedHistory = this.mergeHistory(addNewNoteHistory, this.mergedHistory);
        HashMap<String, Integer> rensoItemClickHistory = this.conn.getHistoryTable().getBehaviorHistory("rensoItemClick", guid);
        this.addWeight(rensoItemClickHistory, Global.getRensoItemClickWeight());
        this.mergedHistory = this.mergeHistory(rensoItemClickHistory, this.mergedHistory);
        HashMap<String, Integer> sameTagHistory = this.conn.getHistoryTable().getBehaviorHistory("sameTag", guid);
        this.addWeight(sameTagHistory, Global.getSameTagWeight());
        this.mergedHistory = this.mergeHistory(sameTagHistory, this.mergedHistory);
        HashMap<String, Integer> sameNotebookHistory = this.conn.getHistoryTable().getBehaviorHistory("sameNotebook", guid);
        this.addWeight(sameNotebookHistory, Global.getSameNotebookWeight());
        this.mergedHistory = this.mergeHistory(sameNotebookHistory, this.mergedHistory);
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.calculateHistory");
    }

    private void addWeight(HashMap<String, Integer> history, int weight) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.addWeight");
        Set<String> keySet = history.keySet();
        for (String key : keySet) {
            history.put(key, history.get(key) * weight);
        }
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.addWeight");
    }

    private void repaintRensoNoteList(boolean needClear) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.repaintRensoNoteList");
        if (needClear) {
            this.clear();
            this.rensoNoteListItems.clear();
            this.rensoNoteListTrueItems.clear();
        }
        if (!this.isEnabled()) {
            return;
        }
        this.allPointSum = 0;
        for (int p : this.mergedHistory.values()) {
            this.allPointSum += p;
        }
        this.addRensoNoteList(this.mergedHistory);
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.repaintRensoNoteList");
    }

    private HashMap<String, Integer> mergeHistory(HashMap<String, Integer> History1, HashMap<String, Integer> History2) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.mergeHistory");
        HashMap<String, Integer> mergedHistory = new HashMap<String, Integer>();
        mergedHistory.putAll(History1);
        Set<String> keySet = History2.keySet();
        for (String key : keySet) {
            if (mergedHistory.containsKey(key)) {
                mergedHistory.put(key, mergedHistory.get(key) + History2.get(key));
                continue;
            }
            mergedHistory.put(key, History2.get(key));
        }
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.mergeHistory");
        return mergedHistory;
    }

    private void addRensoNoteList(HashMap<String, Integer> History) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.addRensoNoteList");
        String currentNoteGuid = new String(this.parent.getCurrentNoteGuid());
        HashMap<String, Integer> staredNotes = new HashMap<String, Integer>();
        HashMap<String, Integer> normalNotes = new HashMap<String, Integer>();
        for (String nextGuid : History.keySet()) {
            int relationPoint = History.get(nextGuid);
            boolean isStared = this.conn.getStaredTable().existNote(currentNoteGuid, nextGuid);
            if (isStared) {
                staredNotes.put(nextGuid, relationPoint);
                continue;
            }
            normalNotes.put(nextGuid, relationPoint);
        }
        int i = 0;
        while (i < Global.getRensoListItemMaximum()) {
            HashMap tmpMap = new HashMap();
            if (!staredNotes.isEmpty()) {
                tmpMap = staredNotes;
            } else if (!normalNotes.isEmpty()) {
                tmpMap = normalNotes;
            }
            if (!tmpMap.isEmpty()) {
                int maxNum = -1;
                String maxGuid = new String();
                for (String nextGuid : tmpMap.keySet()) {
                    int relationPoint = (Integer)tmpMap.get(nextGuid);
                    if (relationPoint <= maxNum) continue;
                    maxNum = relationPoint;
                    maxGuid = nextGuid;
                }
                tmpMap.remove(maxGuid);
                Note maxNote = this.conn.getNoteTable().getNote(maxGuid, true, false, false, false, true);
                boolean isNoteActive = false;
                if (maxNote != null) {
                    isNoteActive = maxNote.isActive();
                }
                if (!isNoteActive || maxNum <= 0) break;
                boolean isStared = this.conn.getStaredTable().existNote(currentNoteGuid, maxGuid);
                QListWidgetItem item = new QListWidgetItem();
                RensoNoteListItem myItem = new RensoNoteListItem(maxNote, maxNum, isStared, this.allPointSum, this.conn, this);
                item.setSizeHint(new QSize(0, 90));
                this.addItem(item);
                this.setItemWidget(item, myItem);
                this.rensoNoteListItems.put(item, maxGuid);
                this.rensoNoteListTrueItems.add(myItem);
            }
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.addRensoNoteList");
    }

    public String getNoteGuid(QListWidgetItem item) {
        return this.rensoNoteListItems.get(item);
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.contextMenuEvent");
        if (this.rensoNotePressedItemGuid == null || this.rensoNotePressedItemGuid.equals("")) {
            return;
        }
        ArrayList menuActions = new ArrayList(this.menu.actions());
        if (menuActions.contains(this.starAction)) {
            this.menu.removeAction(this.starAction);
        }
        if (menuActions.contains(this.unstarAction)) {
            this.menu.removeAction(this.unstarAction);
        }
        String currentNoteGuid = this.parent.getCurrentNoteGuid();
        boolean isExist = this.conn.getStaredTable().existNote(currentNoteGuid, this.rensoNotePressedItemGuid);
        if (isExist) {
            this.menu.insertAction(this.excludeNoteAction, this.unstarAction);
        } else {
            this.menu.insertAction(this.excludeNoteAction, this.starAction);
        }
        this.menu.exec(event.globalPos());
        this.rensoNotePressedItemGuid = null;
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.contextMenuEvent");
    }

    public boolean isContextMenuVisible() {
        return this.menu.isVisible();
    }

    private void contextMenuHidden() {
        int i = 0;
        while (i < this.rensoNoteListTrueItems.size()) {
            RensoNoteListItem item = this.rensoNoteListTrueItems.get(i);
            item.setDefaultBackground();
            ++i;
        }
    }

    private void rensoNoteItemPressed(QListWidgetItem current) {
        this.logger.log(this.logger.HIGH, "Entering RensoNoteList.rensoNoteItemPressed");
        this.rensoNotePressedItemGuid = null;
        if (QApplication.mouseButtons().isSet((QtEnumerator[])new Qt.MouseButton[]{Qt.MouseButton.RightButton})) {
            this.rensoNotePressedItemGuid = this.getNoteGuid(current);
        }
        this.logger.log(this.logger.HIGH, "Leaving RensoNoteList.rensoNoteItemPressed");
    }

    private void enRelatedNotesComplete() {
        this.logger.log(this.logger.HIGH, "Entering RensoNoteList.enRelatedNotesComplete");
        Pair<String, List<String>> enRelatedNoteGuidPair = this.enRelatedNotesRunner.getENRelatedNoteGuids();
        if (enRelatedNoteGuidPair == null) {
            return;
        }
        String sourceGuid = enRelatedNoteGuidPair.getFirst();
        List<String> enRelatedNoteGuids = enRelatedNoteGuidPair.getSecond();
        if (sourceGuid != null && !sourceGuid.equals("") && enRelatedNoteGuids != null) {
            this.enRelatedNotesCache.put(sourceGuid, enRelatedNoteGuids);
            if (!enRelatedNoteGuids.isEmpty() && sourceGuid.equals(this.guid)) {
                this.addENRelatedNotes(enRelatedNoteGuids);
                this.repaintRensoNoteList(true);
            }
        }
        this.logger.log(this.logger.HIGH, "Leaving RensoNoteList.enRelatedNotesComplete");
    }

    private void addENRelatedNotes(List<String> relatedNoteGuids) {
        this.logger.log(this.logger.EXTREME, "Entering RensoNoteList.addENRelatedNotes");
        HashMap<String, Integer> enRelatedNotes = new HashMap<String, Integer>();
        for (String relatedGuid : relatedNoteGuids) {
            enRelatedNotes.put(relatedGuid, Global.getENRelatedNotesWeight());
        }
        this.mergedHistory = this.mergeHistory(enRelatedNotes, this.mergedHistory);
        this.logger.log(this.logger.EXTREME, "Leaving RensoNoteList.addENRelatedNotes");
    }

    public boolean stopThread() {
        this.logger.log(this.logger.HIGH, "Entering RensoNoteList.stopThread");
        if (this.enRelatedNotesRunner.addStop()) {
            this.logger.log(this.logger.HIGH, "RensoNoteList.stopThread succeeded");
            return true;
        }
        this.logger.log(this.logger.HIGH, "RensoNoteList.stopThread failed");
        return false;
    }

    public QThread getEnRelatedNotesThread() {
        return this.enRelatedNotesThread;
    }

    public String getGuid() {
        return this.guid;
    }
}

