/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote;

import com.evernote.edam.type.Accounting;
import com.evernote.edam.type.PrivilegeLevel;
import com.evernote.edam.type.User;
import com.evernote.edam.type.UserAttributes;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QSettings;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QSystemTrayIcon;
import cx.fbn.nevernote.config.FileManager;
import cx.fbn.nevernote.config.InitializationException;
import cx.fbn.nevernote.config.StartupConfig;
import cx.fbn.nevernote.gui.ContainsAttributeFilterTable;
import cx.fbn.nevernote.gui.DateAttributeFilterTable;
import cx.fbn.nevernote.gui.ShortcutKeys;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class Global {
    public static String version = "0.3";
    public static String[] validVersions = new String[]{"0.3", "0.2", "0.1.3", "0.1.2", "0.1.1", "0.1"};
    public static String username = "";
    public static final int mainThreadId = 0;
    public static final int syncThreadId = 1;
    public static final int tagCounterThreadId = 2;
    public static final int trashCounterThreadId = 3;
    public static final int indexThreadId = 4;
    public static final int saveThreadId = 5;
    public static final int notebookCounterThreadId = 6;
    public static final int indexThread03Id = 7;
    public static final int indexThread04Id = 8;
    public static final int dbThreadId = 9;
    public static final int threadCount = 10;
    public static int View_List_Wide = 1;
    public static int View_List_Narrow = 2;
    public static QSize smallThumbnailSize = new QSize(100, 75);
    public static QSize largeThumbnailSize = new QSize(300, 225);
    public static HashMap<String, Pair<String, String>> passwordSafe = new HashMap();
    public static List<Pair<String, String>> passwordRemember = new ArrayList<Pair<String, String>>();
    public static User user;
    public static long authTimeRemaining;
    public static long authRefreshTime;
    public static long failedRefreshes;
    public static String userStoreUrl;
    public static String noteStoreUrl;
    public static String noteStoreUrlBase;
    public static boolean keepRunning;
    public static int noteTableCreationPosition;
    public static int noteTableTitlePosition;
    public static int noteTableTagPosition;
    public static int noteTableNotebookPosition;
    public static int noteTableChangedPosition;
    public static int noteTableGuidPosition;
    public static int noteTableAuthorPosition;
    public static int noteTableSourceUrlPosition;
    public static int noteTableSubjectDatePosition;
    public static int noteTableSynchronizedPosition;
    public static int noteTableThumbnailPosition;
    public static int noteTablePinnedPosition;
    public static int noteTableColumnCount;
    public static Integer cryptCounter;
    public static boolean enableCarriageReturnFix;
    public static boolean enableHTMLEntitiesFix;
    public static QSettings settings;
    public static boolean isConnected;
    public static boolean showDeleted;
    public static boolean disableUploads;
    public static int messageLevel;
    public static String tagDelimeter;
    public static String attachmentNameDelimeter;
    public static String databaseName;
    public static String indexDatabaseName;
    public static String resourceDatabaseName;
    public static String behaviorDatabaseName;
    public static DateAttributeFilterTable createdSinceFilter;
    public static DateAttributeFilterTable createdBeforeFilter;
    public static DateAttributeFilterTable changedSinceFilter;
    public static DateAttributeFilterTable changedBeforeFilter;
    public static ContainsAttributeFilterTable containsFilter;
    public static ApplicationLogger logger;
    public static QPalette originalPalette;
    public static ShortcutKeys shortcutKeys;
    public static boolean disableViewing;
    public static List<String> invalidElements;
    public static HashMap<String, ArrayList<String>> invalidAttributes;
    public static boolean mimicEvernoteInterface;
    public static HashMap<String, String> resourceMap;
    public static String cipherPassword;
    public static String databaseCache;
    static Calendar startTraceTime;
    static Calendar intervalTraceTime;
    static boolean syncOnly;
    private static FileManager fileManager;

    static {
        failedRefreshes = 0L;
        noteTableCreationPosition = 0;
        noteTableTitlePosition = 1;
        noteTableTagPosition = 2;
        noteTableNotebookPosition = 3;
        noteTableChangedPosition = 4;
        noteTableGuidPosition = 5;
        noteTableAuthorPosition = 6;
        noteTableSourceUrlPosition = 7;
        noteTableSubjectDatePosition = 8;
        noteTableSynchronizedPosition = 9;
        noteTableThumbnailPosition = 10;
        noteTablePinnedPosition = 11;
        noteTableColumnCount = 12;
        cryptCounter = 0;
        enableCarriageReturnFix = false;
        enableHTMLEntitiesFix = false;
        showDeleted = false;
        disableUploads = false;
        tagDelimeter = ",";
        attachmentNameDelimeter = "------";
        databaseName = new String("NeverNote");
        indexDatabaseName = new String("Index");
        resourceDatabaseName = new String("Resources");
        behaviorDatabaseName = new String("Behavior");
        invalidElements = new ArrayList<String>();
        invalidAttributes = new HashMap();
        cipherPassword = "";
        databaseCache = "16384";
    }

    public static void setup(StartupConfig startupConfig) throws InitializationException {
        String settingFileName = new String("NeighborNote.ini");
        String oldSettingPath = new QSettings(settingFileName, QSettings.Format.IniFormat).fileName();
        File homeDir = new File(FileManager.toPlatformPathSeparator(startupConfig.getHomeDirPath()));
        String homePath = FileManager.slashTerminatePath(homeDir.getPath());
        if (QFile.exists((String)oldSettingPath)) {
            QFile file = new QFile(oldSettingPath);
            file.copy(String.valueOf(homePath) + settingFileName);
            file.remove();
        }
        settings = new QSettings(String.valueOf(homePath) + settingFileName, QSettings.Format.IniFormat);
        disableViewing = startupConfig.getDisableViewing();
        syncOnly = startupConfig.isSyncOnly();
        fileManager = new FileManager(startupConfig.getHomeDirPath(), startupConfig.getProgramDirPath());
        Global.getServer();
        settings.beginGroup("Debug");
        String msglevel = (String)settings.value("messageLevel", (Object)"Low");
        settings.endGroup();
        Global.setMessageLevel(msglevel);
        keepRunning = true;
        disableUploads = Global.disableUploads();
        enableCarriageReturnFix = Global.enableCarriageReturnFix();
        enableHTMLEntitiesFix = Global.enableHtmlEntitiesFix();
        logger = new ApplicationLogger("global.log");
        shortcutKeys = new ShortcutKeys();
        mimicEvernoteInterface = Global.getMimicEvernoteInterface();
        resourceMap = new HashMap();
        databaseCache = Global.getDatabaseCacheSize();
        username = Global.getUserInformation().getUsername();
    }

    public static void setMessageLevel(String msglevel) {
        if (msglevel.equalsIgnoreCase("low")) {
            messageLevel = 1;
        }
        if (msglevel.equalsIgnoreCase("medium")) {
            messageLevel = 2;
        }
        if (msglevel.equalsIgnoreCase("high")) {
            messageLevel = 3;
        }
        if (msglevel.equalsIgnoreCase("extreme")) {
            messageLevel = 4;
        }
        settings.beginGroup("Debug");
        settings.setValue("messageLevel", (Object)msglevel);
        settings.endGroup();
    }

    public static void saveUserInformation(User user) {
        settings.beginGroup("User");
        settings.setValue("id", (Object)user.getId());
        settings.setValue("username", (Object)user.getUsername());
        settings.setValue("email", (Object)user.getEmail());
        settings.setValue("name", (Object)user.getName());
        settings.setValue("timezone", (Object)user.getTimezone());
        settings.setValue("privilege", (Object)user.getPrivilege().getValue());
        settings.setValue("created", (Object)user.getCreated());
        settings.setValue("updated", (Object)user.getUpdated());
        settings.setValue("deleted", (Object)user.getDeleted());
        settings.setValue("shard", (Object)user.getShardId());
        settings.endGroup();
        Global.isPremium();
        if (user.getAttributes() != null) {
            Global.saveUserAttributes(user.getAttributes());
        }
        if (user.getAccounting() != null) {
            Global.saveUserAccounting(user.getAccounting());
        }
    }

    public static User getUserInformation() {
        User user = new User();
        settings.beginGroup("User");
        try {
            user.setId(((Integer)settings.value("id", (Object)0)).intValue());
        }
        catch (ClassCastException e) {
            user.setId(new Integer((String)settings.value("id", (Object)"0")).intValue());
        }
        String username = (String)settings.value("username", (Object)"");
        String email = (String)settings.value("email", (Object)"");
        String name = (String)settings.value("name", (Object)"");
        String timezone = (String)settings.value("timezone", (Object)"");
        Integer privilege = 0;
        try {
            privilege = new Integer((String)settings.value("privilege", (Object)"0"));
        }
        catch (ClassCastException e) {
            privilege = (Integer)settings.value("privilege", (Object)0);
        }
        try {
            String date = (String)settings.value("created", (Object)"0");
            user.setCreated(new Long(date).longValue());
            date = (String)settings.value("updated", (Object)"0");
            user.setUpdated(new Long(date).longValue());
            date = (String)settings.value("deleted", (Object)"0");
            user.setDeleted(new Long(date).longValue());
        }
        catch (ClassCastException e) {
            Long date = (Long)settings.value("created", (Object)0);
            user.setCreated(date.longValue());
            date = (Long)settings.value("updated", (Object)0);
            user.setUpdated(date.longValue());
            date = (Long)settings.value("deleted", (Object)0);
            user.setDeleted(date.longValue());
        }
        String shard = (String)settings.value("shard", (Object)"");
        settings.endGroup();
        user.setUsername(username);
        user.setEmail(email);
        user.setName(name);
        user.setTimezone(timezone);
        PrivilegeLevel userLevel = PrivilegeLevel.findByValue((int)privilege);
        user.setPrivilege(userLevel);
        user.setShardId(shard);
        return user;
    }

    public static void saveUserAttributes(UserAttributes attrib) {
        settings.beginGroup("UserAttributes");
        settings.setValue("defaultLocationName", (Object)attrib.getDefaultLocationName());
        settings.setValue("defaultLatitude", (Object)attrib.getDefaultLocationName());
        settings.setValue("defaultLongitude", (Object)attrib.getDefaultLocationName());
        settings.setValue("incomingEmailAddress", (Object)attrib.getIncomingEmailAddress());
        settings.endGroup();
    }

    public static UserAttributes getUserAttributes() {
        settings.beginGroup("UserAttributes");
        UserAttributes attrib = new UserAttributes();
        attrib.setDefaultLocationName((String)settings.value("defaultLocationName", (Object)""));
        attrib.setDefaultLatitudeIsSet(false);
        attrib.setDefaultLongitudeIsSet(false);
        attrib.setIncomingEmailAddress((String)settings.value("incomingEmailAddress", (Object)""));
        settings.endGroup();
        return attrib;
    }

    public static void saveUserAccounting(Accounting acc) {
        settings.beginGroup("UserAccounting");
        settings.setValue("uploadLimit", (Object)acc.getUploadLimit());
        settings.setValue("uploadLimitEnd", (Object)acc.getUploadLimitEnd());
        settings.setValue("uploadLimitNextMonth", (Object)acc.getUploadLimitNextMonth());
        settings.setValue("premiumServiceStart", (Object)acc.getPremiumServiceStart());
        settings.setValue("nextPaymentDue", (Object)acc.getNextPaymentDue());
        settings.setValue("uploadAmount", (Object)acc.getUpdated());
        settings.endGroup();
    }

    public static long getUploadLimitEnd() {
        Long limit;
        settings.beginGroup("UserAccounting");
        try {
            String val = (String)settings.value("uploadLimitEnd", (Object)"0");
            limit = new Long(val.trim());
        }
        catch (Exception e) {
            try {
                limit = (Long)settings.value("uploadLimitEnd", (Object)0);
            }
            catch (Exception e1) {
                limit = new Long(0L);
            }
        }
        settings.endGroup();
        return limit;
    }

    public static void saveUploadAmount(long amount) {
        settings.beginGroup("UserAccounting");
        settings.setValue("uploadAmount", (Object)amount);
        settings.endGroup();
    }

    public static long getUploadAmount() {
        long amt = 0L;
        settings.beginGroup("UserAccounting");
        try {
            String num = (String)settings.value("uploadAmount", (Object)"0");
            amt = new Long(num.trim());
        }
        catch (Exception e) {
            try {
                amt = ((Integer)settings.value("uploadAmount", (Object)0)).intValue();
            }
            catch (Exception e1) {
                amt = 0L;
            }
        }
        settings.endGroup();
        return amt;
    }

    public static void saveEvernoteUpdateCount(long amount) {
        settings.beginGroup("UserAccounting");
        settings.setValue("updateCount", (Object)amount);
        settings.endGroup();
    }

    public static long getEvernoteUpdateCount() {
        long amt;
        settings.beginGroup("UserAccounting");
        try {
            String num = (String)settings.value("updateCount", (Object)new Long(0L).toString());
            amt = new Long(num.trim());
        }
        catch (ClassCastException e) {
            amt = 0L;
        }
        settings.endGroup();
        return amt;
    }

    public static boolean isPremium() {
        int level;
        settings.beginGroup("User");
        try {
            String num = (String)settings.value("privilege", (Object)"1");
            level = new Integer(num.trim());
        }
        catch (ClassCastException e) {
            try {
                level = (Integer)settings.value("privilege", (Object)1);
            }
            catch (Exception e1) {
                level = 1;
            }
        }
        settings.endGroup();
        PrivilegeLevel userLevel = PrivilegeLevel.findByValue((int)level);
        return userLevel != PrivilegeLevel.NORMAL;
    }

    public static long getUploadLimit() {
        long limit;
        settings.beginGroup("UserAccounting");
        try {
            String num = (String)settings.value("uploadLimit", (Object)new Long(0L).toString());
            limit = new Long(num.trim());
        }
        catch (ClassCastException e) {
            limit = 0L;
        }
        settings.endGroup();
        return limit;
    }

    public static boolean showTrayIcon() {
        settings.beginGroup("General");
        try {
            String max = (String)settings.value("showTrayIcon", (Object)"false");
            settings.endGroup();
            return max.equalsIgnoreCase("true") && QSystemTrayIcon.isSystemTrayAvailable();
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("showTrayIcon", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setShowTrayIcon(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("showTrayIcon", (Object)"true");
        } else {
            settings.setValue("showTrayIcon", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean wasWindowMaximized() {
        try {
            settings.beginGroup("General");
            String max = (String)settings.value("isMaximized", (Object)"true");
            settings.endGroup();
            return max.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("isMaximized", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void saveWindowMaximized(boolean isMax) {
        settings.beginGroup("General");
        if (isMax) {
            settings.setValue("isMaximized", (Object)"true");
        } else {
            settings.setValue("isMaximized", (Object)"false");
        }
        settings.endGroup();
    }

    public static String getLastViewedNoteGuid() {
        settings.beginGroup("General");
        String guid = (String)settings.value("lastViewedNote", (Object)"");
        settings.endGroup();
        return guid;
    }

    public static void saveCurrentNoteGuid(String guid) {
        settings.beginGroup("General");
        if (guid != null) {
            settings.setValue("lastViewedNote", (Object)guid);
        } else {
            settings.setValue("lastViewedNote", (Object)"");
        }
        settings.endGroup();
    }

    public static void setSortColumn(int i) {
        int view = Global.getListView();
        settings.beginGroup("General");
        if (view == View_List_Wide) {
            settings.setValue("sortColumn", (Object)i);
        } else {
            settings.setValue("sortColumn-Narrow", (Object)i);
        }
        settings.endGroup();
    }

    public static int getSortColumn() {
        int order;
        String key = Global.getListView() == View_List_Wide ? "sortColumn" : "sortColumn-Narrow";
        settings.beginGroup("General");
        try {
            String val = settings.value(key, (Object)new Integer(0)).toString();
            order = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                order = (Integer)settings.value(key, (Object)0);
            }
            catch (Exception e1) {
                order = 0;
            }
        }
        settings.endGroup();
        return order;
    }

    public static void setSortOrder(int i) {
        int view = Global.getListView();
        settings.beginGroup("General");
        if (view == View_List_Wide) {
            settings.setValue("sortOrder", (Object)i);
        } else {
            settings.setValue("sortOrder-Narrow", (Object)i);
        }
        settings.endGroup();
    }

    public static int getSortOrder() {
        int order;
        int view = Global.getListView();
        settings.beginGroup("General");
        String key = view == View_List_Wide ? "sortOrder" : "sortOrder-Narrow";
        try {
            String val = settings.value(key, (Object)new Integer(0)).toString();
            order = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                order = (Integer)settings.value(key, (Object)0);
            }
            catch (Exception e1) {
                order = 0;
            }
        }
        settings.endGroup();
        return order;
    }

    public static boolean automaticLogin() {
        try {
            settings.beginGroup("General");
            String text = (String)settings.value("automaticLogin", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("automaticLogin", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setAutomaticLogin(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("automaticLogin", (Object)"true");
        } else {
            settings.setValue("automaticLogin", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setServer(String server) {
        settings.beginGroup("General");
        settings.setValue("server", (Object)server);
        settings.endGroup();
    }

    public static String getServer() {
        settings.beginGroup("General");
        String text = (String)settings.value("server", (Object)"www.evernote.com");
        if (text.equals("www.evernote.com")) {
            userStoreUrl = "https://www.evernote.com/edam/user";
            noteStoreUrlBase = "www.evernote.com/edam/note/";
        } else {
            userStoreUrl = "https://sandbox.evernote.com/edam/user";
            noteStoreUrlBase = "sandbox.evernote.com/edam/note/";
        }
        settings.endGroup();
        noteStoreUrlBase = "https://" + noteStoreUrlBase;
        return text;
    }

    public static boolean disableUploads() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("disableUploads", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("disableUploads", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setDisableUploads(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("disableUploads", (Object)"true");
        } else {
            settings.setValue("disableUploads", (Object)"false");
        }
        settings.endGroup();
        disableUploads = val;
    }

    public static boolean pdfPreview() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("pdfPreview", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("pdfPreview", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setPdfPreview(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("pdfPreview", (Object)"true");
        } else {
            settings.setValue("pdfPreview", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean newNoteWithSelectedTags() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("newNoteWithSelectedTags", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("newNoteWithSelectedTags", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setNewNoteWithSelectedTags(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("newNoteWithSelectedTags", (Object)"true");
        } else {
            settings.setValue("newNoteWithSelectedTags", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setRecognitionWeight(int len) {
        settings.beginGroup("General");
        settings.setValue("recognitionWeight", (Object)len);
        settings.endGroup();
    }

    public static int getRecognitionWeight() {
        Integer len;
        settings.beginGroup("General");
        try {
            len = (Integer)settings.value("recognitionWeight", (Object)30);
        }
        catch (Exception e) {
            len = 80;
        }
        settings.endGroup();
        return len;
    }

    public static String getMessageLevel() {
        settings.beginGroup("Debug");
        String text = (String)settings.value("messageLevel", (Object)"Low");
        settings.endGroup();
        Global.setMessageLevel(text);
        return text;
    }

    public static void setDateFormat(String format) {
        settings.beginGroup("General");
        settings.setValue("dateFormat", (Object)format);
        settings.endGroup();
    }

    public static String getDateFormat() {
        settings.beginGroup("General");
        String text = (String)settings.value("dateFormat", (Object)"MM/dd/yyyy");
        settings.endGroup();
        return text;
    }

    public static void setTimeFormat(String format) {
        settings.beginGroup("General");
        settings.setValue("timeFormat", (Object)format);
        settings.endGroup();
    }

    public static String getTimeFormat() {
        settings.beginGroup("General");
        String text = (String)settings.value("timeFormat", (Object)"HH:mm:ss");
        settings.endGroup();
        return text;
    }

    public static String getSyncInterval() {
        settings.beginGroup("General");
        String text = (String)settings.value("syncInterval", (Object)"15 minutes");
        settings.endGroup();
        return text;
    }

    public static void setSyncInterval(String format) {
        settings.beginGroup("General");
        settings.setValue("syncInterval", (Object)format);
        settings.endGroup();
    }

    public static void setColumnWidth(String col, int width) {
        if (Global.getListView() == View_List_Wide) {
            settings.beginGroup("ColumnWidths");
        } else {
            settings.beginGroup("ColumnWidths-Narrow");
        }
        settings.setValue(col, (Object)width);
        settings.endGroup();
    }

    public static int getColumnWidth(String col) {
        Integer width;
        int view = Global.getListView();
        if (view == View_List_Wide) {
            settings.beginGroup("ColumnWidths");
        } else {
            settings.beginGroup("ColumnWidths-Narrow");
        }
        try {
            String val = (String)settings.value(col, (Object)"0");
            width = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                width = (Integer)settings.value(col, (Object)0);
            }
            catch (Exception e1) {
                width = 0;
            }
        }
        settings.endGroup();
        return width;
    }

    public static void setColumnPosition(String col, int width) {
        if (Global.getListView() == View_List_Wide) {
            settings.beginGroup("ColumnPosition");
        } else {
            settings.beginGroup("ColumnPosition-Narrow");
        }
        settings.setValue(col, (Object)width);
        settings.endGroup();
    }

    public static int getColumnPosition(String col) {
        Integer width;
        if (Global.getListView() == View_List_Wide) {
            settings.beginGroup("ColumnPosition");
        } else {
            settings.beginGroup("ColumnPosition-Narrow");
        }
        try {
            String val = (String)settings.value(col, (Object)"-1");
            width = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                width = (Integer)settings.value(col, (Object)0);
            }
            catch (Exception e1) {
                width = 0;
            }
        }
        settings.endGroup();
        return width;
    }

    public static boolean verifyDelete() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("verifyDelete", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("verifyDelete", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setVerifyDelete(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("verifyDelete", (Object)"true");
        } else {
            settings.setValue("verifyDelete", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean startMinimized() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("startMinimized", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("startMinimized", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setStartMinimized(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("startMinimized", (Object)"true");
        } else {
            settings.setValue("startMinimized", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean synchronizeDeletedContent() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("syncDeletedContent", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("syncDeletedContent", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setSynchronizeDeletedContent(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("syncDeletedContent", (Object)"true");
        } else {
            settings.setValue("syncDeletedContent", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean isWindowVisible(String window) {
        settings.beginGroup("WindowsVisible");
        try {
            String defaultValue = "true";
            if (window.equalsIgnoreCase("noteInformation")) {
                defaultValue = "false";
            }
            String text = (String)settings.value(window, (Object)defaultValue);
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            boolean defaultValue = true;
            if (window.equalsIgnoreCase("noteInformation")) {
                defaultValue = false;
            }
            Boolean value = (Boolean)settings.value("showTrayIcon", (Object)defaultValue);
            settings.endGroup();
            return value;
        }
    }

    public static void saveWindowVisible(String window, boolean val) {
        settings.beginGroup("WindowsVisible");
        if (val) {
            settings.setValue(window, (Object)"true");
        } else {
            settings.setValue(window, (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean isColumnVisible(String window) {
        String defaultValue = "true";
        int view = Global.getListView();
        if (Global.getListView() == View_List_Wide) {
            settings.beginGroup("ColumnsVisible");
        } else {
            settings.beginGroup("ColumnsVisible-Narrow");
        }
        if (window.equalsIgnoreCase("thumbnail") && view == View_List_Wide) {
            defaultValue = "false";
        }
        if (window.equalsIgnoreCase("thumbnail")) {
            defaultValue = "false";
        }
        if (window.equalsIgnoreCase("Guid")) {
            defaultValue = "false";
        }
        try {
            String text = (String)settings.value(window, (Object)defaultValue);
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            boolean defBool = false;
            defBool = window.equalsIgnoreCase("true");
            Boolean value = (Boolean)settings.value(window, (Object)defBool);
            settings.endGroup();
            return value;
        }
    }

    public static void saveColumnVisible(String column, boolean val) {
        if (Global.getListView() == View_List_Wide) {
            settings.beginGroup("ColumnsVisible");
        } else {
            settings.beginGroup("ColumnsVisible-Narrow");
        }
        if (val) {
            settings.setValue(column, (Object)"true");
        } else {
            settings.setValue(column, (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean isEditorButtonVisible(String window) {
        settings.beginGroup("EditorButtonsVisible");
        try {
            String text = (String)settings.value(window, (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value(window, (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void saveEditorButtonsVisible(String column, boolean val) {
        settings.beginGroup("EditorButtonsVisible");
        if (val) {
            settings.setValue(column, (Object)"true");
        } else {
            settings.setValue(column, (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean enableCarriageReturnFix() {
        try {
            settings.beginGroup("Debug");
            String text = (String)settings.value("enableCarriageReturnFix", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("enableCarriageReturnFix", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void saveCarriageReturnFix(boolean val) {
        settings.beginGroup("Debug");
        if (val) {
            settings.setValue("enableCarriageReturnFix", (Object)"true");
        } else {
            settings.setValue("enableCarriageReturnFix", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean enableHtmlEntitiesFix() {
        try {
            settings.beginGroup("Debug");
            String text = (String)settings.value("enableHtmlEntitiesFix", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("enableHtmlEntitiesFix", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void saveHtmlEntitiesFix(boolean val) {
        settings.beginGroup("Debug");
        if (val) {
            settings.setValue("enableHtmlEntitiesFix", (Object)"true");
        } else {
            settings.setValue("enableHtmlEntitiesFix", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setZoomFactor(double val) {
        settings.beginGroup("General");
        settings.setValue("zoomFactor", (Object)val);
        settings.endGroup();
    }

    public static double getZoomFactor() {
        Double threads;
        settings.beginGroup("General");
        try {
            String val = (String)settings.value("zoomFactor", (Object)"1.0");
            threads = new Double(val.trim());
        }
        catch (Exception e) {
            try {
                threads = (Double)settings.value("zoomFactor", (Object)1.0);
            }
            catch (Exception e1) {
                threads = new Double(1.0);
            }
        }
        settings.endGroup();
        return threads;
    }

    public static void setTextSizeMultiplier(double val) {
        settings.beginGroup("General");
        settings.setValue("textMultiplier", (Object)val);
        settings.endGroup();
    }

    public static double getTextSizeMultiplier() {
        Double threads;
        settings.beginGroup("General");
        try {
            String val = (String)settings.value("textMultiplier", (Object)"1");
            threads = new Double(val.trim());
        }
        catch (Exception e) {
            try {
                threads = (Double)settings.value("textMultiplier", (Object)1);
            }
            catch (Exception e1) {
                threads = new Double(1.0);
            }
        }
        settings.endGroup();
        return threads;
    }

    public static boolean getMimicEvernoteInterface() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("mimicEvernoteInterface", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("mimicEvernoteInterface", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setMimicEvernoteInterface(boolean value) {
        settings.beginGroup("General");
        if (value) {
            settings.setValue("mimicEvernoteInterface", (Object)"true");
        } else {
            settings.setValue("mimicEvernoteInterface", (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean synchronizeOnClose() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("synchronizeOnClose", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("synchronizeOnClose", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setSynchronizeOnClose(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("synchronizeOnClose", (Object)"true");
        } else {
            settings.setValue("synchronizeOnClose", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setDatabaseVersion(String version) {
        settings.beginGroup("General");
        settings.setValue("databaseVersion", (Object)version);
        settings.endGroup();
    }

    public static String getDatabaseVersion() {
        settings.beginGroup("General");
        String val = (String)settings.value("databaseVersion", (Object)"0.70");
        settings.endGroup();
        return val;
    }

    public static String getDatabaseUrl() {
        settings.beginGroup("General");
        String val = (String)settings.value("DatabaseURL", (Object)"");
        settings.endGroup();
        if (val.equals("")) {
            val = "jdbc:h2:" + Global.getFileManager().getDbDirPath(databaseName);
        }
        return val;
    }

    public static String getIndexDatabaseUrl() {
        settings.beginGroup("General");
        String val = (String)settings.value("IndexDatabaseURL", (Object)"");
        settings.endGroup();
        if (val.equals("")) {
            val = "jdbc:h2:" + Global.getFileManager().getDbDirPath(indexDatabaseName);
        }
        return val;
    }

    public static String getResourceDatabaseUrl() {
        settings.beginGroup("General");
        String val = (String)settings.value("ResourceDatabaseURL", (Object)"");
        settings.endGroup();
        if (val.equals("")) {
            val = "jdbc:h2:" + Global.getFileManager().getDbDirPath(resourceDatabaseName);
        }
        return val;
    }

    public static String getBehaviorDatabaseUrl() {
        settings.beginGroup("General");
        String val = (String)settings.value("BehaviorDatabaseURL", (Object)"");
        settings.endGroup();
        if (val.equals("")) {
            val = "jdbc:h2:" + Global.getFileManager().getDbDirPath(behaviorDatabaseName);
        }
        return val;
    }

    public static void setDatabaseUrl(String value) {
        settings.beginGroup("General");
        settings.setValue("DatabaseURL", (Object)value);
        settings.endGroup();
    }

    public static void setIndexDatabaseUrl(String value) {
        settings.beginGroup("General");
        settings.setValue("IndexDatabaseURL", (Object)value);
        settings.endGroup();
    }

    public static void setResourceDatabaseUrl(String value) {
        settings.beginGroup("General");
        settings.setValue("ResourceDatabaseURL", (Object)value);
        settings.endGroup();
    }

    public static void setBehaviorDatabaseUrl(String value) {
        settings.beginGroup("General");
        settings.setValue("BehaviorDatabaseURL", (Object)value);
        settings.endGroup();
    }

    public static String getDatabaseUserid() {
        settings.beginGroup("General");
        String val = (String)settings.value("databaseUserid", (Object)"");
        settings.endGroup();
        return val;
    }

    public static String getDatabaseUserPassword() {
        settings.beginGroup("General");
        String val = (String)settings.value("databaseUserPassword", (Object)"");
        settings.endGroup();
        return val;
    }

    public static void setStyle(String style) {
        settings.beginGroup("General");
        settings.setValue("style", (Object)style);
        settings.endGroup();
    }

    public static String getStyle() {
        settings.beginGroup("General");
        String val = (String)settings.value("style", (Object)"Cleanlooks");
        settings.endGroup();
        return val;
    }

    public static boolean useStandardPalette() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("standardPalette", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("standardPalette", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setStandardPalette(boolean val) {
        settings.beginGroup("General");
        if (val) {
            settings.setValue("standardPalette", (Object)"true");
        } else {
            settings.setValue("standardPalette", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setIndexThreadSleepInterval(int sleep) {
        settings.beginGroup("General");
        settings.setValue("IndexThreadSleepInterval", (Object)sleep);
        settings.endGroup();
    }

    public static int getIndexThreadSleepInterval() {
        Integer sleep;
        settings.beginGroup("General");
        try {
            String val = (String)settings.value("IndexThreadSleepInterval", (Object)"300");
            sleep = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                sleep = (Integer)settings.value("IndexThreadSleepInterval", (Object)0);
            }
            catch (Exception e1) {
                sleep = 300;
            }
        }
        settings.endGroup();
        return sleep;
    }

    public static void saveState(String name, QByteArray state) {
        int view = Global.getListView();
        if (view == View_List_Narrow) {
            name = String.valueOf(name) + "Narrow";
        }
        settings.beginGroup("SaveState");
        settings.setValue(name, (Object)state);
        settings.endGroup();
    }

    public static QByteArray restoreState(String name) {
        int view = Global.getListView();
        if (view == View_List_Narrow) {
            name = String.valueOf(name) + "Narrow";
        }
        settings.beginGroup("SaveState");
        QByteArray state = (QByteArray)settings.value(name);
        settings.endGroup();
        return state;
    }

    public static void saveGeometry(String name, QByteArray state) {
        int view = Global.getListView();
        if (view == View_List_Narrow) {
            settings.beginGroup("SaveGeometryNarrow");
        } else {
            settings.beginGroup("SaveGeometry");
        }
        settings.setValue(name, (Object)state);
        settings.endGroup();
    }

    public static QByteArray restoreGeometry(String name) {
        int view = Global.getListView();
        if (view == View_List_Narrow) {
            settings.beginGroup("SaveGeometryNarrow");
        } else {
            settings.beginGroup("SaveGeometry");
        }
        QByteArray state = (QByteArray)settings.value(name);
        settings.endGroup();
        return state;
    }

    public static void setAutoSaveInterval(int interval) {
        settings.beginGroup("General");
        settings.setValue("autoSaveInterval", (Object)interval);
        settings.endGroup();
    }

    public static int getAutoSaveInterval() {
        Integer value;
        settings.beginGroup("General");
        try {
            String val = (String)settings.value("autoSaveInterval", (Object)"5");
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("autoSaveInterval", (Object)5);
            }
            catch (Exception e1) {
                value = 5;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void addInvalidAttribute(String element, String attribute) {
        List attributes = invalidAttributes.get(element);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.size()) {
                if (attribute.equalsIgnoreCase((String)attributes.get(i))) {
                    return;
                }
                ++i;
            }
        }
        if (!invalidAttributes.containsKey(element)) {
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add(attribute);
            invalidAttributes.put(element, attributeList);
        } else {
            ArrayList<String> attributeList = invalidAttributes.get(element);
            attributeList.add(attribute);
            invalidAttributes.put(element, attributeList);
        }
    }

    public static void addInvalidElement(String element) {
        int i = 0;
        while (i < invalidElements.size()) {
            if (element.equalsIgnoreCase(invalidElements.get(i))) {
                return;
            }
            ++i;
        }
        invalidElements.add(element);
    }

    public static String getProxyValue(String key) {
        settings.beginGroup("Proxy");
        String val = (String)settings.value(key, (Object)"");
        settings.endGroup();
        return val;
    }

    public static void setProxyValue(String key, String value) {
        settings.beginGroup("Proxy");
        settings.setValue(key, (Object)value);
        settings.endGroup();
    }

    public static String byteArrayToHexString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int halfbyte = element >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = element & 0xF;
            } while (two_halfs++ < 1);
            ++n2;
        }
        return buf.toString();
    }

    public static boolean getSpellSetting(String value) {
        settings.beginGroup("Spell");
        String text = (String)settings.value(value, (Object)"");
        settings.endGroup();
        if (text.equalsIgnoreCase("true")) {
            return true;
        }
        if (text.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("SPELL_IGNOREDIGITWORDS")) {
            return true;
        }
        if (value.equalsIgnoreCase("SPELL_IGNOREINTERNETADDRESS")) {
            return true;
        }
        if (value.equalsIgnoreCase("SPELL_IGNOREUPPERCASE")) {
            return true;
        }
        return value.equalsIgnoreCase("SPELL_IGNORESENTENCECAPTILIZATION");
    }

    public static void setSpellSetting(String setting, boolean val) {
        settings.beginGroup("Spell");
        if (val) {
            settings.setValue(setting, (Object)"true");
        } else {
            settings.setValue(setting, (Object)"false");
        }
        settings.endGroup();
    }

    public static String tagBehavior() {
        settings.beginGroup("General");
        String text = (String)settings.value("tagBehavior", (Object)"DoNothing");
        settings.endGroup();
        return text;
    }

    public static void setTagBehavior(String value) {
        settings.beginGroup("General");
        settings.setValue("tagBehavior", (Object)value);
        settings.endGroup();
    }

    public static boolean isToolbarButtonVisible(String window) {
        settings.beginGroup("ToolbarButtonsVisible");
        try {
            String text = (String)settings.value(window, (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value(window, (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void saveToolbarButtonsVisible(String column, boolean val) {
        settings.beginGroup("ToolbarButtonsVisible");
        if (val) {
            settings.setValue(column, (Object)"true");
        } else {
            settings.setValue(column, (Object)"false");
        }
        settings.endGroup();
    }

    public static boolean enableThumbnails() {
        settings.beginGroup("Debug");
        try {
            String text = (String)settings.value("thumbnails", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("thumbnails", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setEnableThumbnails(boolean val) {
        settings.beginGroup("Debug");
        if (val) {
            settings.setValue("thumbnails", (Object)"true");
        } else {
            settings.setValue("thumbnails", (Object)"false");
        }
        settings.endGroup();
    }

    public static void trace(boolean resetInterval) {
        String fmt = "MM/dd/yy HH:mm:ss.SSSSSS";
        String dateTimeFormat = new String(fmt);
        SimpleDateFormat simple = new SimpleDateFormat(dateTimeFormat);
        Calendar cal = Calendar.getInstance();
        if (intervalTraceTime == null) {
            intervalTraceTime = Calendar.getInstance();
        }
        if (startTraceTime == null) {
            startTraceTime = Calendar.getInstance();
        }
        float interval = cal.getTimeInMillis() - intervalTraceTime.getTimeInMillis();
        float total = cal.getTimeInMillis() - startTraceTime.getTimeInMillis();
        StackTraceElement[] exceptions = Thread.currentThread().getStackTrace();
        System.out.println("------------------------------------------");
        System.out.println("Date/Time " + simple.format(cal.getTime()));
        System.out.format("Interval Time: %-10.6f%n", Float.valueOf(interval));
        System.out.format("Total Time: %-10.6f%n", Float.valueOf(total));
        int i = 2;
        while (i < 5 && i < exceptions.length) {
            System.out.println(exceptions[i]);
            ++i;
        }
        if (resetInterval) {
            intervalTraceTime = cal;
        }
    }

    public static void traceReset() {
        intervalTraceTime = null;
        startTraceTime = null;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static boolean getDisableViewing() {
        return disableViewing;
    }

    public static int calculateThumbnailZoom(String content) {
        int zoom = 1;
        if (content.indexOf("application/pdf") == -1 && content.indexOf("image/") == -1) {
            String text = StringEscapeUtils.unescapeHtml4((String)content.replaceAll("\\<.*?\\>", ""));
            zoom = 2;
            if (text.length() < 500) {
                zoom = 2;
            }
            if (text.length() < 250) {
                zoom = 3;
            }
            if (text.length() < 100) {
                zoom = 4;
            }
            if (text.length() < 50) {
                zoom = 5;
            }
            if (text.length() < 10) {
                zoom = 6;
            }
        }
        return zoom;
    }

    public static void setListView(int view) {
        settings.beginGroup("General");
        settings.setValue("listView", (Object)view);
        settings.endGroup();
    }

    public static int getListView() {
        Integer value;
        settings.beginGroup("General");
        try {
            String val = (String)settings.value("listView", (Object)View_List_Wide);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("listView", (Object)View_List_Wide);
            }
            catch (Exception e1) {
                value = View_List_Wide;
            }
        }
        settings.endGroup();
        return value;
    }

    public static boolean overrideDefaultFont() {
        settings.beginGroup("Font");
        try {
            String text = (String)settings.value("overrideFont", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("overrideFont", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setOverrideDefaultFont(boolean value) {
        settings.beginGroup("Font");
        settings.setValue("overrideFont", (Object)value);
        settings.endGroup();
    }

    public static String getDefaultFont() {
        settings.beginGroup("Font");
        String val = (String)settings.value("font", (Object)"");
        settings.endGroup();
        return val;
    }

    public static void setDefaultFont(String value) {
        settings.beginGroup("Font");
        settings.setValue("font", (Object)value);
        settings.endGroup();
    }

    public static String getDefaultFontSize() {
        settings.beginGroup("Font");
        String val = (String)settings.value("fontSize", (Object)"");
        settings.endGroup();
        return val;
    }

    public static void setDefaultFontSize(String value) {
        settings.beginGroup("Font");
        settings.setValue("fontSize", (Object)value);
        settings.endGroup();
    }

    public static boolean minimizeOnClose() {
        settings.beginGroup("General");
        try {
            String text = (String)settings.value("minimizeOnClose", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true") && QSystemTrayIcon.isSystemTrayAvailable();
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("minimizeOnClose", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setMinimizeOnClose(boolean value) {
        settings.beginGroup("General");
        settings.setValue("minimizeOnClose", (Object)value);
        settings.endGroup();
    }

    public static boolean checkVersionUpgrade() {
        settings.beginGroup("Upgrade");
        try {
            String text = (String)settings.value("checkForUpdates", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("checkForUpdates", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setCheckVersionUpgrade(boolean value) {
        settings.beginGroup("Upgrade");
        settings.setValue("checkForUpdates", (Object)value);
        settings.endGroup();
    }

    public static String getUpdatesAvailableUrl() {
        settings.beginGroup("Upgrade");
        String text = (String)settings.value("avialableUrl", (Object)"http://puma.cis.ibaraki.ac.jp/products/neighbornote/develop/versions.txt");
        settings.endGroup();
        return text;
    }

    public static String getUpdateAnnounceUrl() {
        settings.beginGroup("Upgrade");
        String text = (String)settings.value("announceUrl", (Object)"http://puma.cis.ibaraki.ac.jp/products/neighbornote/develop/upgrade.html");
        settings.endGroup();
        return text;
    }

    public static String getUpdateDownloadUrl() {
        settings.beginGroup("Upgrade");
        String text = (String)settings.value("downloadUrl", (Object)"http://puma.cis.ibaraki.ac.jp/products/neighbornote/download.html");
        settings.endGroup();
        return text;
    }

    public static boolean indexNoteBody() {
        settings.beginGroup("Index");
        try {
            String value = (String)settings.value("indexNoteBody", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("indexNoteBody", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setIndexNoteTitle(boolean value) {
        settings.beginGroup("Index");
        settings.setValue("indexNoteTitle", (Object)value);
        settings.endGroup();
    }

    public static boolean indexNoteTitle() {
        settings.beginGroup("Index");
        try {
            String value = (String)settings.value("indexNoteTitle", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("indexNoteTitle", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setIndexNoteBody(boolean value) {
        settings.beginGroup("Index");
        settings.setValue("indexNoteBody", (Object)value);
        settings.endGroup();
    }

    public static boolean indexAttachmentsLocally() {
        settings.beginGroup("Index");
        try {
            String value = (String)settings.value("indexAttachmentsLocally", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("indexAttachmentsLocally", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setIndexImageRecognition(boolean value) {
        settings.beginGroup("Index");
        settings.setValue("indexImageRecognition", (Object)value);
        settings.endGroup();
    }

    public static boolean indexImageRecognition() {
        settings.beginGroup("Index");
        try {
            String value = (String)settings.value("indexImageRecognition", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("indexImageRecognition", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setIndexAttachmentsLocally(boolean value) {
        settings.beginGroup("Index");
        settings.setValue("indexAttachmentsLocally", (Object)value);
        settings.endGroup();
    }

    public static boolean anyTagSelectionMatch() {
        settings.beginGroup("General");
        try {
            String value = (String)settings.value("anyTagSelectionMatch", (Object)"false");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("anyTagSelectionMatch", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setAnyTagSelectionMatch(boolean value) {
        settings.beginGroup("General");
        settings.setValue("anyTagSelectionMatch", (Object)value);
        settings.endGroup();
    }

    public static boolean bypassSynchronizationWarning() {
        settings.beginGroup("User");
        try {
            String value = (String)settings.value("bypassSynchronizationWarning", (Object)"false");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("bypassSynchronizationWarning", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setBypassSynchronizationWarning(boolean value) {
        settings.beginGroup("User");
        settings.setValue("bypassSynchronizationWarning", (Object)value);
        settings.endGroup();
    }

    public static String getDatabaseCacheSize() {
        settings.beginGroup("Debug");
        String text = (String)settings.value("databaseCache", (Object)"16384");
        settings.endGroup();
        return text;
    }

    public static void setDatabaseCache(String value) {
        settings.beginGroup("Debug");
        settings.setValue("databaseCache", (Object)value);
        settings.endGroup();
        databaseCache = value;
    }

    public static Object deepCopy(Object oldObj) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            return ois.readObject();
        }
        catch (Exception e) {
            logger.log(Global.logger.LOW, "Exception in ObjectCloner = " + e);
            try {
                oos.close();
                ois.close();
            }
            catch (IOException e2) {
                logger.log(Global.logger.LOW, "Exception in ObjectCloner = " + e2);
                e2.printStackTrace();
            }
            return null;
        }
    }

    public static boolean includeTagChildren() {
        settings.beginGroup("General");
        try {
            String value = (String)settings.value("includeTagChildren", (Object)"false");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("includeTagChildren", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setIncludeTagChildren(boolean value) {
        settings.beginGroup("General");
        settings.setValue("includeTagChildren", (Object)value);
        settings.endGroup();
    }

    public static boolean displayRightToLeft() {
        settings.beginGroup("General");
        try {
            String value = (String)settings.value("displayRightToLeft", (Object)"false");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("displayRightToLeft", (Object)false);
            settings.endGroup();
            return value;
        }
    }

    public static void setDisplayRightToLeft(boolean value) {
        settings.beginGroup("General");
        settings.setValue("displayRightToLeft", (Object)value);
        settings.endGroup();
    }

    public static String getStartupNotebook() {
        settings.beginGroup("General");
        String text = (String)settings.value("startupNotebook", (Object)"");
        settings.endGroup();
        return text;
    }

    public static void setStartupNotebook(String value) {
        settings.beginGroup("General");
        settings.setValue("startupNotebook", (Object)value);
        settings.endGroup();
        databaseCache = value;
    }

    public static void setBrowseWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("browseWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getBrowseWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("browseWeight", (Object)1);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("browseWeight", (Object)1);
            }
            catch (Exception e1) {
                value = 1;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setCopyPasteWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("copyPasteWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getCopyPasteWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("copyPasteWeight", (Object)3);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("copyPasteWeight", (Object)3);
            }
            catch (Exception e1) {
                value = 3;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setAddNewNoteWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("addNewNoteWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getAddNewNoteWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("addNewNoteWeight", (Object)3);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("addNewNoteWeight", (Object)3);
            }
            catch (Exception e1) {
                value = 1;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setRensoItemClickWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("rensoItemClickWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getRensoItemClickWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("rensoItemClickWeight", (Object)10);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("rensoItemClickWeight", (Object)10);
            }
            catch (Exception e1) {
                value = 10;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setSameTagWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("sameTagWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getSameTagWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("sameTagWeight", (Object)2);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("sameTagWeight", (Object)2);
            }
            catch (Exception e1) {
                value = 2;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setSameNotebookWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("sameNotebookWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getSameNotebookWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("sameNotebookWeight", (Object)2);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("sameNotebookWeight", (Object)2);
            }
            catch (Exception e1) {
                value = 2;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setENRelatedNotesWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("enRelatedNotesWeight", (Object)weight);
        settings.endGroup();
    }

    public static int getENRelatedNotesWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("enRelatedNotesWeight", (Object)5);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("enRelatedNotesWeight", (Object)5);
            }
            catch (Exception e1) {
                value = 10;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void setMergeRensoNote(boolean value) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("mergeRensoNoteList", (Object)value);
        settings.endGroup();
    }

    public static boolean getMergeRensoNote() {
        settings.beginGroup("RensoNoteList");
        try {
            String value = (String)settings.value("mergeRensoNoteList", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("mergeRensoNoteList", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setDuplicateRensoNote(boolean value) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("duplicateRensoNoteList", (Object)value);
        settings.endGroup();
    }

    public static boolean getDuplicateRensoNote() {
        settings.beginGroup("RensoNoteList");
        try {
            String value = (String)settings.value("duplicateRensoNoteList", (Object)"true");
            settings.endGroup();
            return value.equals("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("duplicateRensoNoteList", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static boolean verifyExclude() {
        settings.beginGroup("RensoNoteList");
        try {
            String text = (String)settings.value("verifyExclude", (Object)"true");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("verifyExclude", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void setVerifyExclude(boolean val) {
        settings.beginGroup("RensoNoteList");
        if (val) {
            settings.setValue("verifyExclude", (Object)"true");
        } else {
            settings.setValue("verifyExclude", (Object)"false");
        }
        settings.endGroup();
    }

    public static void setRensoListItemMaximum(int maximum) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("rensoListMaximum", (Object)maximum);
        settings.endGroup();
    }

    public static int getRensoListItemMaximum() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("rensoListMaximum", (Object)20);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("rensoListMaximum", (Object)20);
            }
            catch (Exception e1) {
                value = 20;
            }
        }
        settings.endGroup();
        return value;
    }

    public static String extractPlainText(String sourceText) {
        String plainText = sourceText.replaceAll("<.+?>", "");
        plainText = plainText.replaceAll("\\s{2,}", " ");
        String kaigyo = System.getProperty("line.separator");
        plainText = plainText.replaceAll(kaigyo, "");
        plainText = plainText.replaceAll("&#39;", "'");
        plainText = plainText.replaceAll("&quot;", "\"");
        plainText = plainText.replaceAll("&gt;", ">");
        plainText = plainText.replaceAll("&lt;", "<");
        plainText = plainText.replaceAll("&amp;", "&");
        plainText = plainText.replaceAll("&.+?;", "");
        return plainText;
    }

    public static boolean rebuildFullTextNoteTarget(DatabaseConnection dbConn) {
        NSqlQuery nQuery = new NSqlQuery(dbConn.getConnection());
        StringBuilder noteTableTarget = new StringBuilder();
        boolean success = true;
        if (Global.indexNoteBody()) {
            noteTableTarget.append("CONTENTTEXT");
        }
        if (Global.indexNoteTitle()) {
            if (noteTableTarget.length() > 0) {
                noteTableTarget.append(", ");
            }
            noteTableTarget.append("TITLE");
        }
        if (noteTableTarget.length() > 0) {
            nQuery.prepare("CALL FTL_CREATE_INDEX('PUBLIC', 'NOTE', :column);");
            nQuery.bindValue(":column", noteTableTarget.toString());
            if (!nQuery.exec()) {
                success = false;
            }
        }
        return success;
    }

    public static boolean rebuildFullTextResourceTarget(DatabaseConnection dbConn) {
        NSqlQuery rQuery = new NSqlQuery(dbConn.getResourceConnection());
        StringBuilder resourceTableTarget = new StringBuilder();
        boolean success = true;
        if (Global.indexAttachmentsLocally()) {
            resourceTableTarget.append("RESOURCETEXT");
        }
        if (resourceTableTarget.length() > 0) {
            rQuery.prepare("CALL FTL_CREATE_INDEX('PUBLIC', 'NOTERESOURCES', :column);");
            rQuery.bindValue(":column", resourceTableTarget.toString());
            if (!rQuery.exec()) {
                success = false;
            }
        }
        return success;
    }

    public static boolean isHaltLogButton() {
        settings.beginGroup("RensoNoteList");
        try {
            String text = (String)settings.value("haltOperationLog", (Object)"false");
            settings.endGroup();
            return text.equalsIgnoreCase("true");
        }
        catch (ClassCastException e) {
            Boolean value = (Boolean)settings.value("haltOperationLog", (Object)true);
            settings.endGroup();
            return value;
        }
    }

    public static void saveHaltLogButton(boolean val) {
        settings.beginGroup("RensoNoteList");
        if (val) {
            settings.setValue("haltOperationLog", (Object)"true");
        } else {
            settings.setValue("haltOperationLog", (Object)"false");
        }
        settings.endGroup();
    }

    public static String rensoWeightingSelect() {
        settings.beginGroup("RensoNoteList");
        String text = (String)settings.value("rensoWeightingSelect", (Object)"Standard");
        settings.endGroup();
        return text;
    }

    public static void saveRensoWeightingSelect(String val) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("rensoWeightingSelect", (Object)val);
        settings.endGroup();
    }

    public static <E extends Enum<E>> E fromOrdinal(Class<E> enumClass, int ordinal) {
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        return (E)enumArray[ordinal];
    }

    public static int customBrowseWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customBrowseWeight", (Object)1);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customBrowseWeight", (Object)1);
            }
            catch (Exception e1) {
                value = 1;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomBrowseWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customBrowseWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customCopyPasteWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customCopyPasteWeight", (Object)3);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customCopyPasteWeight", (Object)3);
            }
            catch (Exception e1) {
                value = 3;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomCopyPasteWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customCopyPasteWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customAddNewNoteWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customAddNewNoteWeight", (Object)3);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customAddNewNoteWeight", (Object)3);
            }
            catch (Exception e1) {
                value = 3;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomAddNewNoteWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customAddNewNoteWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customRensoItemClickWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customRensoItemClickWeight", (Object)10);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customRensoItemClickWeight", (Object)10);
            }
            catch (Exception e1) {
                value = 10;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomRensoItemClickWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customRensoItemClickWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customSameTagWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customSameTagWeight", (Object)2);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customSameTagWeight", (Object)2);
            }
            catch (Exception e1) {
                value = 2;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomSameTagWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customSameTagWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customSameNotebookWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customSameNotebookWeight", (Object)2);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customSameNotebookWeight", (Object)2);
            }
            catch (Exception e1) {
                value = 2;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomSameNotebookWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customSameNotebookWeight", (Object)weight);
        settings.endGroup();
    }

    public static int customENRelatedNotesWeight() {
        Integer value;
        settings.beginGroup("RensoNoteList");
        try {
            String val = (String)settings.value("customENRelatedNotesWeight", (Object)5);
            value = new Integer(val.trim());
        }
        catch (Exception e) {
            try {
                value = (Integer)settings.value("customENRelatedNotesWeight", (Object)5);
            }
            catch (Exception e1) {
                value = 5;
            }
        }
        settings.endGroup();
        return value;
    }

    public static void saveCustomENRelatedNotesWeight(int weight) {
        settings.beginGroup("RensoNoteList");
        settings.setValue("customENRelatedNotesWeight", (Object)weight);
        settings.endGroup();
    }
}

