/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.Data;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.trolltech.qt.core.QByteArray;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class NoteResourceTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public NoteResourceTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        this.logger.log(this.logger.HIGH, "Creating table NoteResource...");
        if (!query.exec("Create table NoteResources (guid varchar primary key, noteGuid varchar, updateSequenceNumber integer, dataHash varchar, dataSize integer, dataBinary blob, mime varchar, width integer, height integer, duration integer, active integer, recognitionHash varchar, recognitionSize integer, recognitionBinary varchar, attributeSourceUrl varchar, attributeTimestamp timestamp, attributeLatitude double, attributeLongitude double, attributeAltitude double, attributeCameraMake varchar, attributeCameraModel varchar, attributeClientWillIndex varchar, attributeRecoType varchar, attributeFileName varchar,attributeAttachment boolean, isDirty boolean, indexNeeded boolean)")) {
            this.logger.log(this.logger.HIGH, "Table NoteResource creation FAILED!!!");
        }
        if (!query.exec("CREATE INDEX unindexed_resources on noteresources (indexneeded desc, guid);")) {
            this.logger.log(this.logger.HIGH, "Noteresources unindexed_resources index creation FAILED!!!");
        }
        if (!query.exec("CREATE INDEX resources_dataheshhex on noteresources (datahash, guid);")) {
            this.logger.log(this.logger.HIGH, "Noteresources resources_datahash index creation FAILED!!!");
        }
        if (!query.exec("create index RESOURCES_GUID_INDEX on noteresources (noteGuid, guid);")) {
            this.logger.log(this.logger.HIGH, "Noteresources resources_datahash index creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("Drop table NoteResources");
    }

    public void resetDirtyFlag(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Update noteresources set isdirty=false where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error resetting noteresource dirty field. " + query.lastError());
        } else {
            query.exec("commit");
        }
    }

    public void setIndexNeeded(String guid, Boolean indexNeeded) {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Update noteresources set indexNeeded=:needed where guid=:guid");
        query.bindValue(":needed", indexNeeded);
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error setting noteresource indexneeded field: " + query.lastError());
        } else {
            query.exec("commit");
        }
    }

    public List<String> getNextUnindexed(int limit) {
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        if (!query.exec("Select guid from NoteResources where indexNeeded = true limit " + limit)) {
            this.logger.log(this.logger.EXTREME, "NoteResources SQL retrieve has failed on getNextUnindexed(): " + query.lastError());
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            guids.add(guid);
        }
        return guids;
    }

    public List<String> getUnindexed() {
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        if (!query.exec("Select guid from NoteResources where indexNeeded = true")) {
            this.logger.log(this.logger.EXTREME, "NoteResources SQL retrieve has failed on getUnindexed(): " + query.lastError());
        }
        while (query.next()) {
            String guid = new String();
            guid = query.valueString(0);
            guids.add(guid);
        }
        return guids;
    }

    public List<String> getAll() {
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Select guid from noteresources;");
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error getting all note resource guids. " + query.lastError());
        }
        while (query.next()) {
            guids.add(query.valueString(0));
        }
        return guids;
    }

    public List<String> findInkNotes() {
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Select guid from noteresources where mime='application/vnd.evernote.ink'");
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error searching for ink notes. " + query.lastError());
        }
        while (query.next()) {
            guids.add(query.valueString(0));
        }
        return guids;
    }

    public void saveNoteResource(Resource r, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering saveNoteResources: isDirty " + isDirty);
        this.logger.log(this.logger.HIGH, "Note: " + r.getNoteGuid());
        this.logger.log(this.logger.HIGH, "Resource: " + r.getGuid());
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.prepare("Insert Into NoteResources (guid, noteGuid, dataHash, dataSize, dataBinary, updateSequenceNumber, mime, width, height, duration, active, recognitionHash, recognitionSize, recognitionBinary, attributeSourceUrl, attributeTimestamp, attributeLatitude, attributeLongitude, attributeAltitude, attributeCameraMake, attributeCameraModel, attributeClientWillIndex, attributeRecoType, attributeFileName, attributeAttachment, isDirty, indexNeeded) Values(:guid, :noteGuid, :dataHash,:dataSize, :dataBody, :updateSequenceNumber, :mime, :width, :height, :duration, :active, :recognitionHash, :recognitionSize, :recognitionBody, :attributeSourceUrl, :attributeTimestamp, :attributeLatitude, :attributeLongitude, :attributeAltitude, :attributeCameraMake, :attributeCameraModel, :attributeClientWillIndex, :attributeRecoType, :attributeFileName, :attributeAttachment, :isDirty, true)");
        query.bindValue(":guid", r.getGuid());
        query.bindValue(":noteGuid", r.getNoteGuid());
        if (r.getData() != null) {
            query.bindValue(":dataHash", NoteResourceTable.byteArrayToHexString(r.getData().getBodyHash()));
            query.bindValue(":dataSize", r.getData().getSize());
            query.bindBlob(":dataBody", r.getData().getBody());
        }
        query.bindValue(":updateSequenceNumber", r.getUpdateSequenceNum());
        query.bindValue(":mime", r.getMime());
        query.bindValue(":width", new Integer(r.getWidth()));
        query.bindValue(":height", new Integer(r.getHeight()));
        query.bindValue(":duration", new Integer(r.getDuration()));
        query.bindValue(":active", r.isActive());
        if (r.getRecognition() != null) {
            query.bindValue(":recognitionHash", r.getRecognition().getBodyHash());
            query.bindValue(":recognitionSize", r.getRecognition().getSize());
            if (r.getRecognition().getBody() != null) {
                query.bindValue(":recognitionBody", new String(r.getRecognition().getBody()));
            } else {
                query.bindValue(":recognitionBody", "");
            }
        } else {
            query.bindValue(":recognitionHash", "");
            query.bindValue(":recognitionSize", 0);
            query.bindValue(":recognitionBody", "");
        }
        if (r.getAttributes() != null) {
            query.bindValue(":attributeSourceUrl", r.getAttributes().getSourceURL());
            StringBuilder ts = new StringBuilder(simple.format(r.getAttributes().getTimestamp()));
            query.bindValue(":attributeTimestamp", ts.toString());
            query.bindValue(":attributeLatitude", r.getAttributes().getLatitude());
            query.bindValue(":attributeLongitude", r.getAttributes().getLongitude());
            query.bindValue(":attributeAltitude", r.getAttributes().getAltitude());
            query.bindValue(":attributeCameraMake", r.getAttributes().getCameraMake());
            query.bindValue(":attributeCameraModel", r.getAttributes().getCameraModel());
            query.bindValue(":attributeClientWillIndex", r.getAttributes().isClientWillIndex());
            query.bindValue(":attributeRecoType", r.getAttributes().getRecoType());
            query.bindValue(":attributeFileName", r.getAttributes().getFileName());
            query.bindValue(":attributeAttachment", r.getAttributes().isAttachment());
        }
        query.bindValue(":isDirty", isDirty);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "*** NoteResource Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        } else {
            query.exec("commit");
        }
        this.logger.log(this.logger.HIGH, "Leaving DBRunner.saveNoteResources");
    }

    public void expungeNoteResource(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("delete from NoteResources where guid=:guid");
        query.bindValue(":guid", guid);
        query.exec();
        query.exec("commit");
        NSqlQuery query2 = new NSqlQuery(this.db.getConnection());
        query2.prepare("Delete from InkImages where guid=:guid");
        query2.bindValue(":guid", guid);
        query2.exec();
        query2.exec("commit");
    }

    public String getNoteResourceGuidByHashHex(String noteGuid, String hash) {
        this.logger.log(this.logger.HIGH, "Entering DBRunner.getNoteResourceGuidByHashHex");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        boolean check = query.prepare("Select guid from NoteResources where noteGuid=:noteGuid and dataHash=:hash");
        if (check) {
            this.logger.log(this.logger.EXTREME, "NoteResource SQL select prepare was successful.");
        } else {
            this.logger.log(this.logger.EXTREME, "NoteResource SQL select prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":noteGuid", noteGuid);
        query.bindValue(":hash", hash);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "dbRunner.getNoteResourceGuidByHashHex Select failed.Note Guid:" + noteGuid + "Data Body Hash:" + hash);
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        if (!query.next()) {
            this.logger.log(this.logger.MEDIUM, "Note Resource not found.");
            return null;
        }
        return query.valueString(0);
    }

    public Resource getNoteResourceDataBodyByHashHex(String noteGuid, String hash) {
        this.logger.log(this.logger.HIGH, "Entering DBRunner.getNoteResourceDataBodyByHash");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        boolean check = query.prepare("Select guid, mime, from NoteResources where noteGuid=:noteGuid and dataHash=:hash");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "NoteResource SQL select prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.bindValue(":noteGuid", noteGuid);
        query.bindValue(":hash", hash);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "NoteResource Select failed.Note Guid:" + noteGuid + "Data Body Hash:" + hash);
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        if (!query.next()) {
            this.logger.log(this.logger.MEDIUM, "Note Resource not found.");
            return null;
        }
        Resource r = new Resource();
        r.setGuid(query.valueString(0));
        r.setMime(query.valueString(1));
        NSqlQuery binary = new NSqlQuery(this.db.getResourceConnection());
        if (!binary.prepare("Select databinary from NoteResources where guid=:guid")) {
            this.logger.log(this.logger.MEDIUM, "Prepare for NoteResources Binary failed");
            this.logger.log(this.logger.MEDIUM, binary.lastError());
        }
        if (!binary.exec()) {
            this.logger.log(this.logger.MEDIUM, "NoteResources Binary Select failed.Note Guid:" + noteGuid + "Data Body Hash:" + hash);
            this.logger.log(this.logger.MEDIUM, binary.lastError());
        }
        if (!binary.next()) {
            this.logger.log(this.logger.MEDIUM, "Note Resource Binary not found.");
            return null;
        }
        Data d = new Data();
        r.setData(d);
        d.setBody(binary.valueString(0).getBytes());
        this.logger.log(this.logger.HIGH, "Leaving DBRunner.getNoteResourceDataBodyByHash");
        return r;
    }

    public Resource getNoteResource(String guid, boolean withBinary) {
        if (guid == null) {
            return null;
        }
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        String queryString = new String("Select guid, noteGuid, mime, width, height, duration, active, updateSequenceNumber, dataHash, dataSize, recognitionHash, recognitionSize, attributeLatitude, attributeLongitude, attributeAltitude, attributeCameraMake, attributeCameraModel, attributeClientWillIndex, attributeRecoType, attributeFileName, attributeAttachment, attributeSourceUrl  from NoteResources where guid=:guid");
        query.prepare(queryString);
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "NoteResources SQL select has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        Resource r = null;
        if (query.next()) {
            r = new Resource();
            r.setGuid(query.valueString(0));
            r.setNoteGuid(query.valueString(1));
            r.setMime(query.valueString(2));
            r.setWidth(new Short(query.valueString(3)).shortValue());
            r.setHeight(new Short(query.valueString(4)).shortValue());
            r.setDuration(new Short(query.valueString(5)).shortValue());
            r.setActive(new Boolean(query.valueString(6)).booleanValue());
            r.setUpdateSequenceNum(new Integer(query.valueString(7)).intValue());
            Data d = new Data();
            byte[] h = query.valueString(8).getBytes();
            QByteArray hData = new QByteArray(h);
            QByteArray bData = new QByteArray(QByteArray.fromHex((QByteArray)hData));
            d.setBodyHash(bData.toByteArray());
            d.setSize(new Integer(query.valueString(9)).intValue());
            r.setData(d);
            Data rec = new Data();
            if (query.valueObject(10) != null) {
                rec.setBodyHash(query.valueString(10).getBytes());
            }
            if (query.valueObject(11) != null) {
                rec.setSize(new Integer(query.valueString(11)).intValue());
            } else {
                rec.setSize(0);
            }
            r.setRecognition(rec);
            ResourceAttributes a = new ResourceAttributes();
            if (!query.valueString(12).equals("")) {
                a.setLatitude((double)new Float(query.valueString(12)).floatValue());
            }
            if (!query.valueString(13).equals("")) {
                a.setLongitude((double)new Float(query.valueString(13)).floatValue());
            }
            if (!query.valueString(14).equals("")) {
                a.setAltitude((double)new Float(query.valueString(14)).floatValue());
            }
            a.setCameraMake(this.stringValue(query.valueString(15)));
            a.setCameraModel(this.stringValue(query.valueString(16)));
            a.setClientWillIndex(this.booleanValue(query.valueString(17).toString(), false));
            a.setRecoType(this.stringValue(query.valueString(18)));
            a.setFileName(this.stringValue(query.valueString(19)));
            a.setAttachment(this.booleanValue(query.valueString(20).toString(), false));
            a.setSourceURL(query.valueString(21));
            r.setAttributes(a);
            if (withBinary) {
                query.prepare("Select dataBinary from NoteResources where guid=:guid");
                query.bindValue(":guid", r.getGuid());
                query.exec();
                if (query.next()) {
                    byte[] b = query.getBlob(0);
                    r.getData().setBody(b);
                }
            }
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public List<Resource> getNoteResources(String noteGuid, boolean withBinary) {
        if (noteGuid == null) {
            return null;
        }
        res = new ArrayList<Resource>();
        query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Select guid from NoteResources where noteGuid = :noteGuid");
        query.bindValue(":noteGuid", noteGuid);
        if (query.exec()) ** GOTO lbl15
        this.logger.log(this.logger.EXTREME, "NoteResources SQL select has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            guid = query.valueString(0);
            res.add(this.getNoteResource(guid, withBinary));
lbl15:
            // 2 sources

            ** while (query.next())
        }
lbl16:
        // 1 sources

        return res;
    }

    /*
     * Unable to fully structure code
     */
    public List<Resource> getNoteResourcesRecognition(String noteGuid) {
        if (noteGuid == null) {
            return null;
        }
        res = new ArrayList<Resource>();
        query = new NSqlQuery(this.db.getResourceConnection());
        check = query.prepare("Select recognitionHash, recognitionSize, recognitionBinary  from NoteResources where noteGuid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "NoteTable.getNoteRecognition SQL prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        query.bindValue(":guid", noteGuid);
        if (check) ** GOTO lbl27
        this.logger.log(this.logger.EXTREME, "NoteTable.getNoteRecognition exec has failed.");
        this.logger.log(this.logger.MEDIUM, query.lastError());
        return null;
lbl-1000:
        // 1 sources

        {
            r = new Resource();
            res.add(r);
            rec = new Data();
            rec.setBodyHash(query.valueString(0).getBytes());
            x = new String(query.valueString(1));
            if (!x.equals("")) {
                rec.setSize(new Integer(x).intValue());
                rec.setBody(query.valueString(2).getBytes());
            } else {
                rec.setSize(0);
            }
            r.setRecognition(rec);
lbl27:
            // 2 sources

            ** while (query.next())
        }
lbl28:
        // 1 sources

        return res;
    }

    public Resource getNoteResourceRecognition(String guid) {
        if (guid == null) {
            return null;
        }
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        boolean check = query.prepare("Select recognitionHash, recognitionSize, recognitionBinary, noteGuid  from NoteResources where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "NoteTable.getNoteRecognition SQL prepare has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        query.bindValue(":guid", guid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.EXTREME, "NoteTable.getNoteRecognition exec has failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
            return null;
        }
        Resource r = null;
        while (query.next()) {
            r = new Resource();
            Data rec = new Data();
            rec.setBodyHash(query.valueString(0).getBytes());
            String x = new String(query.valueString(1));
            if (!x.equals("")) {
                rec.setSize(new Integer(x).intValue());
                rec.setBody(query.valueString(2).getBytes());
            } else {
                rec.setSize(0);
            }
            r.setRecognition(rec);
            r.setNoteGuid(query.valueString(3));
        }
        return r;
    }

    public void updateNoteResource(Resource r, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteResource");
        this.expungeNoteResource(r.getGuid());
        this.saveNoteResource(r, isDirty);
        this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.updateNoteResource");
    }

    public void updateNoteResourceGuid(String oldGuid, String newGuid, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering RNoteResourceTable.updateNoteResourceGuid");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("update NoteResources set guid=:newGuid, isDirty=:isDirty where guid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":oldGuid", oldGuid);
        query.exec();
        query.exec("commit");
        this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.updateNoteResourceGuid");
    }

    public void resetUpdateSequenceNumber(String guid, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering RNoteResourceTable.updateNoteResourceGuid");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("update NoteResources set updateSequenceNumber=0, isDirty=:isDirty where guid=:guid");
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":guid", guid);
        query.exec();
        query.exec("commit");
        this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.updateNoteResourceGuid");
    }

    public void reindexAll() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("Update NoteResources set indexneeded=true");
        query.exec("commit");
    }

    public int getResourceCount() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("select count(*) from noteresources");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    public int getUnindexedCount() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("select count(*) from noteresources where indexneeded=true");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    private static String byteArrayToHexString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int halfbyte = element >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = element & 0xF;
            } while (two_halfs++ < 1);
            ++n2;
        }
        return buf.toString();
    }

    private String stringValue(Object value) {
        if (value != null && value.toString() != null) {
            return value.toString();
        }
        return null;
    }

    private boolean booleanValue(Object value, boolean unknown) {
        if (value != null && value.toString() != null) {
            try {
                return (Integer)value > 0;
            }
            catch (ClassCastException e) {
                try {
                    String stringValue = (String)value;
                    return stringValue.equalsIgnoreCase("true");
                }
                catch (ClassCastException e1) {
                    return unknown;
                }
            }
        }
        return unknown;
    }

    public void updateNoteSourceUrl(String guid, String url, boolean isDirty) {
        this.logger.log(this.logger.HIGH, "Entering RNoteResourceTable.updateNoteSourceUrl()");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("update NoteResources set attributesourceurl=:url, isDirty=:isDirty where guid=:guid");
        query.bindValue(":guid", guid);
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":url", url);
        query.exec();
        query.exec("commit");
        this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.updateNoteSourceUrl()");
    }

    public String getNoteSourceUrl(String guid) {
        this.logger.log(this.logger.HIGH, "Entering RNoteResourceTable.getNoteSourceUrl()");
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.prepare("Select attributesourceurl from noteresources where guid=:guid");
        query.bindValue(":guid", guid);
        query.exec();
        if (query.next()) {
            this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.getNoteSourceUrl()");
            return query.valueString(0);
        }
        this.logger.log(this.logger.HIGH, "Leaving RNoteResourceTable.getNoteSourceUrl() - no value found");
        return null;
    }

    public List<String> getDistinctNoteGuids() {
        this.logger.log(this.logger.HIGH, "Entering NoteResourceTable.getDistinctNoteGuids()");
        ArrayList<String> guids = new ArrayList<String>();
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("select distinct noteguid from noteresources");
        if (query.next()) {
            guids.add(query.valueString(0));
        }
        this.logger.log(this.logger.HIGH, "Leaving NoteResourceTable.getDistinctNoteGuids()");
        return guids;
    }

    public void resetAllDirty() {
        NSqlQuery query = new NSqlQuery(this.db.getResourceConnection());
        query.exec("update noteresources set isdirty=false");
    }
}

