/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QRectF;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QFont;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QPaintEvent;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPen;
import com.trolltech.qt.gui.QTextOption;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.gui.RensoNoteList;
import cx.fbn.nevernote.sql.DatabaseConnection;
import java.text.SimpleDateFormat;

public class RensoNoteListItem
extends QWidget {
    private final DatabaseConnection conn;
    private final String noteGuid;
    private final String noteTitle;
    private final int relationPoints;
    private final String noteCreated;
    private final String tagNames;
    private String noteContent;
    private final RensoNoteList parent;
    private final boolean isStared;
    private final int allPointSum;
    private final QPalette palette;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public RensoNoteListItem(Note note, int relationPoints, boolean isStared, int allPointSum, DatabaseConnection c, RensoNoteList parent) {
        this.conn = c;
        this.parent = parent;
        this.isStared = isStared;
        this.allPointSum = allPointSum;
        this.noteGuid = new String(note.getGuid());
        this.noteTitle = new String(note.getTitle());
        this.relationPoints = relationPoints;
        SimpleDateFormat simple = new SimpleDateFormat("yyyy/MM/dd");
        this.noteCreated = simple.format(note.getCreated());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < note.getTagNames().size()) {
            sb.append((String)note.getTagNames().get(i));
            if (i + 1 < note.getTagNames().size()) {
                sb.append(String.valueOf(Global.tagDelimeter) + " ");
            }
            ++i;
        }
        this.tagNames = new String(sb);
        this.noteContent = this.conn.getNoteTable().getNoteContentNoUTFConversion(note.getGuid());
        this.noteContent = this.noteContent.replaceAll("<.+?>", "");
        this.noteContent = this.noteContent.replaceAll("\\s{2,}", " ");
        String kaigyo = System.getProperty("line.separator");
        this.noteContent = this.noteContent.replaceAll(kaigyo, "");
        this.palette = new QPalette();
        this.palette.setColor(QPalette.ColorRole.Window, new QColor(255, 255, 255));
        this.setPalette(this.palette);
        this.setAutoFillBackground(true);
        this.setBackgroundRole(QPalette.ColorRole.Window);
    }

    protected void paintEvent(QPaintEvent event) {
        QImage img;
        QPainter painter = new QPainter((QWidget)this);
        painter.setPen(QColor.lightGray);
        painter.drawLine(0, this.rect().height() - 1, this.rect().width() - 1, this.rect().height() - 1);
        QFont relationFont = new QFont();
        relationFont.setPixelSize(25);
        relationFont.setBold(true);
        QFont titleFont = new QFont();
        titleFont.setPixelSize(15);
        titleFont.setBold(true);
        QFont normalFont = new QFont();
        normalFont.setPixelSize(12);
        painter.setPen(QColor.black);
        painter.setFont(titleFont);
        painter.drawText(85, 3, this.size().width() - 85, 20, Qt.AlignmentFlag.AlignLeft.value(), this.noteTitle);
        painter.setFont(normalFont);
        painter.setPen(new QColor(60, 65, 255));
        painter.drawText(85, 23, 75, 17, Qt.AlignmentFlag.AlignLeft.value(), this.noteCreated);
        painter.setPen(QColor.black);
        painter.drawText(165, 23, this.size().width() - 165, 17, Qt.AlignmentFlag.AlignLeft.value(), this.tagNames);
        QPen tmpPen = painter.pen();
        painter.setPen(new QColor(100, 100, 100));
        QTextOption option = new QTextOption();
        option.setAlignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignLeft});
        option.setUseDesignMetrics(true);
        painter.drawText(new QRectF(85.0, 40.0, (double)(this.width() - 85), 45.0), this.noteContent, option);
        painter.setPen(tmpPen);
        double ratio = (double)this.relationPoints / (double)this.allPointSum;
        QColor relationColor = ratio >= 0.8 ? new QColor(255, 0, 0) : (ratio >= 0.5 ? new QColor(255, 100, 0) : new QColor(255, 200, 0));
        painter.setFont(relationFont);
        tmpPen = painter.pen();
        painter.setPen(this.palette().color(QPalette.ColorRole.Window));
        painter.drawText(this.size().width() - 70, this.size().height() - 33, 67, 33, Qt.AlignmentFlag.AlignRight.value(), String.valueOf(String.valueOf((int)(ratio * 100.0))) + "%");
        painter.drawText(this.size().width() - 70, this.size().height() - 33, 73, 33, Qt.AlignmentFlag.AlignRight.value(), String.valueOf(String.valueOf((int)(ratio * 100.0))) + "%");
        painter.drawText(70, this.size().height() - 36, this.size().width() - 70, 36, Qt.AlignmentFlag.AlignRight.value(), String.valueOf(String.valueOf((int)(ratio * 100.0))) + "%");
        painter.drawText(70, this.size().height() - 30, this.size().width() - 70, 30, Qt.AlignmentFlag.AlignRight.value(), String.valueOf(String.valueOf((int)(ratio * 100.0))) + "%");
        painter.setPen(relationColor);
        painter.drawText(70, this.size().height() - 33, this.size().width() - 70, 33, Qt.AlignmentFlag.AlignRight.value(), String.valueOf(String.valueOf((int)(ratio * 100.0))) + "%");
        painter.setPen(tmpPen);
        String thumbnailName = Global.getFileManager().getResDirPath("thumbnail-" + this.noteGuid + ".png");
        QFile thumbnail = new QFile(thumbnailName);
        if (!thumbnail.exists()) {
            img = new QImage();
            img.loadFromData(this.conn.getNoteTable().getThumbnail(this.noteGuid));
        } else {
            img = new QImage(thumbnailName);
        }
        painter.drawImage(2, 4, img, 0, 0, 80, this.rect().height() - 10);
        painter.setPen(QColor.lightGray);
        painter.drawRect(2, 4, 80, this.rect().height() - 10);
        if (this.isStared) {
            QImage starImage = new QImage(String.valueOf(this.iconPath) + "star.png");
            starImage = starImage.scaled(30, 30, Qt.AspectRatioMode.IgnoreAspectRatio, Qt.TransformationMode.SmoothTransformation);
            painter.drawImage(0, 0, starImage, 0, 0, starImage.width(), starImage.height());
        }
        painter.end();
    }

    protected void enterEvent(QEvent e) {
        if (!this.parent.isContextMenuVisible()) {
            this.palette.setColor(QPalette.ColorRole.Window, new QColor(225, 235, 255));
            this.setPalette(this.palette);
        }
    }

    protected void leaveEvent(QEvent e) {
        if (!this.parent.isContextMenuVisible()) {
            this.setDefaultBackground();
        }
    }

    protected void mousePressEvent(QMouseEvent e) {
        this.palette.setColor(QPalette.ColorRole.Window, new QColor(165, 175, 255));
        this.setPalette(this.palette);
        super.mousePressEvent(e);
    }

    public void setDefaultBackground() {
        this.palette.setColor(QPalette.ColorRole.Window, new QColor(255, 255, 255));
        this.setPalette(this.palette);
    }
}

