/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMenuBar;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.gui.ExternalBrowse;

public class ExternalBrowserMenuBar
extends QMenuBar {
    private final ExternalBrowse parent;
    public QAction printAction;
    public QAction emailAction;
    public QAction editFind;
    public QAction editUndo;
    public QAction editRedo;
    public QAction editCut;
    public QAction editPaste;
    public QAction editPasteWithoutFormat;
    public QAction editCopy;
    public QAction formatBold;
    public QAction formatItalic;
    public QAction formatUnderline;
    public QAction formatStrikethrough;
    public QAction formatSuperscript;
    public QAction formatSubscript;
    public QAction formatNumberList;
    public QAction formatBulletList;
    public QAction alignLeftAction;
    public QAction alignRightAction;
    public QAction alignCenterAction;
    public QAction horizontalLineAction;
    public QAction indentAction;
    public QAction outdentAction;
    public QAction spellCheckAction;
    public QMenu fileMenu;
    public QMenu editMenu;
    private QMenu formatMenu;
    private QMenu listMenu;
    private QMenu indentMenu;
    private QMenu alignMenu;

    public ExternalBrowserMenuBar(ExternalBrowse p) {
        this.parent = p;
        this.printAction = new QAction(this.tr("Print"), (QObject)this);
        this.printAction.setToolTip(this.tr("Print the current note"));
        this.printAction.triggered.connect((Object)this.parent, "printNote()");
        this.setupShortcut(this.printAction, "File_Print");
        this.emailAction = new QAction(this.tr("Email"), (QObject)this);
        this.emailAction.setToolTip(this.tr("Email the current note"));
        this.emailAction.triggered.connect((Object)this.parent, "emailNote()");
        this.setupShortcut(this.emailAction, "File_Email");
        this.editFind = new QAction(this.tr("Find In Note"), (QObject)this);
        this.editFind.setToolTip(this.tr("Find a string in the current note"));
        this.editFind.triggered.connect((Object)this.parent, "findText()");
        this.setupShortcut(this.editFind, "Edit_Find_In_Note");
        this.editUndo = new QAction(this.tr("Undo"), (QObject)this);
        this.editUndo.setToolTip(this.tr("Undo"));
        this.editUndo.triggered.connect((Object)this.parent.getBrowserWindow(), "undoClicked()");
        this.setupShortcut(this.editUndo, "Edit_Undo");
        this.editRedo = new QAction(this.tr("Redo"), (QObject)this);
        this.editRedo.setToolTip(this.tr("Redo"));
        this.editRedo.triggered.connect((Object)this.parent.getBrowserWindow(), "redoClicked()");
        this.setupShortcut(this.editRedo, "Edit_Redo");
        this.editCut = new QAction(this.tr("Cut"), (QObject)this);
        this.editCut.setToolTip(this.tr("Cut"));
        this.editCut.triggered.connect((Object)this.parent.getBrowserWindow(), "cutClicked()");
        this.setupShortcut(this.editCut, "Edit_Cut");
        this.editCopy = new QAction(this.tr("Copy"), (QObject)this);
        this.editCopy.setToolTip(this.tr("Copy"));
        this.editCopy.triggered.connect((Object)this.parent.getBrowserWindow(), "copyClicked()");
        this.setupShortcut(this.editCopy, "Edit_Copy");
        this.editPaste = new QAction(this.tr("Paste"), (QObject)this);
        this.editPaste.setToolTip(this.tr("Paste"));
        this.editPaste.triggered.connect((Object)this.parent.getBrowserWindow(), "pasteClicked()");
        this.setupShortcut(this.editPaste, "Edit_Paste");
        this.editPasteWithoutFormat = new QAction(this.tr("Paste Without Formatting"), (QObject)this);
        this.editPasteWithoutFormat.setToolTip(this.tr("Paste Without Formatting"));
        this.editPasteWithoutFormat.triggered.connect((Object)this.parent.getBrowserWindow(), "pasteWithoutFormattingClicked()");
        this.setupShortcut(this.editPasteWithoutFormat, "Edit_Paste_Without_Formatting");
        this.alignLeftAction = new QAction(this.tr("Left"), (QObject)this);
        this.alignLeftAction.setToolTip(this.tr("Left Align"));
        this.alignLeftAction.triggered.connect((Object)this.parent.getBrowserWindow(), "justifyLeftClicked()");
        this.setupShortcut(this.alignLeftAction, "Format_Alignment_Left");
        this.alignRightAction = new QAction(this.tr("Right"), (QObject)this);
        this.alignRightAction.setToolTip(this.tr("Right Align"));
        this.alignRightAction.triggered.connect((Object)this.parent.getBrowserWindow(), "justifyRightClicked()");
        this.setupShortcut(this.alignRightAction, "Format_Alignment_Right");
        this.alignCenterAction = new QAction(this.tr("Center"), (QObject)this);
        this.alignCenterAction.setToolTip(this.tr("Center Align"));
        this.alignCenterAction.triggered.connect((Object)this.parent.getBrowserWindow(), "justifyCenterClicked()");
        this.setupShortcut(this.alignCenterAction, "Format_Alignment_Center");
        this.formatBold = new QAction(this.tr("Bold"), (QObject)this);
        this.formatBold.setToolTip(this.tr("Bold"));
        this.formatBold.triggered.connect((Object)this.parent.getBrowserWindow(), "boldClicked()");
        this.setupShortcut(this.formatBold, "Format_Bold");
        this.formatItalic = new QAction(this.tr("Italic"), (QObject)this);
        this.formatItalic.setToolTip(this.tr("Italic"));
        this.formatItalic.triggered.connect((Object)this.parent.getBrowserWindow(), "italicClicked()");
        this.setupShortcut(this.formatItalic, "Format_Italic");
        this.formatUnderline = new QAction(this.tr("Underline"), (QObject)this);
        this.formatUnderline.setToolTip(this.tr("Underline"));
        this.formatUnderline.triggered.connect((Object)this.parent.getBrowserWindow(), "underlineClicked()");
        this.setupShortcut(this.formatUnderline, "Format_Underline");
        this.formatSuperscript = new QAction(this.tr("Superscript"), (QObject)this);
        this.formatSuperscript.setToolTip(this.tr("Superscript"));
        this.formatSuperscript.triggered.connect((Object)this.parent.getBrowserWindow(), "superscriptClicked()");
        this.setupShortcut(this.formatSuperscript, "Format_Superscript");
        this.formatSubscript = new QAction(this.tr("Subscript"), (QObject)this);
        this.formatSubscript.setToolTip(this.tr("Subscript"));
        this.formatSubscript.triggered.connect((Object)this.parent.getBrowserWindow(), "subscriptClicked()");
        this.setupShortcut(this.formatSubscript, "Format_Subscript");
        this.formatStrikethrough = new QAction(this.tr("Strikethrough"), (QObject)this);
        this.formatStrikethrough.setToolTip(this.tr("Strikethrough"));
        this.formatStrikethrough.triggered.connect((Object)this.parent.getBrowserWindow(), "strikethroughClicked()");
        this.setupShortcut(this.formatStrikethrough, "Format_Strikethrough");
        this.horizontalLineAction = new QAction(this.tr("Horizontal Line"), (QObject)this);
        this.horizontalLineAction.setToolTip(this.tr("Horizontal Line"));
        this.horizontalLineAction.triggered.connect((Object)this.parent.getBrowserWindow(), "hlineClicked()");
        this.setupShortcut(this.horizontalLineAction, "Format_Horizontal_Line");
        this.formatBulletList = new QAction(this.tr("Bulleted List"), (QObject)this);
        this.formatBulletList.triggered.connect((Object)this.parent.getBrowserWindow(), "bulletListClicked()");
        this.setupShortcut(this.formatBulletList, "Format_List_Bullet");
        this.formatNumberList = new QAction(this.tr("Numbered List"), (QObject)this);
        this.formatNumberList.setText(this.tr("Numbered list"));
        this.formatNumberList.triggered.connect((Object)this.parent.getBrowserWindow(), "numberListClicked()");
        this.setupShortcut(this.formatNumberList, "Format_List_Numbered");
        this.indentAction = new QAction(this.tr(">> Increase"), (QObject)this);
        this.indentAction.setText(this.tr(">> Increase"));
        this.indentAction.triggered.connect((Object)this.parent.getBrowserWindow(), "indentClicked()");
        this.setupShortcut(this.indentAction, "Format_Indent_Increase");
        this.outdentAction = new QAction(this.tr("<< Decrease"), (QObject)this);
        this.outdentAction.setText(this.tr("<< Decrease"));
        this.outdentAction.triggered.connect((Object)this.parent.getBrowserWindow(), "outdentClicked()");
        this.setupShortcut(this.outdentAction, "Format_Indent_Decrease");
        this.spellCheckAction = new QAction(this.tr("Spell Check"), (QObject)this);
        this.spellCheckAction.setToolTip(this.tr("Check for spelling errors"));
        this.spellCheckAction.triggered.connect((Object)this.parent.getBrowserWindow(), "spellCheckClicked()");
        this.setupShortcut(this.spellCheckAction, "Tools_Spell_Check");
        this.setupMenuBar();
    }

    public void setupMenuBar() {
        this.fileMenu = this.addMenu(this.tr("&File"));
        this.fileMenu.addSeparator();
        this.fileMenu.addAction(this.emailAction);
        this.fileMenu.addAction(this.printAction);
        this.fileMenu.addSeparator();
        this.editMenu = this.addMenu(this.tr("&Edit"));
        this.editMenu.addAction(this.editFind);
        this.editMenu.addSeparator();
        this.editMenu.addAction(this.editUndo);
        this.editMenu.addAction(this.editRedo);
        this.editMenu.addSeparator();
        this.editMenu.addAction(this.editCut);
        this.editMenu.addAction(this.editCopy);
        this.editMenu.addAction(this.editPaste);
        this.editMenu.addAction(this.editPasteWithoutFormat);
        this.formatMenu = this.addMenu(this.tr("&Format"));
        this.formatMenu.addAction(this.formatBold);
        this.formatMenu.addAction(this.formatUnderline);
        this.formatMenu.addAction(this.formatItalic);
        this.formatMenu.addSeparator();
        this.formatMenu.addAction(this.formatStrikethrough);
        this.formatMenu.addAction(this.horizontalLineAction);
        this.formatMenu.addSeparator();
        this.formatMenu.addAction(this.formatSuperscript);
        this.formatMenu.addAction(this.formatSubscript);
        this.formatMenu.addSeparator();
        this.alignMenu = this.formatMenu.addMenu(this.tr("Alignment"));
        this.alignMenu.addAction(this.alignLeftAction);
        this.alignMenu.addAction(this.alignCenterAction);
        this.alignMenu.addAction(this.alignRightAction);
        this.listMenu = this.formatMenu.addMenu(this.tr("Lists"));
        this.listMenu.addAction(this.formatBulletList);
        this.listMenu.addAction(this.formatNumberList);
        this.indentMenu = this.formatMenu.addMenu(this.tr("Indent"));
        this.indentMenu.addAction(this.indentAction);
        this.indentMenu.addAction(this.outdentAction);
        this.addMenu(this.fileMenu);
        this.addMenu(this.editMenu);
        this.addMenu(this.formatMenu);
    }

    private void setupShortcut(QAction action, String text) {
        if (!Global.shortcutKeys.containsAction(text)) {
            return;
        }
        action.setShortcut(Global.shortcutKeys.getShortcut(text));
    }
}

