/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QIntValidator;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QValidator;
import com.trolltech.qt.gui.QWidget;

public class TableDialog
extends QDialog {
    private boolean okPressed = false;
    private final QSpinBox rows;
    private final QSpinBox cols;
    private final QLineEdit width;
    private final QPushButton ok;
    private final QLabel error;
    private final QIntValidator widthValidator;
    private final QComboBox unit;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public TableDialog() {
        this.setWindowTitle(this.tr("Insert Table"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "table.png"));
        QGridLayout grid = new QGridLayout();
        QGridLayout input = new QGridLayout();
        QGridLayout msgGrid = new QGridLayout();
        QGridLayout button = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.unit = new QComboBox((QWidget)this);
        this.unit.addItem(this.tr("Percent"), (Object)new Boolean(true));
        this.unit.addItem(this.tr("Pixels"), (Object)new Boolean(false));
        this.width = new QLineEdit("80");
        this.widthValidator = new QIntValidator(0, 100, (QObject)this);
        this.width.setValidator((QValidator)this.widthValidator);
        this.width.textChanged.connect((Object)this, "validateWidth()");
        this.rows = new QSpinBox();
        this.cols = new QSpinBox();
        this.rows.setMaximum(30);
        this.rows.setMinimum(1);
        this.cols.setMaximum(30);
        this.cols.setMinimum(1);
        this.unit.activated.connect((Object)this, "unitChanged()");
        input.addWidget((QWidget)new QLabel(this.tr("Rows")), 1, 1);
        input.addWidget((QWidget)this.rows, 1, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Columns")), 2, 1);
        input.addWidget((QWidget)this.cols, 2, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Width")), 3, 1);
        input.addWidget((QWidget)this.width, 3, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Unit")), 4, 1);
        input.addWidget((QWidget)this.unit, 4, 2);
        input.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)input, 1, 1);
        this.error = new QLabel();
        msgGrid.addWidget((QWidget)this.error, 1, 1);
        grid.addLayout((QLayout)msgGrid, 2, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        button.addWidget((QWidget)this.ok, 1, 1);
        button.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)button, 3, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void validateInput() {
        this.ok.setEnabled(false);
        this.ok.setEnabled(true);
    }

    private void validateWidth() {
        if (this.width.text().trim().length() == 0) {
            this.ok.setEnabled(false);
        } else {
            this.ok.setEnabled(true);
        }
    }

    private void unitChanged() {
        int i = this.unit.currentIndex();
        if (((Boolean)this.unit.itemData(i)).booleanValue()) {
            Integer w = new Integer(this.width.text());
            if (w > 100) {
                this.width.setText("80");
            }
            this.widthValidator.setTop(100);
        } else {
            this.widthValidator.setTop(Short.MAX_VALUE);
        }
    }

    public int getRows() {
        return new Integer(this.rows.text());
    }

    public int getCols() {
        return new Integer(this.cols.text());
    }

    public int getWidth() {
        return new Integer(this.width.text());
    }

    public boolean isPercent() {
        int i = this.unit.currentIndex();
        return (Boolean)this.unit.itemData(i);
    }
}

