/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.Data;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.Tag;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.UserStore;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QTextCodec;
import com.trolltech.qt.gui.QMessageBox;
import cx.fbn.nevernote.signals.NoteIndexSignal;
import cx.fbn.nevernote.signals.NoteResourceSignal;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.signals.NotebookSignal;
import cx.fbn.nevernote.signals.SavedSearchSignal;
import cx.fbn.nevernote.signals.StatusSignal;
import cx.fbn.nevernote.signals.SyncSignal;
import cx.fbn.nevernote.signals.TagSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedItemRecord;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private DatabaseConnection conn;
    private boolean idle;
    public boolean error;
    public volatile List<String> errorSharedNotebooks;
    public volatile HashMap<String, String> errorSharedNotebooksIgnored;
    public volatile boolean isConnected;
    public volatile boolean keepRunning;
    public volatile String authToken;
    private long evernoteUpdateCount;
    private final String userAgent = "NeighborNote/" + System.getProperty("os.name") + "/" + System.getProperty("java.vendor") + "/" + System.getProperty("java.version") + ";";
    public volatile NoteStore.Client localNoteStore;
    private UserStore.Client userStore;
    public volatile StatusSignal status;
    public volatile TagSignal tagSignal;
    public volatile NotebookSignal notebookSignal;
    public volatile NoteIndexSignal noteIndexSignal;
    public volatile NoteSignal noteSignal;
    public volatile SavedSearchSignal searchSignal;
    public volatile NoteResourceSignal resourceSignal;
    public volatile SyncSignal syncSignal;
    public volatile boolean authRefreshNeeded;
    public volatile boolean syncNeeded;
    public volatile boolean disableUploads;
    public volatile boolean syncDeletedContent;
    private volatile List<String> dirtyNoteGuids;
    public volatile String username = "";
    public volatile String password = "";
    public volatile String userStoreUrl;
    public String noteStoreUrlBase;
    private THttpClient userStoreTrans;
    private TBinaryProtocol userStoreProt;
    private AuthenticationResult linkedAuthResult;
    private User user;
    public long authRefreshTime;
    public long failedRefreshes = 0L;
    public THttpClient noteStoreTrans;
    public TBinaryProtocol noteStoreProt;
    public String noteStoreUrl;
    public long sequenceDate;
    public int updateSequenceNumber;
    private boolean refreshNeeded;
    private volatile LinkedBlockingQueue<String> workQueue;
    private static int MAX_QUEUED_WAITING = 1000;
    String dbuid;
    String dburl;
    String indexUrl;
    String resourceUrl;
    String behaviorUrl;
    String dbpswd;
    String dbcpswd;
    private final TreeSet<String> ignoreTags;
    private final TreeSet<String> ignoreNotebooks;
    private final TreeSet<String> ignoreLinkedNotebooks;
    private HashMap<String, String> badTagSync;

    public SyncRunner(String logname, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.noteSignal = new NoteSignal();
        this.status = new StatusSignal();
        this.tagSignal = new TagSignal();
        this.notebookSignal = new NotebookSignal();
        this.noteIndexSignal = new NoteIndexSignal();
        this.noteSignal = new NoteSignal();
        this.searchSignal = new SavedSearchSignal();
        this.syncSignal = new SyncSignal();
        this.resourceSignal = new NoteResourceSignal();
        this.resourceUrl = r;
        this.indexUrl = i;
        this.behaviorUrl = b;
        this.dbuid = uid;
        this.dburl = u;
        this.dbpswd = pswd;
        this.dbcpswd = cpswd;
        this.isConnected = false;
        this.syncNeeded = false;
        this.authRefreshNeeded = false;
        this.keepRunning = true;
        this.idle = true;
        this.disableUploads = false;
        this.ignoreTags = new TreeSet();
        this.ignoreNotebooks = new TreeSet();
        this.ignoreLinkedNotebooks = new TreeSet();
        this.workQueue = new LinkedBlockingQueue(MAX_QUEUED_WAITING);
    }

    @Override
    public void run() {
        this.errorSharedNotebooks = new ArrayList<String>();
        this.errorSharedNotebooksIgnored = new HashMap();
        try {
            this.logger.log(this.logger.EXTREME, "Starting thread");
            this.conn = new DatabaseConnection(this.logger, this.dburl, this.indexUrl, this.resourceUrl, this.behaviorUrl, this.dbuid, this.dbpswd, this.dbcpswd, 200);
            while (this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "Blocking until work is found");
                String work = this.workQueue.take();
                this.logger.log(this.logger.LOW, "Dirty Notes Before Sync: " + new Integer(this.conn.getNoteTable().getDirtyCount()).toString());
                this.logger.log(this.logger.EXTREME, "Work found: " + work);
                if (work.equalsIgnoreCase("stop")) {
                    this.idle = false;
                    return;
                }
                this.conn.getNoteTable().dumpDirtyNotes();
                this.idle = false;
                this.error = false;
                if (this.syncNeeded) {
                    this.logger.log(this.logger.EXTREME, "SyncNeeded is true");
                    this.refreshNeeded = false;
                    this.sequenceDate = this.conn.getSyncTable().getLastSequenceDate();
                    this.updateSequenceNumber = this.conn.getSyncTable().getUpdateSequenceNumber();
                    try {
                        this.logger.log(this.logger.EXTREME, "Beginning sync");
                        this.evernoteSync(this.localNoteStore);
                        this.logger.log(this.logger.EXTREME, "Sync finished");
                    }
                    catch (UnknownHostException e) {
                        this.status.message.emit((Object)e.getMessage());
                    }
                }
                this.idle = true;
                this.logger.log(this.logger.EXTREME, "Signaling refresh finished.  refreshNeeded=" + this.refreshNeeded);
                this.syncSignal.finished.emit((Object)this.refreshNeeded);
                if (this.error) {
                    this.syncSignal.errorDisconnect.emit();
                    this.status.message.emit((Object)this.tr("Error synchronizing - see log for details."));
                }
                this.logger.log(this.logger.LOW, "Dirty Notes After Sync: " + new Integer(this.conn.getNoteTable().getDirtyCount()).toString());
                this.conn.getNoteTable().dumpDirtyNotes();
                this.logger.log(this.logger.LOW, "---");
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.conn.dbShutdown();
    }

    public DatabaseConnection getConnection() {
        return this.conn;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setConnected(boolean c) {
        this.isConnected = c;
    }

    public void setKeepRunning(boolean r) {
        this.logger.log(this.logger.EXTREME, "Setting keepRunning=" + r);
        this.keepRunning = r;
    }

    public void setNoteStore(NoteStore.Client c) {
        this.logger.log(this.logger.EXTREME, "Setting NoteStore in sync thread");
        this.localNoteStore = c;
    }

    public void setUserStore(UserStore.Client c) {
        this.logger.log(this.logger.EXTREME, "Setting UserStore in sync thread");
        this.userStore = c;
    }

    public void setEvernoteUpdateCount(long s) {
        this.logger.log(this.logger.EXTREME, "Setting Update Count in sync thread");
        this.evernoteUpdateCount = s;
    }

    private void evernoteSync(NoteStore.Client noteStore) throws UnknownHostException {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.evernoteSync");
        this.ignoreNotebooks.clear();
        List<String> ignore = this.conn.getSyncTable().getIgnoreRecords("NOTEBOOK");
        int i = 0;
        while (i < ignore.size()) {
            this.ignoreNotebooks.add(ignore.get(i));
            ++i;
        }
        ignore.clear();
        ignore = this.conn.getSyncTable().getIgnoreRecords("LINKEDNOTEBOOK");
        i = 0;
        while (i < ignore.size()) {
            this.ignoreLinkedNotebooks.add(ignore.get(i));
            ++i;
        }
        this.ignoreTags.clear();
        ignore = this.conn.getSyncTable().getIgnoreRecords("TAG");
        i = 0;
        while (i < ignore.size()) {
            this.ignoreTags.add(ignore.get(i));
            ++i;
        }
        if (this.isConnected && this.keepRunning) {
            this.error = false;
            this.logger.log(this.logger.EXTREME, "Synchronizing with Evernote");
            this.status.message.emit((Object)this.tr("Synchronizing with Evernote"));
            try {
                this.logger.log(this.logger.EXTREME, "getting user from userstore");
                User user = this.userStore.getUser(this.authToken);
                this.logger.log(this.logger.EXTREME, "Saving user information");
                this.syncSignal.saveUserInformation.emit((Object)user);
            }
            catch (EDAMUserException e1) {
                e1.printStackTrace();
                this.status.message.emit((Object)this.tr("User exception getting user account information.  Aborting sync and disconnecting"));
                this.syncSignal.errorDisconnect.emit();
                this.error = true;
                this.enDisconnect();
                return;
            }
            catch (EDAMSystemException e1) {
                e1.printStackTrace();
                this.status.message.emit((Object)this.tr("System error user account information.  Aborting sync and disconnecting!"));
                this.syncSignal.errorDisconnect.emit();
                this.error = true;
                this.enDisconnect();
                return;
            }
            catch (TException e1) {
                e1.printStackTrace();
                this.syncSignal.errorDisconnect.emit();
                this.error = true;
                this.status.message.emit((Object)this.tr("Transaction error getting user account information.  Aborting sync and disconnecting!"));
                this.enDisconnect();
                return;
            }
            SyncState syncState = null;
            try {
                this.logger.log(this.logger.EXTREME, "Getting sync state");
                syncState = noteStore.getSyncState(this.authToken);
                this.syncSignal.saveUploadAmount.emit((Object)syncState.getUploaded());
                this.syncSignal.saveEvernoteUpdateCount.emit((Object)syncState.getUpdateCount());
                this.evernoteUpdateCount = syncState.getUpdateCount();
            }
            catch (EDAMUserException e) {
                e.printStackTrace();
                this.status.message.emit((Object)this.tr("Error getting sync state! Aborting sync and disconnecting!"));
                this.syncSignal.errorDisconnect.emit();
                this.enDisconnect();
                return;
            }
            catch (EDAMSystemException e) {
                e.printStackTrace();
                this.status.message.emit((Object)this.tr("Error getting sync state! Aborting sync and disconnecting!"));
                this.syncSignal.errorDisconnect.emit();
                this.enDisconnect();
                return;
            }
            catch (TException e) {
                e.printStackTrace();
                this.status.message.emit((Object)this.tr("Error getting sync state! Aborting sync and disconnecting!"));
                this.syncSignal.errorDisconnect.emit();
                this.enDisconnect();
                return;
            }
            if (syncState == null) {
                this.logger.log(this.logger.EXTREME, "Sync State is null");
                this.status.message.emit((Object)this.tr("Syncronization Error!"));
                return;
            }
            this.logger.log(this.logger.LOW, "Full Sequence Before: " + syncState.getFullSyncBefore());
            this.logger.log(this.logger.LOW, "Last Sequence Date: " + this.sequenceDate);
            this.logger.log(this.logger.LOW, "Var Last Sequence Number: " + this.updateSequenceNumber);
            this.logger.log(this.logger.LOW, "DB Last Sequence Number: " + this.conn.getSyncTable().getUpdateSequenceNumber());
            if (syncState.getFullSyncBefore() > this.sequenceDate) {
                this.logger.log(this.logger.EXTREME, "Full sequence date has expired");
                this.sequenceDate = 0L;
                this.conn.getSyncTable().setLastSequenceDate(0L);
                this.updateSequenceNumber = 0;
                this.conn.getSyncTable().setUpdateSequenceNumber(0);
            }
            String syncLinked = this.conn.getSyncTable().getRecord("FullLinkedNotebookSync");
            String syncShared = this.conn.getSyncTable().getRecord("FullSharedNotebookSync");
            String syncNotebooks = this.conn.getSyncTable().getRecord("FullNotebookSync");
            String syncInkNoteImages = this.conn.getSyncTable().getRecord("FullInkNoteImageSync");
            if (syncLinked != null) {
                this.downloadAllLinkedNotebooks(this.localNoteStore);
            }
            if (syncShared != null) {
                this.downloadAllSharedNotebooks(this.localNoteStore);
            }
            if (syncNotebooks != null) {
                this.downloadAllNotebooks(this.localNoteStore);
            }
            if (syncInkNoteImages != null) {
                List<String> guids = this.conn.getNoteTable().noteResourceTable.findInkNotes();
                int i2 = 0;
                while (i2 < guids.size()) {
                    this.downloadInkNoteImage(guids.get(i2), this.authToken);
                    ++i2;
                }
                this.conn.getSyncTable().deleteRecord("FullInkNoteImageSync");
            }
            this.logger.log(this.logger.LOW, "Update Count: " + syncState.getUpdateCount());
            this.logger.log(this.logger.LOW, "Last Update Count: " + this.updateSequenceNumber);
            if (syncState.getUpdateCount() > this.updateSequenceNumber) {
                this.logger.log(this.logger.EXTREME, "Refresh needed is true");
                this.refreshNeeded = true;
                this.logger.log(this.logger.EXTREME, "Downloading changes");
                this.syncRemoteToLocal(this.localNoteStore);
            }
            if (!this.disableUploads) {
                this.logger.log(this.logger.EXTREME, "Uploading changes");
                if (!this.error) {
                    this.syncExpunged(this.localNoteStore);
                }
                if (!this.error) {
                    this.syncLocalTags(this.localNoteStore);
                }
                if (!this.error) {
                    this.syncLocalNotebooks(this.localNoteStore);
                }
                if (!this.error) {
                    this.syncLocalLinkedNotebooks(this.localNoteStore);
                }
                if (!this.error) {
                    this.syncDeletedNotes(this.localNoteStore);
                }
                if (!this.error) {
                    this.syncLocalNotes();
                }
                if (!this.error) {
                    this.syncLocalSavedSearches(this.localNoteStore);
                }
            }
            this.status.message.emit((Object)this.tr("Cleaning up"));
            List<String> notes = this.conn.getNoteTable().expungeIgnoreSynchronizedNotes(this.conn.getSyncTable().getIgnoreRecords("NOTEBOOK"), this.conn.getSyncTable().getIgnoreRecords("TAG"), this.conn.getSyncTable().getIgnoreRecords("LINKEDNOTEBOOK"));
            if (notes.size() > 0) {
                this.syncSignal.refreshLists.emit();
            }
            if (this.refreshNeeded) {
                this.syncSignal.refreshLists.emit();
            }
            if (!this.error) {
                this.logger.log(this.logger.LOW, "Sync completed.  Errors=" + this.error);
                if (!this.disableUploads) {
                    this.status.message.emit((Object)this.tr("Synchronizing complete"));
                } else {
                    this.status.message.emit((Object)this.tr("Download syncronization complete.  Uploads have been disabled."));
                }
                this.logger.log(this.logger.EXTREME, "Saving sync time");
                if (syncState.getCurrentTime() > this.sequenceDate) {
                    this.sequenceDate = syncState.getCurrentTime();
                }
                if (syncState.getUpdateCount() > this.updateSequenceNumber) {
                    this.updateSequenceNumber = syncState.getUpdateCount();
                }
                this.conn.getSyncTable().setLastSequenceDate(this.sequenceDate);
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.evernoteSync");
    }

    private void syncExpunged(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncExpunged");
        List<DeletedItemRecord> expunged = this.conn.getDeletedTable().getAllDeleted();
        boolean error = false;
        int i = 0;
        while (i < expunged.size() && this.keepRunning) {
            try {
                if (expunged.get((int)i).type.equalsIgnoreCase("TAG")) {
                    this.logger.log(this.logger.EXTREME, "Tag expunged");
                    this.conn.getDeletedTable().expungeDeletedItem(expunged.get((int)i).guid, "TAG");
                    this.updateSequenceNumber = noteStore.expungeTag(this.authToken, expunged.get((int)i).guid);
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                    this.conn.getSyncTable().setLastSequenceDate(this.sequenceDate);
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                }
                if (expunged.get((int)i).type.equalsIgnoreCase("NOTEBOOK")) {
                    this.logger.log(this.logger.EXTREME, "Notebook expunged");
                    this.conn.getDeletedTable().expungeDeletedItem(expunged.get((int)i).guid, "NOTEBOOK");
                    this.updateSequenceNumber = noteStore.expungeNotebook(this.authToken, expunged.get((int)i).guid);
                    this.conn.getSyncTable().setLastSequenceDate(this.sequenceDate);
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                }
                if (expunged.get((int)i).type.equalsIgnoreCase("NOTE")) {
                    this.logger.log(this.logger.EXTREME, "Note expunged");
                    this.conn.getDeletedTable().expungeDeletedItem(expunged.get((int)i).guid, "NOTE");
                    this.updateSequenceNumber = noteStore.deleteNote(this.authToken, expunged.get((int)i).guid);
                    this.refreshNeeded = true;
                    this.conn.getSyncTable().setLastSequenceDate(this.sequenceDate);
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                }
                if (expunged.get((int)i).type.equalsIgnoreCase("SAVEDSEARCH")) {
                    this.logger.log(this.logger.EXTREME, "saved search expunged");
                    this.conn.getDeletedTable().expungeDeletedItem(expunged.get((int)i).guid, "SAVEDSEARCH");
                    this.updateSequenceNumber = noteStore.expungeSearch(this.authToken, expunged.get((int)i).guid);
                    this.conn.getSyncTable().setLastSequenceDate(this.sequenceDate);
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                }
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "EDAM User Excepton in syncExpunged: " + expunged.get((int)i).guid);
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "EDAM System Excepton in syncExpunged: " + expunged.get((int)i).guid);
                this.logger.log(this.logger.LOW, e.getStackTrace());
                error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "EDAM Not Found Excepton in syncExpunged: " + expunged.get((int)i).guid);
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "EDAM TExcepton in syncExpunged: " + expunged.get((int)i).guid);
                this.logger.log(this.logger.LOW, e.getStackTrace());
                error = true;
            }
            ++i;
        }
        if (!error) {
            this.conn.getDeletedTable().expungeAllDeletedRecords();
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncExpunged");
    }

    private void syncDeletedNotes(NoteStore.Client noteStore) {
        if (this.syncDeletedContent) {
            return;
        }
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncDeletedNotes");
        this.status.message.emit((Object)this.tr("Synchronizing deleted notes."));
        List<Note> notes = this.conn.getNoteTable().getDirty();
        int i = 0;
        while (i < notes.size() && this.keepRunning) {
            Note enNote = notes.get(i);
            try {
                if (!(enNote.getUpdateSequenceNum() <= 0 || enNote.isActive() && enNote.getDeleted() <= 0L)) {
                    if (enNote.isActive() || enNote.getDeleted() == 0L) {
                        this.conn.getNoteTable().deleteNote(enNote.getGuid());
                        enNote = this.conn.getNoteTable().getNote(enNote.getGuid(), false, false, false, false, false);
                    }
                    if (this.syncDeletedContent) {
                        this.logger.log(this.logger.EXTREME, "Deleted note found & synch content selected");
                        Note delNote = this.conn.getNoteTable().getNote(enNote.getGuid(), true, true, true, true, true);
                        delNote = this.getNoteContent(delNote);
                        delNote = noteStore.updateNote(this.authToken, delNote);
                        enNote.setUpdateSequenceNum(delNote.getUpdateSequenceNum());
                        this.conn.getNoteTable().updateNoteSequence(enNote.getGuid(), enNote.getUpdateSequenceNum());
                    } else {
                        this.logger.log(this.logger.EXTREME, "Deleted note found & sync content not selected");
                        int usn = noteStore.deleteNote(this.authToken, enNote.getGuid());
                        enNote.setUpdateSequenceNum(usn);
                        this.conn.getNoteTable().updateNoteSequence(enNote.getGuid(), enNote.getUpdateSequenceNum());
                    }
                    this.logger.log(this.logger.EXTREME, "Resetting deleted dirty flag");
                    this.conn.getNoteTable().resetDirtyFlag(enNote.getGuid());
                    this.updateSequenceNumber = enNote.getUpdateSequenceNum();
                    this.logger.log(this.logger.EXTREME, "Saving sequence number");
                    this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
                }
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalNotes " + (Object)((Object)e));
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalNotes " + (Object)((Object)e));
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error sending local note: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            ++i;
        }
    }

    private void syncLocalNotes() {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncNotes");
        this.logger.log(this.logger.LOW, "Dirty local notes found: " + new Integer(this.conn.getNoteTable().getDirtyCount()).toString());
        this.status.message.emit((Object)this.tr("Sending local notes."));
        List<Note> notes = this.conn.getNoteTable().getDirty();
        int i = 0;
        while (i < notes.size() && this.keepRunning) {
            this.syncLocalNote(this.localNoteStore, notes.get(i), this.authToken);
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncNotes");
    }

    private void syncLocalNote(NoteStore.Client noteStore, Note enNote, String token) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncNotes");
        this.status.message.emit((Object)this.tr("Sending local notes."));
        if (enNote.isActive()) {
            try {
                if (enNote.getUpdateSequenceNum() > 0) {
                    this.logger.log(this.logger.EXTREME, "Active dirty note found - non new - " + enNote.getGuid());
                    this.logger.log(this.logger.EXTREME, "Fetching note content");
                    enNote = this.getNoteContent(enNote);
                    this.logger.log(this.logger.MEDIUM, "Updating note : " + enNote.getGuid() + " <title>" + enNote.getTitle() + "</title>");
                    enNote = noteStore.updateNote(token, enNote);
                } else {
                    this.logger.log(this.logger.EXTREME, "Active dirty found - new note " + enNote.getGuid());
                    String oldGuid = enNote.getGuid();
                    this.logger.log(this.logger.MEDIUM, "Fetching note content");
                    enNote = this.getNoteContent(enNote);
                    this.logger.log(this.logger.MEDIUM, "Creating note : " + enNote.getGuid() + " <title>" + enNote.getTitle() + "</title>");
                    enNote = noteStore.createNote(token, enNote);
                    this.logger.log(this.logger.MEDIUM, "New note Guid : " + enNote.getGuid() + " <title>" + enNote.getTitle() + "</title>");
                    this.noteSignal.guidChanged.emit((Object)oldGuid, (Object)enNote.getGuid());
                    this.conn.getNoteTable().updateNoteGuid(oldGuid, enNote.getGuid());
                }
                this.updateSequenceNumber = enNote.getUpdateSequenceNum();
                this.logger.log(this.logger.EXTREME, "Saving note");
                this.conn.getNoteTable().updateNoteSequence(enNote.getGuid(), enNote.getUpdateSequenceNum());
                List rl = enNote.getResources();
                this.logger.log(this.logger.EXTREME, "Getting note resources");
                int j = 0;
                while (j < enNote.getResourcesSize() && this.keepRunning) {
                    Resource newRes = (Resource)rl.get(j);
                    Data d = newRes.getData();
                    if (d != null) {
                        this.logger.log(this.logger.EXTREME, "Calculating resource hash");
                        String hash = SyncRunner.byteArrayToHexString(d.getBodyHash());
                        this.logger.log(this.logger.EXTREME, "updating resources by hash");
                        String oldGuid = this.conn.getNoteTable().noteResourceTable.getNoteResourceGuidByHashHex(enNote.getGuid(), hash);
                        this.conn.getNoteTable().updateNoteResourceGuidbyHash(enNote.getGuid(), newRes.getGuid(), hash);
                        this.resourceSignal.resourceGuidChanged.emit((Object)enNote.getGuid(), (Object)oldGuid, (Object)newRes.getGuid());
                    }
                    ++j;
                }
                this.logger.log(this.logger.EXTREME, "Resetting note dirty flag");
                this.conn.getNoteTable().resetDirtyFlag(enNote.getGuid());
                this.updateSequenceNumber = enNote.getUpdateSequenceNum();
                this.logger.log(this.logger.EXTREME, "Emitting note sequence number change");
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error sending local note: ")) + e.getParameter()));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error sending local note: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalNotes " + (Object)((Object)e));
                this.status.message.emit((Object)(String.valueOf(this.tr("Error sending local note: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncLocalNote");
    }

    private void syncLocalNotebooks(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncLocalNotebooks");
        this.status.message.emit((Object)this.tr("Sending local notebooks."));
        List remoteList = new ArrayList();
        try {
            this.logger.log(this.logger.EXTREME, "Getting remote notebooks to compare with local");
            remoteList = noteStore.listNotebooks(this.authToken);
        }
        catch (EDAMUserException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalNotebooks getting remote Notebook List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (EDAMSystemException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalNotebooks getting remote Notebook List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (TException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM Transaction Excepton syncLocalNotebooks getting remote Notebook List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        this.logger.log(this.logger.EXTREME, "Getting local dirty notebooks");
        List<Notebook> notebooks = this.conn.getNotebookTable().getDirty();
        int i = 0;
        while (i < notebooks.size() && this.keepRunning) {
            Notebook enNotebook = notebooks.get(i);
            try {
                int sequence;
                if (enNotebook.getUpdateSequenceNum() > 0) {
                    this.logger.log(this.logger.EXTREME, "Existing notebook is dirty");
                    sequence = noteStore.updateNotebook(this.authToken, enNotebook);
                } else {
                    this.logger.log(this.logger.EXTREME, "New dirty notebook found");
                    String oldGuid = enNotebook.getGuid();
                    boolean found = false;
                    this.logger.log(this.logger.EXTREME, "Looking for matching notebook name");
                    int k = 0;
                    while (k < remoteList.size() && !found && this.keepRunning) {
                        if (((Notebook)remoteList.get(k)).getName().equalsIgnoreCase(enNotebook.getName())) {
                            enNotebook = (Notebook)remoteList.get(k);
                            this.logger.log(this.logger.EXTREME, "Matching notebook found");
                            found = true;
                        }
                        ++k;
                    }
                    if (!found) {
                        enNotebook = noteStore.createNotebook(this.authToken, enNotebook);
                    }
                    this.logger.log(this.logger.EXTREME, "Updating notebook in database");
                    this.conn.getNotebookTable().updateNotebookGuid(oldGuid, enNotebook.getGuid());
                    sequence = enNotebook.getUpdateSequenceNum();
                }
                this.logger.log(this.logger.EXTREME, "Updating notebook sequence in database");
                this.conn.getNotebookTable().updateNotebookSequence(enNotebook.getGuid(), sequence);
                this.logger.log(this.logger.EXTREME, "Resetting dirty flag in notebook");
                this.conn.getNotebookTable().resetDirtyFlag(enNotebook.getGuid());
                this.updateSequenceNumber = sequence;
                this.logger.log(this.logger.EXTREME, "Emitting sequence number to main thread");
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalNotebooks");
                this.logger.log(this.logger.LOW, String.valueOf(e.toString()) + ": Stack : " + enNotebook.getStack());
                this.error = true;
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalNotebooks");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalNotebooks");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalNotebooks");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncLocalNotebooks");
    }

    private void syncLocalTags(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncLocalTags");
        List remoteList = new ArrayList();
        this.status.message.emit((Object)this.tr("Sending local tags."));
        try {
            this.logger.log(this.logger.EXTREME, "Getting remote tags to compare names with the local tags");
            remoteList = noteStore.listTags(this.authToken);
        }
        catch (EDAMUserException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalTags getting remote Tag List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (EDAMSystemException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalTags getting remote Tag List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (TException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM Transaction Excepton syncLocalTags getting remote Tag List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        if (this.badTagSync == null) {
            this.badTagSync = new HashMap();
        } else {
            this.badTagSync.clear();
        }
        Tag enTag = this.findNextTag();
        int maxCount = this.conn.getTagTable().getDirty().size() + 10;
        int loopCount = 0;
        while (enTag != null && loopCount < maxCount) {
            ++loopCount;
            try {
                int sequence;
                if (enTag.getUpdateSequenceNum() > 0) {
                    this.logger.log(this.logger.EXTREME, "Updating tag");
                    sequence = noteStore.updateTag(this.authToken, enTag);
                } else {
                    this.logger.log(this.logger.EXTREME, "New tag.  Comparing with remote names");
                    boolean found = false;
                    String oldGuid = enTag.getGuid();
                    int k = 0;
                    while (k < remoteList.size() && !found && this.keepRunning) {
                        if (((Tag)remoteList.get(k)).getName().equalsIgnoreCase(enTag.getName())) {
                            this.conn.getTagTable().updateTagGuid(enTag.getGuid(), ((Tag)remoteList.get(k)).getGuid());
                            enTag = (Tag)remoteList.get(k);
                            this.logger.log(this.logger.EXTREME, "Matching tag name found");
                            found = true;
                        }
                        ++k;
                    }
                    if (!found) {
                        enTag = noteStore.createTag(this.authToken, enTag);
                    } else {
                        enTag.setUpdateSequenceNum(noteStore.updateTag(this.authToken, enTag));
                    }
                    sequence = enTag.getUpdateSequenceNum();
                    if (!oldGuid.equals(enTag.getGuid())) {
                        this.logger.log(this.logger.EXTREME, "Updating tag guid");
                        this.conn.getTagTable().updateTagGuid(oldGuid, enTag.getGuid());
                    }
                }
                this.logger.log(this.logger.EXTREME, "Updating tag sequence number");
                this.conn.getTagTable().updateTagSequence(enTag.getGuid(), sequence);
                this.logger.log(this.logger.EXTREME, "Resetting tag dirty flag");
                this.conn.getTagTable().resetDirtyFlag(enTag.getGuid());
                this.logger.log(this.logger.EXTREME, "Emitting sequence number to the main thread.");
                this.updateSequenceNumber = sequence;
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalTags: " + enTag.getName());
                this.logger.log(this.logger.LOW, e.toString());
                this.badTagSync.put(enTag.getGuid(), null);
                this.error = true;
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "** EDAM System Excepton syncLocalTags: " + enTag.getName());
                this.logger.log(this.logger.LOW, e.toString());
                this.badTagSync.put(enTag.getGuid(), null);
                this.error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalTags: " + enTag.getName());
                this.logger.log(this.logger.LOW, e.toString());
                this.badTagSync.put(enTag.getGuid(), null);
                this.error = true;
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalTags: " + enTag.getName());
                this.logger.log(this.logger.LOW, e.toString());
                this.badTagSync.put(enTag.getGuid(), null);
                this.error = true;
            }
            this.logger.log(this.logger.EXTREME, "Finding next tag");
            enTag = this.findNextTag();
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncLocalTags");
    }

    private void syncLocalLinkedNotebooks(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncLocalLinkedNotebooks");
        List<String> list = this.conn.getLinkedNotebookTable().getDirtyGuids();
        int i = 0;
        while (i < list.size()) {
            LinkedNotebook book = this.conn.getLinkedNotebookTable().getNotebook(list.get(i));
            try {
                noteStore.updateLinkedNotebook(this.authToken, book);
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalLinkedNotebooks");
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
                e.printStackTrace();
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalLinkedNotebooks");
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
                e.printStackTrace();
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalLinkedNotebooks");
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
                e.printStackTrace();
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalLinkedNotebooks");
                this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e)));
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
                e.printStackTrace();
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncLocalLinkedNotebooks");
    }

    private void syncLocalSavedSearches(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncLocalSavedSearches");
        List remoteList = new ArrayList();
        this.status.message.emit((Object)this.tr("Sending saved searches."));
        this.logger.log(this.logger.EXTREME, "Getting saved searches to compare with local");
        try {
            remoteList = noteStore.listSearches(this.authToken);
        }
        catch (EDAMUserException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalTags getting remote saved search List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (EDAMSystemException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM System Excepton syncLocalTags getting remote saved search List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        catch (TException e1) {
            this.logger.log(this.logger.LOW, "*** EDAM Transaction Excepton syncLocalTags getting remote saved search List");
            this.status.message.emit((Object)(String.valueOf(this.tr("Error: ")) + (Object)((Object)e1)));
            this.logger.log(this.logger.LOW, e1.toString());
            this.error = true;
        }
        List<SavedSearch> searches = this.conn.getSavedSearchTable().getDirty();
        this.logger.log(this.logger.EXTREME, "Beginning to send saved searches");
        int i = 0;
        while (i < searches.size() && this.keepRunning) {
            SavedSearch enSearch = searches.get(i);
            try {
                int sequence;
                if (enSearch.getUpdateSequenceNum() > 0) {
                    sequence = noteStore.updateSearch(this.authToken, enSearch);
                } else {
                    this.logger.log(this.logger.EXTREME, "New saved search found.");
                    boolean found = false;
                    this.logger.log(this.logger.EXTREME, "Matching remote saved search names with local");
                    int k = 0;
                    while (k < remoteList.size() && !found && this.keepRunning) {
                        if (((SavedSearch)remoteList.get(k)).getName().equalsIgnoreCase(enSearch.getName())) {
                            enSearch = (SavedSearch)remoteList.get(k);
                            found = true;
                            this.logger.log(this.logger.EXTREME, "Matching saved search found");
                            sequence = enSearch.getUpdateSequenceNum();
                        }
                        ++k;
                    }
                    String oldGuid = enSearch.getGuid();
                    if (!found) {
                        enSearch = noteStore.createSearch(this.authToken, enSearch);
                    }
                    sequence = enSearch.getUpdateSequenceNum();
                    this.logger.log(this.logger.EXTREME, "Updating tag guid in local database");
                    this.conn.getSavedSearchTable().updateSavedSearchGuid(oldGuid, enSearch.getGuid());
                }
                this.logger.log(this.logger.EXTREME, "Updating tag sequence in local database");
                this.conn.getSavedSearchTable().updateSavedSearchSequence(enSearch.getGuid(), sequence);
                this.logger.log(this.logger.EXTREME, "Resetting tag dirty flag");
                this.conn.getSavedSearchTable().resetDirtyFlag(enSearch.getGuid());
                this.logger.log(this.logger.EXTREME, "Emitting sequence number to the main thread.");
                this.updateSequenceNumber = sequence;
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
            catch (EDAMUserException e) {
                this.logger.log(this.logger.LOW, "*** EDAM User Excepton syncLocalTags");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMSystemException e) {
                this.logger.log(this.logger.LOW, "** EDAM System Excepton syncLocalTags");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (EDAMNotFoundException e) {
                this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton syncLocalTags");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            catch (TException e) {
                this.logger.log(this.logger.LOW, "*** EDAM TExcepton syncLocalTags");
                this.logger.log(this.logger.LOW, e.toString());
                this.error = true;
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncLocalSavedSearches");
    }

    private void syncRemoteToLocal(NoteStore.Client noteStore) {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.syncRemoteToLocal");
        List<Note> dirtyNotes = this.conn.getNoteTable().getDirty();
        this.dirtyNoteGuids = new ArrayList<String>();
        int i = 0;
        while (i < dirtyNotes.size() && this.keepRunning) {
            this.dirtyNoteGuids.add(dirtyNotes.get(i).getGuid());
            ++i;
        }
        int chunkSize = 10;
        SyncChunk chunk = null;
        boolean fullSync = false;
        boolean more = true;
        if (this.updateSequenceNumber == 0) {
            fullSync = true;
        }
        this.status.message.emit((Object)this.tr("Downloading 0% complete."));
        while (more && this.keepRunning) {
            int sequence = this.updateSequenceNumber;
            try {
                this.logger.log(this.logger.EXTREME, "Getting chunk from Evernote");
                chunk = noteStore.getSyncChunk(this.authToken, sequence, chunkSize, fullSync);
                this.logger.log(this.logger.LOW, "Chunk High Sequence: " + chunk.getChunkHighUSN());
            }
            catch (EDAMUserException e) {
                this.error = true;
                e.printStackTrace();
                this.status.message.emit((Object)e.getMessage());
            }
            catch (EDAMSystemException e) {
                this.error = true;
                e.printStackTrace();
                this.status.message.emit((Object)e.getMessage());
            }
            catch (TException e) {
                this.error = true;
                e.printStackTrace();
                this.status.message.emit((Object)e.getMessage());
            }
            if (this.error || chunk == null) {
                return;
            }
            this.syncRemoteTags(chunk.getTags());
            this.syncRemoteSavedSearches(chunk.getSearches());
            this.syncRemoteNotebooks(chunk.getNotebooks());
            this.syncRemoteNotes(noteStore, chunk.getNotes(), fullSync, this.authToken);
            this.syncRemoteResources(noteStore, chunk.getResources());
            this.syncRemoteLinkedNotebooks(chunk.getLinkedNotebooks());
            int i2 = 0;
            while (i2 < chunk.getNotesSize()) {
                this.noteSignal.noteChanged.emit((Object)((Note)chunk.getNotes().get(i2)).getGuid(), null);
                ++i2;
            }
            this.syncExpungedNotes(chunk);
            if (chunk.getChunkHighUSN() <= this.updateSequenceNumber) {
                more = false;
            }
            if (this.error) {
                more = false;
            }
            this.logger.log(this.logger.EXTREME, "More notes? " + more);
            if (!this.error && chunk.getChunkHighUSN() > 0 && this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "emitting sequence number to main thread");
                this.updateSequenceNumber = chunk.getChunkHighUSN();
                this.conn.getSyncTable().setLastSequenceDate(chunk.getCurrentTime());
                this.conn.getSyncTable().setUpdateSequenceNumber(this.updateSequenceNumber);
            }
            if (!more) continue;
            long pct = chunk.getChunkHighUSN() * 100;
            this.conn.getSyncTable().setLastSequenceDate(chunk.getCurrentTime());
            this.status.message.emit((Object)(String.valueOf(this.tr("Downloading ")) + new Long(pct /= this.evernoteUpdateCount).toString() + this.tr("% complete.")));
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.syncRemoteToLocal");
    }

    private void syncExpungedNotes(SyncChunk chunk) {
        int i;
        this.logger.log(this.logger.EXTREME, "Doing local deletes");
        List guid = chunk.getExpungedNotes();
        if (guid != null) {
            i = 0;
            while (i < guid.size() && this.keepRunning) {
                String notebookGuid = "";
                Note localNote = this.conn.getNoteTable().getNote((String)guid.get(i), false, false, false, false, false);
                if (localNote != null) {
                    this.conn.getNoteTable().updateNoteSequence((String)guid.get(i), 0);
                    notebookGuid = localNote.getNotebookGuid();
                }
                if (!this.conn.getNotebookTable().isNotebookLocal(notebookGuid) || localNote == null) {
                    this.logger.log(this.logger.EXTREME, "Expunging local note from database");
                    this.conn.getNoteTable().expungeNote((String)guid.get(i), true, false);
                }
                ++i;
            }
        }
        if ((guid = chunk.getExpungedNotebooks()) != null) {
            i = 0;
            while (i < guid.size() && this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "Expunging local notebook from database");
                this.conn.getNotebookTable().expungeNotebook((String)guid.get(i), false);
                ++i;
            }
        }
        if ((guid = chunk.getExpungedTags()) != null) {
            i = 0;
            while (i < guid.size() && this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "Expunging tags from local database");
                this.conn.getTagTable().expungeTag((String)guid.get(i), false);
                ++i;
            }
        }
        if ((guid = chunk.getExpungedSearches()) != null) {
            i = 0;
            while (i < guid.size() && this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "Expunging saved search from local database");
                this.conn.getSavedSearchTable().expungeSavedSearch((String)guid.get(i), false);
                ++i;
            }
        }
        if ((guid = chunk.getExpungedLinkedNotebooks()) != null) {
            i = 0;
            while (i < guid.size() && this.keepRunning) {
                this.logger.log(this.logger.EXTREME, "Expunging linked notebook from local database");
                this.conn.getLinkedNotebookTable().expungeNotebook((String)guid.get(i), false);
                ++i;
            }
        }
    }

    private void syncRemoteTags(List<Tag> tags) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteTags");
        if (tags != null) {
            int i = 0;
            while (i < tags.size() && this.keepRunning) {
                String oldGuid = this.conn.getTagTable().findTagByName(tags.get(i).getName());
                if (oldGuid != null && !tags.get(i).getGuid().equalsIgnoreCase(oldGuid)) {
                    this.conn.getTagTable().updateTagGuid(oldGuid, tags.get(i).getGuid());
                }
                this.conn.getTagTable().syncTag(tags.get(i), false);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteTags");
    }

    private void syncRemoteSavedSearches(List<SavedSearch> searches) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncSavedSearches");
        if (searches != null) {
            int i = 0;
            while (i < searches.size() && this.keepRunning) {
                String oldGuid = this.conn.getSavedSearchTable().findSavedSearchByName(searches.get(i).getName());
                if (oldGuid != null && !searches.get(i).getGuid().equalsIgnoreCase(oldGuid)) {
                    this.conn.getSavedSearchTable().updateSavedSearchGuid(oldGuid, searches.get(i).getGuid());
                }
                this.conn.getSavedSearchTable().syncSavedSearch(searches.get(i), false);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncSavedSearches");
    }

    private void syncRemoteLinkedNotebooks(List<LinkedNotebook> books) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncLinkedNotebooks");
        if (books != null) {
            int i = 0;
            while (i < books.size() && this.keepRunning) {
                this.conn.getLinkedNotebookTable().updateNotebook(books.get(i), false);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncLinkedNotebooks");
    }

    private void syncRemoteNotebooks(List<Notebook> notebooks) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteNotebooks");
        if (notebooks != null) {
            int i = 0;
            while (i < notebooks.size() && this.keepRunning) {
                String oldGuid = this.conn.getNotebookTable().findNotebookByName(notebooks.get(i).getName());
                if (oldGuid != null && !this.conn.getNotebookTable().isNotebookLocal(oldGuid) && !notebooks.get(i).getGuid().equalsIgnoreCase(oldGuid)) {
                    this.conn.getNotebookTable().updateNotebookGuid(oldGuid, notebooks.get(i).getGuid());
                }
                this.conn.getNotebookTable().syncNotebook(notebooks.get(i), false);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteNotebooks");
    }

    private void syncRemoteResources(NoteStore.Client noteStore, List<Resource> resource) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteResources");
        if (resource != null) {
            int i = 0;
            while (i < resource.size() && this.keepRunning) {
                this.syncRemoteResource(noteStore, resource.get(i), this.authToken);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteResources");
    }

    private void syncRemoteResource(NoteStore.Client noteStore, Resource resource, String authToken) {
        Note n = this.conn.getNoteTable().getNote(resource.getNoteGuid(), false, false, false, false, false);
        if (n != null) {
            this.logger.log(this.logger.HIGH, "Resource for note " + n.getGuid() + " : " + n.getTitle());
        }
        boolean saveNeeded = false;
        Resource r = this.getEvernoteResource(noteStore, resource.getGuid(), true, true, true, authToken);
        Resource l = this.conn.getNoteTable().noteResourceTable.getNoteResource(r.getGuid(), false);
        if (l == null) {
            this.logger.log(this.logger.HIGH, "Local resource not found");
            saveNeeded = true;
        } else {
            boolean isNoteDirty = this.conn.getNoteTable().isNoteDirty(r.getNoteGuid());
            if (!isNoteDirty) {
                this.logger.log(this.logger.HIGH, "Local resource found, but is not dirty");
                saveNeeded = true;
            } else {
                String remoteHash = "";
                if (r != null && r.getData() != null && r.getData().getBodyHash() != null) {
                    remoteHash = SyncRunner.byteArrayToHexString(r.getData().getBodyHash());
                }
                String localHash = "";
                if (l != null && l.getData() != null && l.getData().getBodyHash() != null) {
                    remoteHash = SyncRunner.byteArrayToHexString(l.getData().getBodyHash());
                }
                if (localHash.equalsIgnoreCase(remoteHash)) {
                    saveNeeded = true;
                }
            }
        }
        this.logger.log(this.logger.HIGH, "Resource save needed: " + saveNeeded);
        if (saveNeeded) {
            this.conn.getNoteTable().noteResourceTable.updateNoteResource(r, false);
        }
        if (r.getMime().equalsIgnoreCase("application/vnd.evernote.ink")) {
            this.downloadInkNoteImage(r.getGuid(), authToken);
        }
    }

    private void syncRemoteNotes(NoteStore.Client noteStore, List<Note> note, boolean fullSync, String token) {
        if (note != null) {
            this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteNotes");
            this.logger.log(this.logger.LOW, "Local Dirty Notes: ");
            this.logger.log(this.logger.LOW, "Remote Dirty Notes:");
            int i = 0;
            while (i < note.size()) {
                this.logger.log(this.logger.LOW, String.valueOf(i) + " : " + note.get(i).getGuid() + " : " + note.get(i).getTitle());
                ++i;
            }
            this.logger.log(this.logger.LOW, "---");
            i = 0;
            while (i < note.size() && this.keepRunning) {
                Note n = this.getEvernoteNote(noteStore, note.get(i).getGuid(), true, fullSync, true, true, token);
                this.syncRemoteNote(n, fullSync, token);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteNotes");
    }

    private void syncRemoteNote(Note n, boolean fullSync, String token) {
        if (n != null) {
            boolean conflictingNote = true;
            this.logger.log(this.logger.EXTREME, "Checking for duplicate note " + n.getGuid() + " : " + n.getTitle());
            if (this.dirtyNoteGuids != null && this.dirtyNoteGuids.contains(n.getGuid())) {
                this.logger.log(this.logger.EXTREME, "Conflict check beginning");
                conflictingNote = this.checkForConflict(n);
                this.logger.log(this.logger.EXTREME, "Conflict check results " + conflictingNote);
                if (conflictingNote) {
                    this.moveConflictingNote(n.getGuid());
                }
            }
            boolean ignoreNote = false;
            if (this.ignoreNotebooks.contains(n.getNotebookGuid())) {
                ignoreNote = true;
            }
            int i = 0;
            while (i < n.getTagGuidsSize()) {
                if (this.ignoreTags.contains(n.getTagGuids().get(i))) {
                    ignoreNote = true;
                    i = n.getTagGuidsSize();
                }
                ++i;
            }
            if ((conflictingNote || fullSync) && !ignoreNote) {
                this.logger.log(this.logger.EXTREME, "Saving Note");
                this.conn.getNoteTable().syncNote(n);
                this.noteSignal.noteDownloaded.emit((Object)n, (Object)true);
                this.logger.log(this.logger.EXTREME, "Note Saved");
                if (fullSync && n.getResources() != null) {
                    int q = 0;
                    while (q < n.getResources().size() && this.keepRunning) {
                        this.logger.log(this.logger.EXTREME, "Getting note resources.");
                        this.conn.getNoteTable().noteResourceTable.updateNoteResource((Resource)n.getResources().get(q), false);
                        if (((Resource)n.getResources().get(q)).getMime().equalsIgnoreCase("application/vnd.evernote.ink")) {
                            this.downloadInkNoteImage(((Resource)n.getResources().get(q)).getGuid(), token);
                        }
                        ++q;
                    }
                }
            }
        }
    }

    private Note getEvernoteNote(NoteStore.Client noteStore, String guid, boolean withContent, boolean withResourceData, boolean withResourceRecognition, boolean withResourceAlternateData, String token) {
        Note n = null;
        try {
            this.logger.log(this.logger.EXTREME, "Retrieving note " + guid);
            n = noteStore.getNote(token, guid, withContent, withResourceData, withResourceRecognition, withResourceAlternateData);
            this.logger.log(this.logger.EXTREME, "Note " + guid + " has been retrieved.");
        }
        catch (EDAMUserException e) {
            this.logger.log(this.logger.LOW, "*** EDAM User Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (EDAMSystemException e) {
            this.logger.log(this.logger.LOW, "*** EDAM System Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (EDAMNotFoundException e) {
            this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (TException e) {
            this.logger.log(this.logger.LOW, "*** EDAM TExcepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        return n;
    }

    private Resource getEvernoteResource(NoteStore.Client noteStore, String guid, boolean withData, boolean withRecognition, boolean withAttributes, String token) {
        Resource n = null;
        try {
            this.logger.log(this.logger.EXTREME, "Retrieving resource " + guid);
            n = noteStore.getResource(token, guid, withData, withRecognition, withAttributes, withAttributes);
            this.logger.log(this.logger.EXTREME, "Resource " + guid + " has been retrieved.");
        }
        catch (EDAMUserException e) {
            this.logger.log(this.logger.LOW, "*** EDAM User Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (EDAMSystemException e) {
            this.logger.log(this.logger.LOW, "*** EDAM System Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (EDAMNotFoundException e) {
            this.logger.log(this.logger.LOW, "*** EDAM Not Found Excepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        catch (TException e) {
            this.logger.log(this.logger.LOW, "*** EDAM TExcepton getEvernoteNote");
            this.logger.log(this.logger.LOW, e.toString());
            this.error = true;
            e.printStackTrace();
        }
        return n;
    }

    private boolean checkForConflict(Note n) {
        this.logger.log(this.logger.EXTREME, "Checking note sequence number  " + n.getGuid());
        Note oldNote = this.conn.getNoteTable().getNote(n.getGuid(), false, false, false, false, false);
        this.logger.log(this.logger.EXTREME, "Local/Remote sequence numbers: " + oldNote.getUpdateSequenceNum() + "/" + n.getUpdateSequenceNum());
        this.logger.log(this.logger.LOW, "Remote Note Title:" + n.getTitle());
        this.logger.log(this.logger.LOW, "Local Note Title:" + oldNote.getTitle());
        if (oldNote.getUpdateSequenceNum() == n.getUpdateSequenceNum()) {
            return false;
        }
        boolean oldIsDirty = this.conn.getNoteTable().isNoteDirty(n.getGuid());
        return oldIsDirty;
    }

    private void moveConflictingNote(String guid) {
        long prevTime;
        Long l;
        this.logger.log(this.logger.EXTREME, "Conflicting change found for note " + guid);
        List<Notebook> books = this.conn.getNotebookTable().getAllLocal();
        String notebookGuid = null;
        int i = 0;
        while (i < books.size() && this.keepRunning) {
            if (books.get(i).getName().equalsIgnoreCase("Conflicting Changes (local)") || books.get(i).getName().equalsIgnoreCase("Conflicting Changes")) {
                notebookGuid = books.get(i).getGuid();
                i = books.size();
            }
            ++i;
        }
        if (notebookGuid == null) {
            this.logger.log(this.logger.EXTREME, "Building conflicting change notebook " + guid);
            GregorianCalendar currentTime = new GregorianCalendar();
            l = new Long(currentTime.getTimeInMillis());
            prevTime = l;
            while (prevTime == l) {
                currentTime = new GregorianCalendar();
                l = currentTime.getTimeInMillis();
            }
            String randint = new String(Long.toString(l));
            Notebook newBook = new Notebook();
            newBook.setUpdateSequenceNum(0);
            newBook.setGuid(randint);
            newBook.setName("Conflicting Changes");
            newBook.setServiceCreated(new Date().getTime());
            newBook.setServiceUpdated(new Date().getTime());
            newBook.setDefaultNotebook(false);
            newBook.setPublished(false);
            this.conn.getNotebookTable().addNotebook(newBook, false, true);
            this.notebookSignal.listChanged.emit();
            notebookGuid = newBook.getGuid();
            this.refreshNeeded = true;
        }
        this.logger.log(this.logger.EXTREME, "Moving conflicting note " + guid);
        GregorianCalendar currentTime = new GregorianCalendar();
        l = new Long(currentTime.getTimeInMillis());
        prevTime = l;
        while (prevTime == l) {
            currentTime = new GregorianCalendar();
            l = currentTime.getTimeInMillis();
        }
        String newGuid = new String(Long.toString(l));
        Note oldNote = this.conn.getNoteTable().getNote(guid, true, true, false, false, false);
        int i2 = 0;
        while (i2 < oldNote.getResources().size() && this.keepRunning) {
            l = new Long(currentTime.getTimeInMillis());
            String newResG = new String(Long.toString(l));
            String oldResG = ((Resource)oldNote.getResources().get(i2)).getGuid();
            this.conn.getNoteTable().noteResourceTable.resetUpdateSequenceNumber(oldResG, true);
            this.conn.getNoteTable().noteResourceTable.updateNoteResourceGuid(oldResG, newResG, true);
            ++i2;
        }
        this.conn.getNoteTable().resetNoteSequence(guid);
        this.conn.getNoteTable().updateNoteGuid(guid, newGuid);
        this.conn.getNoteTable().updateNoteNotebook(newGuid, notebookGuid, true);
        this.noteSignal.notebookChanged.emit((Object)newGuid, (Object)notebookGuid);
        this.refreshNeeded = true;
        this.noteSignal.guidChanged.emit((Object)guid, (Object)newGuid);
    }

    private static String byteArrayToHexString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int halfbyte = element >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = element & 0xF;
            } while (two_halfs++ < 1);
            ++n2;
        }
        return buf.toString();
    }

    private Tag findNextTag() {
        this.logger.log(this.logger.HIGH, "Entering SyncRunner.findNextTag");
        Tag nextTag = null;
        List<Tag> tags = this.conn.getTagTable().getDirty();
        int i = 0;
        while (i < tags.size() && this.keepRunning) {
            if (!this.badTagSync.containsKey(tags.get(i).getGuid())) {
                if (tags.get(i).getParentGuid() == null) {
                    this.logger.log(this.logger.HIGH, "Leaving SyncRunner.findNextTag - tag found without parent");
                    return tags.get(i);
                }
                Tag parentTag = this.conn.getTagTable().getTag(tags.get(i).getParentGuid());
                if (parentTag.getUpdateSequenceNum() > 0) {
                    this.logger.log(this.logger.HIGH, "Leaving SyncRunner.findNextTag - tag found");
                    return tags.get(i);
                }
            }
            ++i;
        }
        this.logger.log(this.logger.HIGH, "Leaving SyncRunner.findNextTag - no tags returned");
        return nextTag;
    }

    public boolean enConnect() {
        QMessageBox mb;
        try {
            this.userStoreTrans = new THttpClient(this.userStoreUrl);
            this.userStoreTrans.setCustomHeader("User-Agent", this.userAgent);
        }
        catch (TTransportException e) {
            mb = new QMessageBox(QMessageBox.Icon.Critical, "Transport Excepton", e.getLocalizedMessage());
            mb.exec();
            e.printStackTrace();
        }
        this.userStoreProt = new TBinaryProtocol((TTransport)this.userStoreTrans);
        this.userStore = new UserStore.Client((TProtocol)this.userStoreProt, (TProtocol)this.userStoreProt);
        this.syncSignal.saveUserStore.emit((Object)this.userStore);
        try {
            this.user = this.userStore.getUser(this.authToken);
        }
        catch (EDAMUserException e) {
            mb = new QMessageBox(QMessageBox.Icon.Critical, "Error", "Invalid Authorization");
            mb.exec();
            this.isConnected = false;
            return false;
        }
        catch (EDAMSystemException e) {
            mb = new QMessageBox(QMessageBox.Icon.Critical, "EDAM System Excepton", e.getLocalizedMessage());
            mb.exec();
            e.printStackTrace();
            this.isConnected = false;
        }
        catch (TException e) {
            mb = new QMessageBox(QMessageBox.Icon.Critical, "Transport Excepton", e.getLocalizedMessage());
            mb.exec();
            e.printStackTrace();
            this.isConnected = false;
        }
        boolean versionOk = false;
        try {
            versionOk = this.userStore.checkVersion("NeighborNote", (short)1, (short)20);
        }
        catch (TException e) {
            e.printStackTrace();
            this.isConnected = false;
        }
        if (!versionOk) {
            System.err.println("Incomatible EDAM client protocol version");
            this.isConnected = false;
        }
        if (this.user == null || this.noteStoreUrlBase == null) {
            this.logger.log(this.logger.LOW, "Error retrieving user information.  Aborting.");
            System.err.println("Error retrieving user information.");
            this.isConnected = false;
            mb = new QMessageBox(QMessageBox.Icon.Critical, this.tr("Connection Error"), this.tr("Error retrieving user information.  Synchronization not complete"));
            mb.exec();
            return false;
        }
        this.noteStoreUrl = String.valueOf(this.noteStoreUrlBase) + this.user.getShardId();
        this.syncSignal.saveAuthToken.emit((Object)this.authToken);
        this.syncSignal.saveNoteStore.emit((Object)this.localNoteStore);
        try {
            this.noteStoreTrans = new THttpClient(this.noteStoreUrl);
            this.noteStoreTrans.setCustomHeader("User-Agent", this.userAgent);
        }
        catch (TTransportException e) {
            QMessageBox mb2 = new QMessageBox(QMessageBox.Icon.Critical, "Transport Excepton", e.getLocalizedMessage());
            mb2.exec();
            e.printStackTrace();
            this.isConnected = false;
        }
        this.noteStoreProt = new TBinaryProtocol((TTransport)this.noteStoreTrans);
        this.localNoteStore = new NoteStore.Client((TProtocol)this.noteStoreProt, (TProtocol)this.noteStoreProt);
        this.isConnected = true;
        try {
            User user = this.userStore.getUser(this.authToken);
            this.syncSignal.saveUserInformation.emit((Object)user);
        }
        catch (EDAMUserException e1) {
            e1.printStackTrace();
        }
        catch (EDAMSystemException e1) {
            e1.printStackTrace();
        }
        catch (TException e1) {
            e1.printStackTrace();
        }
        return this.isConnected;
    }

    public void enDisconnect() {
        this.isConnected = false;
    }

    public synchronized boolean addWork(String request) {
        return this.workQueue.offer(request);
    }

    private Note getNoteContent(Note n) {
        QTextCodec codec = QTextCodec.codecForLocale();
        codec = QTextCodec.codecForName((String)"UTF-8");
        n.setContent(codec.toUnicode(new QByteArray(n.getContent())));
        return n;
    }

    private void downloadAllSharedNotebooks(NoteStore.Client noteStore) {
        try {
            List books = noteStore.listSharedNotebooks(this.authToken);
            this.logger.log(this.logger.LOW, "Shared notebooks found = " + books.size());
            int i = 0;
            while (i < books.size()) {
                this.conn.getSharedNotebookTable().updateNotebook((SharedNotebook)books.get(i), false);
                ++i;
            }
            this.conn.getSyncTable().deleteRecord("FullSharedNotebookSync");
        }
        catch (EDAMUserException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("User exception Listing shared notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (EDAMSystemException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("System exception Listing shared notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (TException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("Transaction exception Listing shared notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (EDAMNotFoundException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("EDAM Not Found exception Listing shared notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
        }
    }

    private void downloadAllNotebooks(NoteStore.Client noteStore) {
        try {
            List books = noteStore.listNotebooks(this.authToken);
            this.logger.log(this.logger.LOW, "Shared notebooks found = " + books.size());
            int i = 0;
            while (i < books.size()) {
                this.conn.getNotebookTable().updateNotebook((Notebook)books.get(i), false);
                ++i;
            }
            this.conn.getSyncTable().deleteRecord("FullNotebookSync");
        }
        catch (EDAMUserException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("User exception Listing notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (EDAMSystemException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("System exception Listing notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (TException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("Transaction exception Listing notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
    }

    private void downloadAllLinkedNotebooks(NoteStore.Client noteStore) {
        try {
            List books = noteStore.listLinkedNotebooks(this.authToken);
            this.logger.log(this.logger.LOW, "Linked notebooks found = " + books.size());
            int i = 0;
            while (i < books.size()) {
                this.conn.getLinkedNotebookTable().updateNotebook((LinkedNotebook)books.get(i), false);
                ++i;
            }
            this.conn.getSyncTable().deleteRecord("FullLinkedNotebookSync");
        }
        catch (EDAMUserException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("User exception Listing linked notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (EDAMSystemException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("System exception Listing linked notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (TException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("Transaction exception Listing lineked notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
            return;
        }
        catch (EDAMNotFoundException e1) {
            e1.printStackTrace();
            this.status.message.emit((Object)this.tr("EDAM Not Found exception Listing linked notebooks."));
            this.logger.log(this.logger.LOW, e1.getMessage());
        }
    }

    private void downloadInkNoteImage(String guid, String authToken) {
        String urlBase = String.valueOf(this.noteStoreUrl.replace("/edam/note/", "/shard/")) + "/res/" + guid + ".ink?slice=";
        Integer slice = 1;
        Resource r = this.conn.getNoteTable().noteResourceTable.getNoteResource(guid, false);
        this.conn.getInkImagesTable().expungeImage(r.getGuid());
        int sliceCount = 1 + (r.getHeight() - 1) / 480;
        DefaultHttpClient http = new DefaultHttpClient();
        int i = 0;
        while (i < sliceCount) {
            String url = String.valueOf(urlBase) + slice.toString();
            HttpPost post = new HttpPost(url);
            post.getParams().setParameter("auth", (Object)authToken);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("auth", authToken));
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            try {
                HttpResponse response = http.execute((HttpUriRequest)post);
                HttpEntity resEntity = response.getEntity();
                InputStream is = resEntity.getContent();
                QByteArray data = this.writeToFile(is);
                this.conn.getInkImagesTable().saveImage(guid, slice, data);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            slice = slice + 1;
            ++i;
        }
        http.getConnectionManager().shutdown();
        this.noteSignal.noteChanged.emit((Object)r.getNoteGuid(), null);
    }

    public QByteArray writeToFile(InputStream iStream) throws IOException {
        File temp = File.createTempFile("nn-inknote-temp", ".png");
        FilterOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(temp));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = iStream.read(buffer)) != -1) {
                ((BufferedOutputStream)fOut).write(buffer, 0, bytesRead);
            }
        }
        finally {
            iStream.close();
            fOut.close();
        }
        QFile tempFile = new QFile(temp.getAbsoluteFile().toString());
        tempFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly});
        QByteArray data = tempFile.readAll();
        tempFile.close();
        tempFile.remove();
        return data;
    }

    private void syncLinkedNotebooks() {
        this.logger.log(this.logger.MEDIUM, "Authenticating linked Notebooks");
        this.status.message.emit((Object)this.tr("Synchronizing shared notebooks."));
        List<LinkedNotebook> books = this.conn.getLinkedNotebookTable().getAll();
        this.errorSharedNotebooks.clear();
        int i = 0;
        while (i < books.size()) {
            if (this.errorSharedNotebooksIgnored.containsKey(books.get(i).getGuid())) break;
            try {
                this.logger.log(this.logger.EXTREME, "Checking notebook: " + books.get(i).getShareName());
                long lastSyncDate = this.conn.getLinkedNotebookTable().getLastSequenceDate(books.get(i).getGuid());
                int lastSequenceNumber = this.conn.getLinkedNotebookTable().getLastSequenceNumber(books.get(i).getGuid());
                this.logger.log(this.logger.EXTREME, "Last Sequence Number on file: " + lastSequenceNumber);
                String linkedNoteStoreUrl = String.valueOf(this.noteStoreUrlBase) + books.get(i).getShardId();
                this.logger.log(this.logger.EXTREME, "linkedNoteStoreURL: " + linkedNoteStoreUrl);
                THttpClient linkedNoteStoreTrans = new THttpClient(linkedNoteStoreUrl);
                TBinaryProtocol linkedNoteStoreProt = new TBinaryProtocol((TTransport)linkedNoteStoreTrans);
                NoteStore.Client linkedNoteStore = new NoteStore.Client((TProtocol)linkedNoteStoreProt, (TProtocol)linkedNoteStoreProt);
                this.linkedAuthResult = null;
                if (books.get(i).getShareKey() != null) {
                    this.logger.log(this.logger.EXTREME, "Share Key Not Null: " + books.get(i).getShareKey());
                    this.linkedAuthResult = linkedNoteStore.authenticateToSharedNotebook(books.get(i).getShareKey(), this.authToken);
                    this.logger.log(this.logger.EXTREME, "Authentication Token" + this.linkedAuthResult.getAuthenticationToken());
                } else {
                    this.logger.log(this.logger.EXTREME, "Share key is null");
                    this.linkedAuthResult = new AuthenticationResult();
                    this.linkedAuthResult.setAuthenticationToken("");
                }
                SyncState linkedSyncState = linkedNoteStore.getLinkedNotebookSyncState(this.linkedAuthResult.getAuthenticationToken(), books.get(i));
                if (linkedSyncState.getUpdateCount() > lastSequenceNumber) {
                    this.logger.log(this.logger.EXTREME, "Remote changes found");
                    if (lastSyncDate < linkedSyncState.getFullSyncBefore()) {
                        lastSequenceNumber = 0;
                    }
                    this.logger.log(this.logger.EXTREME, "Calling syncLinkedNotebook for " + books.get(i).getShareName());
                    this.syncLinkedNotebook(linkedNoteStore, books.get(i), lastSequenceNumber, linkedSyncState.getUpdateCount(), this.authToken);
                }
                this.syncLocalLinkedNoteChanges(linkedNoteStore, books.get(i));
            }
            catch (EDAMUserException e) {
                e.printStackTrace();
            }
            catch (EDAMNotFoundException e) {
                this.status.message.emit((Object)this.tr("Error synchronizing \" " + books.get(i).getShareName() + "\". Please verify you still have access to that shared notebook."));
                this.errorSharedNotebooks.add(books.get(i).getGuid());
                this.errorSharedNotebooksIgnored.put(books.get(i).getGuid(), books.get(i).getGuid());
                this.logger.log(this.logger.LOW, "Error synchronizing shared notebook.  EDAMNotFound: " + e.getMessage());
                this.logger.log(this.logger.LOW, e.getStackTrace());
                this.error = true;
                e.printStackTrace();
            }
            catch (EDAMSystemException e) {
                this.error = true;
                this.logger.log(this.logger.LOW, "System error authenticating against shared notebook. Key: " + books.get(i).getShareKey() + " Error:" + e.getMessage());
                e.printStackTrace();
            }
            catch (TException e) {
                this.error = true;
                e.printStackTrace();
            }
            ++i;
        }
        this.conn.getTagTable().removeUnusedLinkedTags();
        this.conn.getTagTable().cleanupTags();
        this.tagSignal.listChanged.emit();
    }

    private void syncLinkedNotebook(NoteStore.Client linkedNoteStore, LinkedNotebook book, int usn, int highSequence, String token) {
        this.logger.log(this.logger.EXTREME, "Entering syncLinkedNotebook");
        if (this.ignoreLinkedNotebooks.contains(book.getGuid())) {
            return;
        }
        List<Note> dirtyNotes = this.conn.getNoteTable().getDirtyLinkedNotes();
        if (this.dirtyNoteGuids == null) {
            this.dirtyNoteGuids = new ArrayList<String>();
        }
        int i = 0;
        while (i < dirtyNotes.size() && this.keepRunning) {
            this.dirtyNoteGuids.add(dirtyNotes.get(i).getGuid());
            ++i;
        }
        boolean fullSync = false;
        if (usn == 0) {
            fullSync = true;
        }
        boolean syncError = false;
        while (usn < highSequence && !syncError) {
            this.refreshNeeded = true;
            try {
                SyncChunk chunk = linkedNoteStore.getLinkedNotebookSyncChunk(token, book, usn, 10, fullSync);
                this.syncExpungedNotes(chunk);
                this.logger.log(this.logger.EXTREME, "Syncing remote notes: " + chunk.getNotesSize());
                this.syncRemoteNotes(linkedNoteStore, chunk.getNotes(), fullSync, this.linkedAuthResult.getAuthenticationToken());
                this.logger.log(this.logger.EXTREME, "Finding new linked tags");
                this.findNewLinkedTags(linkedNoteStore, chunk.getNotes(), this.linkedAuthResult.getAuthenticationToken());
                this.logger.log(this.logger.EXTREME, "Synchronizing tags: " + chunk.getTagsSize());
                int i2 = 0;
                while (i2 < chunk.getResourcesSize()) {
                    this.syncRemoteResource(linkedNoteStore, (Resource)chunk.getResources().get(i2), this.linkedAuthResult.getAuthenticationToken());
                    ++i2;
                }
                this.logger.log(this.logger.EXTREME, "Synchronizing linked notebooks: " + chunk.getNotebooksSize());
                this.syncRemoteLinkedNotebooks(linkedNoteStore, chunk.getNotebooks(), false, book);
                this.syncLinkedTags(chunk.getTags(), book.getGuid());
                i2 = 0;
                while (i2 < chunk.getNotesSize()) {
                    this.noteSignal.noteChanged.emit((Object)((Note)chunk.getNotes().get(i2)).getGuid(), null);
                    ++i2;
                }
                this.logger.log(this.logger.EXTREME, "Expunging linked notebooks: " + chunk.getExpungedLinkedNotebooksSize());
                i2 = 0;
                while (i2 < chunk.getExpungedLinkedNotebooksSize()) {
                    this.conn.getLinkedNotebookTable().expungeNotebook((String)chunk.getExpungedLinkedNotebooks().get(i2), false);
                    ++i2;
                }
                usn = chunk.getChunkHighUSN();
                this.conn.getLinkedNotebookTable().setLastSequenceDate(book.getGuid(), chunk.getCurrentTime());
                this.conn.getLinkedNotebookTable().setLastSequenceNumber(book.getGuid(), chunk.getChunkHighUSN());
            }
            catch (EDAMUserException e) {
                syncError = true;
                this.status.message.emit((Object)this.tr("EDAM UserException synchronizing linked notbook.  See the log for datails."));
                e.printStackTrace();
                this.logger.log(this.logger.LOW, String.valueOf(this.tr("EDAM UserException synchronizing linked notbook ")) + e.getMessage());
            }
            catch (EDAMSystemException e) {
                syncError = true;
                this.status.message.emit((Object)this.tr("EDAM SystemException synchronizing linked notbook.  See the log for datails."));
                e.printStackTrace();
                this.logger.log(this.logger.LOW, String.valueOf(this.tr("EDAM SystemException synchronizing linked notbook.  See the log for datails")) + e.getMessage());
            }
            catch (EDAMNotFoundException e) {
                syncError = true;
                this.status.message.emit((Object)(String.valueOf(this.tr("Notebook URL not found. Removing notobook ")) + book.getShareName()));
                this.conn.getNotebookTable().deleteLinkedTags(book.getGuid());
                this.conn.getLinkedNotebookTable().expungeNotebook(book.getGuid(), false);
                this.logger.log(this.logger.LOW, String.valueOf(this.tr("Notebook URL not found. Removing notobook ")) + e.getMessage());
            }
            catch (TException e) {
                syncError = true;
                this.status.message.emit((Object)this.tr("EDAM TException synchronizing linked notbook.  See the log for datails."));
                e.printStackTrace();
                this.logger.log(this.logger.LOW, String.valueOf(this.tr("EDAM TException synchronizing linked notbook.  See the log for datails.")) + e.getMessage());
            }
        }
        this.logger.log(this.logger.EXTREME, "leaving syncLinkedNotebook");
    }

    private void syncLinkedTags(List<Tag> tags, String notebookGuid) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteTags");
        if (tags != null) {
            int i = 0;
            while (i < tags.size() && this.keepRunning) {
                this.conn.getTagTable().syncLinkedTag(tags.get(i), notebookGuid, false);
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteTags");
    }

    private void syncRemoteLinkedNotebooks(NoteStore.Client noteStore, List<Notebook> notebooks, boolean readOnly, LinkedNotebook linked) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.syncRemoteNotebooks");
        if (notebooks != null) {
            int i = 0;
            while (i < notebooks.size() && this.keepRunning) {
                try {
                    this.logger.log(this.logger.EXTREME, "auth token:" + this.linkedAuthResult.getAuthenticationToken());
                    if (!this.linkedAuthResult.getAuthenticationToken().equals("")) {
                        SharedNotebook s = noteStore.getSharedNotebookByAuth(this.linkedAuthResult.getAuthenticationToken());
                        this.logger.log(this.logger.EXTREME, "share key:" + s.getShareKey() + " notebookGuid" + s.getNotebookGuid());
                        this.conn.getLinkedNotebookTable().setNotebookGuid(s.getShareKey(), s.getNotebookGuid());
                        readOnly = !s.isNotebookModifiable();
                    } else {
                        readOnly = true;
                    }
                    notebooks.get(i).setName(linked.getShareName());
                    notebooks.get(i).setDefaultNotebook(false);
                    this.conn.getNotebookTable().syncLinkedNotebook(notebooks.get(i), false, readOnly);
                }
                catch (EDAMUserException e) {
                    readOnly = true;
                    e.printStackTrace();
                }
                catch (EDAMNotFoundException e) {
                    readOnly = true;
                    e.printStackTrace();
                }
                catch (EDAMSystemException e) {
                    readOnly = true;
                    e.printStackTrace();
                }
                catch (TException e) {
                    readOnly = true;
                    e.printStackTrace();
                }
                ++i;
            }
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.syncRemoteNotebooks");
    }

    private void findNewLinkedTags(NoteStore.Client noteStore, List<Note> newNotes, String token) {
        if (newNotes == null) {
            return;
        }
        int i = 0;
        while (i < newNotes.size()) {
            Note n = newNotes.get(i);
            int j = 0;
            while (j < n.getTagGuidsSize()) {
                String tag = (String)n.getTagGuids().get(j);
                if (!this.conn.getTagTable().exists(tag)) {
                    try {
                        Tag newTag = noteStore.getTag(token, tag);
                        this.conn.getTagTable().addTag(newTag, false);
                    }
                    catch (EDAMUserException e) {
                        e.printStackTrace();
                    }
                    catch (EDAMSystemException e) {
                        e.printStackTrace();
                    }
                    catch (EDAMNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void syncLocalLinkedNoteChanges(NoteStore.Client noteStore, LinkedNotebook book) {
        this.logger.log(this.logger.EXTREME, "Entering SyncRunner.synclocalLinkedNoteChanges");
        String notebookGuid = this.conn.getLinkedNotebookTable().getNotebookGuid(book.getGuid());
        this.logger.log(this.logger.EXTREME, "Finding changes for " + book.getShareName() + ":" + book.getGuid() + ":" + notebookGuid);
        List<Note> notes = this.conn.getNoteTable().getDirtyLinked(notebookGuid);
        this.logger.log(this.logger.EXTREME, "Number of changes found: " + notes.size());
        int i = 0;
        while (i < notes.size()) {
            this.logger.log(this.logger.EXTREME, "Calling syncLocalNote with key " + this.linkedAuthResult.getAuthenticationToken());
            this.syncLocalNote(noteStore, notes.get(i), this.linkedAuthResult.getAuthenticationToken());
            ++i;
        }
        this.logger.log(this.logger.EXTREME, "Leaving SyncRunner.synclocalLinkedNoteChanges");
    }
}

