/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql.driver;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class NSqlQuery {
    private final Connection connection;
    private String lastError;
    private ResultSet resultSet;
    private PreparedStatement preparedStatement;
    private final HashMap<String, Integer> positionMap;
    private ByteArrayInputStream fis;

    public NSqlQuery(Connection c) {
        this.connection = c;
        this.positionMap = new HashMap();
    }

    public boolean next() {
        this.lastError = null;
        if (this.resultSet == null) {
            this.lastError = "Result set is null";
            return false;
        }
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
            return false;
        }
    }

    public boolean exec(String sql) {
        boolean retVal = false;
        this.lastError = "";
        this.resultSet = null;
        try {
            Statement st = this.connection.createStatement();
            retVal = st.execute(sql);
            this.resultSet = st.getResultSet();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
        }
        return retVal;
    }

    public boolean exec() {
        this.lastError = "";
        this.resultSet = null;
        if (this.preparedStatement == null) {
            this.lastError = "No SQL statement prepared";
            return false;
        }
        try {
            this.preparedStatement.execute();
            this.resultSet = this.preparedStatement.getResultSet();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
            return false;
        }
        return true;
    }

    public String lastError() {
        if (this.lastError == null) {
            return "";
        }
        return this.lastError;
    }

    public Object valueObject(int position) {
        this.lastError = null;
        if (this.resultSet == null) {
            this.lastError = "ResultSet is null";
            return null;
        }
        try {
            return this.resultSet.getObject(position + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
            return null;
        }
    }

    public String valueString(int position) {
        this.lastError = null;
        if (this.resultSet == null) {
            this.lastError = "ResultSet is null";
            return null;
        }
        try {
            return this.resultSet.getString(position + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
            return null;
        }
    }

    public boolean valueBoolean(int position, boolean unknown) {
        try {
            return this.resultSet.getBoolean(position + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return unknown;
        }
    }

    public long valueLong(int position) {
        try {
            return this.resultSet.getLong(position + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public int valueInteger(int position) {
        try {
            return this.resultSet.getInt(position + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void bindValue(String field, String value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position != null && position > 0) {
            try {
                this.preparedStatement.setString(position, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public void bindValue(String field, boolean value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position > 0) {
            try {
                this.preparedStatement.setBoolean(position, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public void bindValue(String field, int value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position > 0) {
            try {
                this.preparedStatement.setInt(position, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public void bindValue(String field, double value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position > 0) {
            try {
                this.preparedStatement.setDouble(position, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public void bindValue(String field, byte[] value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position > 0) {
            try {
                this.preparedStatement.setBytes(position, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public boolean prepare(String statement) {
        this.positionMap.clear();
        this.preparedStatement = null;
        this.lastError = null;
        int position = 1;
        int i = statement.indexOf(":");
        while (i > 0) {
            int endField = statement.indexOf(" ", i + 1);
            int nextComma = statement.indexOf(",", i + 1);
            int nextBracket = statement.indexOf(")", i + 1);
            if (nextComma > 0 && nextComma < endField) {
                endField = nextComma;
            }
            if (endField == -1) {
                endField = nextBracket;
            }
            if (nextBracket > 0 && nextBracket < endField) {
                endField = nextBracket;
            }
            String fieldName = null;
            if (endField > 0) {
                fieldName = statement.substring(i, endField);
            } else {
                fieldName = statement.substring(i);
                endField = statement.length();
            }
            statement = String.valueOf(statement.substring(0, i)) + "?" + statement.substring(endField);
            this.positionMap.put(fieldName.toLowerCase(), new Integer(position));
            ++position;
            i = statement.indexOf(":", i);
        }
        try {
            this.preparedStatement = this.connection.prepareStatement(statement);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
            return false;
        }
        return true;
    }

    public void bindBlob(String field, byte[] value) {
        Integer position = this.positionMap.get(field.toLowerCase());
        this.lastError = null;
        if (this.preparedStatement == null) {
            this.lastError = "No prepared statement exists";
            return;
        }
        if (position != null && position > 0) {
            try {
                this.fis = new ByteArrayInputStream(value);
                this.preparedStatement.setBinaryStream(position, this.fis);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
            }
            return;
        }
    }

    public byte[] getBlob(int position) {
        Blob dataBinary;
        block3: {
            try {
                dataBinary = this.resultSet.getBlob(position + 1);
                if (dataBinary != null) break block3;
                return null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.lastError = e.getMessage();
                return null;
            }
        }
        byte[] b = dataBinary.getBytes(1L, (int)dataBinary.length());
        return b;
    }
}

