using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.RemoteFacades
{
	/// <summary>
	/// IdNumberingテーブルのリモートファサードを表します。
	/// </summary>
	public class IdNumberingFacade : RemoteFacade< IdNumberingKey, IdNumberingGateway, IdNumberingEntity, IdNumberingDTO, IdNumberingModule >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public IdNumberingFacade() : base( new DataSetHolder() )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public IdNumberingFacade( string connectionString ) : base( new DataSetHolder( connectionString ) )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public IdNumberingFacade( DataSetHolder holder ) : base( holder )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="loadKey">充填するキー</param>
		public IdNumberingFacade( IKey loadKey ) : base( new DataSetHolder(), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		/// <param name="loadKey">充填するキー</param>
		public IdNumberingFacade( string connectionString, IKey loadKey ) : base( new DataSetHolder( connectionString ), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <param name="loadKey">充填するキー</param>
		public IdNumberingFacade( DataSetHolder holder, IKey loadKey ) : base( holder, loadKey )
		{
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="tableName">TableName</param>
		/// <returns>エンティティ</returns>
		public IdNumberingEntity this[ string tableName ]
		{
			get
			{
				return( this[ new IdNumberingKey( tableName ) ] );
			}
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( IdNumberingGateway.AccessTableName );
			}
		}

		/// <summary>
		/// 新しいテーブルデータゲートウェイを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルデータゲートウェイ</returns>
		protected override IdNumberingGateway NewGateway( DataSetHolder holder )
		{
			return( new IdNumberingGateway( holder ) );
		}

		/// <summary>
		/// 新しいテーブルモジュールを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルモジュール</returns>
		protected override IdNumberingModule NewModule( DataSetHolder holder )
		{
			return( new IdNumberingModule( holder ) );
		}
	}
}
