using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;
using NDac.Modules.Entities;

namespace NDac.Modules.DataTransferObjects
{
	/// <summary>
	/// IdNumberingテーブルのデータ変換オブジェクトを表します。
	/// </summary>
	[ Serializable ]
	public partial class IdNumberingDTO : DataTransferObject< IdNumberingKey, IdNumberingEntity >
	{
		private string _tableName;
		private long _nextId;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public IdNumberingDTO()
			: base()
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="entity">エンティティ</param>
		public IdNumberingDTO( IdNumberingEntity entity )
			: base( entity )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public IdNumberingDTO( string primaryKey )
		{
			this._tableName = primaryKey;
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public IdNumberingDTO( IdNumberingKey primaryKey )
		{
			this._tableName = primaryKey.TableName;
		}

		/// <summary>
		/// TableNameを表します。
		/// </summary>
		[ PrimaryKey( "TableName", typeof( string ) ) ]
		public string TableName
		{
			get
			{
				return( StringCutDowner.Variable( this._tableName, 100 ) );
			}
			set
			{
				this._tableName = StringCutDowner.Variable( value, 100 );
			}
		}

		/// <summary>
		/// NextIdを表します。
		/// </summary>
		public long NextId
		{
			get
			{
				return( this._nextId );
			}
			set
			{
				this._nextId = value;
			}
		}

		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		protected override void Copy( DataTransferObject< IdNumberingKey, IdNumberingEntity > source )
		{
			this.Copy( ( IdNumberingDTO )source );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		public void Copy( IdNumberingDTO source )
		{
			this.TableName = source.TableName;
			this.NextId = source.NextId;
		}

		/// <summary>
		/// エンティティの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public override void Copy( IdNumberingEntity source )
		{
			this.FillValue( source );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティにコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		/// <param name="destination">コピー先のエンティティ</param>
		public static void Copy( IdNumberingDTO source, IdNumberingEntity destination )
		{
			source.FillTo( destination );
		}

		/// <summary>
		/// エンティティの内容をデータ変換オブジェクトにコピーします。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		/// <param name="destination">コピー先のデータ変換オブジェクト</param>
		public static void Copy( IdNumberingEntity source, IdNumberingDTO destination )
		{
			destination.FillValue( source );
		}

		/// <summary>
		/// エンティティより値を充填します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillValue( IEntity entity )
		{
			this.FillValue( ( IdNumberingEntity )entity );
		}

		/// <summary>
		/// エンティティより値を充填します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillValue( IdNumberingEntity entity )
		{
			this._tableName = entity.TableName;
			this._nextId = entity.NextId;
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティに反映させます。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillTo( IEntity entity )
		{
			this.FillTo( ( IdNumberingEntity )entity );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティに反映させます。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillTo( IdNumberingEntity entity )
		{
			entity.TableName = this._tableName;
			entity.NextId = this._nextId;
		}

		/// <summary>
		/// プライマリキーでデータを充填されたテーブルモジュールを取得します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>テーブルモジュール</returns>
		protected override ITableModule LoadModule( IKey primaryKey )
		{
			return( this.LoadModule( ( IdNumberingKey )primaryKey ) );
		}

		/// <summary>
		/// プライマリキーでデータを充填されたテーブルモジュールを取得します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>テーブルモジュール</returns>
		protected override ITableModule LoadModule( IdNumberingKey primaryKey )
		{
			DataSetHolder holder = new DataSetHolder();

			IdNumberingGateway gateway = new IdNumberingGateway( holder );

			IdNumberingModule module = new IdNumberingModule( holder );

			gateway.LoadBy( primaryKey );

			return( module );
		}

		/// <summary>
		/// プライマリキーに変換します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override IdNumberingKey ToPrimaryKey()
		{
			return( new IdNumberingKey( this.TableName ) );
		}
	}

	/// <summary>
	/// IdNumberingテーブルエンティティの拡張メソッド定義クラスを表します。
	/// </summary>
	public static class IdNumberingEntityExtension
	{
		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		public static void Copy( this IdNumberingEntity entity, IdNumberingDTO source )
		{
			IdNumberingDTO.Copy( source, entity );
		}

		/// <summary>
		/// データ変換オブジェクトに変換します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		/// <returns>データ変換オブジェクト</returns>
		public static IdNumberingDTO ToDataTransferObject( this IdNumberingEntity entity )
		{
			return( new IdNumberingDTO( entity ) );
		}
	}
}
