using System;
using System.Data;
using NDac.Datas;
using NDac.Keys;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.Modules
{
	/// <summary>
	/// Bookテーブルのテーブルモジュールを表します。
	/// </summary>
	public partial class BookModule : TableModule< BookKey, BookEntity, BookDTO >
	{
		private const string TABLE_NAME = "Book";

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="table">データテーブル</param>
		public BookModule( DataTable table )
			: base( table )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="ds">データセット</param>
		public BookModule( DataSet ds )
			: base( ds, TABLE_NAME )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public BookModule( DataSetHolder holder )
			: base( holder, TABLE_NAME )
		{
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( TABLE_NAME );
			}
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>エンティティ/returns>
		public BookEntity this[ long id ]
		{
			get
			{
				return( this[ new BookKey( id ) ] );
			}
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>新しい行のエンティティ</returns>
		public BookEntity NewEntity( long id )
		{
			return( this.NewEntity( new BookKey( id ) ) );
		}

		/// <summary>
		/// 新しい行のエンティティを作成します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>新しい行のエンティティ</returns>
		protected override BookEntity NewEntity( BookKey primaryKey )
		{
			DataRow row = base.NewRow();

			row[ "Id" ] = primaryKey.Id;

			this._table.Rows.Add( row );

			return( ( BookEntity )this.ToEntity( row ) );
		}

		/// <summary>
		/// データ変換オブジェクトをセットします。データ変換オブジェクトのキーに一致するデータが存在する場合はUpdate，存在しない場合はInsertします。データベースに反映する時はDataSetHolderのUpdate()を呼び出して下さい。
		/// </summary>
		/// <param name="dto">データ変換オブジェクト</param>
		public override void Set( BookDTO dto )
		{
			if( this[ dto.GetPrimaryKey() ] == null )
			{
				this.Insert( dto );
			}
			else
			{
				this[ dto.GetPrimaryKey() ].Copy( dto );
			}
		}

		/// <summary>
		/// 行データをエンティティに変換します。
		/// </summary>
		/// <param name="row">データ行</param>
		/// <returns>エンティティ</returns>
		protected internal override BookEntity ToEntity( DataRow row )
		{
			if( row != null )
			{
				return( new BookEntity( row ) );
			}
			else
			{
				return( null );
			}
		}

		/// <summary>
		/// SELECT実行時のフィルタ処理式に変換します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>フィルタ処理式</returns>
		protected override string ToFilterExpression( BookKey primaryKey )
		{
			return( string.Format( "( Id = {0} )", primaryKey.Id ) );
		}

		/// <summary>
		/// データセットにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="ds">データセット</param>
		public static void FillSchema( DataSet ds )
		{
			TableModule< BookKey, BookEntity, BookDTO >.FillSchema( TABLE_NAME, ds );
		}

		/// <summary>
		/// データテーブルにテーブルスキーマを充填します。
		/// </summary>
		/// <param name="table">データテーブル</param>
		public static void FillSchema( DataTable table )
		{
			TableModule< BookKey, BookEntity, BookDTO >.FillSchema( TABLE_NAME, table );
		}
	}
}
