using System;

namespace NDac.Modules.Attributes
{
	/// <summary>
	/// ユニークキー属性を表します。
	/// </summary>
	public class UniqueKeyAttribute : IndexAttribute
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="propertyName">プロパティ名</param>
		/// <param name="dataType">データ型</param>
		public UniqueKeyAttribute( string propertyName, Type dataType )
			: base( string.Empty, propertyName, dataType )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">キー／インデックス名</param>
		/// <param name="propertyName">プロパティ名</param>
		/// <param name="dataType">データ型</param>
		public UniqueKeyAttribute( string name, string propertyName, Type dataType )
			: base( name, propertyName, dataType )
		{
		}

		/// <summary>
		/// プロパティがユニーク属性か否かを表します。
		/// </summary>
		public override bool IsUnique
		{
			get
			{
				return( true );
			}
		}

		/// <summary>
		/// プロパティがプライマリ属性か否かを表します。
		/// </summary>
		public override bool IsPrimary
		{
			get
			{
				return( false );
			}
		}
	}
}
