//---------------------------------------------------------------------------
#ifndef TCommandLineParserH
#define TCommandLineParserH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>

#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEPredictionAlgorithm.h"

#include "TCFbECosineSimilarity.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAdjustedCosineSimilarityWithMedian.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbECorrelationCoefficientWithMedian.h"
#include "TCFbERankCorrelation.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEDistanceSimilarityWithMedian.h"

#include "TCFbEWeightedSum.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfRow.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
#include "TCFbEAmplifiedWeightedSumWithAveragedMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithMedianOfMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithWeightedMultiplier.h"
//---------------------------------------------------------------------------
class TCommandLineParser : public TObject
{
public:
    virtual __fastcall TCommandLineParser(int argc=0, char* argv[]=NULL);    // RXgN^
    __fastcall ~TCommandLineParser();    // fXgN^

    TFileName    LearningDataFileName;
    TFileName    EstimatingDataFileName;
    TCFbESimilarityComputationAlgorithm*    SimilarityComputationAlgorithm;
    TCFbEPredictionAlgorithm*    PredictionAlgorithm;
    TCFbEValueBase    ValueBase;
    TCFbEAlgorithmBase    AlgorithmBase;
    int    NeighborsSize;
    TStringList*    TargetColumnLabelList;
    bool    NLabelEnabled;            // Neighborhoods ̃x\邩ǂ
    bool    NSimilaritiesEnabled;    // Neighborhoods ̗ގx\邩ǂ
    bool    SDistributionEnabled;     // ގx̕z\邩ǂ
    TFileName    OutputFileName;

protected:
    TStringList* FOptionList;
    virtual bool __fastcall IsEmpty(void);    // IvVȂ
    virtual bool __fastcall IsEnableOption(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionList Ɋ܂܂ĂΕԂ
    virtual bool __fastcall IsEnableValue(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionLabel= Ƃ`Ŋ֘Atꂽ񂪂 true Ԃ
    virtual AnsiString __fastcall GetValueString(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionLabel= Ƃ`Ŋ֘Atꂽ OptionList ɂΕԂ

    virtual TCFbESimilarityComputationAlgorithm* __fastcall GetSimilarityComputationAlgorithm(AnsiString AlgorithmName);
    virtual TCFbEPredictionAlgorithm* __fastcall GetPredictionAlgorithm(AnsiString AlgorithmName, int NeighborsSize);

private:

};
//---------------------------------------------------------------------------
#endif
