/*
    TCFbETable.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETableH
#define TCFbETableH
//---------------------------------------------------------------------------
#include <System.hpp>
#include <Classes.hpp>
#include <Contnrs.hpp>

// #include "Maprof.h"

#include "TCFbECell.h"
#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
class TCFbETable : public TObject
{
public:
    __property int NumberOfRows = { read=GetNumberOfRows };
    __property int NumberOfColumns = { read=GetNumberOfColumns };
    __property TCFbECell* Cells[AnsiString RowLabal][AnsiString ColumnLabel] = { read=GetCells, write=SetCells };    // e[u̗vfێ 2 z
    __property TCFbECell* CellsByIndex[int RowIndex][int ColumnIndex] = { read=GetCellsByIndex, write=SetCellsByIndex };

    TStringList* RowLabelList;
    TStringList* ColumnLabelList;

    virtual __fastcall TCFbETable(void);    // RXgN^ĩe[u쐬
    virtual __fastcall TCFbETable(TStringList* RowLabelList, TStringList* ColumnLabelList);    // w肳ꂽse[u쐬
    __fastcall ~TCFbETable();    // fXgN^

    virtual void __fastcall Assign(TCFbETable* SourceTable);    // SourceTable ̊evfRs[
    virtual void __fastcall AssignWithTurn(TCFbETable* SourceTable);    // SourceTable ̊evf̍sƗւăRs[

    virtual void __fastcall Normalize(void);    // Table ̗vf Normalize 
    virtual void __fastcall Standardize(void);    // Table ̗vf Standardize 
    virtual void __fastcall Ordering(void);    // Table ̗vf Ordering 

    virtual void __fastcall RowNormalize(void);    // Table ̗vf Normalize 
    virtual void __fastcall RowStandardize(void);    // Table ̗vf Standardize 
    virtual void __fastcall RowOrdering(void);    // Table ̗vf Ordering 

    virtual double __fastcall DisNormalize(int ColumnIndex, double NormalizedValue);    // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
    virtual double __fastcall DisStandardize(int ColumnIndex, double StandardizedValue);    // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
    virtual double __fastcall DisOrdering(int ColumnIndex, double Order, TDoubleDynArray& SortedOrders);    // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ

    virtual double __fastcall DisRowNormalize(int RowIndex, double RowNormalizedValue);    // RowIndex ڂ̉ Normalize ꂽl RowNormalizedValue  DisRowNormalize ĕԂ
    virtual double __fastcall DisRowStandardize(int RowIndex, double RowStandardizedValue);    // RowIndex ڂ̉ Standardize ꂽl RowStandardizedValue  DisRowStandardize ĕԂ
    virtual double __fastcall DisRowOrdering(int RowIndex, double RowOrder, TDoubleDynArray& SortedOrders);    // RowIndex ڂ̉ Ordering ꂽl RowOrder  DisRowOrdering ĕԂ

    virtual double __fastcall DisOrderingCommon(int Index, double Order, TDoubleDynArray& SortedOrders, TDoubleDynArray& SortedValues);    // DisOrdering  DisRowOrdering Ŏgʂ̏

    virtual void __fastcall AddValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value);    // RowLabel, ColumnLabel ̃Z̒l Value Z
    virtual void __fastcall UpdateValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value);    // RowLabel, ColumnLabel ̃Z̒l Value ɍXV
    virtual void __fastcall DeleteValue(AnsiString RowLabel, AnsiString ColumnLabel);    // RowLabel, ColumnLabel ̃Z폜iEnabled = false ɂ

    virtual int __fastcall AddRow(AnsiString RowLabel);    // sǉD
    virtual void __fastcall DeleteRow(AnsiString RowLabel);    // s폜D
    virtual void __fastcall AddRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values);    // s̊evfZDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void __fastcall UpdateRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values);    // s̊evfXVDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void __fastcall DeleteRowElements(AnsiString RowLabel, TStringList* ColumnLabelList);    // s̎wvf Enabled  false ɂDvf ColumnLabelList Ŏw肳Dŝ̍폜͍sȂD

    virtual int __fastcall AddColumn(AnsiString ColumnLabel);    // ǉD
    virtual void __fastcall DeleteColumn(AnsiString ColumnLabel);    // 폜D
    virtual void __fastcall AddColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values);    // ̊evfZDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void __fastcall UpdateColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values);    // ̊evfXVDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void __fastcall DeleteColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList);    // ̎wvf Enabled  false ɂDvf RowLabelList Ŏw肳D񎩑̂̍폜͍sȂD

    virtual double __fastcall GetMaxOfRow(int i);    // s̍őlԂD
    virtual double __fastcall GetMinOfRow(int i);    // s̍ŏlԂD
    virtual double __fastcall GetAverageOfRow(int i);    // s̕ϒlԂD
    virtual double __fastcall GetMedianOfRow(int i);    // s̒ԒlԂD
    virtual double __fastcall GetStdevOfRow(int i);    // s̕W΍ԂD
    virtual double __fastcall GetInversedDistanceOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Inversed Distance ԂD
    virtual double __fastcall GetAveragedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Median of Multiplier ԂD
    virtual double __fastcall GetWeightedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex, int BaseColumnIndex);    // BaseColumnIndex Ԗڂ̗Ɋւ ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Weighted Multiplier ԂD
    virtual int    __fastcall GetEnabledCountOfRow(int i);    //  Enabled ȃZ̐Ԃ

    virtual double __fastcall GetMaxOfColumn(int j);    // ̍őlԂD
    virtual double __fastcall GetMinOfColumn(int j);    // ̍ŏlԂD
    virtual double __fastcall GetAverageOfColumn(int j);    // ̕ϒlԂD
    virtual double __fastcall GetMedianOfColumn(int j);    // ̒ԒlԂD
    virtual double __fastcall GetStdevOfColumn(int j);    // ̕W΍ԂD
    virtual double __fastcall GetInversedDistanceOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Inversed Distance ԂD
    virtual double __fastcall GetAveragedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Median of Multiplier ԂD
    virtual double __fastcall GetWeightedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex, int BaseRowIndex);    // BaseRowIndex Ԗڂ̍sɊւ BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Weighted Multiplier ԂD
    virtual int    __fastcall GetEnabledCountOfColumn(int j);    //  Enabled ȃZ̐Ԃ

    virtual void __fastcall GetBothEnableSortedCellList(int TargetRowIndex, int ComparedRowIndex, TList* TargetSortedCellList, TList* ComparedSortedCellList);    // TargetRowIndex sڂ ComparedRowIndex sڂŋʂ Enabled ȗvf\[gCTargetSortedCellList Ɓ@ComparedSortedCellList ɂꂼĕԂiRankCorrelation Ŏg

    virtual void __fastcall RowIsUpdated(int RowIndex);
    virtual int __fastcall RowIsUpdated(AnsiString RowLabel);
    virtual void __fastcall ColumnIsUpdated(int  ColumnIndex);
    virtual int __fastcall ColumnIsUpdated(AnsiString ColumnLabel);

    virtual void __fastcall GetSortedCellListOfRow(int RowIndex, TList* SortedCellList);    // RowIndex Ԗڂ̍s Enabled ȗvf\[gCSortedCellList ɓĕԂ
    virtual void __fastcall GetSortedCellListOfColumn(int ColumnIndex, TList* SortedCellList);    // ColumnIndex Ԗڂ̗ Enabled ȗvf\[gCSortedCellList ɓĕԂ

protected:
    virtual int __fastcall GetNumberOfRows(void) { return this->RowLabelList->Count; }
    virtual int __fastcall GetNumberOfColumns(void) { return this->ColumnLabelList->Count; }
    virtual TCFbECell* __fastcall GetCells(AnsiString RowLabel, AnsiString ColumnLabel);
    virtual void __fastcall SetCells(AnsiString RowLabel, AnsiString ColumnLabel, TCFbECell* Cell);
    virtual TCFbECell* __fastcall GetCellsByIndex(int RowIndex, int ColumnIndex);
    virtual void __fastcall SetCellsByIndex(int RowIndex, int ColumnIndex, TCFbECell* Cell);

    virtual void __fastcall GetEnabledCellsInRow(int RowIndex, TDoubleDynArray& DynArray);    // RowIndex Ԗڂ̍s Enabled ȗvf DynArray ɓĕԂ
    virtual void __fastcall GetEnabledCellsInColumn(int ColumnIndex, TDoubleDynArray& DynArray);    // ColumnIndex Ԗڂ̗ Enabled ȗvf DynArray ɓĕԂ

    TObjectList* RowList;
    TObjectList* MaxOfRowList;
    TObjectList* MinOfRowList;
    TObjectList* AverageOfRowList;
    TObjectList* MedianOfRowList;
    TObjectList* StdevOfRowList;
    TObjectList* InversedDistanceOfRowList;
    TList* CachedBaseRowListForID;

    TObjectList* MaxOfColumnList;
    TObjectList* MinOfColumnList;
    TObjectList* AverageOfColumnList;
    TObjectList* MedianOfColumnList;
    TObjectList* StdevOfColumnList;
    TObjectList* InversedDistanceOfColumnList;
    TList* CachedBaseColumnListForID;

private:

};
//---------------------------------------------------------------------------
#endif
