/*
    TCFbEPredictionAlgorithm.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEPredictionAlgorithmH
#define TCFbEPredictionAlgorithmH
//---------------------------------------------------------------------------
#include <Classes.hpp>

class TCFbEDataSet;
#include "TCFbEDataSet.h"
//---------------------------------------------------------------------------
class TCFbEPredictionAlgorithm : public TPersistent
{
public:
    virtual __fastcall TCFbEPredictionAlgorithm(void);    // RXgN^
    __fastcall ~TCFbEPredictionAlgorithm();    // fXgN^

    virtual void __fastcall SetDataSet(TCFbEDataSet* DataSet) { this->DataSet = DataSet; }    // f[^Zbgݒ肷iTCFbEDataSet gɂĎs
    virtual double __fastcall Predict(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize) = 0;    // TargetRowIndex sڂ TargetColumnIndex ̒l\

protected:
    TCFbEDataSet* DataSet;

private:

};
//---------------------------------------------------------------------------
#endif
