/*
    TCFbEDataSet.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#define BUFFERLEN    256

#include "TCFbEDataSet.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)            
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEDataSet::TCFbEDataSet(void)
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSourceTable = new TCFbETable();
    this->FSimilarityComputationTable = new TCFbETable();
    this->FPredictionMediateTable = new TCFbETable();
    this->FPredictionTable = new TCFbETable();
    this->FAppliedTableArePrepared = false;
    this->FSimilarityList = new TObjectList();
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->TargetRowIndexOfSimilarity = -1;
    this->FPredictedValueList = new TObjectList();
    this->TargetRowIndexOfPrediction = -1;

    this->TemporaryUnableRowIndex = -1;
    this->TemporaryUnableColumnIndex = -1;
}

//---------------------------------------------------------------------------
// RXgN^
// SourceCsvStringList f[^\z
// Row  1 sڂɃR[h̃x
// Column  1 sڂɃACẽx
// ͒lĂƂ݂Ȃ
__fastcall TCFbEDataSet::TCFbEDataSet(TStringList* SourceCsvStringList)
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSourceTable = new TCFbETable();
    this->FSimilarityComputationTable = new TCFbETable();
    this->FSimilarityComputationTable = new TCFbETable();
    this->FPredictionMediateTable = new TCFbETable();
    this->FPredictionTable = new TCFbETable();
    this->FAppliedTableArePrepared = false;
    this->FSimilarityList = new TObjectList();
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->TargetRowIndexOfSimilarity = -1;
    this->FPredictedValueList = new TObjectList();
    this->TargetRowIndexOfPrediction = -1;

    this->TemporaryUnableRowIndex = -1;
    this->TemporaryUnableColumnIndex = -1;
    
    // ̃f[^Zbg
    if (SourceCsvStringList->Count == 0) {
        return;
    }

    // Column x̎擾
    TStringList* Delimited = new TStringList();
    this->CsvToStrings2(SourceCsvStringList->Strings[0].c_str(), Delimited);
    for (int j = 1; j < Delimited->Count; j++) {
        this->FSourceTable->AddColumn(Delimited->Strings[j]);
    }

    // row ̒ǉ
    for (int i = 1; i < SourceCsvStringList->Count; i++) {
        Delimited->Clear();
        this->CsvToStrings2(SourceCsvStringList->Strings[i].c_str(), Delimited);
        if (Delimited->Count == 0) {
            continue;
        }

        int AddedRowIndex = this->FSourceTable->AddRow(Delimited->Strings[0]);

        for (int j = 1; j < Delimited->Count; j++) {
            if (Delimited->Strings[j].IsEmpty()) {
                continue;
            }
            
            try {
                this->FSourceTable->CellsByIndex[AddedRowIndex][j-1]->Value = Delimited->Strings[j].ToDouble();
            } catch (EConvertError &e) {
                // ^ϊłȂ
            }
        }
    }

    delete Delimited;
}

//---------------------------------------------------------------------------
__fastcall TCFbEDataSet::~TCFbEDataSet()    // fXgN^
{
    delete this->FPredictedValueList;
    delete this->FSimilarityList;
    if (this->FPredictionAlgorithm != NULL) {
        delete this->FPredictionAlgorithm;
    }
    if (this->FSimilarityComputationAlgorithm != NULL) {
        delete this->FSimilarityComputationAlgorithm;
    }
    delete this->FPredictionTable;
    delete this->FPredictionMediateTable;
    delete this->FSimilarityComputationTable;
    delete this->FSourceTable;
}

//---------------------------------------------------------------------------
//    CF ̏siPredictionTable 
//    ValueBase:    vZɎgliValue / StandardizedValue / NormalizedValue / Order
//    AlgorithmBase:    Row(User)-based CColumn(Item)-based 
//    SimilarityComputationAlgorithm:    ގxvZASYiTCFbEDataSet 
//    PredictionAlgorithm:    \ASYiTCFbEDataSet 
//    NeighborhoodSize:    lCo[tbhTCY
//  DefaultValueEnabled:    Default Value ߍ݋@\Lɂ邩ǂ
//    DefaultValue:    Default Value ߍ݋@\LȂƂɖߍޒl
//    InverseCaseFrequencyEnabled:    Inverse Case Frequency @\Lɂ邩ǂ
//    CaseAmplifier:    Case Amplification @\gpƂ amplifierigpȂƂ 1.0 wj
void __fastcall TCFbEDataSet::PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier)
{
    this->IsUpdated();

    if (this->FSimilarityComputationAlgorithm != NULL) {
        delete this->FSimilarityComputationAlgorithm;
    }
    this->FSimilarityComputationAlgorithm = SimilarityComputationAlgorithm;
    if (this->FSimilarityComputationAlgorithm != NULL) {
        this->FSimilarityComputationAlgorithm->SetDataSet(this);
    }

    if (this->FPredictionAlgorithm != NULL) {
        delete this->FPredictionAlgorithm;
    }
    this->FPredictionAlgorithm = PredictionAlgorithm;
    if (this->FPredictionAlgorithm != NULL) {
        this->FPredictionAlgorithm->SetDataSet(this);
    }

    this->FNeighborhoodSize = NeighborhoodSize;

    this->FAlgorithmBase = AlgorithmBase;
    this->FValueBase = ValueBase;

    TCFbETable* BufferTable = new TCFbETable();

    // Value / StandardizedValue / NormalizedValue / Order ̏
    if (this->FValueBase == vbStandardizedValue) {
        BufferTable->Assign(this->FSourceTable);
        BufferTable->Standardize();

    } else if (this->FValueBase == vbNormalizedValue) {
        BufferTable->Assign(this->FSourceTable);
        BufferTable->Normalize();

    } else if (this->FValueBase == vbOrder) {
        BufferTable->Assign(this->FSourceTable);
        BufferTable->Ordering();

    } else if (this->FValueBase == vbDoubleStandardizedValue) {
        this->FPredictionMediateTable->Assign(this->FSourceTable);
        this->FPredictionMediateTable->Standardize();
        BufferTable->Assign(this->FPredictionMediateTable);
        BufferTable->RowStandardize();

    } else if (this->FValueBase == vbDoubleNormalizedValue) {
        this->FPredictionMediateTable->Assign(this->FSourceTable);
        this->FPredictionMediateTable->Normalize();
        BufferTable->Assign(this->FPredictionMediateTable);
        BufferTable->RowNormalize();

    } else if (this->FValueBase == vbDoubleOrder) {
        this->FPredictionMediateTable->Assign(this->FSourceTable);
        this->FPredictionMediateTable->Ordering();
        BufferTable->Assign(this->FPredictionMediateTable);
        BufferTable->RowOrdering();
        
    } else {
        BufferTable->Assign(this->FSourceTable);
    }

    // Default Value ̐ݒ
    this->FDefaultValueEnabled = DefaultValueEnabled;
    this->FDefaultValue = DefaultValue;
    if (this->DefaultValueEnabled) {
        for (int i = 0; i < BufferTable->NumberOfRows; i++) {
            for (int j = 0; j < BufferTable->NumberOfColumns; j++) {
                TCFbECell* Cell = BufferTable->CellsByIndex[i][j];
                if (!Cell->Enabled) {
                    Cell->Value = this->DefaultValue;
                }
            }
        }
    }

    // SimilarityComputationTable, PredictionTable ̏
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        this->FSimilarityComputationTable->Assign(BufferTable);
        this->FPredictionTable->Assign(BufferTable);
    } else {    // Item-based CF
        this->FSimilarityComputationTable->AssignWithTurn(BufferTable);
        this->FPredictionTable->AssignWithTurn(BufferTable);
    }

    // Inverse Case Frequency
    this->FInverseCaseFrequencyEnabled = InverseCaseFrequencyEnabled;
    if (this->FInverseCaseFrequencyEnabled) {
        for (int j = 0; j < this->FSimilarityComputationTable->NumberOfColumns; j++) {
            double    ICFCoefficient = this->GetICFCoefficient(j);
            for (int i = 0; i < this->FSimilarityComputationTable->NumberOfRows; i++) {
                TCFbECell*    CurrentCell = this->FSimilarityComputationTable->CellsByIndex[i][j];
                if (CurrentCell->Enabled) {
                    CurrentCell->Value *= ICFCoefficient;
                }
            }
        }
    }

    this->FCaseAmplifier = CaseAmplifier;

    // Similarities LbV̏^ǉ
    this->TargetRowIndexOfSimilarity = -1;

    for (int i = 0; i < this->FPredictionTable->NumberOfRows; i++) {
        if (this->FSimilarityList->Count <= i) {
            this->FSimilarityList->Add(new TCFbECell());
        }
    }

    // ߏ Similarities LbV̍폜
    while (this->FSimilarityList->Count > this->FPredictionTable->NumberOfRows) {
        this->FSimilarityList->Delete(0);
    }

    // Predictions LbV̏^ǉ
    this->TargetRowIndexOfPrediction = -1;

    for (int j = 0; j < this->FSourceTable->NumberOfColumns; j++) {
        if (this->FPredictedValueList->Count <= j) {
            this->FPredictedValueList->Add(new TCFbECell());
        }
    }

    // ߏ Predictions LbV̍폜
    while (this->FPredictedValueList->Count > this->FSourceTable->NumberOfColumns) {
        this->FPredictedValueList->Delete(0);
    }

    this->FAppliedTableArePrepared = true;
}

//---------------------------------------------------------------------------
// TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
// ɈꎞI Enabled = false ɂĂZꍇ́C܂߂Ăs
void    __fastcall TCFbEDataSet::TemporaryUnable(int TargetRowIndex, int TargetColumnIndex)
{
    if ((this->TemporaryUnableRowIndex >= 0) && (this->TemporaryUnableColumnIndex >= 0)) {
        this->RecoverEnabled();
    }

    TCFbECell* TargetCell = this->FSourceTable->CellsByIndex[TargetRowIndex][TargetColumnIndex];
    if (!TargetCell->Enabled) {    // ڕW̃Z Enabled ł͂Ȃ
        return;
    }

    this->TemporaryUnableRowIndex = TargetRowIndex;
    this->TemporaryUnableColumnIndex = TargetColumnIndex;
    
    TargetCell->Enabled = false;

    if(this->FAppliedTableArePrepared) {
        if (this->AlgorithmBase == abColumn) {
            this->SimilarityComputationTable->CellsByIndex[TargetColumnIndex][TargetRowIndex]->Enabled = false;
            this->PredictionTable->CellsByIndex[TargetColumnIndex][TargetRowIndex]->Enabled = false;
        } else {
            this->SimilarityComputationTable->CellsByIndex[TargetRowIndex][TargetColumnIndex]->Enabled = false;
            this->PredictionTable->CellsByIndex[TargetRowIndex][TargetColumnIndex]->Enabled = false;
        }
    }
}

//---------------------------------------------------------------------------
// ꎞI Enabled = false ɂĂZɂǂ
void    __fastcall TCFbEDataSet::RecoverEnabled(void)
{
    if ((this->TemporaryUnableRowIndex < 0) && (this->TemporaryUnableColumnIndex < 0)) {
        return;
    }

    this->FSourceTable->CellsByIndex[this->TemporaryUnableRowIndex][this->TemporaryUnableColumnIndex]->Enabled = true;

    if(this->FAppliedTableArePrepared) {
        if (this->AlgorithmBase == abColumn) {
            this->SimilarityComputationTable->CellsByIndex[this->TemporaryUnableColumnIndex][this->TemporaryUnableRowIndex]->Enabled = true;
            this->PredictionTable->CellsByIndex[this->TemporaryUnableColumnIndex][this->TemporaryUnableRowIndex]->Enabled = true;
        } else {
            this->SimilarityComputationTable->CellsByIndex[this->TemporaryUnableRowIndex][this->TemporaryUnableColumnIndex]->Enabled = true;
            this->PredictionTable->CellsByIndex[this->TemporaryUnableRowIndex][this->TemporaryUnableColumnIndex]->Enabled = true;
        }
    }

    this->TemporaryUnableRowIndex = -1;
    this->TemporaryUnableColumnIndex = -1;
}

//---------------------------------------------------------------------------
// RowLabel, ColumnLabel ̃Z̒l Value Z
void __fastcall TCFbEDataSet::AddValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value)
{
    this->IsUpdated();
    this->FSourceTable->AddValue(RowLabel, ColumnLabel, Value);
}

//---------------------------------------------------------------------------
// RowLabel, ColumnLabel ̃Z̒l Value ɍXV
void __fastcall TCFbEDataSet::UpdateValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value)
{
    this->IsUpdated();
    this->FSourceTable->UpdateValue(RowLabel, ColumnLabel, Value);
}

//---------------------------------------------------------------------------
// RowLabel, ColumnLabel ̃Z폜iEnabled = false ɂ
void __fastcall TCFbEDataSet::DeleteValue(AnsiString RowLabel, AnsiString ColumnLabel)
{
    this->IsUpdated();
    this->FSourceTable->DeleteValue(RowLabel, ColumnLabel);
}

//---------------------------------------------------------------------------
// DataSet  RowIndex sڂXV
int __fastcall TCFbEDataSet::UpdateRow(TCFbEDataSet* DataSet, int RowIndex)
{
    int UpdatedIndex = this->RowLabelList->IndexOf(DataSet->RowLabelList->Strings[RowIndex]);
    if (UpdatedIndex < 0) {    // s݂Ȃ
        UpdatedIndex = this->AddRow(DataSet->RowLabelList->Strings[RowIndex]);
    }
    for (int j = 0; j < DataSet->NumberOfColumns; j++) {
        if (DataSet->EnabledByIndex[RowIndex][j]) {
            int    TargetColumn = this->ColumnLabelList->IndexOf(DataSet->ColumnLabelList->Strings[j]);
            if (TargetColumn != -1) {
                this->ValuesByIndex[UpdatedIndex][TargetColumn] = DataSet->ValuesByIndex[RowIndex][j];
            }
        }
    }

    return UpdatedIndex;
}

//---------------------------------------------------------------------------
// sǉD
int __fastcall TCFbEDataSet::AddRow(AnsiString RowLabel)
{
    this->IsUpdated();
    return this->FSourceTable->AddRow(RowLabel);
}

//---------------------------------------------------------------------------
// s폜D
void __fastcall TCFbEDataSet::DeleteRow(AnsiString RowLabel)
{
    this->IsUpdated();
    this->FSourceTable->DeleteRow(RowLabel);
}

//---------------------------------------------------------------------------
// s̊evfZDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
void __fastcall TCFbEDataSet::AddRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values)
{
    this->IsUpdated();
    this->FSourceTable->AddRowElements(RowLabel, ColumnLabelList, Values);
}

//---------------------------------------------------------------------------
// s̊evfXVDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
void __fastcall TCFbEDataSet::UpdateRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values)
{
    this->IsUpdated();
    this->FSourceTable->UpdateRowElements(RowLabel, ColumnLabelList, Values);
}

//---------------------------------------------------------------------------
// s̎wvf Enabled  false ɂDvf ColumnLabelList Ŏw肳Dŝ̍폜͍sȂD
void __fastcall TCFbEDataSet::DeleteRowElements(AnsiString RowLabel, TStringList* ColumnLabelList)
{
    this->IsUpdated();
    this->FSourceTable->DeleteRowElements(RowLabel, ColumnLabelList);
}

//---------------------------------------------------------------------------
// ǉD
int __fastcall TCFbEDataSet::AddColumn(AnsiString ColumnLabel)
{
    this->IsUpdated();
    return this->FSourceTable->AddColumn(ColumnLabel);
}

//---------------------------------------------------------------------------
// 폜D
void __fastcall TCFbEDataSet::DeleteColumn(AnsiString ColumnLabel)
{
    this->IsUpdated();
    this->FSourceTable->DeleteColumn(ColumnLabel);
}

//---------------------------------------------------------------------------
// ̊evfZDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
void __fastcall TCFbEDataSet::AddColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values)
{
    this->IsUpdated();
    this->FSourceTable->AddColumnElements(ColumnLabel, RowLabelList, Values);
}

//---------------------------------------------------------------------------
// ̊evfXVDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
void __fastcall TCFbEDataSet::UpdateColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values)
{
    this->IsUpdated();
    this->FSourceTable->UpdateColumnElements(ColumnLabel, RowLabelList, Values);
}

//---------------------------------------------------------------------------
// ̎wvf Enabled  false ɂDvf RowLabelList Ŏw肳D񎩑̂̍폜͍sȂD
void __fastcall TCFbEDataSet::DeleteColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList)
{
    this->IsUpdated();
    this->FSourceTable->DeleteColumnElements(ColumnLabel, RowLabelList);
}

//---------------------------------------------------------------------------
// j ڂ Inverse Case Frequency Coefficient 𓾂
double __fastcall TCFbEDataSet::GetICFCoefficient(int j)
{
    int    EnabledCount = (this->FAlgorithmBase == abRow) ? this->FSourceTable->GetEnabledCountOfColumn(j) : this->FSourceTable->GetEnabledCountOfRow(j);
    if (EnabledCount == 0) {
        return 0.0;
    }
    return log((double)this->SimilarityComputationTable->NumberOfRows / (double)EnabledCount);
}

//---------------------------------------------------------------------------
// TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ
// TargetRowIndex: ގx𒲂ׂΏۂ̍s
// TargetColumnIndex: \Ώۂ̗iTargetColumnIndex ̒l Enabled łȂs Neighbors Ɋ܂߂Ȃ 
// NeighborList  Neigobors ގxɓĕԂ
void __fastcall TCFbEDataSet::GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList)
{
    NeighborList->Clear();
    if (NeighborhoodSize == 0) {
        NeighborhoodSize = MaxInt;
    }

    int NumberOfRows = this->FSimilarityComputationTable->NumberOfRows;

    for (int i = 0; i < NumberOfRows; i++) {
        TCFbECell*    CurrentPredictionCell = this->FPredictionTable->CellsByIndex[i][TargetColumnIndex];
        if (CurrentPredictionCell->Enabled && (i != TargetRowIndex)) {
            double    Similarity = this->SimilaritiesByIndex[TargetRowIndex][i];

            int k = 0;
            while (k < NeighborList->Count) {
                if ( ((TCFbENeighbor*)NeighborList->Items[k])->Similarity < Similarity) {
                    break;
                }
                k++;
            }

            if (k < NeighborhoodSize) {
                if (NeighborList->Count >= NeighborhoodSize) {
                    NeighborList->Delete(NeighborList->Count - 1);
                }
                TCFbECell*    CurrentSourceCell = (this->AlgorithmBase == abRow) ? this->FSourceTable->CellsByIndex[i][TargetColumnIndex] : this->FSourceTable->CellsByIndex[TargetColumnIndex][i];
                double    Value = CurrentSourceCell->Enabled ? CurrentSourceCell->Value : this->DefaultValue;
                NeighborList->Insert(k, new TCFbENeighbor(this->FPredictionTable->RowLabelList->Strings[i], Similarity, CurrentPredictionCell->Value, Value));
            }
        }
    }    
}

//---------------------------------------------------------------------------
// BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
void __fastcall TCFbEDataSet::FillColumns(TCFbEDataSet* BaseDataSet)
{
    for (int j = 0; j < BaseDataSet->NumberOfColumns; j++) {
        if (this->ColumnLabelList->IndexOf(BaseDataSet->ColumnLabelList->Strings[j]) == -1) {
            this->AddColumn(BaseDataSet->ColumnLabelList->Strings[j]);
        }
    }
}

//---------------------------------------------------------------------------
// TargetDataSet Ǝѐ邩ǂ𒲂ׂ
bool __fastcall TCFbEDataSet::IsConsistentWith(TCFbEDataSet* TargetDataSet)
{
    if (this->NumberOfColumns != TargetDataSet->NumberOfColumns) {
        return false;
    }

    for (int j = 0; j < this->ColumnLabelList->Count; j++) {
        if (TargetDataSet->ColumnLabelList->IndexOf(this->ColumnLabelList->Strings[j]) == -1) {
            return false;
        }
    }
    return true;
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
double __fastcall TCFbEDataSet::DisNormalize(int ColumnIndex, double NormalizedValue)
{
    return this->FSourceTable->DisNormalize(ColumnIndex, NormalizedValue);
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
double __fastcall TCFbEDataSet::DisStandardize(int ColumnIndex, double StandardizedValue)
{
    return this->FSourceTable->DisStandardize(ColumnIndex, StandardizedValue);
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
double __fastcall TCFbEDataSet::DisOrdering(int ColumnIndex, double Order)
{
    TList*    SortedList = new TList();
    if (this->AlgorithmBase == abColumn) {    // Item-based
        this->PredictionTable->GetSortedCellListOfRow(ColumnIndex, SortedList);
    } else {    // User-based
        this->PredictionTable->GetSortedCellListOfColumn(ColumnIndex, SortedList);
    }

    TDoubleDynArray Array;
    Array.Length = SortedList->Count;
    for (int k = 0; k < SortedList->Count; k++) {
        Array[k] = ((TCFbECell*)SortedList->Items[k])->Value;
    }

    double ResultedValue = this->FSourceTable->DisOrdering(ColumnIndex, Order, Array);
    delete SortedList;
    Array.Length = 0;
    
    return ResultedValue;
}

//---------------------------------------------------------------------------
// RowIndex sځCColumnIndex ڂ DoubleNormalize ꂽl DoubleNormalizedValue  DisDoubleNormalize ĕԂ
double __fastcall TCFbEDataSet::DisDoubleNormalize(int RowIndex, int ColumnIndex, double DoubleNormalizedValue)
{
    return this->DisNormalize(ColumnIndex, this->FPredictionMediateTable->DisRowNormalize(RowIndex, DoubleNormalizedValue));
}

//---------------------------------------------------------------------------
// RowIndex sځCColumnIndex ڂ DoubleStandardize ꂽl DoubleStandardizedValue  DisDoubleStandardize ĕԂ
double __fastcall TCFbEDataSet::DisDoubleStandardize(int RowIndex, int ColumnIndex, double DoubleStandardizedValue)
{
    return this->DisStandardize(ColumnIndex, this->FPredictionMediateTable->DisRowStandardize(RowIndex, DoubleStandardizedValue));
}

//---------------------------------------------------------------------------
// RowIndex sځCColumnIndex ڂ DoubleOrdering ꂽl DoubleOrder  DisDoubleOrdering ĕԂ
double __fastcall TCFbEDataSet::DisDoubleOrdering(int RowIndex, int ColumnIndex, double DoubleOrder)
{
    TList*    AppliedSortedList = new TList();
    TList*    MediateSortedList = new TList();
    if (this->AlgorithmBase == abColumn) {    // Item-based
        this->PredictionTable->GetSortedCellListOfColumn(RowIndex, AppliedSortedList);
        this->FPredictionMediateTable->GetSortedCellListOfColumn(RowIndex, MediateSortedList);
    } else {    // User-based
        this->PredictionTable->GetSortedCellListOfRow(RowIndex, AppliedSortedList);
        this->FPredictionMediateTable->GetSortedCellListOfColumn(ColumnIndex, MediateSortedList);
    }

    TDoubleDynArray AppliedArray;
    AppliedArray.Length = AppliedSortedList->Count;
    for (int k = 0; k < AppliedSortedList->Count; k++) {
        AppliedArray[k] = ((TCFbECell*)AppliedSortedList->Items[k])->Value;
    }

    TDoubleDynArray MediateArray;
    MediateArray.Length = MediateSortedList->Count;
    for (int k = 0; k < MediateSortedList->Count; k++) {
        MediateArray[k] = ((TCFbECell*)MediateSortedList->Items[k])->Value;
    }

    double ResultedValue = this->FSourceTable->DisOrdering(ColumnIndex, this->FPredictionMediateTable->DisRowOrdering(RowIndex, DoubleOrder, AppliedArray), MediateArray);

    delete MediateSortedList;
    delete AppliedSortedList;
    MediateArray.Length = 0;
    AppliedArray.Length = 0;
    
    return ResultedValue;
}

//---------------------------------------------------------------------------
// ȉCprotected \bh̒`
//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetValues(AnsiString RowLabel, AnsiString ColumnLabel)
{
    return this->FSourceTable->Cells[RowLabel][ColumnLabel]->Value;
}

//---------------------------------------------------------------------------
void __fastcall TCFbEDataSet::SetValues(AnsiString RowLabel, AnsiString ColumnLabel, double Value)
{
    this->IsUpdated();
    this->FSourceTable->CellsByIndex[this->FSourceTable->RowIsUpdated(RowLabel)][this->FSourceTable->ColumnIsUpdated(ColumnLabel)]->Value = Value;
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetValuesByIndex(int RowIndex, int ColumnIndex)
{
    return this->FSourceTable->CellsByIndex[RowIndex][ColumnIndex]->Value;
}

//---------------------------------------------------------------------------
void __fastcall TCFbEDataSet::SetValuesByIndex(int RowIndex, int ColumnIndex, double Value)
{
    this->IsUpdated();
    this->FSourceTable->RowIsUpdated(RowIndex);
    this->FSourceTable->ColumnIsUpdated(ColumnIndex);
    this->FSourceTable->CellsByIndex[RowIndex][ColumnIndex]->Value = Value;
}

//---------------------------------------------------------------------------
bool __fastcall TCFbEDataSet::GetEnabled(AnsiString RowLabel, AnsiString ColumnLabel)
{
    return this->FSourceTable->Cells[RowLabel][ColumnLabel]->Enabled;
}

//---------------------------------------------------------------------------
void __fastcall TCFbEDataSet::SetEnabled(AnsiString RowLabel, AnsiString ColumnLabel, bool Value)
{
    this->IsUpdated();
    this->FSourceTable->CellsByIndex[this->FSourceTable->RowIsUpdated(RowLabel)][this->FSourceTable->ColumnIsUpdated(ColumnLabel)]->Enabled = Value;
}

//---------------------------------------------------------------------------
bool __fastcall TCFbEDataSet::GetEnabledByIndex(int RowIndex, int ColumnIndex)
{
    return this->FSourceTable->CellsByIndex[RowIndex][ColumnIndex]->Enabled;
}

//---------------------------------------------------------------------------
void __fastcall TCFbEDataSet::SetEnabledByIndex(int RowIndex, int ColumnIndex, bool Value)
{
    this->IsUpdated();
    this->FSourceTable->RowIsUpdated(RowIndex);
    this->FSourceTable->ColumnIsUpdated(ColumnIndex);
    this->FSourceTable->CellsByIndex[RowIndex][ColumnIndex]->Enabled = Value;
}

//---------------------------------------------------------------------------
int __fastcall TCFbEDataSet::GetNumberOfRows(void)
{
    return this->FSourceTable->NumberOfRows;
}

//---------------------------------------------------------------------------
int __fastcall TCFbEDataSet::GetNumberOfColumns(void)
{
    return this->FSourceTable->NumberOfColumns;
}

//---------------------------------------------------------------------------
TStringList* __fastcall TCFbEDataSet::GetRowLabelList(void)
{
    return this->FSourceTable->RowLabelList;
}

//---------------------------------------------------------------------------
TStringList* __fastcall TCFbEDataSet::GetColumnLabelList(void)
{
    return this->FSourceTable->ColumnLabelList;
}

//---------------------------------------------------------------------------
TCFbETable* __fastcall TCFbEDataSet::GetSimilarityComputationTable(void)
{
    if (!this->FAppliedTableArePrepared) {
        Exception("AppliedValues are not prepared.");
    }
    return this->FSimilarityComputationTable;
}

//---------------------------------------------------------------------------
TCFbETable* __fastcall TCFbEDataSet::GetPredictionTable(void)
{
    if (!this->FAppliedTableArePrepared) {
        Exception("AppliedValues are not prepared.");
    }
    return this->FPredictionTable;
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetSimilarities(AnsiString TargetRowLabel, AnsiString ComparedRowLabel)
{
    int TargetRowIndex = this->RowLabelList->IndexOf(TargetRowLabel);
    int ComparedRowIndex = this->RowLabelList->IndexOf(ComparedRowLabel);
    return this->GetSimilaritiesByIndex(TargetRowIndex, ComparedRowIndex);
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetSimilaritiesByIndex(int TargetRowIndex, int ComparedRowIndex)
{
    if (!this->FAppliedTableArePrepared) {
        Exception("AppliedValues were not preapared (in TCFbEDataSet::GetSimilaritiesByIndex).");
    }

    // LbVNA
    if (this->TargetRowIndexOfSimilarity != TargetRowIndex) {
        for (int i = 0; i < this->FSimilarityList->Count; i++) {
            ((TCFbECell*)this->FSimilarityList->Items[i])->Enabled = false;
        }
    }

    TCFbECell* CachedSimilarity = (TCFbECell*)this->FSimilarityList->Items[ComparedRowIndex];
    if (!CachedSimilarity->Enabled) {
        this->TargetRowIndexOfSimilarity = TargetRowIndex;

        CachedSimilarity->Value = this->FSimilarityComputationAlgorithm->ComputeSimilarity(TargetRowIndex, ComparedRowIndex);

        if (this->CaseAmplifier != 1.0) {
            if (CachedSimilarity->Value >= 0.0) {
                CachedSimilarity->Value = pow(CachedSimilarity->Value, this->CaseAmplifier);
            } else {
                CachedSimilarity->Value = -1.0 * Power(-1.0 * CachedSimilarity->Value, this->CaseAmplifier);
            }
        }
    }

    return CachedSimilarity->Value;
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetPredictedValues(AnsiString TargetRowLabel, AnsiString TargetColumnLabel)
{
    int TargetRowIndex = this->RowLabelList->IndexOf(TargetRowLabel);
    int TargetColumnIndex = this->ColumnLabelList->IndexOf(TargetColumnLabel);
    return this->GetPredictedValuesByIndex(TargetRowIndex, TargetColumnIndex);
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSet::GetPredictedValuesByIndex(int TargetRowIndex, int TargetColumnIndex)
{
    if (!this->FAppliedTableArePrepared) {
        Exception("AppliedValues were not preapared (in TCFbEDataSet::GetPredictedValuesByIndex).");
    }

    // LbVNA
    if (this->TargetRowIndexOfPrediction != TargetRowIndex) {
        for (int i = 0; i < this->NumberOfColumns; i++) {
            ((TCFbECell*)this->FPredictedValueList->Items[i])->Enabled = false;
        }
    }

    TCFbECell* CachedPredictedValue = (TCFbECell*)this->FPredictedValueList->Items[TargetColumnIndex];

    if (!CachedPredictedValue->Enabled) {
        this->TargetRowIndexOfPrediction = TargetRowIndex;

        double ResultValue;
        if (this->FAlgorithmBase == abColumn) {    // ACex[XȂ\Ώۂ̍sƗւĎs
            ResultValue = this->FPredictionAlgorithm->Predict(TargetColumnIndex, TargetRowIndex, this->NeighborhoodSize);
        } else {
            ResultValue = this->FPredictionAlgorithm->Predict(TargetRowIndex, TargetColumnIndex, this->NeighborhoodSize);
        }

        switch (this->ValueBase) {
            case vbStandardizedValue:
                CachedPredictedValue->Value = this->DisStandardize(TargetColumnIndex, ResultValue);
                break;
            case vbNormalizedValue:
                CachedPredictedValue->Value = this->DisNormalize(TargetColumnIndex, ResultValue);
                break;
            case vbOrder:
                CachedPredictedValue->Value = this->DisOrdering(TargetColumnIndex, ResultValue);
                break;
            case vbDoubleStandardizedValue:
                CachedPredictedValue->Value = this->DisDoubleStandardize(TargetRowIndex, TargetColumnIndex, ResultValue);
                break;
            case vbDoubleNormalizedValue:
                CachedPredictedValue->Value = this->DisDoubleNormalize(TargetRowIndex, TargetColumnIndex, ResultValue);
                break;
            case vbDoubleOrder:
                CachedPredictedValue->Value = this->DisDoubleOrdering(TargetRowIndex, TargetColumnIndex, ResultValue);
                break;
            default:
                CachedPredictedValue->Value = ResultValue;
        }
    }

    return CachedPredictedValue->Value;
}

//---------------------------------------------------------------------------
// Abvf[gꂽƂ}[NCLbVNA
void __fastcall TCFbEDataSet::IsUpdated(void)
{
    this->FAppliedTableArePrepared = false;
    this->TargetRowIndexOfSimilarity = -1;
    this->TargetRowIndexOfPrediction = -1;
}

//---------------------------------------------------------------------------
// CSV`̕TStringsɕ
void __fastcall TCFbEDataSet::CsvToStrings2(char* str, TStrings *List)
{
    AnsiString    Buffer = "";
    char    tmp[BUFFERLEN];
    bool    quote = false;     // p

    int    strIndex = 0;
    int    tmpIndex = 0;

    while (str[strIndex] != '\0') {
        if((str[strIndex] == '\"') || (str[strIndex] == '\'')){    //p
            quote =!quote;
        } else if(!quote && (str[strIndex] == ',')) {    //؂蕶
            tmp[tmpIndex] = '\0';
            Buffer += AnsiString(tmp);
            List->Add(Buffer);
            Buffer = "";
            tmpIndex = 0;
        } else if(!quote && isspace(str[strIndex])) {    //(KvȁH)
            ;
        } else {    //̑
            tmp[tmpIndex++] = str[strIndex];
            if (tmpIndex + 1 > BUFFERLEN) {
                tmp[tmpIndex] = '\0';
                Buffer += AnsiString(tmp);
            }
        }
        strIndex++;
    }

    tmp[tmpIndex] = '\0';
    Buffer += AnsiString(tmp);
    List->Add(Buffer);
}

//---------------------------------------------------------------------------

