/* $Id: EngineTreeNode.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Properties;

import javax.swing.tree.TreeNode;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;

/**
 * エンジンツリー用ノードの共通インタフェース
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface EngineTreeNode extends TreeNode
{
	/**
	 * 指定されたフィルターを利用して、情報の再読み込みを行う。
	 *
	 * @param filter フィルター
	 * @throws Exception 任意の例外
	 */
	public void reload(Filter filter) throws Exception;
	
	/**
	 * ノードのプロパティ情報を返す。
	 *
	 * @param rm リソースマネージャ
	 * @return プロパティ
	 */
	public Properties getProperties(ResourceManager rm);
}
