/* $Id: ConcurrentLayerManager.java,v 1.2 2007/12/10 09:34:42 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import jp.co.argo21.nautica.commons.util.StringUtils;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;

/**
 * 同期階層を管理するマネージャ
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ConcurrentLayerManager
{
	//内包される同期階層のリスト
	private List<ConcurrentLayer> subLayers = new ArrayList<ConcurrentLayer>();
	//このレイヤーに所属するアクティビティのリスト
	private List<ActivityDefinition> activities = new ArrayList<ActivityDefinition>();

	/**
	 * 同期階層マネージャを生成する。
	 */
	public ConcurrentLayerManager()
	{
	}

	/**
	 * 同期階層を初期化する。
	 * 
	 * @param activities	アクティビティ一覧
	 */
	public void initConcurrentLayer(List<ActivityDefinition> activities)
	{
		Map<String, ConcurrentLayer> layers = new Hashtable<String, ConcurrentLayer>();

		for (ActivityDefinition act : activities) {
			if (act.getType().equals(ActivityDefinition.CONCUR_START)) {
				ConcurrentLayer l = new ConcurrentLayer();
				l.setStartDefinition(act);
				layers.put(act.getBlockID(), l);
			}
		}

		for (ActivityDefinition act : activities) {
			if (act.getType().equals(ActivityDefinition.CONCUR_START)) {
			} else if (act.getType().equals(ActivityDefinition.CONCUR_END)) {
				ConcurrentLayer l = (ConcurrentLayer)layers.get(act.getBlockID());
				l.setEndDefinition(act);
				String parentID = act.getParentBID();
				if (StringUtils.checkNull(parentID)) {
					addLayer(l);
				} else {
					ConcurrentLayer pl = (ConcurrentLayer)layers.get(parentID);
					l.setParentLayer(pl);
					pl.addLayer(l);
				}
			} else {
				String affID = act.getAffiliateBID();
				if (StringUtils.checkNull(affID)) {
				} else {
					ConcurrentLayer al = (ConcurrentLayer)layers.get(affID);
					al.addLayerDefinition(act);
				}
			}
		}
	}
	
	/**
	 * 階層にアクティビティを追加する。
	 * 
	 * @param def	アクティビティ
	 */
	public void addLayerDefinition(ActivityDefinition def)
	{
		if (def == null) return;
		activities.add(def);
	}

	/**
	 * 
	 * 
	 * @param layer
	 */	
	public void addLayer(ConcurrentLayer layer)
	{
		if (layer == null) return;
		
		addLayerDefinition(layer.getStartDefinition());
		addLayerDefinition(layer.getEndDefinition());
		subLayers.add(layer);
	}

	/**
	 * 同期階層の背景を描画する。
	 * 
	 * @param g	描画対象グラフィックス
	 * @param c	描画色
	 * @param grid	単位幅
	 */	
	public void paintLayerBackgroud(Graphics g, Color c, int grid)
	{
		for (ConcurrentLayer l : subLayers) {
			l.paintLayerBackgroud(g, c, grid);
		}
	}

	/**
	 * 同期階層の枠を描画する。
	 * 
	 * @param g	描画対象グラフィックス
	 * @param c	描画色
	 * @param grid	単位幅
	 */
	public void paintLayerBorder(Graphics g, Color c, int grid)
	{
		for (ConcurrentLayer l : subLayers) {
			l.paintLayerBorder(g, c, grid);
		}
	}
}
