/* $Id: ExitAction.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import jp.co.argo21.nautica.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminFrame;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * Nauticaワークフロー運用管理ツールの終了アクションです。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ExitAction extends AbstractAction
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/**
	 * このアクションが選択されたときに実行される処理内容。
	 * 
	 * @param e アクションイベント
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		WorkflowAdminFrame frame = WorkflowAdminManager.getMainFrame();
		try {
			frame.notifyApplicationWillExit();
			
			//ユーザ設定の保存
			PreferenceManager.getInstance().save();
			
			System.exit(0);
		} catch (Exception ex) {
			ExceptionViewer exceptionViewer = new ExceptionViewer(null, true);
			exceptionViewer.setThrowable(ex);
			exceptionViewer.setMessage(
				"Nautica WorkflowDesigner exit process failed.\n"
				+ "Please press CLOSE button for exit.");
			exceptionViewer.setVisible(true);
		}
	}
}
