/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.InputStream;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ResourceUtil;

public class HotdeployClassLoader
extends ClassLoader {
    private String[] rootPackageNames;

    public HotdeployClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setRootPackageNames(String[] rootPackageNames) {
        this.rootPackageNames = rootPackageNames;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.isTargetClass(className)) {
            Class clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            clazz = ClassLoaderUtil.findLoadedClass(this.getParent(), className);
            if (clazz != null) {
                return clazz;
            }
            String path = ClassUtil.getResourcePath(className);
            InputStream is = ResourceUtil.getResourceAsStreamNoException(path);
            if (is != null) {
                clazz = this.defineClass(className, is);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    protected Class defineClass(String className, InputStream classFile) {
        return this.defineClass(className, InputStreamUtil.getBytes(classFile));
    }

    protected Class defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected boolean isTargetClass(String className) {
        if (this.rootPackageNames == null) {
            return true;
        }
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i])) continue;
            return true;
        }
        return false;
    }
}

