/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.StringUtil;

public class DICapableClassLoader
extends ClassLoader {
    public static final String INJECT_DEPENDENCY = "INJECT_DEPENDENCY";
    protected S2Container container;
    protected List classPatterns = new ArrayList();
    protected List ignoreClassPatterns = new ArrayList();
    protected ClassPool classPool = new ClassPool();

    public DICapableClassLoader(ClassLoader parent) {
        super(parent);
        this.classPool.appendClassPath((ClassPath)new LoaderClassPath(parent));
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public synchronized void addClassPattern(String packageName, String shortClassNames) {
        this.addClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public synchronized void addClassPattern(ClassPattern classPattern) {
        this.classPatterns.add(classPattern);
    }

    public synchronized void addIgnoreClassPattern(String packageName, String shortClassNames) {
        this.addIgnoreClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public synchronized void addIgnoreClassPattern(ClassPattern classPattern) {
        this.ignoreClassPatterns.add(classPattern);
    }

    public synchronized void reset() {
        this.classPatterns.clear();
        this.ignoreClassPatterns.clear();
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.resolveClassIfNecessary(Class.forName(name, false, null), resolve);
        }
        catch (ClassNotFoundException ignore) {
            if (!this.isTargetClass(name)) {
                return this.resolveClassIfNecessary(this.getParent().loadClass(name), resolve);
            }
            Class clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = this.findClass(name);
            }
            return this.resolveClassIfNecessary(clazz, resolve);
        }
    }

    protected Class resolveClassIfNecessary(Class clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        try {
            CtClass ctClass = this.classPool.get(name);
            this.enhanceClass(ctClass);
            byte[] bytes = ctClass.toBytecode();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    protected boolean isTargetClass(String name) {
        return this.isMatch(name, this.classPatterns) && !this.isMatch(name, this.ignoreClassPatterns);
    }

    protected boolean isMatch(String name, List patterns) {
        if (patterns.isEmpty()) {
            return false;
        }
        int pos = name.lastIndexOf(46);
        String packageName = name.substring(0, pos);
        String shortName = name.substring(pos + 1);
        for (int i = 0; i < patterns.size(); ++i) {
            ClassPattern pattern = (ClassPattern)patterns.get(i);
            if (!pattern.isAppliedPackageName(packageName) || !pattern.isAppliedShortClassName(shortName)) continue;
            return true;
        }
        return false;
    }

    protected void enhanceClass(CtClass ctClass) throws CannotCompileException {
        if (ctClass.isInterface() || (ctClass.getModifiers() & 0x400) != 0) {
            return;
        }
        String defaultComponentName = this.getDefaultComponentName(ctClass);
        this.enhanceConstructors(ctClass, defaultComponentName);
    }

    protected void enhanceConstructors(CtClass clazz, String defaultComponentName) throws CannotCompileException {
        CtConstructor[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            String componentName = this.getComponentName(ctors[i], defaultComponentName);
            if (componentName == null) continue;
            if (StringUtil.isEmpty(componentName)) {
                this.enhanceConstructor(ctors[i], "");
                continue;
            }
            this.enhanceConstructor(ctors[i], ", \"" + componentName + "\"");
        }
    }

    protected void enhanceConstructor(CtConstructor constructor, String arg) throws CannotCompileException {
        constructor.insertAfter("ClassLoader loader = getClass().getClassLoader();Class clazz = loader.getClass();java.lang.reflect.Method method =   org.seasar.framework.util.ClassUtil    .getMethod(clazz, \"getContainer\", null);org.seasar.framework.container.S2Container container =   (org.seasar.framework.container.S2Container)    org.seasar.framework.util.MethodUtil.invoke(method, loader, null);container.injectDependency(this" + arg + ");");
    }

    protected String getDefaultComponentName(CtClass ctClass) {
        String componentName = this.getDefaultComponentNameFromAnnotation(ctClass);
        if (componentName == null) {
            componentName = this.getDefaultComponentNameFromConstant(ctClass);
        }
        return componentName;
    }

    protected String getDefaultComponentNameFromConstant(CtClass ctClass) {
        try {
            CtField field = ctClass.getField(INJECT_DEPENDENCY);
            String componentName = (String)field.getConstantValue();
            return componentName;
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    protected String getDefaultComponentNameFromAnnotation(CtClass ctClass) {
        return null;
    }

    protected String getComponentName(CtConstructor ctClass, String defaultValue) {
        return defaultValue;
    }
}

