/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.util.StringUtil;

public class SqlTimeConverter
extends AbstractConverter {
    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat dateFormat;
        if (source == null) {
            return null;
        }
        if (source instanceof Time) {
            return source;
        }
        if (source instanceof Date) {
            return this.toTime((Date)source);
        }
        if (source instanceof Calendar) {
            return this.toTime((Calendar)source);
        }
        if (source instanceof Number) {
            return this.toTime((Number)source);
        }
        if (source instanceof String && (dateFormat = (DateFormat)context.getContextInfo("TIME_PATTERN")) != null) {
            return this.toTime((String)source, dateFormat);
        }
        return null;
    }

    protected Time toTime(Date date) {
        return new Time(date.getTime());
    }

    protected Time toTime(Calendar calendar) {
        return this.toTime(calendar.getTime());
    }

    protected Time toTime(Number date) {
        return new Time(date.longValue());
    }

    protected Time toTime(String date, DateFormat dateFormat) {
        if (StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            return this.toTime(dateFormat.parse(date));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

