/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.util.StringUtil;

public class SqlDateConverter
extends AbstractConverter {
    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat dateFormat;
        if (source == null) {
            return null;
        }
        if (source instanceof java.sql.Date) {
            return source;
        }
        if (source instanceof Date) {
            return this.toDate((Date)source);
        }
        if (source instanceof Calendar) {
            return this.toDate((Calendar)source);
        }
        if (source instanceof Number) {
            return this.toDate((Number)source);
        }
        if (source instanceof String && (dateFormat = (DateFormat)context.getContextInfo("DATE_PATTERN")) != null) {
            return this.toDate((String)source, dateFormat);
        }
        return null;
    }

    protected java.sql.Date toDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    protected java.sql.Date toDate(Calendar calendar) {
        return this.toDate(calendar.getTime());
    }

    protected java.sql.Date toDate(Number date) {
        return new java.sql.Date(date.longValue());
    }

    protected java.sql.Date toDate(String date, DateFormat dateFormat) {
        if (StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            return this.toDate(dateFormat.parse(date));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

