/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.command.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.extension.dxo.IllegalSignatureRuntimeException;
import org.seasar.extension.dxo.command.DxoCommand;

public abstract class AbstractDxoCommand
implements DxoCommand {
    protected ConversionHelper conversionHelper;

    public AbstractDxoCommand(Method method) {
        this.conversionHelper = this.getConversionHelper(method);
    }

    public Object execute(Object[] args) {
        return this.conversionHelper.convert(args);
    }

    protected abstract Object convertScalar(Object var1);

    protected abstract Class getDestElementType();

    protected abstract void copy(Object var1, Object var2);

    protected Object[] createArray(int length) {
        return (Object[])Array.newInstance(this.getDestElementType(), length);
    }

    protected ConversionHelper getConversionHelper(Method method) {
        Class<?> destType;
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            throw new IllegalSignatureRuntimeException(method.getDeclaringClass(), method);
        }
        Class<?> sourceType = parameterTypes[0];
        Class<?> clazz = destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        if (sourceType.isArray()) {
            if (destType.isArray()) {
                return new ArrayToArrayConversionHelper();
            }
            if (List.class.isAssignableFrom(destType)) {
                return new ArrayToListConversionHelper();
            }
        } else if (List.class.isAssignableFrom(sourceType)) {
            if (destType.isArray()) {
                return new ListToArrayConversionHelper();
            }
            if (List.class.isAssignableFrom(destType)) {
                return new ListToListConvertsionHelper();
            }
        } else {
            return new ScalarConversionHelper();
        }
        throw new IllegalSignatureRuntimeException(method.getDeclaringClass(), method);
    }

    public class ListToListConvertsionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            List src = (List)args[0];
            List<Object> dest = args.length == 1 ? new ArrayList() : (List)args[1];
            dest.clear();
            Iterator it = src.iterator();
            while (it.hasNext()) {
                dest.add(AbstractDxoCommand.this.convertScalar(it.next()));
            }
            return dest;
        }
    }

    public class ListToArrayConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            List src = (List)args[0];
            Object[] dest = args.length == 1 ? AbstractDxoCommand.this.createArray(src.size()) : (Object[])args[1];
            Iterator it = src.iterator();
            for (int i = 0; it.hasNext() && i < dest.length; ++i) {
                dest[i] = AbstractDxoCommand.this.convertScalar(it.next());
            }
            return dest;
        }
    }

    public class ArrayToListConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            Object[] src = (Object[])args[0];
            List<Object> dest = args.length == 1 ? new ArrayList() : (List)args[1];
            dest.clear();
            for (int i = 0; i < src.length; ++i) {
                dest.add(AbstractDxoCommand.this.convertScalar(src[i]));
            }
            return dest;
        }
    }

    public class ArrayToArrayConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            Object[] src = (Object[])args[0];
            Object[] dest = args.length == 1 ? AbstractDxoCommand.this.createArray(src.length) : (Object[])args[1];
            for (int i = 0; i < src.length && i < dest.length; ++i) {
                dest[i] = AbstractDxoCommand.this.convertScalar(src[i]);
            }
            return dest;
        }
    }

    public class ScalarConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            Object dest = AbstractDxoCommand.this.convertScalar(args[0]);
            if (args.length > 1) {
                AbstractDxoCommand.this.copy(dest, args[1]);
            }
            return dest;
        }
    }

    public static interface ConversionHelper {
        public Object convert(Object[] var1);
    }
}

