/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public abstract class AbstractScanningIterator
implements Iterator {
    private Stack _stack;
    private Object _next;

    public AbstractScanningIterator(Iterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        this._stack = new Stack();
        this._stack.push(iterator);
    }

    protected boolean filter(Object test) {
        return true;
    }

    protected Object getNextObject(Object next) {
        return next;
    }

    public boolean hasNext() {
        while (true) {
            if (this._next != null) {
                return true;
            }
            Iterator it = (Iterator)this._stack.peek();
            if (it.hasNext()) {
                Object next = this.getNextObject(it.next());
                if (next instanceof Iterator) {
                    this._stack.push(next);
                    continue;
                }
                if (!this.filter(next)) continue;
                this._next = next;
                continue;
            }
            if (this._stack.size() <= 1) break;
            this._stack.pop();
        }
        return false;
    }

    public Object next() {
        if (this._next == null) {
            this.hasNext();
        }
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        Object ret = this._next;
        this._next = null;
        return ret;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

