/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.impl.IllegalParameterValueException;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.source.SourceHolderFactory;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;
import org.seasar.mayaa.source.PageSourceFactory;
import org.seasar.mayaa.source.SourceDescriptor;
import org.seasar.mayaa.source.SourceHolder;

public class PageSourceFactoryImpl
extends ParameterAwareImpl
implements PageSourceFactory {
    private static final long serialVersionUID = 3334813227060846723L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$source$PageSourceFactoryImpl == null ? (class$org$seasar$mayaa$impl$source$PageSourceFactoryImpl = PageSourceFactoryImpl.class$("org.seasar.mayaa.impl.source.PageSourceFactoryImpl")) : class$org$seasar$mayaa$impl$source$PageSourceFactoryImpl));
    private Object _context;
    private Class _serviceClass;
    private List _parameterNames;
    private List _parameterValues;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$source$PageSourceFactoryImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$source$WebContextFolderSourceHolder;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$source$AbsolutePathSourceHolder;

    public void setServiceClass(Class serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException();
        }
        this._serviceClass = serviceClass;
    }

    public Class getServiceClass() {
        if (this._serviceClass == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceClass;
    }

    public SourceDescriptor getPageSource(String systemID) {
        if (StringUtil.isEmpty(systemID)) {
            throw new IllegalArgumentException();
        }
        Class sourceClass = this.getServiceClass();
        if (sourceClass == null) {
            throw new IllegalStateException("serviceClass is null");
        }
        SourceDescriptor source = (SourceDescriptor)ObjectUtil.newInstance(sourceClass);
        if (this._parameterNames != null) {
            for (int i = 0; i < this._parameterNames.size(); ++i) {
                String key = (String)this._parameterNames.get(i);
                String value = (String)this._parameterValues.get(i);
                source.setParameter(key, value);
            }
        }
        source.setSystemID(systemID);
        return source;
    }

    public void setUnderlyingContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
    }

    public Object getUnderlyingContext() {
        if (this._context == null) {
            throw new IllegalStateException("context is null");
        }
        return this._context;
    }

    public void setParameter(String name, String value) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalParameterValueException(this.getClass(), name);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(name + ": " + value));
        }
        if (this._parameterNames == null) {
            this._parameterNames = new ArrayList();
        }
        if (this._parameterValues == null) {
            this._parameterValues = new ArrayList();
        }
        this._parameterNames.add(name);
        this._parameterValues.add(value);
        Class sourceHolderClass = null;
        if ("folder".equals(name)) {
            sourceHolderClass = class$org$seasar$mayaa$impl$source$WebContextFolderSourceHolder == null ? (class$org$seasar$mayaa$impl$source$WebContextFolderSourceHolder = PageSourceFactoryImpl.class$("org.seasar.mayaa.impl.source.WebContextFolderSourceHolder")) : class$org$seasar$mayaa$impl$source$WebContextFolderSourceHolder;
        } else if ("absolutePath".equals(name)) {
            sourceHolderClass = class$org$seasar$mayaa$impl$source$AbsolutePathSourceHolder == null ? (class$org$seasar$mayaa$impl$source$AbsolutePathSourceHolder = PageSourceFactoryImpl.class$("org.seasar.mayaa.impl.source.AbsolutePathSourceHolder")) : class$org$seasar$mayaa$impl$source$AbsolutePathSourceHolder;
        } else {
            super.setParameter(name, value);
            return;
        }
        SourceHolder holder = (SourceHolder)ObjectUtil.newInstance(sourceHolderClass);
        try {
            holder.setRoot(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalParameterValueException(sourceHolderClass, name + "=" + value);
        }
        SourceHolderFactory.appendSourceHolder(holder);
    }

    public String getParameter(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._parameterNames == null) {
            return null;
        }
        for (int i = 0; i < this._parameterNames.size(); ++i) {
            if (!name.equals(this._parameterNames.get(i))) continue;
            return (String)this._parameterValues.get(i);
        }
        return null;
    }

    public Iterator iterateParameterNames() {
        if (this._parameterNames == null) {
            return NullIterator.getInstance();
        }
        return this._parameterNames.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

