/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.source.FileSourceDescriptor;
import org.seasar.mayaa.impl.source.ForbiddenPathException;
import org.seasar.mayaa.impl.util.StringUtil;

public class ApplicationSourceDescriptor
extends FileSourceDescriptor {
    private static final long serialVersionUID = -2775274363708858237L;
    public static final String WEB_INF = "/WEB-INF";
    private transient ApplicationScope _application;
    private boolean _denyWebInf = true;

    public ApplicationSourceDescriptor() {
        super.setRoot("");
    }

    public void setApplicationScope(ApplicationScope application) {
        if (application == null) {
            throw new IllegalArgumentException();
        }
        this._application = application;
    }

    public ApplicationScope getApplicationScope() {
        if (this._application == null) {
            this._application = FactoryFactory.getApplicationScope();
        }
        return this._application;
    }

    public void setDenyWebInf(boolean denyWebInf) {
        this._denyWebInf = denyWebInf;
    }

    public void setSystemID(String systemID) {
        if (this._denyWebInf && systemID != null && systemID.indexOf(WEB_INF) != -1) {
            throw new ForbiddenPathException(systemID);
        }
        super.setSystemID(systemID);
    }

    protected String getRealPath() {
        String path = super.getRealPath();
        if (StringUtil.isEmpty(path)) {
            path = "/";
        }
        return this.getApplicationScope().getRealPath(path);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._application = CycleUtil.getServiceCycle().getApplicationScope();
    }
}

