/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification.serialize;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.web.MockHttpServletRequest;
import org.seasar.mayaa.impl.cycle.web.MockHttpServletResponse;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.serialize.SerializeThreadManager;

public class SerializeThread
extends Thread {
    private static final int RECYCLE_LIVE_COUNT = 600;
    private int _index;
    private volatile int _liveCount;
    private List _queue = new ArrayList();
    private Object _requestContext;
    private Object _responseContext;
    private boolean _terminated;

    SerializeThread(int index, Object servletContext) {
        this.setName("serializeThread-" + index);
        this._index = index;
        this._liveCount = 600;
        this._requestContext = new MockHttpServletRequest((ServletContext)servletContext);
        this._responseContext = new MockHttpServletResponse();
    }

    public int waitCount() {
        return this._queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SpecificationImpl specification) {
        if (this._liveCount > 0 && !this._terminated) {
            List list = this._queue;
            synchronized (list) {
                this._queue.add(specification);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CycleUtil.initialize(this._requestContext, this._responseContext);
        try {
            while (this._liveCount > 0 && !this._terminated) {
                Thread.sleep(100L);
                SpecificationImpl specification = null;
                Object object = this._queue;
                synchronized (object) {
                    if (this._queue.size() > 0) {
                        specification = (SpecificationImpl)this._queue.remove(0);
                    }
                }
                if (specification != null) {
                    this._liveCount = 600;
                    object = specification;
                    synchronized (object) {
                        try {
                            specification.serialize();
                        }
                        finally {
                            specification = null;
                        }
                    }
                }
                if (--this._liveCount > 0) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            CycleUtil.cycleFinalize();
            SerializeThreadManager.threadDestroy(this._index);
        }
    }

    public void terminate() {
        this._terminated = true;
    }
}

