/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.script.LiteralScript;
import org.seasar.mayaa.impl.cycle.script.ScriptUtil;
import org.seasar.mayaa.impl.engine.specification.IllegalChildNodeException;
import org.seasar.mayaa.impl.engine.specification.NamespaceImpl;
import org.seasar.mayaa.impl.engine.specification.PrefixAwareNameImpl;
import org.seasar.mayaa.impl.engine.specification.PrefixMappingImpl;
import org.seasar.mayaa.impl.engine.specification.QNameImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationNodeImpl;
import org.seasar.mayaa.impl.engine.specification.URIImpl;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class SpecificationUtil
implements CONST_IMPL {
    private static EventScriptEnvironment _eventScripts = new EventScriptEnvironment();
    public static final PrefixMapping XML_DEFAULT_PREFIX_MAPPING = PrefixMappingImpl.getInstance("xml", CONST_IMPL.URI_XML);
    public static final PrefixMapping HTML_DEFAULT_PREFIX_MAPPING = PrefixMappingImpl.getInstance("", CONST_IMPL.URI_HTML);
    static /* synthetic */ Class class$java$lang$Void;

    private SpecificationUtil() {
    }

    public static String getAttributeValue(SpecificationNode node, QName qName) {
        NodeAttribute nameAttr = node.getAttribute(qName);
        if (nameAttr != null) {
            return nameAttr.getValue();
        }
        return null;
    }

    public static Specification findSpecification(NodeTreeWalker current) {
        while (!(current instanceof Specification)) {
            if ((current = current.getParentNode()) != null) continue;
            return null;
        }
        return (Specification)current;
    }

    public static Specification findSpecification() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        NodeTreeWalker current = cycle.getOriginalNode();
        if (current != null) {
            return SpecificationUtil.findSpecification(current);
        }
        return null;
    }

    public static SpecificationNode getMayaaNode(NodeTreeWalker current) {
        Specification specification = SpecificationUtil.findSpecification(current);
        Iterator it = specification.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode node = (SpecificationNode)it.next();
            if (!node.getQName().equals(CONST_IMPL.QM_MAYAA)) continue;
            return node;
        }
        return null;
    }

    public static String getMayaaAttributeValue(NodeTreeWalker current, QName qName) {
        String value;
        SpecificationNode mayaa = SpecificationUtil.getMayaaNode(current);
        if (mayaa != null && (value = SpecificationUtil.getAttributeValue(mayaa, qName)) != null) {
            return value;
        }
        return null;
    }

    public static String getNodeBodyText(SpecificationNode node) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = node.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child = (SpecificationNode)it.next();
            QName qName = child.getQName();
            if (CONST_IMPL.QM_CDATA.equals(qName)) {
                buffer.append(SpecificationUtil.getNodeBodyText(child));
                continue;
            }
            if (CONST_IMPL.QM_CHARACTERS.equals(qName)) {
                buffer.append(SpecificationUtil.getAttributeValue(child, CONST_IMPL.QM_TEXT));
                continue;
            }
            String name = child.getPrefix() + ":" + qName.getLocalName();
            throw new IllegalChildNodeException(name);
        }
        return buffer.toString();
    }

    public static void initScope() {
        ProviderUtil.getScriptEnvironment().initScope();
    }

    public static void startScope(Map variables) {
        ProviderUtil.getScriptEnvironment().startScope(variables);
    }

    public static void endScope() {
        ProviderUtil.getScriptEnvironment().endScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execEvent(Specification spec, QName eventName) {
        if (eventName == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode mayaa = SpecificationUtil.getMayaaNode(spec);
        if (mayaa != null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            Iterator it = mayaa.iterateChildNode();
            while (it.hasNext()) {
                SpecificationNode child = (SpecificationNode)it.next();
                if (!eventName.equals(child.getQName())) continue;
                NodeTreeWalker save = cycle.getInjectedNode();
                try {
                    cycle.setInjectedNode(child);
                    _eventScripts.execEventScript(mayaa, child);
                }
                finally {
                    cycle.setInjectedNode(save);
                }
            }
            NodeAttribute attr = mayaa.getAttribute(eventName);
            if (attr != null) {
                _eventScripts.execEventAttributeScript(mayaa, attr.getValue());
            }
        }
    }

    public static Namespace createNamespace() {
        return new NamespaceImpl();
    }

    public static Namespace getFixedNamespace(Namespace original) {
        return original;
    }

    public static QName createQName(String localName) {
        return SpecificationUtil.createQName(CONST_IMPL.URI_MAYAA, localName);
    }

    public static QName createQName(URI namespaceURI, String localName) {
        return QNameImpl.getInstance(namespaceURI, localName);
    }

    public static PrefixMapping createPrefixMapping(String prefix, URI namespaceURI) {
        return PrefixMappingImpl.getInstance(prefix, namespaceURI);
    }

    public static PrefixMapping createPrefixMapping(String prefixAndNamespaceURI) {
        return PrefixMappingImpl.revertStringToMapping(prefixAndNamespaceURI);
    }

    public static QName parseQName(String qName) {
        int end;
        if (StringUtil.hasValue(qName) && qName.charAt(0) == '{' && (end = qName.indexOf(125)) != -1 && end < qName.length() - 1) {
            String namespaceURI = qName.substring(1, end).trim();
            String localName = qName.substring(end + 1).trim();
            if (StringUtil.hasValue(namespaceURI) && StringUtil.hasValue(localName)) {
                return QNameImpl.getInstance(SpecificationUtil.createURI(namespaceURI), localName);
            }
        }
        throw new IllegalArgumentException(qName);
    }

    public static PrefixAwareName createPrefixAwareName(QName qName) {
        return SpecificationUtil.createPrefixAwareName(qName, "");
    }

    public static PrefixAwareName createPrefixAwareName(QName qName, String prefix) {
        return PrefixAwareNameImpl.getInstance(qName, prefix);
    }

    public static SpecificationNode createSpecificationNode(QName qName, String systemID, int lineNumber, boolean onTemplate, int sequenceID) {
        SpecificationNodeImpl node = new SpecificationNodeImpl(qName);
        node.setSequenceID(sequenceID);
        node.setSystemID(systemID);
        node.setLineNumber(lineNumber);
        node.setOnTemplate(onTemplate);
        return node;
    }

    public static URI createURI(String uri) {
        return URIImpl.getInstance(uri);
    }

    public static Namespace copyNamespace(Namespace original) {
        return NamespaceImpl.copyOf(original);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class EventScriptEnvironment {
        private static final LiteralScript NULL_SCRIPT = new LiteralScript("");
        private WeakHashMap _mayaaScriptCache = new WeakHashMap();

        protected EventScriptEnvironment() {
        }

        protected CompiledScript compile(String text, boolean fullScript) {
            if (StringUtil.hasValue(text)) {
                if (fullScript) {
                    ScriptUtil.assertSingleScript(text);
                }
                return ScriptUtil.compile(text, class$java$lang$Void == null ? (class$java$lang$Void = SpecificationUtil.class$("java.lang.Void")) : class$java$lang$Void);
            }
            return NULL_SCRIPT;
        }

        protected CompiledScript findScriptFromCache(SpecificationNode mayaa, Object key) {
            Map scriptMap = (Map)this._mayaaScriptCache.get(mayaa);
            if (scriptMap != null) {
                return (CompiledScript)scriptMap.get(key);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CompiledScript newScriptFromCache(SpecificationNode mayaa, Object key, String scriptText, boolean fullScript) {
            WeakHashMap weakHashMap = this._mayaaScriptCache;
            synchronized (weakHashMap) {
                CompiledScript script = this.findScriptFromCache(mayaa, key);
                if (script != null) {
                    return script;
                }
                script = this.compile(scriptText, fullScript);
                HashMap<Object, CompiledScript> scriptMap = (HashMap<Object, CompiledScript>)this._mayaaScriptCache.get(mayaa);
                if (scriptMap == null) {
                    scriptMap = new HashMap<Object, CompiledScript>();
                    this._mayaaScriptCache.put(mayaa, scriptMap);
                }
                scriptMap.put(key, script);
                return script;
            }
        }

        public void execEventScript(SpecificationNode mayaa, SpecificationNode child) {
            CompiledScript script = this.findScriptFromCache(mayaa, child);
            if (script == null) {
                String bodyText = SpecificationUtil.getNodeBodyText(child);
                bodyText = ScriptUtil.getBlockSignedText(bodyText);
                script = this.newScriptFromCache(mayaa, child, bodyText, true);
            }
            script.execute(null);
        }

        public void execEventAttributeScript(SpecificationNode mayaa, String text) {
            CompiledScript script = this.findScriptFromCache(mayaa, text);
            if (script == null) {
                String key = text;
                script = this.newScriptFromCache(mayaa, key, text, false);
            }
            script.execute(null);
        }
    }
}

