/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.map.ReferenceMap;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.engine.specification.NamespaceImpl;

public class FinalNamespace
extends NamespaceImpl
implements Namespace {
    private static final long serialVersionUID = -3137745935798561250L;
    private static Map _namespaces = new ReferenceMap(1, 1, true);
    private static volatile long _instanceTotal;
    static volatile long _finalLastKey;
    private transient boolean _protect = false;
    private long _key = _finalLastKey++;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace getFinalInstance(Namespace namespace) {
        FinalNamespace result;
        if (namespace == null) {
            return null;
        }
        if (namespace instanceof FinalNamespace) {
            return namespace;
        }
        String key = FinalNamespace.forNamespaceString(namespace);
        Map map = _namespaces;
        synchronized (map) {
            result = (FinalNamespace)_namespaces.get(key);
            if (result == null) {
                result = new FinalNamespace(namespace);
                ++_instanceTotal;
                _namespaces.put(key, result);
            }
        }
        return result;
    }

    public static String forNamespaceString(Namespace namespace) {
        return FinalNamespace.forNamespaceString(namespace, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String forNamespaceString(Namespace namespace, boolean allPrefixes) {
        if (namespace == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("parent={");
        Namespace parent = namespace.getParentSpace();
        if (parent != null) {
            if (!(parent instanceof FinalNamespace)) throw new IllegalStateException("Set parents to IFinalNamespace previously");
            sb.append(((FinalNamespace)parent).getFinalKey());
        } else {
            sb.append("null");
        }
        sb.append("},current={");
        sb.append(FinalNamespace.forNamespaceString0(namespace, allPrefixes));
        sb.append("}");
        sb.append(",defaultURI=");
        sb.append(namespace.getDefaultNamespaceURI());
        return sb.toString();
    }

    private static String forNamespaceString0(Namespace namespace, boolean allPrefixes) {
        StringBuffer sb = new StringBuffer();
        sb.append("prefixes={");
        sb.append(FinalNamespace.forNamespaceString1(namespace.iteratePrefixMapping(false)));
        sb.append("}");
        if (allPrefixes) {
            sb.append(",allprefixes={");
            sb.append(FinalNamespace.forNamespaceString1(namespace.iteratePrefixMapping(true)));
            sb.append("}");
        }
        return sb.toString();
    }

    private static String forNamespaceString1(Iterator prefixMappingIterator) {
        StringBuffer sb = new StringBuffer();
        TreeSet<String> sortSet = new TreeSet<String>();
        while (prefixMappingIterator.hasNext()) {
            PrefixMapping prefixMapping = (PrefixMapping)prefixMappingIterator.next();
            sortSet.add(prefixMapping.toString());
        }
        Iterator it = sortSet.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FinalNamespace(Namespace copyFrom) {
        try {
            Namespace parentNamespace = FinalNamespace.getFinalInstance(copyFrom.getParentSpace());
            if (parentNamespace != null) {
                this.setParentSpace(parentNamespace);
            }
            Iterator it = copyFrom.iteratePrefixMapping(false);
            while (it.hasNext()) {
                PrefixMapping prefixMapping = (PrefixMapping)it.next();
                this.addPrefixMapping(prefixMapping.getPrefix(), prefixMapping.getNamespaceURI());
            }
            this.setDefaultNamespaceURI(copyFrom.getDefaultNamespaceURI());
        }
        finally {
            this._protect = true;
        }
    }

    public void addPrefixMapping(String prefix, URI namespaceURI) {
        if (this._protect) {
            throw new UnsupportedOperationException();
        }
        super.addPrefixMapping(prefix, namespaceURI);
    }

    public void setParentSpace(Namespace parent) {
        if (this._protect || !(parent instanceof FinalNamespace)) {
            throw new UnsupportedOperationException();
        }
        super.setParentSpace(parent);
    }

    public long getFinalKey() {
        return this._key;
    }

    public static int keptSize() {
        return _namespaces.size();
    }

    static {
        _finalLastKey = 1L;
    }
}

